/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.xpack.sql.tree.Node;

public abstract class Graphviz {
    private static final int NODE_LABEL_INDENT = 12;
    private static final int CLUSTER_INDENT = 2;
    private static final int INDENT = 1;

    public static String dot(String name, Node<?> root) {
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G { rankdir=BT; \nlabel=\"" + name + "\"; \nnode[shape=plaintext, color=azure1];\n edge[color=black,arrowsize=0.5];\n");
        Graphviz.handleNode(sb, root, new AtomicInteger(0), 1, true);
        sb.append("}");
        return sb.toString();
    }

    public static String dot(Map<String, ? extends Node<?>> clusters, boolean drawSubTrees) {
        AtomicInteger nodeCounter = new AtomicInteger(0);
        StringBuilder sb = new StringBuilder();
        sb.append("digraph G { rankdir=BT;\n node[shape=plaintext, color=azure1];\n edge[color=black];\n graph[compound=true];\n\n");
        int clusterNodeStart = 1;
        int clusterId = 0;
        StringBuilder clusterEdges = new StringBuilder();
        for (Map.Entry<String, Node<?>> entry : clusters.entrySet()) {
            Graphviz.indent(sb, 1);
            sb.append("subgraph cluster");
            sb.append(++clusterId);
            sb.append(" {\n");
            Graphviz.indent(sb, 2);
            sb.append("color=blue;\n");
            Graphviz.indent(sb, 2);
            sb.append("label=");
            sb.append(Graphviz.quoteGraphviz(entry.getKey()));
            sb.append(";\n\n");
            Graphviz.indent(sb, 2);
            sb.append("c" + clusterId);
            sb.append("[style=invis]\n");
            Graphviz.indent(sb, 2);
            sb.append("node" + (nodeCounter.get() + 1));
            sb.append(" -> ");
            sb.append("c" + clusterId);
            sb.append(" [style=invis];\n");
            Graphviz.handleNode(sb, entry.getValue(), nodeCounter, 2, drawSubTrees);
            int clusterNodeStop = nodeCounter.get();
            Graphviz.indent(sb, 1);
            sb.append("}\n");
            if (clusterId > 1) {
                Graphviz.indent(clusterEdges, 1);
                clusterEdges.append("node" + clusterNodeStart);
                clusterEdges.append(" -> ");
                clusterEdges.append("node" + clusterNodeStop);
                clusterEdges.append("[ltail=cluster");
                clusterEdges.append(clusterId - 1);
                clusterEdges.append(" lhead=cluster");
                clusterEdges.append(clusterId);
                clusterEdges.append("];\n");
            }
            clusterNodeStart = clusterNodeStop;
        }
        sb.append("\n");
        Graphviz.indent(sb, 1);
        sb.append("{ rank=same");
        for (int i = 1; i <= clusterId; ++i) {
            sb.append(" c" + i);
        }
        sb.append(" };\n}");
        return sb.toString();
    }

    private static void handleNode(StringBuilder output, Node<?> n, AtomicInteger nodeId, int currentIndent, boolean drawSubTrees) {
        int thisId = nodeId.incrementAndGet();
        StringBuilder nodeInfo = new StringBuilder();
        nodeInfo.append("\n");
        Graphviz.indent(nodeInfo, currentIndent + 12);
        nodeInfo.append("<table border=\"0\" cellborder=\"1\" cellspacing=\"0\">\n");
        Graphviz.indent(nodeInfo, currentIndent + 12);
        nodeInfo.append("<th><td border=\"0\" colspan=\"2\" align=\"center\"><b>" + n.nodeName() + "</b></td></th>\n");
        Graphviz.indent(nodeInfo, currentIndent + 12);
        List<Object> props = n.properties();
        ArrayList<String> parsed = new ArrayList<String>(props.size());
        ArrayList<Node> subTrees = new ArrayList<Node>();
        for (Object v : props) {
            if (v == null || n.children().contains(v)) continue;
            if (v instanceof Collection) {
                Object c = (Collection)v;
                StringBuilder colS = new StringBuilder();
                Iterator iterator = c.iterator();
                while (iterator.hasNext()) {
                    Object o = iterator.next();
                    if (drawSubTrees && Graphviz.isAnotherTree(o)) {
                        subTrees.add((Node)o);
                        continue;
                    }
                    colS.append(o);
                    colS.append("\n");
                }
                if (colS.length() <= 0) continue;
                parsed.add(colS.toString());
                continue;
            }
            if (drawSubTrees && Graphviz.isAnotherTree(v)) {
                subTrees.add((Node)v);
                continue;
            }
            parsed.add(v.toString());
        }
        for (String line : parsed) {
            nodeInfo.append("<tr><td align=\"left\" bgcolor=\"azure2\">");
            nodeInfo.append(Graphviz.escapeHtml(line));
            nodeInfo.append("</td></tr>\n");
            Graphviz.indent(nodeInfo, currentIndent + 12);
        }
        nodeInfo.append("</table>\n");
        if (!subTrees.isEmpty()) {
            output.append("subgraph cluster_" + thisId + " {");
            output.append("style=filled; color=white; fillcolor=azure2; label=\"\";\n");
        }
        Graphviz.indent(output, currentIndent);
        output.append("node");
        output.append(thisId);
        output.append("[label=");
        output.append(Graphviz.quoteGraphviz(nodeInfo.toString()));
        output.append("];\n");
        if (!subTrees.isEmpty()) {
            Graphviz.indent(output, currentIndent + 1);
            output.append("node[shape=ellipse, color=black]\n");
            for (Node node : subTrees) {
                Graphviz.indent(output, currentIndent + 1);
                Graphviz.drawNodeTree(output, node, "st_" + thisId + "_", 0);
            }
            output.append("\n}\n");
        }
        Graphviz.indent(output, currentIndent + 1);
        int prevId = -1;
        for (Object c : n.children()) {
            int childId = nodeId.get() + 1;
            Graphviz.handleNode(output, c, nodeId, currentIndent + 1, drawSubTrees);
            Graphviz.indent(output, currentIndent + 1);
            output.append("node");
            output.append(childId);
            output.append(" -> ");
            output.append("node");
            output.append(thisId);
            output.append(";\n");
            if (prevId != -1) {
                Graphviz.indent(output, currentIndent + 1);
                output.append("node");
                output.append(prevId);
                output.append(" -> ");
                output.append("node");
                output.append(childId);
                output.append(";\n");
            }
            prevId = childId;
        }
        Graphviz.indent(output, currentIndent);
    }

    private static void drawNodeTree(StringBuilder sb, Node<?> node, String prefix, int counter) {
        String nodeName;
        prefix = nodeName = prefix + counter;
        Graphviz.drawNode(sb, node, nodeName);
        sb.append("{ rankdir=LR; rank=same;\n");
        int prevId = -1;
        int saveId = counter;
        for (Node child : node.children()) {
            int currId = ++counter;
            Graphviz.drawNode(sb, child, prefix + currId);
            if (prevId > -1) {
                sb.append(prefix + prevId + " -> " + prefix + currId + " [style=invis];\n");
            }
            prevId = currId;
        }
        sb.append("}\n");
        for (int i = saveId; i < counter; ++i) {
            sb.append(prefix + (i + 1) + " -> " + nodeName + ";\n");
        }
        counter = saveId;
        for (Node child : node.children()) {
            Graphviz.drawNodeTree(sb, child, prefix, ++counter);
        }
    }

    private static void drawNode(StringBuilder sb, Node<?> node, String nodeName) {
        if (node.children().isEmpty()) {
            sb.append(nodeName + " [label=\"" + node.toString() + "\"];\n");
        } else {
            sb.append(nodeName + " [label=\"" + node.nodeName() + "\"];\n");
        }
    }

    private static boolean isAnotherTree(Object value) {
        Node n;
        return value instanceof Node && (n = (Node)value).children().size() > 0;
    }

    private static String escapeHtml(Object value) {
        return String.valueOf(value).replace("&", "&#38;").replace("\"", "&#34;").replace("'", "&#39;").replace("<", "&#60;").replace(">", "&#62;").replace("\n", "<br align=\"left\"/>");
    }

    private static String quoteGraphviz(String value) {
        if (value.contains("<")) {
            return "<" + value + ">";
        }
        return "\"" + value + "\"";
    }

    private static String escapeGraphviz(String value) {
        return value.replace("<", "\\<").replace(">", "\\>").replace("\"", "\\\"");
    }

    private static void indent(StringBuilder sb, int indent) {
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
    }
}

