/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.metadata.AliasMetaData;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexTemplateMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.MetaDataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.indices.IndexTemplateMissingException;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidIndexTemplateException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetaDataIndexTemplateService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final AliasValidator aliasValidator;
    private final IndicesService indicesService;
    private final MetaDataCreateIndexService metaDataCreateIndexService;
    private final IndexScopedSettings indexScopedSettings;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MetaDataIndexTemplateService(Settings settings, ClusterService clusterService, MetaDataCreateIndexService metaDataCreateIndexService, AliasValidator aliasValidator, IndicesService indicesService, IndexScopedSettings indexScopedSettings, NamedXContentRegistry xContentRegistry) {
        super(settings);
        this.clusterService = clusterService;
        this.aliasValidator = aliasValidator;
        this.indicesService = indicesService;
        this.metaDataCreateIndexService = metaDataCreateIndexService;
        this.indexScopedSettings = indexScopedSettings;
        this.xContentRegistry = xContentRegistry;
    }

    public void removeTemplates(final RemoveRequest request, final RemoveListener listener) {
        this.clusterService.submitStateUpdateTask("remove-index-template [" + request.name + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                HashSet<String> templateNames = new HashSet<String>();
                for (ObjectCursor cursor : currentState.metaData().templates().keys()) {
                    String templateName = (String)cursor.value;
                    if (!Regex.simpleMatch(request.name, templateName)) continue;
                    templateNames.add(templateName);
                }
                if (templateNames.isEmpty()) {
                    if (Regex.isMatchAllPattern(request.name)) {
                        return currentState;
                    }
                    throw new IndexTemplateMissingException(request.name);
                }
                MetaData.Builder metaData = MetaData.builder(currentState.metaData());
                for (String templateName : templateNames) {
                    MetaDataIndexTemplateService.this.logger.info("removing template [{}]", (Object)templateName);
                    metaData.removeTemplate(templateName);
                }
                return ClusterState.builder(currentState).metaData(metaData).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new RemoveResponse(true));
            }
        });
    }

    public void putTemplate(final PutRequest request, final PutListener listener) {
        Settings.Builder updatedSettingsBuilder = Settings.builder();
        updatedSettingsBuilder.put(request.settings).normalizePrefix("index.");
        request.settings(updatedSettingsBuilder.build());
        if (request.name == null) {
            listener.onFailure(new IllegalArgumentException("index_template must provide a name"));
            return;
        }
        if (request.indexPatterns == null) {
            listener.onFailure(new IllegalArgumentException("index_template must provide a template"));
            return;
        }
        try {
            this.validate(request);
        }
        catch (Exception e) {
            listener.onFailure(e);
            return;
        }
        final IndexTemplateMetaData.Builder templateBuilder = IndexTemplateMetaData.builder(request.name);
        this.clusterService.submitStateUpdateTask("create-index-template [" + request.name + "], cause [" + request.cause + "]", new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public ClusterState execute(ClusterState currentState) throws Exception {
                if (request.create && currentState.metaData().templates().containsKey(request.name)) {
                    throw new IllegalArgumentException("index_template [" + request.name + "] already exists");
                }
                MetaDataIndexTemplateService.validateAndAddTemplate(request, templateBuilder, MetaDataIndexTemplateService.this.indicesService, MetaDataIndexTemplateService.this.xContentRegistry);
                for (Alias alias : request.aliases) {
                    AliasMetaData aliasMetaData = AliasMetaData.builder(alias.name()).filter(alias.filter()).indexRouting(alias.indexRouting()).searchRouting(alias.searchRouting()).build();
                    templateBuilder.putAlias(aliasMetaData);
                }
                IndexTemplateMetaData template = templateBuilder.build();
                MetaData.Builder builder = MetaData.builder(currentState.metaData()).put(template);
                MetaDataIndexTemplateService.this.logger.info("adding template [{}] for index patterns {}", (Object)request.name, (Object)request.indexPatterns);
                return ClusterState.builder(currentState).metaData(builder).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new PutResponse(true, templateBuilder.build()));
            }
        });
    }

    public static List<IndexTemplateMetaData> findTemplates(MetaData metaData, String indexName) {
        ArrayList<IndexTemplateMetaData> matchedTemplates = new ArrayList<IndexTemplateMetaData>();
        for (ObjectCursor cursor : metaData.templates().values()) {
            IndexTemplateMetaData template = (IndexTemplateMetaData)cursor.value;
            boolean matched = template.patterns().stream().anyMatch(pattern -> Regex.simpleMatch(pattern, indexName));
            if (!matched) continue;
            matchedTemplates.add(template);
        }
        CollectionUtil.timSort(matchedTemplates, Comparator.comparingInt(IndexTemplateMetaData::order).reversed());
        return matchedTemplates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void validateAndAddTemplate(PutRequest request, IndexTemplateMetaData.Builder templateBuilder, IndicesService indicesService, NamedXContentRegistry xContentRegistry) throws Exception {
        Index createdIndex = null;
        String temporaryIndexName = UUIDs.randomBase64UUID();
        try {
            int dummyPartitionSize = IndexMetaData.INDEX_ROUTING_PARTITION_SIZE_SETTING.get(request.settings);
            int dummyShards = request.settings.getAsInt("index.number_of_shards", dummyPartitionSize == 1 ? 1 : dummyPartitionSize + 1);
            Settings dummySettings = Settings.builder().put("index.version.created", Version.CURRENT).put(request.settings).put("index.number_of_shards", dummyShards).put("index.number_of_replicas", 0).put("index.uuid", UUIDs.randomBase64UUID()).build();
            IndexMetaData tmpIndexMetadata = IndexMetaData.builder(temporaryIndexName).settings(dummySettings).build();
            IndicesClusterStateService.AllocatedIndex dummyIndexService = indicesService.createIndex(tmpIndexMetadata, Collections.emptyList());
            createdIndex = ((AbstractIndexComponent)((Object)dummyIndexService)).index();
            templateBuilder.order(request.order);
            templateBuilder.version(request.version);
            templateBuilder.patterns(request.indexPatterns);
            templateBuilder.settings(request.settings);
            HashMap<String, Map<String, Object>> mappingsForValidation = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, String> entry : request.mappings.entrySet()) {
                try {
                    templateBuilder.putMapping(entry.getKey(), entry.getValue());
                }
                catch (Exception e) {
                    throw new MapperParsingException("Failed to parse mapping [{}]: {}", (Throwable)e, entry.getKey(), e.getMessage());
                }
                mappingsForValidation.put(entry.getKey(), MapperService.parseMapping(xContentRegistry, entry.getValue()));
            }
            ((IndexService)dummyIndexService).mapperService().merge(mappingsForValidation, MapperService.MergeReason.MAPPING_UPDATE, false);
            if (createdIndex != null) {
                indicesService.removeIndex(createdIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, " created for parsing template mapping");
            }
        }
        catch (Throwable throwable) {
            if (createdIndex != null) {
                indicesService.removeIndex(createdIndex, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, " created for parsing template mapping");
            }
            throw throwable;
        }
    }

    private void validate(PutRequest request) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (request.name.contains(" ")) {
            validationErrors.add("name must not contain a space");
        }
        if (request.name.contains(",")) {
            validationErrors.add("name must not contain a ','");
        }
        if (request.name.contains("#")) {
            validationErrors.add("name must not contain a '#'");
        }
        if (request.name.startsWith("_")) {
            validationErrors.add("name must not start with '_'");
        }
        if (!request.name.toLowerCase(Locale.ROOT).equals(request.name)) {
            validationErrors.add("name must be lower cased");
        }
        for (String string : request.indexPatterns) {
            if (string.contains(" ")) {
                validationErrors.add("template must not contain a space");
            }
            if (string.contains(",")) {
                validationErrors.add("template must not contain a ','");
            }
            if (string.contains("#")) {
                validationErrors.add("template must not contain a '#'");
            }
            if (string.startsWith("_")) {
                validationErrors.add("template must not start with '_'");
            }
            if (Strings.validFileNameExcludingAstrix(string)) continue;
            validationErrors.add("template must not contain the following characters " + Strings.INVALID_FILENAME_CHARS);
        }
        try {
            this.indexScopedSettings.validate(request.settings, true);
        }
        catch (IllegalArgumentException iae) {
            validationErrors.add(iae.getMessage());
            for (Throwable t : iae.getSuppressed()) {
                validationErrors.add(t.getMessage());
            }
        }
        List<String> indexSettingsValidation = this.metaDataCreateIndexService.getIndexSettingsValidationErrors(request.settings, true);
        validationErrors.addAll(indexSettingsValidation);
        if (!validationErrors.isEmpty()) {
            ValidationException validationException = new ValidationException();
            validationException.addValidationErrors(validationErrors);
            throw new InvalidIndexTemplateException(request.name, validationException.getMessage());
        }
        for (Alias alias : request.aliases) {
            this.aliasValidator.validateAliasStandalone(alias);
            if (!request.indexPatterns.contains(alias.name())) continue;
            throw new IllegalArgumentException("Alias [" + alias.name() + "] cannot be the same as any pattern in [" + String.join((CharSequence)", ", request.indexPatterns) + "]");
        }
    }

    public static interface RemoveListener {
        public void onResponse(RemoveResponse var1);

        public void onFailure(Exception var1);
    }

    public static class RemoveResponse {
        private final boolean acknowledged;

        public RemoveResponse(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class RemoveRequest {
        final String name;
        TimeValue masterTimeout = MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public RemoveRequest(String name) {
            this.name = name;
        }

        public RemoveRequest masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }
    }

    public static class PutResponse {
        private final boolean acknowledged;
        private final IndexTemplateMetaData template;

        public PutResponse(boolean acknowledged, IndexTemplateMetaData template) {
            this.acknowledged = acknowledged;
            this.template = template;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }

        public IndexTemplateMetaData template() {
            return this.template;
        }
    }

    public static class PutRequest {
        final String name;
        final String cause;
        boolean create;
        int order;
        Integer version;
        List<String> indexPatterns;
        Settings settings = Settings.Builder.EMPTY_SETTINGS;
        Map<String, String> mappings = new HashMap<String, String>();
        List<Alias> aliases = new ArrayList<Alias>();
        TimeValue masterTimeout = MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public PutRequest(String cause, String name) {
            this.cause = cause;
            this.name = name;
        }

        public PutRequest order(int order) {
            this.order = order;
            return this;
        }

        public PutRequest patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public PutRequest create(boolean create) {
            this.create = create;
            return this;
        }

        public PutRequest settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public PutRequest mappings(Map<String, String> mappings) {
            this.mappings.putAll(mappings);
            return this;
        }

        public PutRequest aliases(Set<Alias> aliases) {
            this.aliases.addAll(aliases);
            return this;
        }

        public PutRequest putMapping(String mappingType, String mappingSource) {
            this.mappings.put(mappingType, mappingSource);
            return this;
        }

        public PutRequest masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }

        public PutRequest version(Integer version) {
            this.version = version;
            return this;
        }
    }

    public static interface PutListener {
        public void onResponse(PutResponse var1);

        public void onFailure(Exception var1);
    }
}

