/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.spi.ExtendedLogger;
import org.elasticsearch.common.logging.PrefixLogger;

final class ESLoggerFactory {
    private ESLoggerFactory() {
    }

    static Logger getLogger(String prefix, String name) {
        return ESLoggerFactory.getLogger(prefix, LogManager.getLogger(name));
    }

    static Logger getLogger(String prefix, Class<?> clazz) {
        return ESLoggerFactory.getLogger(prefix, LogManager.getLogger(clazz.getName()));
    }

    static Logger getLogger(String prefix, Logger logger) {
        if (prefix == null || prefix.length() == 0) {
            return logger;
        }
        return new PrefixLogger((ExtendedLogger)logger, logger.getName(), prefix);
    }
}

