/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Assertions;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.common.CheckedRunnable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;

final class IndexShardOperationPermits
implements Closeable {
    private final ShardId shardId;
    private final Logger logger;
    private final ThreadPool threadPool;
    static final int TOTAL_PERMITS = Integer.MAX_VALUE;
    final Semaphore semaphore = new Semaphore(Integer.MAX_VALUE, true);
    private final List<DelayedOperation> delayedOperations = new ArrayList<DelayedOperation>();
    private volatile boolean closed;
    private int queuedBlockOperations;
    private final Map<AtomicBoolean, Tuple<String, StackTraceElement[]>> issuedPermits;

    IndexShardOperationPermits(ShardId shardId, Logger logger, ThreadPool threadPool) {
        this.shardId = shardId;
        this.logger = logger;
        this.threadPool = threadPool;
        this.issuedPermits = Assertions.ENABLED ? new ConcurrentHashMap<AtomicBoolean, Tuple<String, StackTraceElement[]>>() : null;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <E extends Exception> void blockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        this.delayOperations();
        try {
            this.doBlockOperations(timeout, timeUnit, onBlocked);
        }
        finally {
            this.releaseDelayedOperations();
        }
    }

    <E extends Exception> void asyncBlockOperations(final long timeout, final TimeUnit timeUnit, final CheckedRunnable<E> onBlocked, final Consumer<Exception> onFailure) {
        this.delayOperations();
        this.threadPool.executor("generic").execute(new AbstractRunnable(){

            @Override
            public void onFailure(Exception e) {
                onFailure.accept(e);
            }

            @Override
            protected void doRun() throws Exception {
                IndexShardOperationPermits.this.doBlockOperations(timeout, timeUnit, onBlocked);
            }

            @Override
            public void onAfter() {
                IndexShardOperationPermits.this.releaseDelayedOperations();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delayOperations() {
        if (this.closed) {
            throw new IndexShardClosedException(this.shardId);
        }
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0 || this.delayedOperations.isEmpty());
            ++this.queuedBlockOperations;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Exception> void doBlockOperations(long timeout, TimeUnit timeUnit, CheckedRunnable<E> onBlocked) throws InterruptedException, TimeoutException, E {
        if (Assertions.ENABLED) {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                assert (this.queuedBlockOperations > 0);
            }
        }
        if (this.semaphore.tryAcquire(Integer.MAX_VALUE, timeout, timeUnit)) {
            assert (this.semaphore.availablePermits() == 0);
            try {
                onBlocked.run();
            }
            finally {
                this.semaphore.release(Integer.MAX_VALUE);
            }
        } else {
            throw new TimeoutException("timeout while blocking operations");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseDelayedOperations() {
        List queuedActions;
        IndexShardOperationPermits indexShardOperationPermits = this;
        synchronized (indexShardOperationPermits) {
            assert (this.queuedBlockOperations > 0);
            --this.queuedBlockOperations;
            if (this.queuedBlockOperations == 0) {
                queuedActions = new ArrayList<DelayedOperation>(this.delayedOperations);
                this.delayedOperations.clear();
            } else {
                queuedActions = Collections.emptyList();
            }
        }
        if (!queuedActions.isEmpty()) {
            this.threadPool.executor("generic").execute(() -> {
                for (DelayedOperation queuedAction : queuedActions) {
                    this.acquire(queuedAction.listener, null, false, queuedAction.debugInfo, queuedAction.stackTrace);
                }
            });
        }
    }

    public void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution, Object debugInfo) {
        StackTraceElement[] stackTrace = Assertions.ENABLED ? Thread.currentThread().getStackTrace() : null;
        this.acquire(onAcquired, executorOnDelay, forceExecution, debugInfo, stackTrace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquire(ActionListener<Releasable> onAcquired, String executorOnDelay, boolean forceExecution, Object debugInfo, StackTraceElement[] stackTrace) {
        Releasable releasable;
        if (this.closed) {
            onAcquired.onFailure(new IndexShardClosedException(this.shardId));
            return;
        }
        try {
            IndexShardOperationPermits indexShardOperationPermits = this;
            synchronized (indexShardOperationPermits) {
                if (this.queuedBlockOperations > 0) {
                    Supplier<ThreadContext.StoredContext> contextSupplier = this.threadPool.getThreadContext().newRestorableContext(false);
                    ActionListener<Releasable> wrappedListener = executorOnDelay != null ? new PermitAwareThreadedActionListener(this.threadPool, executorOnDelay, new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired), forceExecution) : new ContextPreservingActionListener<Releasable>(contextSupplier, onAcquired);
                    this.delayedOperations.add(new DelayedOperation(wrappedListener, debugInfo, stackTrace));
                    return;
                }
                releasable = this.acquire(debugInfo, stackTrace);
            }
        }
        catch (InterruptedException e) {
            onAcquired.onFailure(e);
            return;
        }
        onAcquired.onResponse(releasable);
    }

    private Releasable acquire(Object debugInfo, StackTraceElement[] stackTrace) throws InterruptedException {
        assert (Thread.holdsLock(this));
        if (this.semaphore.tryAcquire(1, 0L, TimeUnit.SECONDS)) {
            AtomicBoolean closed = new AtomicBoolean();
            Releasable releasable = () -> {
                if (closed.compareAndSet(false, true)) {
                    if (Assertions.ENABLED) {
                        Tuple<String, StackTraceElement[]> existing = this.issuedPermits.remove(closed);
                        assert (existing != null);
                    }
                    this.semaphore.release(1);
                }
            };
            if (Assertions.ENABLED) {
                this.issuedPermits.put(closed, new Tuple<String, StackTraceElement[]>(debugInfo.toString(), stackTrace));
            }
            return releasable;
        }
        throw new IllegalStateException("failed to obtain permit but operations are not delayed");
    }

    int getActiveOperationsCount() {
        int availablePermits = this.semaphore.availablePermits();
        if (availablePermits == 0) {
            return 0;
        }
        return Integer.MAX_VALUE - availablePermits;
    }

    synchronized boolean isBlocked() {
        return this.queuedBlockOperations > 0;
    }

    List<String> getActiveOperations() {
        return this.issuedPermits.values().stream().map(t -> (String)t.v1() + "\n" + ExceptionsHelper.formatStackTrace((StackTraceElement[])t.v2())).collect(Collectors.toList());
    }

    private static class PermitAwareThreadedActionListener
    implements ActionListener<Releasable> {
        private final ThreadPool threadPool;
        private final String executor;
        private final ActionListener<Releasable> listener;
        private final boolean forceExecution;

        private PermitAwareThreadedActionListener(ThreadPool threadPool, String executor, ActionListener<Releasable> listener, boolean forceExecution) {
            this.threadPool = threadPool;
            this.executor = executor;
            this.listener = listener;
            this.forceExecution = forceExecution;
        }

        @Override
        public void onResponse(final Releasable releasable) {
            this.threadPool.executor(this.executor).execute(new AbstractRunnable(){

                @Override
                public boolean isForceExecution() {
                    return forceExecution;
                }

                @Override
                protected void doRun() throws Exception {
                    listener.onResponse(releasable);
                }

                @Override
                public void onRejection(Exception e) {
                    IOUtils.closeWhileHandlingException(releasable);
                    super.onRejection(e);
                }

                @Override
                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }

        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    private static class DelayedOperation {
        private final ActionListener<Releasable> listener;
        private final String debugInfo;
        private final StackTraceElement[] stackTrace;

        private DelayedOperation(ActionListener<Releasable> listener, Object debugInfo, StackTraceElement[] stackTrace) {
            this.listener = listener;
            if (Assertions.ENABLED) {
                this.debugInfo = "[delayed] " + debugInfo;
                this.stackTrace = stackTrace;
            } else {
                this.debugInfo = null;
                this.stackTrace = null;
            }
        }
    }
}

