/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase.highlight;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.highlight.DefaultEncoder;
import org.apache.lucene.search.highlight.Encoder;
import org.apache.lucene.search.highlight.SimpleHTMLEncoder;
import org.elasticsearch.index.fieldvisitor.CustomFieldsVisitor;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.highlight.SearchContextHighlight;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.lookup.SourceLookup;

public final class HighlightUtils {
    public static final char PARAGRAPH_SEPARATOR = '\u2029';
    public static final char NULL_SEPARATOR = '\u0000';

    private HighlightUtils() {
    }

    public static List<Object> loadFieldValues(SearchContextHighlight.Field field, MappedFieldType fieldType, SearchContext searchContext, FetchSubPhase.HitContext hitContext) throws IOException {
        List<Object> textsToHighlight;
        boolean forceSource = searchContext.highlight().forceSource(field);
        if (!forceSource && fieldType.stored()) {
            CustomFieldsVisitor fieldVisitor = new CustomFieldsVisitor(Collections.singleton(fieldType.name()), false);
            hitContext.reader().document(hitContext.docId(), fieldVisitor);
            textsToHighlight = fieldVisitor.fields().get(fieldType.name());
            if (textsToHighlight == null) {
                textsToHighlight = Collections.emptyList();
            }
        } else {
            SourceLookup sourceLookup = searchContext.lookup().source();
            sourceLookup.setSegmentAndDocument(hitContext.readerContext(), hitContext.docId());
            textsToHighlight = sourceLookup.extractRawValues(fieldType.name());
        }
        assert (textsToHighlight != null);
        return textsToHighlight;
    }

    static Analyzer getAnalyzer(DocumentMapper docMapper, MappedFieldType type) {
        KeywordFieldMapper.KeywordFieldType keywordFieldType;
        if (type instanceof KeywordFieldMapper.KeywordFieldType && (keywordFieldType = (KeywordFieldMapper.KeywordFieldType)type).normalizer() != null) {
            return keywordFieldType.normalizer();
        }
        return docMapper.mappers().indexAnalyzer();
    }

    public static class Encoders {
        public static final Encoder DEFAULT = new DefaultEncoder();
        public static final Encoder HTML = new SimpleHTMLEncoder();
    }
}

