/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.args;

import com.unboundid.util.LDAPSDKUsageException;
import com.unboundid.util.Mutable;
import com.unboundid.util.NotExtensible;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.args.ArgsMessages;
import com.unboundid.util.args.ArgumentException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@NotExtensible
@Mutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public abstract class Argument
implements Serializable {
    private static final long serialVersionUID = -6938320885602903919L;
    private boolean isHidden;
    private boolean isRegistered;
    private final boolean isRequired;
    private boolean isSensitive;
    private boolean isUsageArgument;
    private int maxOccurrences;
    private int numOccurrences;
    private final Map<Character, Boolean> shortIdentifiers;
    private final Map<String, Boolean> longIdentifiers;
    private String argumentGroupName;
    private final String description;
    private final String valuePlaceholder;

    protected Argument(Character shortIdentifier, String longIdentifier, boolean isRequired, int maxOccurrences, String valuePlaceholder, String description) throws ArgumentException {
        if (description == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_DESCRIPTION_NULL.get());
        }
        if (shortIdentifier == null && longIdentifier == null) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_NO_IDENTIFIERS.get());
        }
        this.shortIdentifiers = new LinkedHashMap<Character, Boolean>(5);
        if (shortIdentifier != null) {
            this.shortIdentifiers.put(shortIdentifier, false);
        }
        this.longIdentifiers = new LinkedHashMap<String, Boolean>(5);
        if (longIdentifier != null) {
            this.longIdentifiers.put(longIdentifier, false);
        }
        this.isRequired = isRequired;
        this.valuePlaceholder = valuePlaceholder;
        this.description = description;
        this.maxOccurrences = maxOccurrences > 0 ? maxOccurrences : Integer.MAX_VALUE;
        this.argumentGroupName = null;
        this.numOccurrences = 0;
        this.isHidden = false;
        this.isRegistered = false;
        this.isSensitive = false;
        this.isUsageArgument = false;
    }

    protected Argument(Argument source) {
        this.argumentGroupName = source.argumentGroupName;
        this.isHidden = source.isHidden;
        this.isRequired = source.isRequired;
        this.isSensitive = source.isSensitive;
        this.isUsageArgument = source.isUsageArgument;
        this.maxOccurrences = source.maxOccurrences;
        this.description = source.description;
        this.valuePlaceholder = source.valuePlaceholder;
        this.isRegistered = false;
        this.numOccurrences = 0;
        this.shortIdentifiers = new LinkedHashMap<Character, Boolean>(source.shortIdentifiers);
        this.longIdentifiers = new LinkedHashMap<String, Boolean>(source.longIdentifiers);
    }

    public final boolean hasShortIdentifier() {
        return !this.shortIdentifiers.isEmpty();
    }

    public final Character getShortIdentifier() {
        for (Map.Entry<Character, Boolean> e : this.shortIdentifiers.entrySet()) {
            if (e.getValue().booleanValue()) continue;
            return e.getKey();
        }
        return null;
    }

    public final List<Character> getShortIdentifiers() {
        return this.getShortIdentifiers(true);
    }

    public final List<Character> getShortIdentifiers(boolean includeHidden) {
        ArrayList<Character> identifierList = new ArrayList<Character>(this.shortIdentifiers.size());
        for (Map.Entry<Character, Boolean> e : this.shortIdentifiers.entrySet()) {
            if (!includeHidden && e.getValue().booleanValue()) continue;
            identifierList.add(e.getKey());
        }
        return Collections.unmodifiableList(identifierList);
    }

    public final void addShortIdentifier(Character c) throws ArgumentException {
        this.addShortIdentifier(c, false);
    }

    public final void addShortIdentifier(Character c, boolean isHidden) throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ID_CHANGE_AFTER_REGISTERED.get(this.getIdentifierString()));
        }
        this.shortIdentifiers.put(c, isHidden);
    }

    public final boolean hasLongIdentifier() {
        return !this.longIdentifiers.isEmpty();
    }

    public final String getLongIdentifier() {
        for (Map.Entry<String, Boolean> e : this.longIdentifiers.entrySet()) {
            if (e.getValue().booleanValue()) continue;
            return e.getKey();
        }
        return null;
    }

    public final List<String> getLongIdentifiers() {
        return this.getLongIdentifiers(true);
    }

    public final List<String> getLongIdentifiers(boolean includeHidden) {
        ArrayList<String> identifierList = new ArrayList<String>(this.longIdentifiers.size());
        for (Map.Entry<String, Boolean> e : this.longIdentifiers.entrySet()) {
            if (!includeHidden && e.getValue().booleanValue()) continue;
            identifierList.add(e.getKey());
        }
        return Collections.unmodifiableList(identifierList);
    }

    public final void addLongIdentifier(String s) throws ArgumentException {
        this.addLongIdentifier(s, false);
    }

    public final void addLongIdentifier(String s, boolean isHidden) throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ID_CHANGE_AFTER_REGISTERED.get(this.getIdentifierString()));
        }
        this.longIdentifiers.put(s, isHidden);
    }

    public final String getIdentifierString() {
        for (Map.Entry<String, Boolean> entry : this.longIdentifiers.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return "--" + entry.getKey();
        }
        for (Map.Entry<Object, Boolean> entry : this.shortIdentifiers.entrySet()) {
            if (entry.getValue().booleanValue()) continue;
            return "-" + entry.getKey();
        }
        throw new LDAPSDKUsageException(ArgsMessages.ERR_ARG_NO_NON_HIDDEN_IDENTIFIER.get(this.toString()));
    }

    public final boolean isRequired() {
        return this.isRequired;
    }

    public final int getMaxOccurrences() {
        return this.maxOccurrences;
    }

    public final void setMaxOccurrences(int maxOccurrences) {
        this.maxOccurrences = maxOccurrences <= 0 ? Integer.MAX_VALUE : maxOccurrences;
    }

    public boolean takesValue() {
        return this.valuePlaceholder != null;
    }

    public final String getValuePlaceholder() {
        return this.valuePlaceholder;
    }

    public abstract List<String> getValueStringRepresentations(boolean var1);

    public final String getDescription() {
        return this.description;
    }

    public final String getArgumentGroupName() {
        return this.argumentGroupName;
    }

    public final void setArgumentGroupName(String argumentGroupName) {
        this.argumentGroupName = argumentGroupName;
    }

    public final boolean isHidden() {
        return this.isHidden;
    }

    public final void setHidden(boolean isHidden) {
        this.isHidden = isHidden;
    }

    public final boolean isUsageArgument() {
        return this.isUsageArgument;
    }

    public final void setUsageArgument(boolean isUsageArgument) {
        this.isUsageArgument = isUsageArgument;
    }

    public final boolean isPresent() {
        return this.numOccurrences > 0 || this.hasDefaultValue();
    }

    public final int getNumOccurrences() {
        return this.numOccurrences;
    }

    final void incrementOccurrences() throws ArgumentException {
        if (this.numOccurrences >= this.maxOccurrences) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_MAX_OCCURRENCES_EXCEEDED.get(this.getIdentifierString()));
        }
        ++this.numOccurrences;
    }

    protected abstract void addValue(String var1) throws ArgumentException;

    protected abstract boolean hasDefaultValue();

    public final boolean isSensitive() {
        return this.isSensitive;
    }

    public final void setSensitive(boolean isSensitive) {
        this.isSensitive = isSensitive;
    }

    boolean isRegistered() {
        return this.isRegistered;
    }

    void setRegistered() throws ArgumentException {
        if (this.isRegistered) {
            throw new ArgumentException(ArgsMessages.ERR_ARG_ALREADY_REGISTERED.get(this.getIdentifierString()));
        }
        this.isRegistered = true;
    }

    public abstract String getDataTypeName();

    public String getValueConstraints() {
        return null;
    }

    protected void reset() {
        this.numOccurrences = 0;
    }

    public abstract Argument getCleanCopy();

    protected abstract void addToCommandLine(List<String> var1);

    public final String toString() {
        StringBuilder buffer = new StringBuilder();
        this.toString(buffer);
        return buffer.toString();
    }

    public abstract void toString(StringBuilder var1);

    protected void appendBasicToStringInfo(StringBuilder buffer) {
        Iterator<Object> iterator;
        switch (this.shortIdentifiers.size()) {
            case 0: {
                break;
            }
            case 1: {
                buffer.append("shortIdentifier='-");
                buffer.append(this.shortIdentifiers.keySet().iterator().next());
                buffer.append('\'');
                break;
            }
            default: {
                buffer.append("shortIdentifiers={");
                iterator = this.shortIdentifiers.keySet().iterator();
                while (iterator.hasNext()) {
                    buffer.append("'-");
                    buffer.append(iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        if (!this.shortIdentifiers.isEmpty()) {
            buffer.append(", ");
        }
        switch (this.longIdentifiers.size()) {
            case 0: {
                break;
            }
            case 1: {
                buffer.append("longIdentifier='--");
                buffer.append(this.longIdentifiers.keySet().iterator().next());
                buffer.append('\'');
                break;
            }
            default: {
                buffer.append("longIdentifiers={");
                iterator = this.longIdentifiers.keySet().iterator();
                while (iterator.hasNext()) {
                    buffer.append("'--");
                    buffer.append((String)iterator.next());
                    buffer.append('\'');
                    if (!iterator.hasNext()) continue;
                    buffer.append(", ");
                }
                buffer.append('}');
            }
        }
        buffer.append(", description='");
        buffer.append(this.description);
        if (this.argumentGroupName != null) {
            buffer.append("', argumentGroup='");
            buffer.append(this.argumentGroupName);
        }
        buffer.append("', isRequired=");
        buffer.append(this.isRequired);
        buffer.append(", maxOccurrences=");
        if (this.maxOccurrences == 0) {
            buffer.append("unlimited");
        } else {
            buffer.append(this.maxOccurrences);
        }
        if (this.valuePlaceholder == null) {
            buffer.append(", takesValue=false");
        } else {
            buffer.append(", takesValue=true, valuePlaceholder='");
            buffer.append(this.valuePlaceholder);
            buffer.append('\'');
        }
        if (this.isHidden) {
            buffer.append(", isHidden=true");
        }
    }
}

