/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONArray;
import com.unboundid.util.json.JSONBoolean;
import com.unboundid.util.json.JSONException;
import com.unboundid.util.json.JSONMessages;
import com.unboundid.util.json.JSONNull;
import com.unboundid.util.json.JSONNumber;
import com.unboundid.util.json.JSONObject;
import com.unboundid.util.json.JSONString;
import com.unboundid.util.json.JSONValue;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class JSONObjectReader
implements Closeable {
    private final ByteStringBuffer currentObjectBytes;
    private final ByteStringBuffer stringBuffer;
    private final InputStream inputStream;

    public JSONObjectReader(InputStream inputStream) {
        this(inputStream, true);
    }

    public JSONObjectReader(InputStream inputStream, boolean bufferInputStream) {
        this.inputStream = bufferInputStream && !(inputStream instanceof BufferedInputStream) ? new BufferedInputStream(inputStream) : inputStream;
        this.currentObjectBytes = new ByteStringBuffer();
        this.stringBuffer = new ByteStringBuffer();
    }

    public JSONObject readObject() throws IOException, JSONException {
        this.skipWhitespace();
        this.currentObjectBytes.clear();
        Object firstToken = this.readToken(true);
        if (firstToken == null) {
            return null;
        }
        if (!firstToken.equals(Character.valueOf('{'))) {
            throw new JSONException(JSONMessages.ERR_OBJECT_READER_ILLEGAL_START_OF_OBJECT.get(String.valueOf(firstToken)));
        }
        LinkedHashMap<String, JSONValue> m = new LinkedHashMap<String, JSONValue>(10);
        this.readObject(m);
        return new JSONObject(m, this.currentObjectBytes.toString());
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    private Object readToken(boolean allowEndOfStream) throws IOException, JSONException {
        this.skipWhitespace();
        Byte byteRead = this.readByte(allowEndOfStream);
        if (byteRead == null) {
            return null;
        }
        switch (byteRead) {
            case 123: {
                return Character.valueOf('{');
            }
            case 125: {
                return Character.valueOf('}');
            }
            case 91: {
                return Character.valueOf('[');
            }
            case 93: {
                return Character.valueOf(']');
            }
            case 58: {
                return Character.valueOf(':');
            }
            case 44: {
                return Character.valueOf(',');
            }
            case 34: {
                return this.readString();
            }
            case 102: 
            case 116: {
                return this.readBoolean();
            }
            case 110: {
                return this.readNull();
            }
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.readNumber();
            }
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_READER_ILLEGAL_FIRST_CHAR_FOR_JSON_TOKEN.get(this.currentObjectBytes.length(), JSONObjectReader.byteToCharString(byteRead)));
    }

    private void skipWhitespace() throws IOException, JSONException {
        block5: while (true) {
            this.inputStream.mark(1);
            Byte byteRead = this.readByte(true);
            if (byteRead == null) {
                return;
            }
            switch (byteRead) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    break;
                }
                case 47: {
                    Byte commentByte;
                    byte nextByte = this.readByte(false);
                    if (nextByte == 47) {
                        do {
                            if ((commentByte = this.readByte(true)) == null) {
                                return;
                            }
                            if (commentByte == 10) continue block5;
                        } while (commentByte != 13);
                        break;
                    }
                    if (nextByte == 42) {
                        Byte possibleSlashByte;
                        while ((commentByte = this.readByte(false)) != 42 || (possibleSlashByte = this.readByte(false)) != 47) {
                        }
                        break;
                    }
                    throw new JSONException(JSONMessages.ERR_OBJECT_READER_ILLEGAL_SLASH_SKIPPING_WHITESPACE.get(this.currentObjectBytes.length()));
                }
                case 35: {
                    Byte commentByte;
                    do {
                        if ((commentByte = this.readByte(true)) == null) {
                            return;
                        }
                        if (commentByte == 10) continue block5;
                    } while (commentByte != 13);
                    break;
                }
                default: {
                    this.inputStream.reset();
                    this.currentObjectBytes.setLength(this.currentObjectBytes.length() - 1);
                    return;
                }
            }
        }
    }

    private Byte readByte(boolean allowEndOfStream) throws IOException, JSONException {
        int byteRead = this.inputStream.read();
        if (byteRead < 0) {
            if (allowEndOfStream) {
                return null;
            }
            throw new JSONException(JSONMessages.ERR_OBJECT_READER_UNEXPECTED_END_OF_STREAM.get(this.currentObjectBytes.length()));
        }
        byte b = (byte)(byteRead & 0xFF);
        this.currentObjectBytes.append(b);
        return b;
    }

    private JSONString readString() throws IOException, JSONException {
        this.stringBuffer.clear();
        int jsonStringStartPos = this.currentObjectBytes.length() - 1;
        block11: while (true) {
            Byte byteRead;
            if (((byteRead = this.readByte(false)) & 0x80) == 128) {
                byte[] charBytes;
                if ((byteRead & 0xE0) == 192) {
                    charBytes = new byte[]{byteRead, this.readByte(false)};
                } else if ((byteRead & 0xF0) == 224) {
                    charBytes = new byte[]{byteRead, this.readByte(false), this.readByte(false)};
                } else if ((byteRead & 0xF8) == 240) {
                    charBytes = new byte[]{byteRead, this.readByte(false), this.readByte(false), this.readByte(false)};
                } else {
                    throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_UTF_8_BYTE_IN_STREAM.get(this.currentObjectBytes.length(), "0x" + StaticUtils.toHex(byteRead)));
                }
                this.stringBuffer.append(new String(charBytes, StandardCharsets.UTF_8));
                continue;
            }
            if (byteRead == 92) {
                byte nextByte = this.readByte(false);
                switch (nextByte) {
                    case 34: 
                    case 47: 
                    case 92: {
                        this.stringBuffer.append(nextByte);
                        continue block11;
                    }
                    case 98: {
                        this.stringBuffer.append('\b');
                        continue block11;
                    }
                    case 102: {
                        this.stringBuffer.append('\f');
                        continue block11;
                    }
                    case 110: {
                        this.stringBuffer.append('\n');
                        continue block11;
                    }
                    case 114: {
                        this.stringBuffer.append('\r');
                        continue block11;
                    }
                    case 116: {
                        this.stringBuffer.append('\t');
                        continue block11;
                    }
                    case 117: {
                        char[] hexChars = new char[]{(char)(this.readByte(false) & 0xFF), (char)(this.readByte(false) & 0xFF), (char)(this.readByte(false) & 0xFF), (char)(this.readByte(false) & 0xFF)};
                        try {
                            this.stringBuffer.append((char)Integer.parseInt(new String(hexChars), 16));
                            continue block11;
                        }
                        catch (Exception e) {
                            Debug.debugException(e);
                            throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_UNICODE_ESCAPE.get(this.currentObjectBytes.length()), e);
                        }
                    }
                }
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_ESCAPED_CHAR.get(this.currentObjectBytes.length(), JSONObjectReader.byteToCharString(nextByte)));
            }
            if (byteRead == 34) {
                return new JSONString(this.stringBuffer.toString(), new String(this.currentObjectBytes.getBackingArray(), jsonStringStartPos, this.currentObjectBytes.length() - jsonStringStartPos, StandardCharsets.UTF_8));
            }
            int byteReadInt = byteRead & 0xFF;
            if ((byteRead & 0xFF) <= 31) {
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_UNESCAPED_CONTROL_CHAR.get(this.currentObjectBytes.length(), JSONObjectReader.byteToCharString(byteRead)));
            }
            this.stringBuffer.append((char)byteReadInt);
        }
    }

    private JSONBoolean readBoolean() throws IOException, JSONException {
        byte firstByte = this.currentObjectBytes.getBackingArray()[this.currentObjectBytes.length() - 1];
        if (firstByte == 116) {
            if (this.readByte(false) == 114 && this.readByte(false) == 117 && this.readByte(false) == 101) {
                return JSONBoolean.TRUE;
            }
            throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_BOOLEAN_TRUE.get(this.currentObjectBytes.length()));
        }
        if (this.readByte(false) == 97 && this.readByte(false) == 108 && this.readByte(false) == 115 && this.readByte(false) == 101) {
            return JSONBoolean.FALSE;
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_BOOLEAN_FALSE.get(this.currentObjectBytes.length()));
    }

    private JSONNull readNull() throws IOException, JSONException {
        if (this.readByte(false) == 117 && this.readByte(false) == 108 && this.readByte(false) == 108) {
            return JSONNull.NULL;
        }
        throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_NULL.get(this.currentObjectBytes.length()));
    }

    private JSONNumber readNumber() throws IOException, JSONException {
        this.stringBuffer.clear();
        this.stringBuffer.append(this.currentObjectBytes.getBackingArray()[this.currentObjectBytes.length() - 1]);
        while (true) {
            this.inputStream.mark(1);
            Byte b = this.readByte(false);
            switch (b) {
                case 9: 
                case 10: 
                case 13: 
                case 32: 
                case 44: 
                case 93: 
                case 125: {
                    this.inputStream.reset();
                    this.currentObjectBytes.setLength(this.currentObjectBytes.length() - 1);
                    return new JSONNumber(this.stringBuffer.toString());
                }
            }
            this.stringBuffer.append(b);
        }
    }

    private JSONArray readArray() throws IOException, JSONException {
        Object nextToken;
        ArrayList<JSONValue> values = new ArrayList<JSONValue>(10);
        boolean firstToken = true;
        do {
            Object token;
            if ((token = this.readToken(false)) instanceof JSONValue) {
                values.add((JSONValue)token);
            } else if (token.equals(Character.valueOf('['))) {
                values.add(this.readArray());
            } else if (token.equals(Character.valueOf('{'))) {
                LinkedHashMap<String, JSONValue> fieldMap = new LinkedHashMap<String, JSONValue>(10);
                values.add(this.readObject(fieldMap));
            } else {
                if (token.equals(Character.valueOf(']')) && firstToken) {
                    return JSONArray.EMPTY_ARRAY;
                }
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_TOKEN_IN_ARRAY.get(this.currentObjectBytes.length(), String.valueOf(token)));
            }
            firstToken = false;
            nextToken = this.readToken(false);
            if (!nextToken.equals(Character.valueOf(']'))) continue;
            return new JSONArray(values);
        } while (nextToken.equals(Character.valueOf(',')));
        throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_TOKEN_AFTER_ARRAY_VALUE.get(this.currentObjectBytes.length(), String.valueOf(nextToken)));
    }

    private JSONObject readObject(Map<String, JSONValue> fields) throws IOException, JSONException {
        Object fieldNameToken;
        Object separatorToken;
        boolean firstField = true;
        do {
            String fieldName;
            if ((fieldNameToken = this.readToken(false)) instanceof JSONString) {
                fieldName = ((JSONString)fieldNameToken).stringValue();
                if (fields.containsKey(fieldName)) {
                    throw new JSONException(JSONMessages.ERR_OBJECT_READER_DUPLICATE_FIELD.get(this.currentObjectBytes.length(), fieldName));
                }
            } else {
                if (firstField && fieldNameToken.equals(Character.valueOf('}'))) {
                    return new JSONObject(fields);
                }
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_TOKEN_IN_OBJECT.get(this.currentObjectBytes.length(), String.valueOf(fieldNameToken)));
            }
            firstField = false;
            Object colonToken = this.readToken(false);
            if (!colonToken.equals(Character.valueOf(':'))) {
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_TOKEN_NOT_COLON.get(this.currentObjectBytes.length(), String.valueOf(colonToken), String.valueOf(fieldNameToken)));
            }
            Object valueToken = this.readToken(false);
            if (valueToken instanceof JSONValue) {
                fields.put(fieldName, (JSONValue)valueToken);
            } else if (valueToken.equals(Character.valueOf('['))) {
                JSONArray a = this.readArray();
                fields.put(fieldName, a);
            } else if (valueToken.equals(Character.valueOf('{'))) {
                LinkedHashMap<String, JSONValue> m = new LinkedHashMap<String, JSONValue>(10);
                JSONObject o = this.readObject(m);
                fields.put(fieldName, o);
            } else {
                throw new JSONException(JSONMessages.ERR_OBJECT_READER_TOKEN_NOT_VALUE.get(this.currentObjectBytes.length(), String.valueOf(valueToken), String.valueOf(fieldNameToken)));
            }
            separatorToken = this.readToken(false);
            if (!separatorToken.equals(Character.valueOf('}'))) continue;
            return new JSONObject(fields);
        } while (separatorToken.equals(Character.valueOf(',')));
        throw new JSONException(JSONMessages.ERR_OBJECT_READER_INVALID_TOKEN_AFTER_OBJECT_VALUE.get(this.currentObjectBytes.length(), String.valueOf(separatorToken), String.valueOf(fieldNameToken)));
    }

    private static String byteToCharString(byte b) {
        if (b >= 32 && b <= 126) {
            return String.valueOf((char)(b & 0xFF));
        }
        return "0x" + StaticUtils.toHex(b);
    }
}

