/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.audit.logfile;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.network.NetworkAddress;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.node.Node;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.core.security.user.XPackUser;
import org.elasticsearch.xpack.security.audit.AuditLevel;
import org.elasticsearch.xpack.security.audit.AuditTrail;
import org.elasticsearch.xpack.security.audit.AuditUtil;
import org.elasticsearch.xpack.security.audit.logfile.LoggingAuditTrail;
import org.elasticsearch.xpack.security.rest.RemoteHostHeader;
import org.elasticsearch.xpack.security.transport.filter.SecurityIpFilterRule;

public class DeprecatedLoggingAuditTrail
extends AbstractComponent
implements AuditTrail,
ClusterStateListener {
    public static final String NAME = "deprecatedLogfile";
    private final Logger logger;
    final LoggingAuditTrail.EventFilterPolicyRegistry eventFilterPolicyRegistry;
    private final ThreadContext threadContext;
    volatile EnumSet<AuditLevel> events;
    boolean includeRequestBody;
    LocalNodeInfo localNodeInfo;

    @Override
    public String name() {
        return NAME;
    }

    public DeprecatedLoggingAuditTrail(Settings settings, ClusterService clusterService, ThreadPool threadPool) {
        this(settings, clusterService, Loggers.getLogger(DeprecatedLoggingAuditTrail.class), threadPool.getThreadContext());
    }

    DeprecatedLoggingAuditTrail(Settings settings, ClusterService clusterService, Logger logger, ThreadContext threadContext) {
        super(settings);
        this.logger = logger;
        this.events = AuditLevel.parse((List)LoggingAuditTrail.INCLUDE_EVENT_SETTINGS.get(settings), (List)LoggingAuditTrail.EXCLUDE_EVENT_SETTINGS.get(settings));
        this.includeRequestBody = (Boolean)LoggingAuditTrail.INCLUDE_REQUEST_BODY.get(settings);
        this.threadContext = threadContext;
        this.localNodeInfo = new LocalNodeInfo(settings, null);
        this.eventFilterPolicyRegistry = new LoggingAuditTrail.EventFilterPolicyRegistry(settings);
        clusterService.addListener((ClusterStateListener)this);
        clusterService.getClusterSettings().addSettingsUpdateConsumer(newSettings -> {
            LocalNodeInfo localNodeInfo = this.localNodeInfo;
            Settings.Builder builder = Settings.builder().put(localNodeInfo.settings).put(newSettings, false);
            this.localNodeInfo = new LocalNodeInfo(builder.build(), localNodeInfo.localNode);
            this.includeRequestBody = (Boolean)LoggingAuditTrail.INCLUDE_REQUEST_BODY.get(newSettings);
            this.events = AuditLevel.parse((List)LoggingAuditTrail.INCLUDE_EVENT_SETTINGS.get(newSettings), (List)LoggingAuditTrail.EXCLUDE_EVENT_SETTINGS.get(newSettings));
        }, Arrays.asList(LoggingAuditTrail.EMIT_HOST_ADDRESS_SETTING, LoggingAuditTrail.EMIT_HOST_NAME_SETTING, LoggingAuditTrail.EMIT_NODE_NAME_SETTING, LoggingAuditTrail.INCLUDE_EVENT_SETTINGS, LoggingAuditTrail.EXCLUDE_EVENT_SETTINGS, LoggingAuditTrail.INCLUDE_REQUEST_BODY));
        clusterService.getClusterSettings().addAffixUpdateConsumer(LoggingAuditTrail.FILTER_POLICY_IGNORE_PRINCIPALS, (policyName, filtersList) -> {
            Optional<LoggingAuditTrail.EventFilterPolicy> policy = this.eventFilterPolicyRegistry.get((String)policyName);
            LoggingAuditTrail.EventFilterPolicy newPolicy = policy.orElse(new LoggingAuditTrail.EventFilterPolicy((String)policyName, settings)).changePrincipalsFilter((List<String>)filtersList);
            this.eventFilterPolicyRegistry.set((String)policyName, newPolicy);
        }, (policyName, filtersList) -> LoggingAuditTrail.EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(LoggingAuditTrail.FILTER_POLICY_IGNORE_REALMS, (policyName, filtersList) -> {
            Optional<LoggingAuditTrail.EventFilterPolicy> policy = this.eventFilterPolicyRegistry.get((String)policyName);
            LoggingAuditTrail.EventFilterPolicy newPolicy = policy.orElse(new LoggingAuditTrail.EventFilterPolicy((String)policyName, settings)).changeRealmsFilter((List<String>)filtersList);
            this.eventFilterPolicyRegistry.set((String)policyName, newPolicy);
        }, (policyName, filtersList) -> LoggingAuditTrail.EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(LoggingAuditTrail.FILTER_POLICY_IGNORE_ROLES, (policyName, filtersList) -> {
            Optional<LoggingAuditTrail.EventFilterPolicy> policy = this.eventFilterPolicyRegistry.get((String)policyName);
            LoggingAuditTrail.EventFilterPolicy newPolicy = policy.orElse(new LoggingAuditTrail.EventFilterPolicy((String)policyName, settings)).changeRolesFilter((List<String>)filtersList);
            this.eventFilterPolicyRegistry.set((String)policyName, newPolicy);
        }, (policyName, filtersList) -> LoggingAuditTrail.EventFilterPolicy.parsePredicate(filtersList));
        clusterService.getClusterSettings().addAffixUpdateConsumer(LoggingAuditTrail.FILTER_POLICY_IGNORE_INDICES, (policyName, filtersList) -> {
            Optional<LoggingAuditTrail.EventFilterPolicy> policy = this.eventFilterPolicyRegistry.get((String)policyName);
            LoggingAuditTrail.EventFilterPolicy newPolicy = policy.orElse(new LoggingAuditTrail.EventFilterPolicy((String)policyName, settings)).changeIndicesFilter((List<String>)filtersList);
            this.eventFilterPolicyRegistry.set((String)policyName, newPolicy);
        }, (policyName, filtersList) -> LoggingAuditTrail.EventFilterPolicy.parsePredicate(filtersList));
    }

    @Override
    public void authenticationSuccess(String realm, User user, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_success]\t{}, realm=[{}], uri=[{}], params=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)realm, (Object)request.uri(), (Object)request.params(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationSuccess(String realm, User user, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_SUCCESS)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(user), Optional.of(realm), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_success]\t{}, {}, realm=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)realm, (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_success]\t{}, {}, realm=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)realm, (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void anonymousAccessDenied(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [anonymous_access_denied]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void anonymousAccessDenied(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.ANONYMOUS_ACCESS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(LoggingAuditTrail.AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [anonymous_access_denied]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(token), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, principal=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(LoggingAuditTrail.AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [authentication_failed]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(token), Optional.empty(), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [authentication_failed]\t{}, principal=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(token), Optional.of(realm), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)realm, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)realm, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)token.principal(), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void authenticationFailed(String realm, AuthenticationToken token, RestRequest request) {
        if (this.events.contains((Object)AuditLevel.REALM_AUTHENTICATION_FAILED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(token), Optional.of(realm), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)realm, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [realm_authentication_failed]\trealm=[{}], {}, principal=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)realm, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)token.principal(), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void accessGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        boolean isSystem;
        User user = authentication.getUser();
        boolean bl = isSystem = SystemUser.is((User)user) || XPackUser.is((User)user);
        if (isSystem && this.events.contains((Object)AuditLevel.SYSTEM_ACCESS_GRANTED) || !isSystem && this.events.contains((Object)AuditLevel.ACCESS_GRANTED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(user), Optional.of(DeprecatedLoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [access_granted]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [access_granted]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void accessDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.ACCESS_DENIED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(DeprecatedLoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [access_denied]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [access_denied]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.subject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void tamperedRequest(RestRequest request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST) && !this.eventFilterPolicyRegistry.ignorePredicate().test(LoggingAuditTrail.AuditEventMetaInfo.EMPTY)) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}]{}, request_body=[{}]", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId(), (Object)AuditUtil.restRequestContent(request));
            } else {
                this.logger.info("{}[rest] [tampered_request]\t{}, uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    @Override
    public void tamperedRequest(String action, TransportMessage message) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [tampered_request]\t{}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void tamperedRequest(User user, String action, TransportMessage request) {
        if (this.events.contains((Object)AuditLevel.TAMPERED_REQUEST)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(request);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(user), Optional.empty(), Optional.empty(), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, request, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)request.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [tampered_request]\t{}, {}, action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, request, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.principal(user), (Object)action, (Object)request.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void connectionGranted(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_GRANTED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(LoggingAuditTrail.AuditEventMetaInfo.EMPTY)) {
            this.logger.info("{}[ip_filter] [connection_granted]\torigin_address=[{}], transport_profile=[{}], rule=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)NetworkAddress.format((InetAddress)inetAddress), (Object)profile, (Object)rule, (Object)this.opaqueId());
        }
    }

    @Override
    public void connectionDenied(InetAddress inetAddress, String profile, SecurityIpFilterRule rule) {
        if (this.events.contains((Object)AuditLevel.CONNECTION_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(LoggingAuditTrail.AuditEventMetaInfo.EMPTY)) {
            this.logger.info("{}[ip_filter] [connection_denied]\torigin_address=[{}], transport_profile=[{}], rule=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)NetworkAddress.format((InetAddress)inetAddress), (Object)profile, (Object)rule, (Object)this.opaqueId());
        }
    }

    @Override
    public void runAsGranted(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_GRANTED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(DeprecatedLoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [run_as_granted]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [run_as_granted]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, String action, TransportMessage message, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED)) {
            Optional<String[]> indices = DeprecatedLoggingAuditTrail.indices(message);
            if (!this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(DeprecatedLoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), indices))) {
                LocalNodeInfo localNodeInfo = this.localNodeInfo;
                if (indices.isPresent()) {
                    this.logger.info("{}[transport] [run_as_denied]\t{}, {}, roles=[{}], action=[{}], indices=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)Strings.arrayToCommaDelimitedString((Object[])indices.get()), (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                } else {
                    this.logger.info("{}[transport] [run_as_denied]\t{}, {}, roles=[{}], action=[{}], request=[{}]{}", (Object)localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.originAttributes(this.threadContext, message, localNodeInfo), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)action, (Object)message.getClass().getSimpleName(), (Object)this.opaqueId());
                }
            }
        }
    }

    @Override
    public void runAsDenied(Authentication authentication, RestRequest request, String[] roleNames) {
        if (this.events.contains((Object)AuditLevel.RUN_AS_DENIED) && !this.eventFilterPolicyRegistry.ignorePredicate().test(new LoggingAuditTrail.AuditEventMetaInfo(Optional.of(authentication.getUser()), Optional.of(DeprecatedLoggingAuditTrail.effectiveRealmName(authentication)), Optional.of(roleNames), Optional.empty()))) {
            if (this.includeRequestBody) {
                this.logger.info("{}[rest] [run_as_denied]\t{}, {}, roles=[{}], uri=[{}], request_body=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)request.uri(), (Object)AuditUtil.restRequestContent(request), (Object)this.opaqueId());
            } else {
                this.logger.info("{}[rest] [run_as_denied]\t{}, {}, roles=[{}], uri=[{}]{}", (Object)this.localNodeInfo.prefix, (Object)DeprecatedLoggingAuditTrail.hostAttributes(request), (Object)DeprecatedLoggingAuditTrail.runAsSubject(authentication), (Object)Strings.arrayToCommaDelimitedString((Object[])roleNames), (Object)request.uri(), (Object)this.opaqueId());
            }
        }
    }

    static String runAsSubject(Authentication authentication) {
        StringBuilder sb = new StringBuilder("principal=[");
        sb.append(authentication.getUser().authenticatedUser().principal());
        sb.append("], realm=[");
        sb.append(authentication.getAuthenticatedBy().getName());
        sb.append("], run_as_principal=[");
        sb.append(authentication.getUser().principal());
        if (authentication.getLookedUpBy() != null) {
            sb.append("], run_as_realm=[").append(authentication.getLookedUpBy().getName());
        }
        sb.append("]");
        return sb.toString();
    }

    static String subject(Authentication authentication) {
        StringBuilder sb = new StringBuilder("principal=[");
        sb.append(authentication.getUser().principal()).append("], realm=[");
        if (authentication.getUser().isRunAs()) {
            sb.append(authentication.getLookedUpBy().getName()).append("], run_by_principal=[");
            sb.append(authentication.getUser().authenticatedUser().principal()).append("], run_by_realm=[");
        }
        sb.append(authentication.getAuthenticatedBy().getName()).append("]");
        return sb.toString();
    }

    private static String hostAttributes(RestRequest request) {
        SocketAddress socketAddress = request.getRemoteAddress();
        String formattedAddress = socketAddress instanceof InetSocketAddress ? NetworkAddress.format((InetAddress)((InetSocketAddress)socketAddress).getAddress()) : socketAddress.toString();
        return "origin_address=[" + formattedAddress + "]";
    }

    protected static String originAttributes(ThreadContext threadContext, TransportMessage message, LocalNodeInfo localNodeInfo) {
        return DeprecatedLoggingAuditTrail.restOriginTag(threadContext).orElse(DeprecatedLoggingAuditTrail.transportOriginTag(message).orElse(localNodeInfo.localOriginTag));
    }

    private String opaqueId() {
        String opaqueId = this.threadContext.getHeader("X-Opaque-Id");
        if (opaqueId != null) {
            return ", opaque_id=[" + opaqueId + "]";
        }
        return "";
    }

    private static Optional<String> restOriginTag(ThreadContext threadContext) {
        InetSocketAddress restAddress = RemoteHostHeader.restRemoteAddress(threadContext);
        if (restAddress == null) {
            return Optional.empty();
        }
        return Optional.of("origin_type=[rest], origin_address=[" + NetworkAddress.format((InetAddress)restAddress.getAddress()) + "]");
    }

    private static Optional<String> transportOriginTag(TransportMessage message) {
        TransportAddress address = message.remoteAddress();
        if (address == null) {
            return Optional.empty();
        }
        return Optional.of("origin_type=[transport], origin_address=[" + NetworkAddress.format((InetAddress)address.address().getAddress()) + "]");
    }

    static Optional<String[]> indices(TransportMessage message) {
        String[] indices;
        if (message instanceof IndicesRequest && (indices = ((IndicesRequest)message).indices()) != null && indices.length != 0) {
            return Optional.of(((IndicesRequest)message).indices());
        }
        return Optional.empty();
    }

    static String effectiveRealmName(Authentication authentication) {
        return authentication.getLookedUpBy() != null ? authentication.getLookedUpBy().getName() : authentication.getAuthenticatedBy().getName();
    }

    static String principal(User user) {
        StringBuilder builder = new StringBuilder("principal=[");
        builder.append(user.principal());
        if (user.isRunAs()) {
            builder.append("], run_by_principal=[").append(user.authenticatedUser().principal());
        }
        return builder.append("]").toString();
    }

    public void clusterChanged(ClusterChangedEvent event) {
        this.updateLocalNodeInfo(event.state().getNodes().getLocalNode());
    }

    void updateLocalNodeInfo(DiscoveryNode newLocalNode) {
        LocalNodeInfo localNodeInfo = this.localNodeInfo;
        if (localNodeInfo.localNode == null || !localNodeInfo.localNode.equals((Object)newLocalNode)) {
            this.localNodeInfo = new LocalNodeInfo(localNodeInfo.settings, newLocalNode);
        }
    }

    static class LocalNodeInfo {
        private final Settings settings;
        private final DiscoveryNode localNode;
        final String prefix;
        private final String localOriginTag;

        LocalNodeInfo(Settings settings, @Nullable DiscoveryNode newLocalNode) {
            this.settings = settings;
            this.localNode = newLocalNode;
            this.prefix = LocalNodeInfo.resolvePrefix(settings, newLocalNode);
            this.localOriginTag = LocalNodeInfo.localOriginTag(newLocalNode);
        }

        static String resolvePrefix(Settings settings, @Nullable DiscoveryNode localNode) {
            String name;
            StringBuilder builder = new StringBuilder();
            if (((Boolean)LoggingAuditTrail.EMIT_HOST_ADDRESS_SETTING.get(settings)).booleanValue()) {
                String address;
                String string = address = localNode != null ? localNode.getHostAddress() : null;
                if (address != null) {
                    builder.append("[").append(address).append("] ");
                }
            }
            if (((Boolean)LoggingAuditTrail.EMIT_HOST_NAME_SETTING.get(settings)).booleanValue()) {
                String hostName;
                String string = hostName = localNode != null ? localNode.getHostName() : null;
                if (hostName != null) {
                    builder.append("[").append(hostName).append("] ");
                }
            }
            if (((Boolean)LoggingAuditTrail.EMIT_NODE_NAME_SETTING.get(settings)).booleanValue() && (name = (String)Node.NODE_NAME_SETTING.get(settings)) != null) {
                builder.append("[").append(name).append("] ");
            }
            return builder.toString();
        }

        private static String localOriginTag(@Nullable DiscoveryNode localNode) {
            if (localNode == null) {
                return "origin_type=[local_node]";
            }
            return "origin_type=[local_node], origin_address=[" + localNode.getHostAddress() + "]";
        }
    }
}

