/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.support.NoOpLogger;
import org.elasticsearch.xpack.core.security.support.Validation;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.support.SecurityFiles;

public class FileUserRolesStore {
    private static final Logger logger = LogManager.getLogger(FileUserRolesStore.class);
    private static final Pattern USERS_DELIM = Pattern.compile("\\s*,\\s*");
    private final Path file;
    private final CopyOnWriteArrayList<Runnable> listeners;
    private volatile Map<String, String[]> userRoles;

    FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, () -> {});
    }

    FileUserRolesStore(RealmConfig config, ResourceWatcherService watcherService, Runnable listener) {
        this.file = FileUserRolesStore.resolveFile(config.env());
        this.userRoles = FileUserRolesStore.parseFileLenient(this.file, logger);
        this.listeners = new CopyOnWriteArrayList<Runnable>(Collections.singletonList(listener));
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener((Object)new FileListener());
        try {
            watcherService.add((ResourceWatcher)watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching the user roles file [" + this.file.toAbsolutePath() + "]", (Throwable)e, new Object[0]);
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    int entriesCount() {
        return this.userRoles.size();
    }

    public String[] roles(String username) {
        String[] roles = this.userRoles.get(username);
        return roles == null ? Strings.EMPTY_ARRAY : roles;
    }

    public static Path resolveFile(Environment env) {
        return Security.resolveConfigFile(env, "users_roles");
    }

    static Map<String, String[]> parseFileLenient(Path path, Logger logger) {
        try {
            Map<String, String[]> map = FileUserRolesStore.parseFile(path, logger);
            return map == null ? Collections.emptyMap() : map;
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse users_roles file [{}]. skipping/removing all entries...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, String[]> parseFile(Path path, @Nullable Logger logger) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users_roles file [{}]...", (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try {
            lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not read users file [" + path.toAbsolutePath() + "]", (Throwable)ioe, new Object[0]);
        }
        HashMap<String, List> userToRoles = new HashMap<String, List>();
        int lineNr = 0;
        for (String line : lines) {
            ++lineNr;
            if (line.startsWith("#")) continue;
            int i = line.indexOf(":");
            if (i <= 0 || i == line.length() - 1) {
                logger.error("invalid entry in users_roles file [{}], line [{}]. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String role = line.substring(0, i).trim();
            Validation.Error validationError = Validation.Roles.validateRoleName((String)role, (boolean)true);
            if (validationError != null) {
                logger.error("invalid role entry in users_roles file [{}], line [{}] - {}. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr, (Object)validationError);
                continue;
            }
            String usersStr = line.substring(i + 1).trim();
            if (Strings.isEmpty((CharSequence)usersStr)) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", (Object)role, (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String[] roleUsers = USERS_DELIM.split(usersStr);
            if (roleUsers.length == 0) {
                logger.error("invalid entry for role [{}] in users_roles file [{}], line [{}]. no users found. skipping...", (Object)role, (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            for (String user : roleUsers) {
                List roles = userToRoles.computeIfAbsent(user, k -> new ArrayList());
                roles.add(role);
            }
        }
        HashMap<String, String[]> usersRoles = new HashMap<String, String[]>();
        for (Map.Entry entry : userToRoles.entrySet()) {
            usersRoles.put((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[((List)entry.getValue()).size()]));
        }
        logger.debug("parsed [{}] user to role mappings from file [{}]", (Object)usersRoles.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(usersRoles);
    }

    public static void writeFile(Map<String, String[]> userToRoles, Path path) {
        HashMap<String, List> roleToUsers = new HashMap<String, List>();
        for (Map.Entry<String, String[]> entry : userToRoles.entrySet()) {
            for (String role : entry.getValue()) {
                List users = roleToUsers.computeIfAbsent(role, k -> new ArrayList());
                users.add(entry.getKey());
            }
        }
        SecurityFiles.writeFileAtomically(path, roleToUsers, e -> String.format(Locale.ROOT, "%s:%s", e.getKey(), Strings.collectionToCommaDelimitedString((Iterable)((Iterable)e.getValue()))));
    }

    void notifyRefresh() {
        this.listeners.forEach(Runnable::run);
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        public void onFileChanged(Path file) {
            if (file.equals(FileUserRolesStore.this.file)) {
                logger.info("users roles file [{}] changed. updating users roles...", (Object)file.toAbsolutePath());
                FileUserRolesStore.this.userRoles = FileUserRolesStore.parseFileLenient(file, logger);
                FileUserRolesStore.this.notifyRefresh();
            }
        }
    }
}

