/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.xpack.core.security.authz.permission.Role;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.support.SecurityIndexManager;

class AuthorizedIndices {
    private final User user;
    private final String action;
    private final MetaData metaData;
    private final Role userRoles;
    private List<String> authorizedIndices;

    AuthorizedIndices(User user, Role userRoles, String action, MetaData metaData) {
        this.user = user;
        this.userRoles = userRoles;
        this.action = action;
        this.metaData = metaData;
    }

    List<String> get() {
        if (this.authorizedIndices == null) {
            this.authorizedIndices = this.load();
        }
        return this.authorizedIndices;
    }

    private List<String> load() {
        Predicate predicate = this.userRoles.indices().allowedIndicesMatcher(this.action);
        ArrayList<String> indicesAndAliases = new ArrayList<String>();
        for (Map.Entry entry : this.metaData.getAliasAndIndexLookup().entrySet()) {
            String aliasOrIndex = (String)entry.getKey();
            if (!predicate.test(aliasOrIndex)) continue;
            indicesAndAliases.add(aliasOrIndex);
        }
        if (!AuthorizationService.isSuperuser(this.user)) {
            indicesAndAliases.removeAll(SecurityIndexManager.indexNames());
        }
        return Collections.unmodifiableList(indicesAndAliases);
    }
}

