/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xpack.core.XPackSettings;

public abstract class SecurityBaseRestHandler
extends BaseRestHandler {
    protected final XPackLicenseState licenseState;

    protected SecurityBaseRestHandler(Settings settings, XPackLicenseState licenseState) {
        super(settings);
        this.licenseState = licenseState;
    }

    protected final BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        BaseRestHandler.RestChannelConsumer consumer = this.innerPrepareRequest(request, client);
        Exception failedFeature = this.checkFeatureAvailable(request);
        if (failedFeature == null) {
            return consumer;
        }
        return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(channel, failedFeature));
    }

    protected Exception checkFeatureAvailable(RestRequest request) {
        if (!((Boolean)XPackSettings.SECURITY_ENABLED.get(this.settings)).booleanValue()) {
            return new IllegalStateException("Security is not enabled but a security rest handler is registered");
        }
        if (!this.licenseState.isSecurityAvailable()) {
            return LicenseUtils.newComplianceException((String)"security");
        }
        if (this.licenseState.isSecurityDisabledByTrialLicense()) {
            return new ElasticsearchException("Security must be explicitly enabled when using a trial license. Enable security by setting [xpack.security.enabled] to [true] in the elasticsearch.yml file and restart the node.", new Object[0]);
        }
        return null;
    }

    protected abstract BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest var1, NodeClient var2) throws IOException;
}

