/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.BubbleMainView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultButtonModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;

public class NodeFoldingComponent
extends JButton {
    private static final int TIMER_DELAY = 50;
    private static final int COLOR_COUNTER_MAX = 15;
    private static final int SIZE_FACTOR_ON_MOUSE_OVER = 4;
    protected static Logger logger = null;
    private boolean mIsEntered;
    private int mColorCounter = 0;
    private NodeView nodeView;
    private boolean mIsEnabled = true;
    private Timer mTimer = null;

    public NodeFoldingComponent(NodeView view) {
        if (logger == null) {
            logger = Resources.getInstance().getLogger(this.getClass().getName());
        }
        this.nodeView = view;
        this.setModel(new DefaultButtonModel());
        this.init(null, null);
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setBackground(Color.BLACK);
        this.setContentAreaFilled(false);
        this.setFocusPainted(false);
        this.setFocusable(false);
        this.setAlignmentY(0.0f);
        this.setUI(new RoundImageButtonUI());
        this.mIsEnabled = Resources.getInstance().getBoolProperty("resources_display_folding_buttons");
        if (this.mIsEnabled) {
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent pE) {
                }

                @Override
                public void mousePressed(MouseEvent pE) {
                }

                @Override
                public void mouseExited(MouseEvent pE) {
                    NodeFoldingComponent.this.mIsEntered = false;
                    NodeFoldingComponent.this.mColorCounter = 15;
                    NodeFoldingComponent.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent pE) {
                    NodeFoldingComponent.this.mIsEntered = true;
                    NodeFoldingComponent.this.startTimer();
                    NodeFoldingComponent.this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent pE) {
                }
            });
            int delay = 50;
            ActionListener taskPerformer = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (NodeFoldingComponent.this.mIsEntered && NodeFoldingComponent.this.mColorCounter < 15) {
                        NodeFoldingComponent.this.mColorCounter++;
                        NodeFoldingComponent.this.repaint();
                    }
                    if (!NodeFoldingComponent.this.mIsEntered && NodeFoldingComponent.this.mColorCounter > 0) {
                        NodeFoldingComponent.this.mColorCounter--;
                        if (NodeFoldingComponent.this.mColorCounter == 0) {
                            NodeFoldingComponent.this.stopTimer();
                        }
                        NodeFoldingComponent.this.repaint();
                    }
                }
            };
            this.mTimer = new Timer(delay, taskPerformer);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getUI().getPreferredSize(this);
    }

    private int getZoomedCircleRadius() {
        return this.nodeView.getZoomedFoldingSymbolHalfWidth();
    }

    public NodeView getNodeView() {
        return this.nodeView;
    }

    public void setCorrectedLocation(Point p) {
        int zoomedCircleRadius = this.getZoomedCircleRadius();
        boolean left = this.nodeView.getModel().isLeft();
        int xCorrection = (int)((float)zoomedCircleRadius * (4.0f + (left ? 1.0f : -1.0f)));
        this.setLocation(p.x - xCorrection, p.y - zoomedCircleRadius * 4);
    }

    public void dispose() {
        if (this.mTimer != null) {
            this.stopTimer();
            this.mTimer = null;
        }
    }

    protected boolean isFolded() {
        MindMapNode model = this.nodeView.getModel();
        return model.isFolded() && model.isVisible();
    }

    protected synchronized void startTimer() {
        if (!this.mTimer.isRunning()) {
            this.mTimer.start();
        }
    }

    protected synchronized void stopTimer() {
        if (this.mTimer.isRunning()) {
            this.mTimer.stop();
        }
    }

    class RoundImageButtonUI
    extends BasicButtonUI {
        protected Shape shape;
        protected Shape base;

        RoundImageButtonUI() {
        }

        @Override
        protected void installDefaults(AbstractButton b) {
            super.installDefaults(b);
            this.clearTextShiftOffset();
            this.defaultTextShiftOffset = 0;
            b.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            b.setContentAreaFilled(false);
            b.setFocusPainted(false);
            b.setOpaque(false);
            b.setBackground(Color.BLACK);
            b.setAlignmentY(0.0f);
            this.initShape(b);
        }

        @Override
        protected void installListeners(AbstractButton b) {
            BasicButtonListener listener = new BasicButtonListener(b){

                @Override
                public void mousePressed(MouseEvent e) {
                    AbstractButton b = (AbstractButton)e.getSource();
                    RoundImageButtonUI.this.initShape(b);
                    if (RoundImageButtonUI.this.shape.contains(e.getX(), e.getY())) {
                        super.mousePressed(e);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                    AbstractButton b = (AbstractButton)e.getSource();
                    RoundImageButtonUI.this.initShape(b);
                    if (RoundImageButtonUI.this.shape.contains(e.getX(), e.getY())) {
                        super.mouseEntered(e);
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    AbstractButton b = (AbstractButton)e.getSource();
                    RoundImageButtonUI.this.initShape(b);
                    if (RoundImageButtonUI.this.shape.contains(e.getX(), e.getY())) {
                        super.mouseEntered(e);
                    } else {
                        super.mouseExited(e);
                    }
                }
            };
            b.addMouseListener(listener);
            b.addMouseMotionListener(listener);
            b.addFocusListener(listener);
            b.addPropertyChangeListener(listener);
            b.addChangeListener(listener);
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Graphics2D g2 = (Graphics2D)g;
            this.initShape(c);
            Object oldRenderingHint = NodeFoldingComponent.this.nodeView.getController().setEdgesRenderingHint(g2);
            g2.setColor(c.getBackground());
            g2.setStroke(BubbleMainView.DEF_STROKE);
            NodeFoldingComponent b = (NodeFoldingComponent)c;
            Rectangle bounds = this.shape.getBounds();
            Color col = this.getColorForCounter();
            Color lineColor = NodeFoldingComponent.this.nodeView.getModel().getEdge().getColor();
            if (b.mIsEntered) {
                Color oldColor = g2.getColor();
                g2.setColor(NodeFoldingComponent.this.nodeView.getMap().getBackground());
                g2.fillOval(bounds.x, bounds.y, bounds.width, bounds.height);
                g2.setColor(lineColor);
                int xmiddle = bounds.x + bounds.width / 2;
                int ymiddle = bounds.y + bounds.height / 2;
                g2.drawLine(bounds.x, ymiddle, bounds.x + bounds.width, ymiddle);
                if (NodeFoldingComponent.this.isFolded()) {
                    g2.drawLine(xmiddle, bounds.y, xmiddle, bounds.y + bounds.height);
                }
                g2.draw(this.shape);
                g2.setColor(oldColor);
            } else {
                int xmiddle = bounds.x + bounds.width / 2;
                int ymiddle = bounds.y + bounds.height / 2;
                int foldingCircleDiameter = bounds.width / 4;
                Color oldColor = g2.getColor();
                if (NodeFoldingComponent.this.mColorCounter != 0) {
                    int diameter = bounds.width * NodeFoldingComponent.this.mColorCounter / 15;
                    if (NodeFoldingComponent.this.isFolded()) {
                        diameter = Math.max(diameter, foldingCircleDiameter);
                    }
                    int radius = diameter / 2;
                    g2.setColor(NodeFoldingComponent.this.nodeView.getMap().getBackground());
                    g2.fillOval(xmiddle - radius, ymiddle - radius, diameter, diameter);
                    g2.setColor(col);
                    if (NodeFoldingComponent.this.isFolded()) {
                        g2.drawLine(xmiddle, ymiddle - radius, xmiddle, ymiddle + radius);
                    }
                    g2.drawLine(xmiddle - radius, ymiddle, xmiddle + radius, ymiddle);
                    g2.setColor(lineColor);
                    g2.drawOval(xmiddle - radius, ymiddle - radius, diameter, diameter);
                    g2.setColor(oldColor);
                } else if (NodeFoldingComponent.this.isFolded()) {
                    int radius = foldingCircleDiameter / 2;
                    g2.setColor(NodeFoldingComponent.this.nodeView.getMap().getBackground());
                    g2.fillOval(xmiddle - radius, ymiddle - radius, foldingCircleDiameter, foldingCircleDiameter);
                    g2.setColor(lineColor);
                    g2.drawOval(xmiddle - radius, ymiddle - radius, foldingCircleDiameter, foldingCircleDiameter);
                    g2.setColor(oldColor);
                }
            }
            Tools.restoreAntialiasing(g2, oldRenderingHint);
        }

        private Color getColorForCounter() {
            Color color = NodeFoldingComponent.this.nodeView.getModel().getEdge().getColor();
            int col = 16 * NodeFoldingComponent.this.mColorCounter;
            return new Color(color.getRed(), color.getGreen(), color.getBlue(), col);
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            JButton b = (JButton)c;
            Insets i = b.getInsets();
            int iw = (int)((float)NodeFoldingComponent.this.getZoomedCircleRadius() * 2.0f * 4.0f);
            return new Dimension(iw + i.right + i.left, iw + i.top + i.bottom);
        }

        private void initShape(JComponent c) {
            if (!c.getBounds().equals(this.base)) {
                Dimension s = c.getPreferredSize();
                this.base = c.getBounds();
                this.shape = new Ellipse2D.Float(0.0f, 0.0f, s.width - 1, s.height - 1);
            }
        }
    }
}

