/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.windows;

import com.jgoodies.looks.BorderStyle;
import com.jgoodies.looks.HeaderStyle;
import com.sun.java.swing.plaf.windows.WindowsToolBarUI;
import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;

public final class WindowsXPToolBarUI
extends WindowsToolBarUI {
    private PropertyChangeListener listener;

    public static ComponentUI createUI(JComponent b) {
        return new WindowsXPToolBarUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this.installSpecialBorder();
    }

    protected void installListeners() {
        super.installListeners();
        this.listener = this.createBorderStyleListener();
        this.toolBar.addPropertyChangeListener(this.listener);
    }

    protected void uninstallListeners() {
        this.toolBar.removePropertyChangeListener(this.listener);
        super.uninstallListeners();
    }

    private PropertyChangeListener createBorderStyleListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String prop = e.getPropertyName();
                if (prop.equals("jgoodies.headerStyle") || prop.equals("jgoodies.windows.borderStyle")) {
                    WindowsXPToolBarUI.this.installSpecialBorder();
                }
            }
        };
    }

    private void installSpecialBorder() {
        BorderStyle borderStyle = BorderStyle.from(this.toolBar, "jgoodies.windows.borderStyle");
        String suffix = borderStyle == BorderStyle.EMPTY ? "emptyBorder" : (borderStyle == BorderStyle.SEPARATOR ? "separatorBorder" : (borderStyle == BorderStyle.ETCHED ? "etchedBorder" : (HeaderStyle.from(this.toolBar) == HeaderStyle.BOTH ? "headerBorder" : "border")));
        LookAndFeel.installBorder(this.toolBar, "ToolBar." + suffix);
    }

    protected void setBorderToRollover(Component c) {
        if (c instanceof AbstractButton) {
            super.setBorderToRollover(c);
        } else if (c instanceof Container) {
            Container cont = (Container)c;
            int i = 0;
            while (i < cont.getComponentCount()) {
                super.setBorderToRollover(cont.getComponent(i));
                ++i;
            }
        }
    }
}

