/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui;

import java.awt.EventQueue;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.ui.GroupSpecificValidationUI;
import org.netbeans.validation.api.ui.ValidationGroupImpl;
import org.netbeans.validation.api.ui.ValidationUI;

final class MulticastValidationUI
implements ValidationUI {
    private final Set<ValidationUI> real;

    MulticastValidationUI(ValidationUI ... real) {
        this.real = new HashSet<ValidationUI>(Arrays.asList(real));
        assert (this.validUIs(real));
    }

    public void add(ValidationUI ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        assert (EventQueue.isDispatchThread()) : "Not on the event thread";
        assert (!this.contains(ui)) : "Already a member: " + ui;
        this.real.add(ui);
    }

    public void remove(ValidationUI ui) {
        if (ui == null) {
            throw new NullPointerException();
        }
        assert (EventQueue.isDispatchThread()) : "Not on the event thread";
        assert (this.contains(ui)) : "Not a member: " + ui;
        this.real.remove(ui);
    }

    public boolean contains(ValidationUI check) {
        boolean result;
        block1: {
            ValidationUI ui;
            result = this.real.contains(check);
            if (result) break block1;
            Iterator<ValidationUI> i$ = this.real.iterator();
            while (!(!i$.hasNext() || (ui = i$.next()) instanceof MulticastValidationUI && (result = ((MulticastValidationUI)ui).contains(check)))) {
            }
        }
        return result;
    }

    public void clearProblem() {
        assert (this.real != null);
        for (ValidationUI ui : this.real) {
            ui.clearProblem();
        }
    }

    public void setProblem(Problem problem) {
        assert (this.real != null);
        for (ValidationUI ui : this.real) {
            ui.setProblem(problem);
        }
    }

    public boolean validUIs(ValidationUI[] uis) {
        for (int i = 0; i < uis.length; ++i) {
            ValidationUI ui = uis[i];
            if (ui != null) continue;
            throw new NullPointerException("Element " + i + " of ui " + "array is null");
        }
        return true;
    }

    public boolean removeUI(ValidationGroupImpl owner) {
        for (ValidationUI ui : this.real) {
            MulticastValidationUI m;
            if (ui instanceof GroupSpecificValidationUI) {
                GroupSpecificValidationUI g = (GroupSpecificValidationUI)ui;
                if (g.owner != owner) continue;
                this.remove(ui);
                return true;
            }
            if (!(ui instanceof MulticastValidationUI) || !(m = (MulticastValidationUI)ui).removeUI(owner)) continue;
            return true;
        }
        return false;
    }
}

