/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.datalab.tables;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.gephi.datalab.api.DataLaboratoryHelper;
import org.gephi.datalab.spi.Manipulator;
import org.gephi.datalab.spi.edges.EdgesManipulator;
import org.gephi.desktop.datalab.DataTablesModel;
import org.gephi.desktop.datalab.tables.AbstractElementsDataTable;
import org.gephi.desktop.datalab.tables.columns.ElementDataColumn;
import org.gephi.desktop.datalab.tables.columns.PropertyDataColumn;
import org.gephi.desktop.datalab.tables.popup.EdgesPopupAdapter;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.GraphModel;
import org.gephi.tools.api.EditWindowController;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class EdgesDataTable
extends AbstractElementsDataTable<Edge> {
    private boolean showEdgesNodesLabels = false;
    private final PropertyDataColumn<Edge> SOURCE_COLUMN = new PropertyDataColumn<Edge>(NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.source.column.text")){

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValueFor(Edge edge) {
            if (EdgesDataTable.this.showEdgesNodesLabels) {
                return edge.getSource().getId() + " - " + edge.getSource().getLabel();
            }
            return edge.getSource().getId();
        }
    };
    private final PropertyDataColumn<Edge> TARGET_COLUMN = new PropertyDataColumn<Edge>(NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.target.column.text")){

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValueFor(Edge edge) {
            if (EdgesDataTable.this.showEdgesNodesLabels) {
                return edge.getTarget().getId() + " - " + edge.getTarget().getLabel();
            }
            return edge.getTarget().getId();
        }
    };
    private final PropertyDataColumn<Edge> TYPE_COLUMN = new PropertyDataColumn<Edge>(NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.type.column.text")){

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValueFor(Edge edge) {
            if (edge.isDirected()) {
                return NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.type.column.directed");
            }
            return NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.type.column.undirected");
        }
    };
    private final PropertyDataColumn<Edge> KIND_COLUMN = new PropertyDataColumn<Edge>(NbBundle.getMessage(EdgesDataTable.class, (String)"EdgeDataTable.kind.column.text")){

        @Override
        public Class getColumnClass() {
            return String.class;
        }

        @Override
        public Object getValueFor(Edge edge) {
            return edge.getTypeLabel() != null ? edge.getTypeLabel().toString() : null;
        }
    };

    public EdgesDataTable() {
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditWindowController edc;
                if (!EdgesDataTable.this.isRefreshingTable() && (edc = (EditWindowController)Lookup.getDefault().lookup(EditWindowController.class)) != null && edc.isOpen()) {
                    if (EdgesDataTable.this.table.getSelectedRow() != -1) {
                        edc.editEdges(EdgesDataTable.this.getElementsFromSelectedRows().toArray(new Edge[0]));
                    } else {
                        edc.disableEdit();
                    }
                }
            }
        });
        this.table.addMouseListener((MouseListener)((Object)new EdgesPopupAdapter(this)));
        this.table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    EdgesManipulator del;
                    DataLaboratoryHelper dlh = DataLaboratoryHelper.getDefault();
                    List<Edge> selectedEdges = EdgesDataTable.this.getElementsFromSelectedRows();
                    if (!selectedEdges.isEmpty() && (del = dlh.getEdgesManipulatorByName("DeleteEdges")) != null) {
                        del.setup(selectedEdges.toArray(new Edge[0]), null);
                        if (del.canExecute()) {
                            dlh.executeManipulator((Manipulator)del);
                        }
                    }
                }
            }
        });
    }

    @Override
    public List<? extends ElementDataColumn<Edge>> getFakeDataColumns(GraphModel graphModel, DataTablesModel dataTablesModel) {
        ArrayList<PropertyDataColumn<Edge>> propertiesColumns = new ArrayList<PropertyDataColumn<Edge>>();
        propertiesColumns.add(this.SOURCE_COLUMN);
        propertiesColumns.add(this.TARGET_COLUMN);
        propertiesColumns.add(this.TYPE_COLUMN);
        if (graphModel.isMultiGraph()) {
            propertiesColumns.add(this.KIND_COLUMN);
        }
        return propertiesColumns;
    }

    public boolean isShowEdgesNodesLabels() {
        return this.showEdgesNodesLabels;
    }

    public void setShowEdgesNodesLabels(boolean showEdgesNodesLabels) {
        this.showEdgesNodesLabels = showEdgesNodesLabels;
    }
}

