/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.lib.gleem.linalg;

import org.gephi.lib.gleem.linalg.Mat4f;
import org.gephi.lib.gleem.linalg.Vec3f;

public class Rotf {
    private static float EPSILON = 1.0E-7f;
    private float q0;
    private float q1;
    private float q2;
    private float q3;

    public Rotf() {
        this.init();
    }

    public Rotf(Rotf arg) {
        this.set(arg);
    }

    public Rotf(Vec3f axis, float angle) {
        this.set(axis, angle);
    }

    public Rotf(Vec3f from, Vec3f to) {
        this.set(from, to);
    }

    public void init() {
        this.q0 = 1.0f;
        this.q3 = 0.0f;
        this.q2 = 0.0f;
        this.q1 = 0.0f;
    }

    public boolean withinEpsilon(Rotf arg, float epsilon) {
        return Math.abs(this.q0 - arg.q0) < epsilon && Math.abs(this.q1 - arg.q1) < epsilon && Math.abs(this.q2 - arg.q2) < epsilon && Math.abs(this.q3 - arg.q3) < epsilon;
    }

    public void set(Vec3f axis, float angle) {
        float halfTheta = angle / 2.0f;
        this.q0 = (float)Math.cos(halfTheta);
        float sinHalfTheta = (float)Math.sin(halfTheta);
        Vec3f realAxis = new Vec3f(axis);
        realAxis.normalize();
        this.q1 = realAxis.x() * sinHalfTheta;
        this.q2 = realAxis.y() * sinHalfTheta;
        this.q3 = realAxis.z() * sinHalfTheta;
    }

    public void set(Rotf arg) {
        this.q0 = arg.q0;
        this.q1 = arg.q1;
        this.q2 = arg.q2;
        this.q3 = arg.q3;
    }

    public void set(Vec3f from, Vec3f to) {
        Vec3f axis = from.cross(to);
        if (axis.lengthSquared() < EPSILON) {
            this.init();
            return;
        }
        float dotp = from.dot(to);
        float denom = from.length() * to.length();
        if (denom < EPSILON) {
            this.init();
            return;
        }
        this.set(axis, (float)Math.acos(dotp /= denom));
    }

    public float get(Vec3f axis) {
        float retval = (float)(2.0 * Math.acos(this.q0));
        axis.set(this.q1, this.q2, this.q3);
        float len = axis.length();
        if (len == 0.0f) {
            axis.set(0.0f, 0.0f, 1.0f);
        } else {
            axis.scale(1.0f / len);
        }
        return retval;
    }

    public Rotf inverse() {
        Rotf tmp = new Rotf(this);
        tmp.invert();
        return tmp;
    }

    public void invert() {
        this.q1 = -this.q1;
        this.q2 = -this.q2;
        this.q3 = -this.q3;
    }

    public float length() {
        return (float)Math.sqrt(this.lengthSquared());
    }

    public float lengthSquared() {
        return this.q0 * this.q0 + this.q1 * this.q1 + this.q2 * this.q2 + this.q3 * this.q3;
    }

    public void normalize() {
        float len = this.length();
        this.q0 /= len;
        this.q1 /= len;
        this.q2 /= len;
        this.q3 /= len;
    }

    public Rotf times(Rotf b) {
        Rotf tmp = new Rotf();
        tmp.mul(this, b);
        return tmp;
    }

    public void mul(Rotf a, Rotf b) {
        this.q0 = a.q0 * b.q0 - a.q1 * b.q1 - a.q2 * b.q2 - a.q3 * b.q3;
        this.q1 = a.q0 * b.q1 + a.q1 * b.q0 + a.q2 * b.q3 - a.q3 * b.q2;
        this.q2 = a.q0 * b.q2 + a.q2 * b.q0 - a.q1 * b.q3 + a.q3 * b.q1;
        this.q3 = a.q0 * b.q3 + a.q3 * b.q0 + a.q1 * b.q2 - a.q2 * b.q1;
    }

    public void toMatrix(Mat4f mat) {
        float q00 = this.q0 * this.q0;
        float q11 = this.q1 * this.q1;
        float q22 = this.q2 * this.q2;
        float q33 = this.q3 * this.q3;
        mat.set(0, 0, q00 + q11 - q22 - q33);
        mat.set(1, 1, q00 - q11 + q22 - q33);
        mat.set(2, 2, q00 - q11 - q22 + q33);
        float q03 = this.q0 * this.q3;
        float q12 = this.q1 * this.q2;
        mat.set(0, 1, 2.0f * (q12 - q03));
        mat.set(1, 0, 2.0f * (q03 + q12));
        float q02 = this.q0 * this.q2;
        float q13 = this.q1 * this.q3;
        mat.set(0, 2, 2.0f * (q02 + q13));
        mat.set(2, 0, 2.0f * (q13 - q02));
        float q01 = this.q0 * this.q1;
        float q23 = this.q2 * this.q3;
        mat.set(1, 2, 2.0f * (q23 - q01));
        mat.set(2, 1, 2.0f * (q01 + q23));
    }

    public void fromMatrix(Mat4f mat) {
        float tr = mat.get(0, 0) + mat.get(1, 1) + mat.get(2, 2);
        if ((double)tr > 0.0) {
            float s = (float)Math.sqrt(tr + 1.0f);
            this.q0 = s * 0.5f;
            s = 0.5f / s;
            this.q1 = (mat.get(2, 1) - mat.get(1, 2)) * s;
            this.q2 = (mat.get(0, 2) - mat.get(2, 0)) * s;
            this.q3 = (mat.get(1, 0) - mat.get(0, 1)) * s;
        } else {
            int i = 0;
            if (mat.get(1, 1) > mat.get(0, 0)) {
                i = 1;
            }
            if (mat.get(2, 2) > mat.get(i, i)) {
                i = 2;
            }
            int j = (i + 1) % 3;
            int k = (j + 1) % 3;
            float s = (float)Math.sqrt(mat.get(i, i) - (mat.get(j, j) + mat.get(k, k)) + 1.0f);
            this.setQ(i + 1, s * 0.5f);
            s = 0.5f / s;
            this.q0 = (mat.get(k, j) - mat.get(j, k)) * s;
            this.setQ(j + 1, (mat.get(j, i) + mat.get(i, j)) * s);
            this.setQ(k + 1, (mat.get(k, i) + mat.get(i, k)) * s);
        }
    }

    public void rotateVector(Vec3f src, Vec3f dest) {
        Vec3f qVec = new Vec3f(this.q1, this.q2, this.q3);
        Vec3f qCrossX = qVec.cross(src);
        Vec3f qCrossXCrossQ = qCrossX.cross(qVec);
        qCrossX.scale(2.0f * this.q0);
        qCrossXCrossQ.scale(-2.0f);
        dest.add(src, qCrossX);
        dest.add(dest, qCrossXCrossQ);
    }

    public Vec3f rotateVector(Vec3f src) {
        Vec3f tmp = new Vec3f();
        this.rotateVector(src, tmp);
        return tmp;
    }

    public String toString() {
        return "(" + this.q0 + ", " + this.q1 + ", " + this.q2 + ", " + this.q3 + ")";
    }

    private void setQ(int i, float val) {
        switch (i) {
            case 0: {
                this.q0 = val;
                break;
            }
            case 1: {
                this.q1 = val;
                break;
            }
            case 2: {
                this.q2 = val;
                break;
            }
            case 3: {
                this.q3 = val;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException();
            }
        }
    }
}

