/*
 * Decompiled with CFR 0.152.
 */
package com.sparshui.common.messages.events;

import com.sparshui.common.Event;
import com.sparshui.common.utils.Converter;

public class DragEvent
implements Event {
    private static final long serialVersionUID = -2305607021385835330L;
    private float _dx;
    private float _dy;
    private byte _nPoints = 1;
    private long _time;

    public DragEvent() {
        this._dx = 0.0f;
        this._dy = 0.0f;
    }

    public DragEvent(float dx, float dy, int nPoints, long time) {
        this._dx = dx;
        this._dy = dy;
        this._nPoints = (byte)nPoints;
        this._time = time;
    }

    public DragEvent(byte[] data) {
        if (data.length < 17) {
            System.err.println("Error constructing Drag Event.");
            this._dx = 0.0f;
            this._dy = 0.0f;
        } else {
            this._dx = Converter.byteArrayToFloat(data, 0);
            this._dy = Converter.byteArrayToFloat(data, 4);
            this._nPoints = data[8];
            this._time = Converter.byteArrayToLong(data, 9);
        }
    }

    public long getTime() {
        return this._time;
    }

    public int getNPoints() {
        return this._nPoints;
    }

    public float getDx() {
        return this._dx;
    }

    public float getDy() {
        return this._dy;
    }

    public void setDx(float dx) {
        this._dx = dx;
    }

    public void setDy(float dy) {
        this._dy = dy;
    }

    @Override
    public int getEventType() {
        return 0;
    }

    public String toString() {
        String ret = "Drag Event: dx = " + this._dx + ", dy = " + this._dy;
        return ret;
    }

    @Override
    public byte[] serialize() {
        byte[] data = new byte[21];
        Converter.intToByteArray(data, 0, this.getEventType());
        Converter.floatToByteArray(data, 4, this._dx);
        Converter.floatToByteArray(data, 8, this._dy);
        data[12] = this._nPoints;
        Converter.longToByteArray(data, 13, this._time);
        return data;
    }
}

