/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik.suggestions_ordering;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.language.Demo;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrderer;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;

public class SuggestionsOrdererTest {
    private String originalConfigNgramsPathValue;
    private boolean originalConfigMLSuggestionsOrderingEnabledValue;

    @Before
    public void setUp() throws Exception {
        this.originalConfigNgramsPathValue = SuggestionsOrdererConfig.getNgramsPath();
        this.originalConfigMLSuggestionsOrderingEnabledValue = SuggestionsOrdererConfig.isMLSuggestionsOrderingEnabled();
    }

    @After
    public void tearDown() {
        SuggestionsOrdererConfig.setNgramsPath((String)this.originalConfigNgramsPathValue);
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)this.originalConfigMLSuggestionsOrderingEnabledValue);
    }

    @Test
    public void orderSuggestionsUsingModelNonExistingRuleId() throws IOException {
        Demo language = new Demo();
        String rule_id = "rule_id";
        this.testOrderingHappened(language, rule_id);
    }

    @Test
    public void orderSuggestionsUsingModelExistingRuleId() throws IOException {
        Demo language = new Demo();
        String rule_id = "MORFOLOGIK_RULE_EN_US";
        this.testOrderingHappened(language, rule_id);
    }

    @Test
    public void orderSuggestionsWithEnabledML() throws IOException {
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)true);
        this.orderSuggestionsUsingModelExistingRuleId();
    }

    @Test
    public void orderSuggestionsWithDisabledML() throws IOException {
        SuggestionsOrdererConfig.setMLSuggestionsOrderingEnabled((boolean)false);
        this.orderSuggestionsUsingModelExistingRuleId();
    }

    private void testOrderingHappened(Language language, String rule_id) throws IOException {
        JLanguageTool languageTool = new JLanguageTool(language);
        SuggestionsOrderer suggestionsOrderer = new SuggestionsOrderer(language, rule_id);
        String word = "wprd";
        String sentence = String.join((CharSequence)" ", "a", word, "containing", "sentence");
        LinkedList<String> suggestions = new LinkedList<String>();
        suggestions.add("word");
        suggestions.add("weird");
        int startPos = sentence.indexOf(word);
        int wordLength = word.length();
        List suggestionsOrdered = suggestionsOrderer.orderSuggestionsUsingModel(suggestions, word, languageTool.getAnalyzedSentence(sentence), startPos, wordLength);
        Assert.assertTrue((boolean)suggestionsOrdered.containsAll(suggestions));
    }
}

