/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.languagetool.server.DatabaseLogEntry;

public class DatabaseAccessLimitLogEntry
extends DatabaseLogEntry {
    private final Calendar date = Calendar.getInstance();
    private final String type;
    private final Long server;
    private final Long client;
    private final Long user;
    private final String reason;
    private final String referrer;
    private final String userAgent;

    DatabaseAccessLimitLogEntry(String type, Long server, Long client, Long user, String reason, String referrer, String userAgent) {
        this.type = type;
        this.server = server;
        this.client = client;
        this.user = user;
        this.referrer = referrer;
        this.userAgent = userAgent;
        this.reason = reason;
    }

    @Override
    public Map<Object, Object> getMapping() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        HashMap<Object, Object> parameters = new HashMap<Object, Object>();
        parameters.put("type", this.type);
        parameters.put("date", dateFormat.format(this.date.getTime()));
        parameters.put("server", this.server);
        parameters.put("client", this.client);
        parameters.put("user", this.user);
        parameters.put("referrer", this.referrer);
        parameters.put("user_agent", this.userAgent);
        parameters.put("reason", this.reason);
        return parameters;
    }

    @Override
    public String getMappingIdentifier() {
        return "org.languagetool.server.LogMapper.accessLimit";
    }

    @Override
    public void followup(Map<Object, Object> parameters) {
    }
}

