var Keyword = require('../tree/keyword'),
    functionRegistry = require('./function-registry');

var defaultFunc = {
    eval: function () {
        var v = this.value_, e = this.error_;
        if (e) {
            throw e;
        }
        if (v != null) {
            return v ? Keyword.True : Keyword.False;
        }
    },
    value: function (v) {
        this.value_ = v;
    },
    error: function (e) {
        this.error_ = e;
    },
    reset: function () {
        this.value_ = this.error_ = null;
    }
};

functionRegistry.add('default', defaultFunc.eval.bind(defaultFunc));

module.exports = defaultFunc;
