/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Clipboard;
import com.sun.glass.ui.ClipboardAssistance;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SystemClipboard
extends Clipboard {
    protected SystemClipboard(String name) {
        super(name);
    }

    protected abstract boolean isOwner();

    protected abstract void pushToSystem(HashMap<String, Object> var1, int var2);

    protected abstract void pushTargetActionToSystem(int var1);

    protected abstract Object popFromSystem(String var1);

    protected abstract int supportedSourceActionsFromSystem();

    protected abstract String[] mimesFromSystem();

    @Override
    public void flush(ClipboardAssistance dataSource, HashMap<String, Object> cacheData, int supportedActions) {
        this.setSharedData(dataSource, cacheData, supportedActions);
        this.pushToSystem(cacheData, supportedActions);
    }

    @Override
    public int getSupportedSourceActions() {
        if (this.isOwner()) {
            return super.getSupportedSourceActions();
        }
        return this.supportedSourceActionsFromSystem();
    }

    @Override
    public void setTargetAction(int actionDone) {
        this.pushTargetActionToSystem(actionDone);
    }

    public Object getLocalData(String mimeType) {
        return super.getData(mimeType);
    }

    @Override
    public Object getData(String mimeType) {
        if (this.isOwner()) {
            return this.getLocalData(mimeType);
        }
        return this.popFromSystem(mimeType);
    }

    @Override
    public String[] getMimeTypes() {
        if (this.isOwner()) {
            return super.getMimeTypes();
        }
        return this.mimesFromSystem();
    }

    @Override
    public String toString() {
        return "System Clipboard";
    }
}

