/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import com.sun.javafx.css.StyleManager;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyBooleanWrapper;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Labeled;

public abstract class ButtonBase
extends Labeled {
    private ReadOnlyBooleanWrapper armed = new ReadOnlyBooleanWrapper(){

        @Override
        protected void invalidated() {
            ButtonBase.this.impl_pseudoClassStateChanged("armed");
        }

        @Override
        public Object getBean() {
            return ButtonBase.this;
        }

        @Override
        public String getName() {
            return "armed";
        }
    };
    private ObjectProperty<EventHandler<ActionEvent>> onAction = new ObjectPropertyBase<EventHandler<ActionEvent>>(){

        @Override
        protected void invalidated() {
            ButtonBase.this.setEventHandler(ActionEvent.ACTION, (EventHandler)this.get());
        }

        @Override
        public Object getBean() {
            return ButtonBase.this;
        }

        @Override
        public String getName() {
            return "onAction";
        }
    };
    private static final long ARMED_PSEUDOCLASS_STATE = StyleManager.getInstance().getPseudoclassMask("armed");

    public ButtonBase() {
    }

    public ButtonBase(String string) {
        super(string);
    }

    public ButtonBase(String string, Node node) {
        super(string, node);
    }

    public final ReadOnlyBooleanProperty armedProperty() {
        return this.armed.getReadOnlyProperty();
    }

    private void setArmed(boolean bl) {
        this.armed.set(bl);
    }

    public final boolean isArmed() {
        return this.armedProperty().get();
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onActionProperty() {
        return this.onAction;
    }

    public final void setOnAction(EventHandler<ActionEvent> eventHandler) {
        this.onActionProperty().set(eventHandler);
    }

    public final EventHandler<ActionEvent> getOnAction() {
        return (EventHandler)this.onActionProperty().get();
    }

    public void arm() {
        this.setArmed(true);
    }

    public void disarm() {
        this.setArmed(false);
    }

    public abstract void fire();

    @Override
    @Deprecated
    public long impl_getPseudoClassState() {
        long l = super.impl_getPseudoClassState();
        if (this.isArmed()) {
            l |= ARMED_PSEUDOCLASS_STATE;
        }
        return l;
    }
}

