/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search.extractor;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.querydsl.container.GroupByRef;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class CompositeKeyExtractor
implements BucketExtractor {
    static final String NAME = "k";
    private final String key;
    private final GroupByRef.Property property;
    private final TimeZone timeZone;

    public CompositeKeyExtractor(String key, GroupByRef.Property property, TimeZone timeZone) {
        this.key = key;
        this.property = property;
        this.timeZone = timeZone;
    }

    CompositeKeyExtractor(StreamInput in) throws IOException {
        DateTimeZone dtz;
        this.key = in.readString();
        this.property = (GroupByRef.Property)in.readEnum(GroupByRef.Property.class);
        this.timeZone = in.getVersion().onOrAfter(Version.V_6_3_0) ? (in.readBoolean() ? TimeZone.getTimeZone(in.readString()) : null) : ((dtz = in.readOptionalTimeZone()) == null ? null : dtz.toTimeZone());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.key);
        out.writeEnum((Enum)this.property);
        if (out.getVersion().onOrAfter(Version.V_6_3_0)) {
            if (this.timeZone == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                out.writeString(this.timeZone.getID());
            }
        } else {
            out.writeOptionalTimeZone(this.timeZone == null ? null : DateTimeZone.forTimeZone((TimeZone)this.timeZone));
        }
    }

    String key() {
        return this.key;
    }

    GroupByRef.Property property() {
        return this.property;
    }

    TimeZone timeZone() {
        return this.timeZone;
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object extract(MultiBucketsAggregation.Bucket bucket) {
        if (this.property == GroupByRef.Property.COUNT) {
            return bucket.getDocCount();
        }
        Object m = bucket.getKey();
        if (!(m instanceof Map)) {
            throw new SqlIllegalArgumentException("Unexpected bucket returned: {}", m);
        }
        Object object = ((Map)m).get(this.key);
        if (this.timeZone != null) {
            if (object == null) {
                return object;
            }
            if (object instanceof Long) {
                object = new DateTime(((Long)object).longValue(), DateTimeZone.forTimeZone((TimeZone)this.timeZone));
            } else {
                throw new SqlIllegalArgumentException("Invalid date key returned: {}", object);
            }
        }
        return object;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.property, this.timeZone});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeKeyExtractor other = (CompositeKeyExtractor)obj;
        return Objects.equals(this.key, other.key) && Objects.equals((Object)this.property, (Object)other.property) && Objects.equals(this.timeZone, other.timeZone);
    }

    public String toString() {
        return "|" + this.key + "|";
    }
}

