/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class UnaryExpression
extends NamedExpression {
    private final Expression child;

    protected UnaryExpression(Location location, Expression child) {
        super(location, null, Collections.singletonList(child), null);
        this.child = child;
    }

    @Override
    public final UnaryExpression replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("expected [1] child but received [" + newChildren.size() + "]");
        }
        return this.replaceChild(newChildren.get(0));
    }

    protected abstract UnaryExpression replaceChild(Expression var1);

    public Expression child() {
        return this.child;
    }

    @Override
    public boolean foldable() {
        return this.child.foldable();
    }

    @Override
    public boolean nullable() {
        return this.child.nullable();
    }

    @Override
    public boolean resolved() {
        return this.child.resolved();
    }

    @Override
    public DataType dataType() {
        return this.child.dataType();
    }

    @Override
    public Attribute toAttribute() {
        throw new SqlIllegalArgumentException("Not supported yet");
    }

    @Override
    public ScriptTemplate asScript() {
        throw new SqlIllegalArgumentException("Not supported yet");
    }

    @Override
    protected Pipe makePipe() {
        throw new SqlIllegalArgumentException("Not supported yet");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.child);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnaryExpression other = (UnaryExpression)obj;
        return Objects.equals(this.child, other.child);
    }
}

