/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;

public class ConstantProcessor
implements Processor {
    public static String NAME = "c";
    private final Object constant;

    public ConstantProcessor(Object value) {
        this.constant = value;
    }

    public ConstantProcessor(StreamInput in) throws IOException {
        this.constant = in.readGenericValue();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeGenericValue(this.constant);
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        return this.constant;
    }

    public int hashCode() {
        return Objects.hashCode(this.constant);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantProcessor other = (ConstantProcessor)obj;
        return Objects.equals(this.constant, other.constant);
    }

    public String toString() {
        return "^" + this.constant;
    }
}

