/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import java.io.IOException;
import java.util.function.BiFunction;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.FunctionalBinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.Arithmetics;

public class BinaryArithmeticProcessor
extends FunctionalBinaryProcessor<Number, Number, Number, BinaryArithmeticOperation> {
    public static final String NAME = "ab";

    public BinaryArithmeticProcessor(Processor left, Processor right, BinaryArithmeticOperation operation) {
        super(left, right, operation);
    }

    public BinaryArithmeticProcessor(StreamInput in) throws IOException {
        super(in, i -> (BinaryArithmeticOperation)i.readEnum(BinaryArithmeticOperation.class));
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void checkParameter(Object param) {
        if (!(param instanceof Number)) {
            throw new SqlIllegalArgumentException("A number is required; received {}", param);
        }
    }

    public static enum BinaryArithmeticOperation implements PredicateBiFunction<Number, Number, Number>
    {
        ADD(Arithmetics::add, "+"),
        SUB(Arithmetics::sub, "-"),
        MUL(Arithmetics::mul, "*"),
        DIV(Arithmetics::div, "/"),
        MOD(Arithmetics::mod, "%");

        private final BiFunction<Number, Number, Number> process;
        private final String symbol;

        private BinaryArithmeticOperation(BiFunction<Number, Number, Number> process, String symbol) {
            this.process = process;
            this.symbol = symbol;
        }

        @Override
        public String symbol() {
            return this.symbol;
        }

        @Override
        public final Number doApply(Number left, Number right) {
            return this.process.apply(left, right);
        }

        public String toString() {
            return this.symbol;
        }
    }
}

