/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.regex;

import java.io.IOException;
import java.util.Objects;
import java.util.regex.Pattern;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.BinaryProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.predicate.PredicateBiFunction;

public class RegexProcessor
extends BinaryProcessor {
    public static final String NAME = "rgx";

    public RegexProcessor(Processor value, Processor pattern) {
        super(value, pattern);
    }

    public RegexProcessor(StreamInput in) throws IOException {
        super(in);
    }

    @Override
    protected Boolean doProcess(Object value, Object pattern) {
        return RegexOperation.match(value, pattern);
    }

    @Override
    protected void checkParameter(Object param) {
        if (!(param instanceof String) && !(param instanceof Character)) {
            throw new SqlIllegalArgumentException("A string/char is required; received [{}]", param);
        }
    }

    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected void doWrite(StreamOutput out) throws IOException {
    }

    public int hashCode() {
        return Objects.hash(this.left(), this.right());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegexProcessor other = (RegexProcessor)obj;
        return Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public static class RegexOperation
    implements PredicateBiFunction<String, String, Boolean> {
        public static final RegexOperation INSTANCE = new RegexOperation();

        @Override
        public String name() {
            return this.symbol();
        }

        @Override
        public String symbol() {
            return "REGEX";
        }

        @Override
        public Boolean doApply(String value, String pattern) {
            return RegexOperation.match(value, pattern);
        }

        public static Boolean match(Object value, Object pattern) {
            if (value == null || pattern == null) {
                return null;
            }
            Pattern p = Pattern.compile(pattern.toString());
            return p.matcher(value.toString()).matches();
        }
    }
}

