/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.sql.plan.logical.UnaryPlan;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class Filter
extends UnaryPlan {
    private final Expression condition;

    public Filter(Location location, LogicalPlan child, Expression condition) {
        super(location, child);
        this.condition = condition;
    }

    @Override
    protected NodeInfo<Filter> info() {
        return NodeInfo.create(this, Filter::new, this.child(), this.condition);
    }

    @Override
    protected Filter replaceChild(LogicalPlan newChild) {
        return new Filter(this.location(), newChild, this.condition);
    }

    public Expression condition() {
        return this.condition;
    }

    @Override
    public boolean expressionsResolved() {
        return this.condition.resolved();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.condition, this.child());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Filter other = (Filter)obj;
        return Objects.equals(this.condition, other.condition) && Objects.equals(this.child(), other.child());
    }
}

