/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.FunctionDefinition;
import org.elasticsearch.xpack.sql.expression.function.FunctionRegistry;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;
import org.elasticsearch.xpack.sql.type.KeywordEsField;

public class ShowFunctions
extends Command {
    private final LikePattern pattern;

    public ShowFunctions(Location location, LikePattern pattern) {
        super(location);
        this.pattern = pattern;
    }

    @Override
    protected NodeInfo<ShowFunctions> info() {
        return NodeInfo.create(this, ShowFunctions::new, this.pattern);
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(new FieldAttribute(this.location(), "name", new KeywordEsField("name")), new FieldAttribute(this.location(), "type", new KeywordEsField("type")));
    }

    @Override
    public void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        FunctionRegistry registry = session.functionRegistry();
        Collection<FunctionDefinition> functions = registry.listFunctions(this.pattern != null ? this.pattern.asJavaRegex() : null);
        listener.onResponse((Object)Rows.of(this.output(), functions.stream().map(f -> Arrays.asList(f.name(), f.type().name())).collect(Collectors.toList())));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowFunctions other = (ShowFunctions)obj;
        return Objects.equals(this.pattern, other.pattern);
    }
}

