/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.agg;

import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.search.aggregations.bucket.composite.DateHistogramValuesSourceBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xpack.sql.querydsl.agg.GroupByKey;
import org.elasticsearch.xpack.sql.querydsl.container.Sort;
import org.joda.time.DateTimeZone;

public class GroupByDateKey
extends GroupByKey {
    private final String interval;
    private final TimeZone timeZone;

    public GroupByDateKey(String id, String fieldName, String interval, TimeZone timeZone) {
        this(id, fieldName, null, interval, timeZone);
    }

    public GroupByDateKey(String id, String fieldName, Sort.Direction direction, String interval, TimeZone timeZone) {
        super(id, fieldName, direction);
        this.interval = interval;
        this.timeZone = timeZone;
    }

    public String interval() {
        return this.interval;
    }

    public TimeZone timeZone() {
        return this.timeZone;
    }

    public DateHistogramValuesSourceBuilder asValueSource() {
        return (DateHistogramValuesSourceBuilder)((DateHistogramValuesSourceBuilder)new DateHistogramValuesSourceBuilder(this.id()).field(this.fieldName())).dateHistogramInterval(new DateHistogramInterval(this.interval)).timeZone(DateTimeZone.forTimeZone((TimeZone)this.timeZone)).missingBucket(true);
    }

    @Override
    protected GroupByKey copy(String id, String fieldName, Sort.Direction direction) {
        return new GroupByDateKey(id, fieldName, direction, this.interval, this.timeZone);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.interval, this.timeZone);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupByDateKey other = (GroupByDateKey)obj;
            return Objects.equals(this.interval, other.interval) && Objects.equals(this.timeZone, other.timeZone);
        }
        return false;
    }
}

