/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.lucene.search.spell.LevensteinDistance;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;

public abstract class StringUtils {
    public static final String EMPTY = "";
    public static final String NEW_LINE = "\n";
    public static final String SQL_WILDCARD = "%";

    public static String camelCaseToUnderscore(String string) {
        if (!Strings.hasText((String)string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim();
        boolean previousCharWasUp = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (Character.isAlphabetic(ch)) {
                if (Character.isUpperCase(ch)) {
                    if (i > 0 && !previousCharWasUp) {
                        sb.append("_");
                    }
                    previousCharWasUp = true;
                } else {
                    previousCharWasUp = ch == '_';
                }
            } else {
                previousCharWasUp = true;
            }
            sb.append(ch);
        }
        return sb.toString().toUpperCase(Locale.ROOT);
    }

    public static String underscoreToLowerCamelCase(String string) {
        if (!Strings.hasText((String)string)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        String s = string.trim().toLowerCase(Locale.ROOT);
        boolean previousCharWasUnderscore = false;
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '_') {
                previousCharWasUnderscore = true;
                continue;
            }
            if (previousCharWasUnderscore) {
                sb.append(Character.toUpperCase(ch));
                previousCharWasUnderscore = false;
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String nullAsEmpty(String string) {
        return string == null ? EMPTY : string;
    }

    public static String likeToJavaPattern(String pattern, char escape) {
        StringBuilder regex = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        regex.append('^');
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                escaped = true;
                if (i + 1 != pattern.length()) continue;
                throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
            }
            switch (curr) {
                case '%': {
                    regex.append(escaped ? SQL_WILDCARD : ".*");
                    break;
                }
                case '_': {
                    regex.append(escaped ? "_" : ".");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    switch (curr) {
                        case '$': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '.': 
                        case '?': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            regex.append('\\');
                        }
                    }
                    regex.append(curr);
                }
            }
            escaped = false;
        }
        regex.append('$');
        return regex.toString();
    }

    public static String likeToLuceneWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : "*");
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : "?");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    switch (curr) {
                        case '*': 
                        case '?': 
                        case '\\': {
                            wildcard.append('\\');
                        }
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String likeToIndexWildcard(String pattern, char escape) {
        StringBuilder wildcard = new StringBuilder(pattern.length() + 4);
        boolean escaped = false;
        for (int i = 0; i < pattern.length(); ++i) {
            char curr = pattern.charAt(i);
            if (!escaped && curr == escape && escape != '\u0000') {
                if (i + 1 == pattern.length()) {
                    throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                }
                escaped = true;
                continue;
            }
            switch (curr) {
                case '%': {
                    wildcard.append(escaped ? SQL_WILDCARD : "*");
                    break;
                }
                case '_': {
                    wildcard.append(escaped ? "_" : "*");
                    break;
                }
                default: {
                    if (escaped) {
                        throw new SqlIllegalArgumentException("Invalid sequence - escape character is not followed by special wildcard char");
                    }
                    wildcard.append(curr);
                }
            }
            escaped = false;
        }
        return wildcard.toString();
    }

    public static String toString(SearchSourceBuilder source) {
        String string;
        block8: {
            XContentBuilder builder = XContentFactory.jsonBuilder().prettyPrint().humanReadable(true);
            try {
                source.toXContent(builder, ToXContent.EMPTY_PARAMS);
                string = Strings.toString((XContentBuilder)builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("error rendering", e);
                }
            }
            builder.close();
        }
        return string;
    }

    public static List<String> findSimilar(String match, Iterable<String> potentialMatches) {
        LevensteinDistance ld = new LevensteinDistance();
        ArrayList<Tuple> scoredMatches = new ArrayList<Tuple>();
        for (String potentialMatch : potentialMatches) {
            float distance = ld.getDistance(match, potentialMatch);
            if (!(distance >= 0.5f)) continue;
            scoredMatches.add(new Tuple((Object)Float.valueOf(distance), (Object)potentialMatch));
        }
        CollectionUtil.timSort(scoredMatches, (a, b) -> ((Float)b.v1()).compareTo((Float)a.v1()));
        return scoredMatches.stream().map(a -> (String)a.v2()).collect(Collectors.toList());
    }
}

