/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.InputStream;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ml.action.FindFileStructureAction;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinder;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureFinderManager;
import org.elasticsearch.xpack.ml.filestructurefinder.FileStructureOverrides;

public class TransportFindFileStructureAction
extends HandledTransportAction<FindFileStructureAction.Request, FindFileStructureAction.Response> {
    @Inject
    public TransportFindFileStructureAction(Settings settings, TransportService transportService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, "cluster:monitor/xpack/ml/findfilestructure", threadPool, transportService, actionFilters, indexNameExpressionResolver, FindFileStructureAction.Request::new);
    }

    protected void doExecute(FindFileStructureAction.Request request, ActionListener<FindFileStructureAction.Response> listener) {
        this.threadPool.executor("ml_utility").execute(() -> {
            try {
                listener.onResponse((Object)this.buildFileStructureResponse(request));
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private FindFileStructureAction.Response buildFileStructureResponse(FindFileStructureAction.Request request) throws Exception {
        FileStructureFinderManager structureFinderManager = new FileStructureFinderManager(this.threadPool.scheduler());
        FileStructureFinder fileStructureFinder = structureFinderManager.findFileStructure(request.getLinesToSample(), (InputStream)request.getSample().streamInput(), new FileStructureOverrides(request), request.getTimeout());
        return new FindFileStructureAction.Response(fileStructureFinder.getStructure());
    }
}

