/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.process;

import java.util.Date;
import java.util.Locale;
import java.util.function.Function;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.DataCounts;
import org.elasticsearch.xpack.ml.job.persistence.JobDataCountsPersister;
import org.elasticsearch.xpack.ml.job.process.diagnostics.DataStreamDiagnostics;

public class DataCountsReporter
extends AbstractComponent {
    private static final TimeValue PERSIST_INTERVAL = TimeValue.timeValueMillis((long)10000L);
    private final Job job;
    private final JobDataCountsPersister dataCountsPersister;
    private final DataCounts totalRecordStats;
    private volatile DataCounts incrementalRecordStats;
    private long analyzedFieldsPerRecord = 1L;
    private long lastRecordCountQuotient = 0L;
    private long logEvery = 1L;
    private long logCount = 0L;
    private Function<Long, Boolean> reportingBoundaryFunction;
    private DataStreamDiagnostics diagnostics;

    public DataCountsReporter(Settings settings, Job job, DataCounts counts, JobDataCountsPersister dataCountsPersister) {
        super(settings);
        this.job = job;
        this.dataCountsPersister = dataCountsPersister;
        this.totalRecordStats = counts;
        this.incrementalRecordStats = new DataCounts(job.getId());
        this.diagnostics = new DataStreamDiagnostics(job, counts);
        this.reportingBoundaryFunction = this::reportEvery10000Records;
    }

    public void reportRecordWritten(long inputFieldCount, long recordTimeMs) {
        long totalRecords;
        boolean isFirstReport;
        Date recordDate = new Date(recordTimeMs);
        this.totalRecordStats.incrementInputFieldCount(inputFieldCount);
        this.totalRecordStats.incrementProcessedRecordCount(1L);
        this.totalRecordStats.setLatestRecordTimeStamp(recordDate);
        this.incrementalRecordStats.incrementInputFieldCount(inputFieldCount);
        this.incrementalRecordStats.incrementProcessedRecordCount(1L);
        this.incrementalRecordStats.setLatestRecordTimeStamp(recordDate);
        boolean bl = isFirstReport = this.totalRecordStats.getEarliestRecordTimeStamp() == null;
        if (isFirstReport) {
            this.totalRecordStats.setEarliestRecordTimeStamp(recordDate);
            this.incrementalRecordStats.setEarliestRecordTimeStamp(recordDate);
        }
        if (this.reportingBoundaryFunction.apply(totalRecords = this.getInputRecordCount()).booleanValue()) {
            this.logStatus(totalRecords);
        }
        this.diagnostics.checkRecord(recordTimeMs);
    }

    public void reportLatestTimeIncrementalStats(long latestRecordTimeMs) {
        this.incrementalRecordStats.setLatestRecordTimeStamp(new Date(latestRecordTimeMs));
    }

    public void reportDateParseError(long inputFieldCount) {
        this.totalRecordStats.incrementInvalidDateCount(1L);
        this.totalRecordStats.incrementInputFieldCount(inputFieldCount);
        this.incrementalRecordStats.incrementInvalidDateCount(1L);
        this.incrementalRecordStats.incrementInputFieldCount(inputFieldCount);
    }

    public void reportMissingField() {
        this.totalRecordStats.incrementMissingFieldCount(1L);
        this.incrementalRecordStats.incrementMissingFieldCount(1L);
    }

    public void reportMissingFields(long missingCount) {
        this.totalRecordStats.incrementMissingFieldCount(missingCount);
        this.incrementalRecordStats.incrementMissingFieldCount(missingCount);
    }

    public void reportBytesRead(long newBytes) {
        this.totalRecordStats.incrementInputBytes(newBytes);
        this.incrementalRecordStats.incrementInputBytes(newBytes);
    }

    public void reportOutOfOrderRecord(long inputFieldCount) {
        this.totalRecordStats.incrementOutOfOrderTimeStampCount(1L);
        this.totalRecordStats.incrementInputFieldCount(inputFieldCount);
        this.incrementalRecordStats.incrementOutOfOrderTimeStampCount(1L);
        this.incrementalRecordStats.incrementInputFieldCount(inputFieldCount);
    }

    public long getInputRecordCount() {
        return this.totalRecordStats.getInputRecordCount();
    }

    public long getProcessedRecordCount() {
        return this.totalRecordStats.getProcessedRecordCount();
    }

    public long getDateParseErrorsCount() {
        return this.totalRecordStats.getInvalidDateCount();
    }

    public long getMissingFieldErrorCount() {
        return this.totalRecordStats.getMissingFieldCount();
    }

    public long getOutOfOrderRecordCount() {
        return this.totalRecordStats.getOutOfOrderTimeStampCount();
    }

    public long getEmptyBucketCount() {
        return this.totalRecordStats.getEmptyBucketCount();
    }

    public long getSparseBucketCount() {
        return this.totalRecordStats.getSparseBucketCount();
    }

    public long getBucketCount() {
        return this.totalRecordStats.getBucketCount();
    }

    public long getBytesRead() {
        return this.totalRecordStats.getInputBytes();
    }

    public Date getLatestRecordTime() {
        return this.totalRecordStats.getLatestRecordTimeStamp();
    }

    public Date getLatestEmptyBucketTime() {
        return this.totalRecordStats.getLatestEmptyBucketTimeStamp();
    }

    public Date getLatestSparseBucketTime() {
        return this.totalRecordStats.getLatestSparseBucketTimeStamp();
    }

    public long getProcessedFieldCount() {
        this.totalRecordStats.calcProcessedFieldCount(this.getAnalysedFieldsPerRecord());
        return this.totalRecordStats.getProcessedFieldCount();
    }

    public long getInputFieldCount() {
        return this.totalRecordStats.getInputFieldCount();
    }

    public void setAnalysedFieldsPerRecord(long value) {
        this.analyzedFieldsPerRecord = value;
    }

    public long getAnalysedFieldsPerRecord() {
        return this.analyzedFieldsPerRecord;
    }

    public void finishReporting(ActionListener<Boolean> listener) {
        Date now = new Date();
        this.incrementalRecordStats.setLastDataTimeStamp(now);
        this.totalRecordStats.setLastDataTimeStamp(now);
        this.diagnostics.flush();
        this.retrieveDiagnosticsIntermediateResults();
        this.dataCountsPersister.persistDataCounts(this.job.getId(), this.runningTotalStats(), listener);
    }

    protected boolean logStatus(long totalRecords) {
        if (++this.logCount % this.logEvery != 0L) {
            return false;
        }
        String status = String.format(Locale.ROOT, "[%s] %d records written to autodetect; missingFieldCount=%d, invalidDateCount=%d, outOfOrderCount=%d", this.job.getId(), this.getProcessedRecordCount(), this.getMissingFieldErrorCount(), this.getDateParseErrorsCount(), this.getOutOfOrderRecordCount());
        this.logger.info(status);
        int log10TotalRecords = (int)Math.floor(Math.log10(totalRecords));
        if (log10TotalRecords > 5) {
            this.logEvery = (int)Math.pow(10.0, log10TotalRecords - 5);
            this.logCount = 0L;
        }
        return true;
    }

    private boolean reportEvery10000Records(long totalRecords) {
        if (totalRecords > 100000L) {
            this.lastRecordCountQuotient = totalRecords / 100000L;
            this.reportingBoundaryFunction = this::reportEvery100000Records;
            return false;
        }
        long quotient = totalRecords / 10000L;
        if (quotient > this.lastRecordCountQuotient) {
            this.lastRecordCountQuotient = quotient;
            return true;
        }
        return false;
    }

    private boolean reportEvery100000Records(long totalRecords) {
        long quotient = totalRecords / 100000L;
        if (quotient > this.lastRecordCountQuotient) {
            this.lastRecordCountQuotient = quotient;
            return true;
        }
        return false;
    }

    public void startNewIncrementalCount() {
        this.incrementalRecordStats = new DataCounts(this.job.getId());
        this.retrieveDiagnosticsIntermediateResults();
    }

    public DataCounts incrementalStats() {
        this.incrementalRecordStats.calcProcessedFieldCount(this.getAnalysedFieldsPerRecord());
        return this.incrementalRecordStats;
    }

    public synchronized DataCounts runningTotalStats() {
        this.totalRecordStats.calcProcessedFieldCount(this.getAnalysedFieldsPerRecord());
        return this.totalRecordStats;
    }

    private void retrieveDiagnosticsIntermediateResults() {
        this.totalRecordStats.incrementBucketCount(this.diagnostics.getBucketCount());
        this.totalRecordStats.incrementEmptyBucketCount(this.diagnostics.getEmptyBucketCount());
        this.totalRecordStats.incrementSparseBucketCount(this.diagnostics.getSparseBucketCount());
        this.totalRecordStats.updateLatestEmptyBucketTimeStamp(this.diagnostics.getLatestEmptyBucketTime());
        this.totalRecordStats.updateLatestSparseBucketTimeStamp(this.diagnostics.getLatestSparseBucketTime());
        this.incrementalRecordStats.incrementBucketCount(this.diagnostics.getBucketCount());
        this.incrementalRecordStats.incrementEmptyBucketCount(this.diagnostics.getEmptyBucketCount());
        this.incrementalRecordStats.incrementSparseBucketCount(this.diagnostics.getSparseBucketCount());
        this.incrementalRecordStats.updateLatestEmptyBucketTimeStamp(this.diagnostics.getLatestEmptyBucketTime());
        this.incrementalRecordStats.updateLatestSparseBucketTimeStamp(this.diagnostics.getLatestSparseBucketTime());
        this.diagnostics.resetCounts();
    }
}

