/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.HashMap;
import java.util.Objects;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.CcrSettings;
import org.elasticsearch.xpack.core.ccr.action.PutFollowAction;
import org.elasticsearch.xpack.core.ccr.action.ResumeFollowAction;

public final class TransportPutFollowAction
extends TransportMasterNodeAction<PutFollowAction.Request, PutFollowAction.Response> {
    private final Client client;
    private final AllocationService allocationService;
    private final ActiveShardsObserver activeShardsObserver;
    private final CcrLicenseChecker ccrLicenseChecker;

    @Inject
    public TransportPutFollowAction(Settings settings, ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client, AllocationService allocationService, CcrLicenseChecker ccrLicenseChecker) {
        super(settings, "indices:admin/xpack/ccr/put_follow", transportService, clusterService, threadPool, actionFilters, PutFollowAction.Request::new, indexNameExpressionResolver);
        this.client = client;
        this.allocationService = allocationService;
        this.activeShardsObserver = new ActiveShardsObserver(settings, clusterService, threadPool);
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker);
    }

    protected String executor() {
        return "same";
    }

    protected PutFollowAction.Response newResponse() {
        return new PutFollowAction.Response();
    }

    protected void masterOperation(PutFollowAction.Request request, ClusterState state, ActionListener<PutFollowAction.Response> listener) throws Exception {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        String remoteCluster = request.getRemoteCluster();
        this.client.getRemoteClusterClient(remoteCluster);
        String leaderIndex = request.getLeaderIndex();
        this.ccrLicenseChecker.checkRemoteClusterLicenseAndFetchLeaderIndexMetadataAndHistoryUUIDs(this.client, remoteCluster, leaderIndex, arg_0 -> listener.onFailure(arg_0), (historyUUID, leaderIndexMetaData) -> this.createFollowerIndex((IndexMetaData)leaderIndexMetaData, (String[])historyUUID, request, listener));
    }

    private void createFollowerIndex(final IndexMetaData leaderIndexMetaData, final String[] historyUUIDs, final PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        if (leaderIndexMetaData == null) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not exist"));
            return;
        }
        if (!leaderIndexMetaData.getSettings().getAsBoolean(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), Boolean.valueOf(false)).booleanValue()) {
            listener.onFailure((Exception)new IllegalArgumentException("leader index [" + request.getLeaderIndex() + "] does not have soft deletes enabled"));
            return;
        }
        ActionListener handler = ActionListener.wrap(result -> {
            if (result.booleanValue()) {
                this.initiateFollowing(request, listener);
            } else {
                listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0));
        this.clusterService.submitStateUpdateTask("create_following_index", (ClusterStateTaskConfig)new AckedClusterStateUpdateTask<Boolean>((AckedRequest)request, handler){

            protected Boolean newResponse(boolean acknowledged) {
                return acknowledged;
            }

            public ClusterState execute(ClusterState currentState) throws Exception {
                String followIndex = request.getFollowRequest().getFollowerIndex();
                IndexMetaData currentIndex = currentState.metaData().index(followIndex);
                if (currentIndex != null) {
                    throw new ResourceAlreadyExistsException(currentIndex.getIndex());
                }
                MetaData.Builder mdBuilder = MetaData.builder((MetaData)currentState.metaData());
                IndexMetaData.Builder imdBuilder = IndexMetaData.builder((String)followIndex);
                HashMap<String, String> metadata = new HashMap<String, String>();
                metadata.put("leader_index_shard_history_uuids", String.join((CharSequence)",", historyUUIDs));
                metadata.put("leader_index_uuid", leaderIndexMetaData.getIndexUUID());
                metadata.put("leader_index_name", leaderIndexMetaData.getIndex().getName());
                metadata.put("remote_cluster_name", request.getRemoteCluster());
                imdBuilder.putCustom("ccr", metadata);
                Settings.Builder settingsBuilder = Settings.builder();
                settingsBuilder.put(leaderIndexMetaData.getSettings());
                settingsBuilder.put("index.uuid", UUIDs.randomBase64UUID());
                settingsBuilder.put("index.provided_name", followIndex);
                settingsBuilder.put(CcrSettings.CCR_FOLLOWING_INDEX_SETTING.getKey(), true);
                settingsBuilder.put(IndexSettings.INDEX_SOFT_DELETES_SETTING.getKey(), true);
                imdBuilder.settings(settingsBuilder);
                for (ObjectObjectCursor cursor : leaderIndexMetaData.getMappings()) {
                    imdBuilder.putMapping((MappingMetaData)cursor.value);
                }
                imdBuilder.setRoutingNumShards(leaderIndexMetaData.getRoutingNumShards());
                IndexMetaData followIMD = imdBuilder.build();
                mdBuilder.put(followIMD, false);
                ClusterState.Builder builder = ClusterState.builder((ClusterState)currentState);
                builder.metaData(mdBuilder.build());
                ClusterState updatedState = builder.build();
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder((RoutingTable)updatedState.routingTable()).addAsNew(updatedState.metaData().index(request.getFollowRequest().getFollowerIndex()));
                updatedState = TransportPutFollowAction.this.allocationService.reroute(ClusterState.builder((ClusterState)updatedState).routingTable(routingTableBuilder.build()).build(), "follow index [" + request.getFollowRequest().getFollowerIndex() + "] created");
                TransportPutFollowAction.this.logger.info("[{}] creating index, cause [ccr_create_and_follow], shards [{}]/[{}]", (Object)followIndex, (Object)followIMD.getNumberOfShards(), (Object)followIMD.getNumberOfReplicas());
                return updatedState;
            }
        });
    }

    private void initiateFollowing(PutFollowAction.Request request, ActionListener<PutFollowAction.Response> listener) {
        this.activeShardsObserver.waitForActiveShards(new String[]{request.getFollowRequest().getFollowerIndex()}, ActiveShardCount.DEFAULT, request.timeout(), result -> {
            if (result.booleanValue()) {
                this.client.execute((Action)ResumeFollowAction.INSTANCE, (ActionRequest)request.getFollowRequest(), ActionListener.wrap(r -> listener.onResponse((Object)new PutFollowAction.Response(true, true, r.isAcknowledged())), arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
            } else {
                listener.onResponse((Object)new PutFollowAction.Response(true, false, false));
            }
        }, arg_0 -> listener.onFailure(arg_0));
    }

    protected ClusterBlockException checkBlock(PutFollowAction.Request request, ClusterState state) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.METADATA_WRITE, request.getFollowRequest().getFollowerIndex());
    }
}

