/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class RemoteInfo
implements Writeable,
ToXContentObject {
    public static final TimeValue DEFAULT_SOCKET_TIMEOUT = TimeValue.timeValueSeconds(30L);
    public static final TimeValue DEFAULT_CONNECT_TIMEOUT = TimeValue.timeValueSeconds(30L);
    private final String scheme;
    private final String host;
    private final int port;
    private final String pathPrefix;
    private final BytesReference query;
    private final String username;
    private final String password;
    private final Map<String, String> headers;
    private final TimeValue socketTimeout;
    private final TimeValue connectTimeout;

    public RemoteInfo(String scheme, String host, int port, String pathPrefix, BytesReference query, String username, String password, Map<String, String> headers, TimeValue socketTimeout, TimeValue connectTimeout) {
        this.scheme = Objects.requireNonNull(scheme, "[scheme] must be specified to reindex from a remote cluster");
        this.host = Objects.requireNonNull(host, "[host] must be specified to reindex from a remote cluster");
        this.port = port;
        this.pathPrefix = pathPrefix;
        this.query = Objects.requireNonNull(query, "[query] must be specified to reindex from a remote cluster");
        this.username = username;
        this.password = password;
        this.headers = Collections.unmodifiableMap(Objects.requireNonNull(headers, "[headers] is required"));
        this.socketTimeout = Objects.requireNonNull(socketTimeout, "[socketTimeout] must be specified");
        this.connectTimeout = Objects.requireNonNull(connectTimeout, "[connectTimeout] must be specified");
    }

    public RemoteInfo(StreamInput in) throws IOException {
        this.scheme = in.readString();
        this.host = in.readString();
        this.port = in.readVInt();
        this.query = in.readBytesReference();
        this.username = in.readOptionalString();
        this.password = in.readOptionalString();
        int headersLength = in.readVInt();
        HashMap<String, String> headers = new HashMap<String, String>(headersLength);
        for (int i = 0; i < headersLength; ++i) {
            headers.put(in.readString(), in.readString());
        }
        this.headers = Collections.unmodifiableMap(headers);
        if (in.getVersion().onOrAfter(Version.V_5_2_0)) {
            this.socketTimeout = in.readTimeValue();
            this.connectTimeout = in.readTimeValue();
        } else {
            this.socketTimeout = DEFAULT_SOCKET_TIMEOUT;
            this.connectTimeout = DEFAULT_CONNECT_TIMEOUT;
        }
        this.pathPrefix = in.getVersion().onOrAfter(Version.V_6_4_0) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.scheme);
        out.writeString(this.host);
        out.writeVInt(this.port);
        out.writeBytesReference(this.query);
        out.writeOptionalString(this.username);
        out.writeOptionalString(this.password);
        out.writeVInt(this.headers.size());
        for (Map.Entry<String, String> header : this.headers.entrySet()) {
            out.writeString(header.getKey());
            out.writeString(header.getValue());
        }
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            out.writeTimeValue(this.socketTimeout);
            out.writeTimeValue(this.connectTimeout);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeOptionalString(this.pathPrefix);
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getPathPrefix() {
        return this.pathPrefix;
    }

    public BytesReference getQuery() {
        return this.query;
    }

    @Nullable
    public String getUsername() {
        return this.username;
    }

    @Nullable
    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public TimeValue getSocketTimeout() {
        return this.socketTimeout;
    }

    public TimeValue getConnectTimeout() {
        return this.connectTimeout;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (!"http".equals(this.scheme)) {
            b.append("scheme=").append(this.scheme).append(' ');
        }
        b.append("host=").append(this.host).append(" port=").append(this.port);
        if (this.pathPrefix != null) {
            b.append(" pathPrefix=").append(this.pathPrefix);
        }
        b.append(" query=").append(this.query.utf8ToString());
        if (this.username != null) {
            b.append(" username=").append(this.username);
        }
        if (this.password != null) {
            b.append(" password=<<>>");
        }
        return b.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.username != null) {
            builder.field("username", this.username);
        }
        if (this.password != null) {
            builder.field("password", this.password);
        }
        builder.field("host", this.scheme + "://" + this.host + ":" + this.port + (this.pathPrefix == null ? "" : "/" + this.pathPrefix));
        if (this.headers.size() > 0) {
            builder.field("headers", this.headers);
        }
        builder.field("socket_timeout", this.socketTimeout.getStringRep());
        builder.field("connect_timeout", this.connectTimeout.getStringRep());
        builder.field("query", this.query);
        builder.endObject();
        return builder;
    }
}

