/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.support.Exceptions;

public class DefaultAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    private final Map<String, List<String>> defaultFailureResponseHeaders;

    @Deprecated
    public DefaultAuthenticationFailureHandler() {
        this(null);
    }

    public DefaultAuthenticationFailureHandler(Map<String, List<String>> failureResponseHeaders) {
        this.defaultFailureResponseHeaders = failureResponseHeaders == null || failureResponseHeaders.isEmpty() ? Collections.singletonMap("WWW-Authenticate", Collections.singletonList("Basic realm=\"security\" charset=\"UTF-8\"")) : Collections.unmodifiableMap(failureResponseHeaders.entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> {
            if (((String)entry.getKey()).equalsIgnoreCase("WWW-Authenticate")) {
                ArrayList values = new ArrayList((Collection)entry.getValue());
                Collections.sort(values, (o1, o2) -> DefaultAuthenticationFailureHandler.authSchemePriority(o1).compareTo(DefaultAuthenticationFailureHandler.authSchemePriority(o2)));
                return Collections.unmodifiableList(values);
            }
            return Collections.unmodifiableList((List)entry.getValue());
        })));
    }

    private static Integer authSchemePriority(String headerValue) {
        if (headerValue.regionMatches(true, 0, "negotiate", 0, "negotiate".length())) {
            return 0;
        }
        if (headerValue.regionMatches(true, 0, "bearer", 0, "bearer".length())) {
            return 1;
        }
        if (headerValue.regionMatches(true, 0, "basic", 0, "basic".length())) {
            return 2;
        }
        return 3;
    }

    @Override
    public ElasticsearchSecurityException failedAuthentication(RestRequest request, AuthenticationToken token, ThreadContext context) {
        return this.createAuthenticationError("unable to authenticate user [{}] for REST request [{}]", null, token.principal(), request.uri());
    }

    @Override
    public ElasticsearchSecurityException failedAuthentication(TransportMessage message, AuthenticationToken token, String action, ThreadContext context) {
        return this.createAuthenticationError("unable to authenticate user [{}] for action [{}]", null, token.principal(), action);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(RestRequest request, Exception e, ThreadContext context) {
        return this.createAuthenticationError("error attempting to authenticate request", e, null);
    }

    @Override
    public ElasticsearchSecurityException exceptionProcessingRequest(TransportMessage message, String action, Exception e, ThreadContext context) {
        return this.createAuthenticationError("error attempting to authenticate request", e, null);
    }

    @Override
    public ElasticsearchSecurityException missingToken(RestRequest request, ThreadContext context) {
        return this.createAuthenticationError("missing authentication token for REST request [{}]", null, request.uri());
    }

    @Override
    public ElasticsearchSecurityException missingToken(TransportMessage message, String action, ThreadContext context) {
        return this.createAuthenticationError("missing authentication token for action [{}]", null, action);
    }

    @Override
    public ElasticsearchSecurityException authenticationRequired(String action, ThreadContext context) {
        return this.createAuthenticationError("action [{}] requires authentication", null, action);
    }

    private ElasticsearchSecurityException createAuthenticationError(String message, Throwable t, Object ... args) {
        boolean containsNegotiateWithToken;
        ElasticsearchSecurityException ese;
        if (t instanceof ElasticsearchSecurityException) {
            assert (((ElasticsearchSecurityException)t).status() == RestStatus.UNAUTHORIZED);
            ese = (ElasticsearchSecurityException)t;
            containsNegotiateWithToken = ese.getHeader("WWW-Authenticate") != null && !ese.getHeader("WWW-Authenticate").isEmpty() ? ese.getHeader("WWW-Authenticate").stream().anyMatch(s -> s != null && s.regionMatches(true, 0, "Negotiate ", 0, "Negotiate ".length())) : false;
        } else {
            ese = Exceptions.authenticationError(message, t, args);
            containsNegotiateWithToken = false;
        }
        this.defaultFailureResponseHeaders.entrySet().stream().forEach(e -> {
            if (containsNegotiateWithToken && ((String)e.getKey()).equalsIgnoreCase("WWW-Authenticate")) {
                return;
            }
            ese.addHeader((String)e.getKey(), (List)e.getValue());
        });
        return ese;
    }
}

