/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.support.CachingRealm;
import org.elasticsearch.xpack.core.security.authc.support.CachingUsernamePasswordRealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.Hasher;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.support.UsernamePasswordRealm;

public abstract class CachingUsernamePasswordRealm
extends UsernamePasswordRealm
implements CachingRealm {
    private final Cache<String, ListenableFuture<UserWithHash>> cache;
    private final ThreadPool threadPool;
    private final boolean authenticationEnabled;
    final Hasher cacheHasher;

    protected CachingUsernamePasswordRealm(String type, RealmConfig config, ThreadPool threadPool) {
        super(type, config);
        this.cacheHasher = Hasher.resolve((String)((String)CachingUsernamePasswordRealmSettings.CACHE_HASH_ALGO_SETTING.get(config.settings())));
        this.threadPool = threadPool;
        TimeValue ttl = (TimeValue)CachingUsernamePasswordRealmSettings.CACHE_TTL_SETTING.get(config.settings());
        this.cache = ttl.getNanos() > 0L ? CacheBuilder.builder().setExpireAfterWrite(ttl).setMaximumWeight((long)((Integer)CachingUsernamePasswordRealmSettings.CACHE_MAX_USERS_SETTING.get(config.settings())).intValue()).build() : null;
        this.authenticationEnabled = (Boolean)CachingUsernamePasswordRealmSettings.AUTHC_ENABLED_SETTING.get(config.settings());
    }

    public final void expire(String username) {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for user [{}] in realm [{}]", (Object)username, (Object)this.name());
            this.cache.invalidate((Object)username);
        }
    }

    public final void expireAll() {
        if (this.cache != null) {
            this.logger.trace("invalidating cache for all users in realm [{}]", (Object)this.name());
            this.cache.invalidateAll();
        }
    }

    @Override
    public UsernamePasswordToken token(ThreadContext threadContext) {
        if (!this.authenticationEnabled) {
            return null;
        }
        return super.token(threadContext);
    }

    @Override
    public boolean supports(AuthenticationToken token) {
        return this.authenticationEnabled && super.supports(token);
    }

    public final void authenticate(AuthenticationToken authToken, ActionListener<AuthenticationResult> listener) {
        if (!this.authenticationEnabled) {
            listener.onResponse((Object)AuthenticationResult.notHandled());
            return;
        }
        UsernamePasswordToken token = (UsernamePasswordToken)authToken;
        try {
            if (this.cache == null) {
                this.doAuthenticate(token, listener);
            } else {
                this.authenticateWithCache(token, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void authenticateWithCache(UsernamePasswordToken token, ActionListener<AuthenticationResult> listener) {
        try {
            AtomicBoolean authenticationInCache = new AtomicBoolean(true);
            ListenableFuture listenableCacheEntry = (ListenableFuture)this.cache.computeIfAbsent((Object)token.principal(), k -> {
                authenticationInCache.set(false);
                return new ListenableFuture();
            });
            if (authenticationInCache.get()) {
                listenableCacheEntry.addListener(ActionListener.wrap(authenticatedUserWithHash -> {
                    if (authenticatedUserWithHash != null && authenticatedUserWithHash.verify(token.credentials())) {
                        this.handleCachedAuthentication(authenticatedUserWithHash.user, (ActionListener<AuthenticationResult>)ActionListener.wrap(cacheResult -> {
                            if (cacheResult.isAuthenticated()) {
                                this.logger.debug("realm [{}] authenticated user [{}], with roles [{}]", (Object)this.name(), (Object)token.principal(), (Object)cacheResult.getUser().roles());
                            } else {
                                this.logger.debug("realm [{}] authenticated user [{}] from cache, but then failed [{}]", (Object)this.name(), (Object)token.principal(), (Object)cacheResult.getMessage());
                            }
                            listener.onResponse(cacheResult);
                        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0)));
                    } else {
                        this.cache.invalidate((Object)token.principal(), (Object)listenableCacheEntry);
                        this.authenticateWithCache(token, listener);
                    }
                }, e -> {
                    this.cache.invalidate((Object)token.principal(), (Object)listenableCacheEntry);
                    this.authenticateWithCache(token, listener);
                }), this.threadPool.executor("generic"), this.threadPool.getThreadContext());
            } else {
                this.doAuthenticate(token, (ActionListener<AuthenticationResult>)ActionListener.wrap(authResult -> {
                    if (authResult.isAuthenticated() && authResult.getUser().enabled()) {
                        UserWithHash userWithHash = new UserWithHash(authResult.getUser(), token.credentials(), this.cacheHasher);
                        listenableCacheEntry.onResponse((Object)userWithHash);
                    } else {
                        listenableCacheEntry.onResponse(null);
                    }
                    listener.onResponse(authResult);
                }, e -> {
                    listenableCacheEntry.onFailure(e);
                    listener.onFailure(e);
                }));
            }
        }
        catch (ExecutionException e2) {
            listener.onFailure((Exception)e2);
        }
    }

    protected void handleCachedAuthentication(User user, ActionListener<AuthenticationResult> listener) {
        listener.onResponse((Object)AuthenticationResult.success((User)user));
    }

    public void usageStats(ActionListener<Map<String, Object>> listener) {
        super.usageStats(ActionListener.wrap(stats -> {
            stats.put("cache", Collections.singletonMap("size", this.getCacheSize()));
            listener.onResponse(stats);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    protected int getCacheSize() {
        return this.cache.count();
    }

    protected abstract void doAuthenticate(UsernamePasswordToken var1, ActionListener<AuthenticationResult> var2);

    public final void lookupUser(String username, ActionListener<User> listener) {
        try {
            if (this.cache == null) {
                this.doLookupUser(username, listener);
            } else {
                this.lookupWithCache(username, listener);
            }
        }
        catch (Exception e) {
            listener.onFailure(e);
        }
    }

    private void lookupWithCache(String username, ActionListener<User> listener) {
        try {
            AtomicBoolean lookupInCache = new AtomicBoolean(true);
            ListenableFuture listenableCacheEntry = (ListenableFuture)this.cache.computeIfAbsent((Object)username, key -> {
                lookupInCache.set(false);
                return new ListenableFuture();
            });
            if (!lookupInCache.get()) {
                this.doLookupUser(username, (ActionListener<User>)ActionListener.wrap(user -> {
                    if (user != null) {
                        UserWithHash userWithHash = new UserWithHash((User)user, null, null);
                        listenableCacheEntry.onResponse((Object)userWithHash);
                    } else {
                        this.cache.invalidate((Object)username, (Object)listenableCacheEntry);
                        listenableCacheEntry.onResponse(null);
                    }
                }, e -> {
                    this.cache.invalidate((Object)username, (Object)listenableCacheEntry);
                    listenableCacheEntry.onFailure(e);
                }));
            }
            listenableCacheEntry.addListener(ActionListener.wrap(userWithHash -> {
                if (userWithHash != null) {
                    listener.onResponse((Object)userWithHash.user);
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)), this.threadPool.executor("generic"), this.threadPool.getThreadContext());
        }
        catch (ExecutionException e2) {
            listener.onFailure((Exception)e2);
        }
    }

    protected abstract void doLookupUser(String var1, ActionListener<User> var2);

    private static class UserWithHash {
        final User user;
        final char[] hash;

        UserWithHash(User user, SecureString password, Hasher hasher) {
            this.user = Objects.requireNonNull(user);
            this.hash = password == null ? null : hasher.hash(password);
        }

        boolean verify(SecureString password) {
            return this.hash != null && Hasher.verifyHash((SecureString)password, (char[])this.hash);
        }
    }
}

