/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.upgrade.rest;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.protocol.xpack.migration.IndexUpgradeInfoRequest;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.upgrade.actions.IndexUpgradeInfoAction;

public class RestIndexUpgradeInfoAction
extends BaseRestHandler {
    public RestIndexUpgradeInfoAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/migration/assistance", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/migration/assistance/{index}", (RestHandler)this);
    }

    public String getName() {
        return "xpack_migration_assistance";
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (request.method().equals((Object)RestRequest.Method.GET)) {
            return this.handleGet(request, client);
        }
        throw new IllegalArgumentException("illegal method [" + request.method() + "] for request [" + request.path() + "]");
    }

    private BaseRestHandler.RestChannelConsumer handleGet(RestRequest request, NodeClient client) {
        IndexUpgradeInfoRequest infoRequest = new IndexUpgradeInfoRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        infoRequest.indicesOptions(IndicesOptions.fromRequest((RestRequest)request, (IndicesOptions)infoRequest.indicesOptions()));
        return channel -> client.execute((Action)IndexUpgradeInfoAction.INSTANCE, (ActionRequest)infoRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

