/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.ext;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channel;
import org.jruby.Ruby;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.JavaMethod;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.ext.JavaExtensions;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaIo {
    public static void define(Ruby runtime2) {
        JavaExtensions.put(runtime2, InputStream.class, proxyClass -> proxyClass.addMethodInternal("to_io", new InputStreamToIO((RubyModule)proxyClass)));
        JavaExtensions.put(runtime2, OutputStream.class, proxyClass -> proxyClass.addMethodInternal("to_io", new OutputStreamToIO((RubyModule)proxyClass)));
        JavaExtensions.put(runtime2, Channel.class, proxyClass -> proxyClass.addMethodInternal("to_io", new ChannelToIO((RubyModule)proxyClass)));
    }

    static RubyIO to_io(ThreadContext context, InputStream stream, IRubyObject opts) {
        RubyIO io2 = new RubyIO(context.runtime, stream);
        JavaIo.setAutoclose(context, io2, opts);
        return io2;
    }

    static RubyIO to_io(ThreadContext context, OutputStream stream, IRubyObject opts) {
        RubyIO io2 = new RubyIO(context.runtime, stream);
        JavaIo.setAutoclose(context, io2, opts);
        return io2;
    }

    private static void setAutoclose(ThreadContext context, RubyIO io2, IRubyObject opts) {
        IRubyObject autoclose2;
        if (opts != null && opts != context.nil && (autoclose2 = opts.callMethod(context, "[]", context.runtime.newSymbol("autoclose"))) != context.nil) {
            io2.setAutoclose(autoclose2.isTrue());
        }
    }

    private static final class ChannelToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        ChannelToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "to_io");
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return ChannelToIO.to_io(context, self2, null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return ChannelToIO.to_io(context, self2, opts);
        }

        private static RubyIO to_io(ThreadContext context, IRubyObject self2, IRubyObject opts) {
            RubyIO io2 = new RubyIO(context.runtime, (Channel)JavaUtil.unwrapIfJavaObject(self2));
            JavaIo.setAutoclose(context, io2, opts);
            return io2;
        }
    }

    private static final class OutputStreamToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        OutputStreamToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "to_io");
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return JavaIo.to_io(context, (OutputStream)JavaUtil.unwrapIfJavaObject(self2), null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return JavaIo.to_io(context, (OutputStream)JavaUtil.unwrapIfJavaObject(self2), opts);
        }
    }

    private static final class InputStreamToIO
    extends JavaMethod.JavaMethodZeroOrOne {
        InputStreamToIO(RubyModule implClass) {
            super(implClass, Visibility.PUBLIC, "to_io");
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2) {
            return JavaIo.to_io(context, (InputStream)JavaUtil.unwrapIfJavaObject(self2), null);
        }

        @Override
        public RubyIO call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject opts) {
            return JavaIo.to_io(context, (InputStream)JavaUtil.unwrapIfJavaObject(self2), opts);
        }
    }
}

