/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.signature;

import org.jetbrains.org.objectweb.asm.signature.SignatureVisitor;

public class SignatureReader {
    private final String signature;

    public SignatureReader(String signature) {
        this.signature = signature;
    }

    public void accept(SignatureVisitor v2) {
        int pos;
        String signature = this.signature;
        int len = signature.length();
        if (signature.charAt(0) == '<') {
            char c;
            pos = 2;
            do {
                int end = signature.indexOf(58, pos);
                v2.visitFormalTypeParameter(signature.substring(pos - 1, end));
                pos = end + 1;
                c = signature.charAt(pos);
                if (c == 'L' || c == '[' || c == 'T') {
                    pos = SignatureReader.parseType(signature, pos, v2.visitClassBound());
                }
                while ((c = signature.charAt(pos++)) == ':') {
                    pos = SignatureReader.parseType(signature, pos, v2.visitInterfaceBound());
                }
            } while (c != '>');
        } else {
            pos = 0;
        }
        if (signature.charAt(pos) == '(') {
            ++pos;
            while (signature.charAt(pos) != ')') {
                pos = SignatureReader.parseType(signature, pos, v2.visitParameterType());
            }
            pos = SignatureReader.parseType(signature, pos + 1, v2.visitReturnType());
            while (pos < len) {
                pos = SignatureReader.parseType(signature, pos + 1, v2.visitExceptionType());
            }
        } else {
            pos = SignatureReader.parseType(signature, pos, v2.visitSuperclass());
            while (pos < len) {
                pos = SignatureReader.parseType(signature, pos, v2.visitInterface());
            }
        }
    }

    public void acceptType(SignatureVisitor v2) {
        SignatureReader.parseType(this.signature, 0, v2);
    }

    private static int parseType(String signature, int pos, SignatureVisitor v2) {
        char c = signature.charAt(pos++);
        switch (c) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'V': 
            case 'Z': {
                v2.visitBaseType(c);
                return pos;
            }
            case '[': {
                return SignatureReader.parseType(signature, pos, v2.visitArrayType());
            }
            case 'T': {
                int end = signature.indexOf(59, pos);
                v2.visitTypeVariable(signature.substring(pos, end));
                return end + 1;
            }
        }
        int start = pos;
        boolean visited2 = false;
        boolean inner = false;
        while (true) {
            c = signature.charAt(pos++);
            block5 : switch (c) {
                case '.': 
                case ';': {
                    String name;
                    if (!visited2) {
                        name = signature.substring(start, pos - 1);
                        if (inner) {
                            v2.visitInnerClassType(name);
                        } else {
                            v2.visitClassType(name);
                        }
                    }
                    if (c == ';') {
                        v2.visitEnd();
                        return pos;
                    }
                    start = pos;
                    visited2 = false;
                    inner = true;
                    break;
                }
                case '<': {
                    String name = signature.substring(start, pos - 1);
                    if (inner) {
                        v2.visitInnerClassType(name);
                    } else {
                        v2.visitClassType(name);
                    }
                    visited2 = true;
                    block15: while (true) {
                        c = signature.charAt(pos);
                        switch (c) {
                            case '>': {
                                break block5;
                            }
                            case '*': {
                                ++pos;
                                v2.visitTypeArgument();
                                continue block15;
                            }
                            case '+': 
                            case '-': {
                                pos = SignatureReader.parseType(signature, pos + 1, v2.visitTypeArgument(c));
                                continue block15;
                            }
                        }
                        pos = SignatureReader.parseType(signature, pos, v2.visitTypeArgument('='));
                    }
                }
            }
        }
    }
}

