-- CSS properties, automatically compiled from http://css-infos.net

{
  "-moz-animation": {
    "description": "Combines common animation properties into a single property.",
    "values": {
    }
  },
  "-moz-animation-delay": {
    "description": "Defines when an animation starts.",
    "values": {
      "0": "The default value is 0.",
      "now": "The animation begins immediately. Available in iOS 2.0 and later."
    }
  },
  "-moz-animation-direction": {
    "description": "Determines whether the animation should play in reverse on alternate iterations.",
    "values": {
      "normal": "Play each iteration of the animation in the forward direction.",
      "alternate": "Play even-numbered iterations of the animation in the forward direction and odd-numbered iterations in the reverse direction. \n                             When an animation is played in reverse, the timing functions are also reversed. For example, when played in reverse, an ease-in animation appears as an ease-out animation."
    }
  },
  "-moz-animation-duration": {
    "description": "Specifies the length of time that an animation takes to complete one iteration.",
    "values": {
    }
  },
  "-moz-animation-fill-mode": {
    "description": "Specifies whether the effects of an animation are apparent before the animation starts and after it ends.",
    "values": {
      "none": "The effects of the animation are apparent only during the defined duration of the animation.",
      "forwards": "The animation’s final keyframe continues to apply after the final iteration of the animation completes.",
      "backwards": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element. This only affects animations that have a nonzero value for -webkit-animation-delay.",
      "both": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element, and the animation’s final keyframe continues to apply after the final iteration of the animation completes. The initial keyframe only affects animations that have a nonzero value for -webkit-animation-delay."
    }
  },
  "-moz-animation-iteration-count": {
    "description": "Specifies the number of times an animation iterates.",
    "values": {
      "1": "The default value is 1.",
      "infinite": "Repeats the animation forever."
    }
  },
  "-moz-animation-name": {
    "description": "Specifies the name of an animation.",
    "values": {
      "\"\"": "The default value is \"\"."
    }
  },
  "-moz-animation-play-state": {
    "description": "Determines whether the animation is running or paused.",
    "values": {
      "running": "Plays the animation.",
      "paused": "Pauses the animation."
    }
  },
  "-moz-animation-timing-function": {
    "description": "Defines how an animation progresses between keyframes.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)."
    }
  },
  "-moz-appearance": {
    "description": "Changes the appearance of buttons and other controls to resemble native controls.",
    "values": {
      "caps-lock-indicator": "The indicator that appears in a password field when Caps Lock is active. Available in Safari 4.0 and later. Available in iOS 2.0 and later.",
      "button": "",
      "button-bevel": "",
      "caret": "",
      "checkbox": "",
      "default-button": "",
      "listbox": "",
      "listitem": "",
      "media-fullscreen-button": "",
      "media-mute-button": "",
      "media-play-button": "",
      "media-seek-back-button": "",
      "media-seek-forward-button": "",
      "media-slider": "",
      "media-sliderthumb": "",
      "menulist": "",
      "menulist-button": "",
      "menulist-text": "",
      "menulist-textfield": "",
      "none": "",
      "push-button": "",
      "radio": "",
      "searchfield": "",
      "searchfield-cancel-button": "",
      "searchfield-decoration": "",
      "searchfield-results-button": "",
      "searchfield-results-decoration": "",
      "slider-horizontal, slider-vertical": "",
      "sliderthumb-horizontal": "",
      "sliderthumb-vertical": "",
      "square-button": "",
      "textarea": "",
      "textfield": "",
      "scrollbarbutton-down": "Unsupported in Safari 4.0",
      "scrollbarbutton-left": "Unsupported in Safari 4.0",
      "scrollbarbutton-right": "Unsupported in Safari 4.0",
      "scrollbarbutton-up": "Unsupported in Safari 4.0",
      "scrollbargripper-horizontal": "Unsupported in Safari 4.0",
      "scrollbargripper-vertical": "Unsupported in Safari 4.0",
      "scrollbarthumb-horizontal": "Unsupported in Safari 4.0",
      "scrollbarthumb-vertical": "Unsupported in Safari 4.0",
      "scrollbartrack-horizontal": "Unsupported in Safari 4.0",
      "scrollbartrack-vertical": "Unsupported in Safari 4.0"
    }
  },
  "-moz-backface-visibility": {
    "description": "Determines whether or not a transformed element is visible when it is not facing the screen.",
    "values": {
      "visible": "The element is always visible even when it is not facing the screen.",
      "hidden": "The element is invisible if it is not facing the screen."
    }
  },
  "-moz-background-clip": {
    "description": "Specifies the clipping behavior of the background of a box.",
    "values": {
      "border": "The background clips to the border of the box.",
      "content": "The background clips to the content of the box.",
      "padding": "The background clips to the padding of the box.",
      "text": "The background clips to the text of the box. Available in Safari 4.0 and later."
    }
  },
  "-moz-background-composite": {
    "description": "Sets a compositing style for background images and colors.",
    "values": {
      "border": "The background extends into the border area",
      "padding": "The background extends only into the padding area enclosed by the border"
    }
  },
  "-moz-background-origin": {
    "description": "Determines where the background-position property is anchored.",
    "values": {
    }
  },
  "-moz-background-size": {
    "description": "Overrides the size of a background image.",
    "values": {
    }
  },
  "-moz-border-bottom-left-radius": {
    "description": "Specifies that the bottom-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-moz-border-bottom-right-radius": {
    "description": "Specifies that the bottom-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-moz-border-horizontal-spacing": {
    "description": "Defines the spacing between the horizontal portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-moz-border-image": {
    "description": "Specifies an image as the border for a box.",
    "values": {
      "repeat": "The image is tiled.",
      "round": "The image is stretched before it is tiled to prevent partial tiles.",
      "stretch": "The image is stretched to the size of the border."
    }
  },
  "-moz-border-radius": {
    "description": "Specifies that the corners of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-moz-border-top-left-radius": {
    "description": "Specifies that the top-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-moz-border-top-right-radius": {
    "description": "Specifies that the top-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-moz-border-vertical-spacing": {
    "description": "Defines the spacing between the vertical portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-moz-box-align": {
    "description": "Specifies the alignment of nested elements within an outer flexible box element.",
    "values": {
      "baseline": "Elements are aligned with the baseline of the box.",
      "center": "Elements are aligned with the center of the box.",
      "end": "Elements are aligned with the end of the box.",
      "start": "Elements are aligned with the start of the box.",
      "stretch": "Elements are stretched to fill the box."
    }
  },
  "-moz-box-direction": {
    "description": "Specifies the direction in which child elements of a flexible box element are laid out.",
    "values": {
      "normal": "Elements are laid out in the default direction.",
      "reverse": "Elements are laid out in the reverse direction."
    }
  },
  "-moz-box-flex": {
    "description": "Specifies an element’s flexibility.",
    "values": {
    }
  },
  "-moz-box-flex-group": {
    "description": "Specifies groups of dynamically resizing elements that are adjusted to be the same size.",
    "values": {
    }
  },
  "-moz-box-lines": {
    "description": "Specifies whether a flexible box should contain multiple lines of content.",
    "values": {
      "multiple": "The box can contain multiple lines of content.",
      "single": "The box can contain only one line of content."
    }
  },
  "-moz-box-ordinal-group": {
    "description": "Specifies a rough ordering of elements in a flexible box.",
    "values": {
    }
  },
  "-moz-box-orient": {
    "description": "Specifies the layout of elements nested within a flexible box element.",
    "values": {
      "block-axis": "Elements are oriented along the box's axis.",
      "horizontal": "Elements are oriented horizontally.",
      "inline-axis": "Elements are oriented along the inline axis.",
      "vertical": "Elements are oriented vertically."
    }
  },
  "-moz-box-pack": {
    "description": "Specifies alignment of child elements within the current element in the direction of orientation.",
    "values": {
      "center": "Child elements are aligned to the center of the element.",
      "end": "Child elements are aligned to the end of the element.",
      "justify": "Child elements are justified with both the start and end of the element.",
      "start": "Child elements are aligned to the start of the element."
    }
  },
  "-moz-box-reflect": {
    "description": "Defines a reflection of a border box.",
    "values": {
      "above": "The reflection appears above the border box.",
      "below": "The reflection appears below the border box.",
      "left": "The reflection appears to the left of the border box.",
      "right": "The reflection appears to the right of the border box."
    }
  },
  "-moz-box-shadow": {
    "description": "Applies a drop shadow effect to the border box of an object.",
    "values": {
      "none": "The box has no shadow."
    }
  },
  "-moz-box-sizing": {
    "description": "Specifies that the size of a box be measured according to either its content (default) or its total size including borders.",
    "values": {
      "border-box": "The box size includes borders in addition to content.",
      "content-box": "The box size only includes content."
    }
  },
  "-moz-column-break-after": {
    "description": "Determines whether a column break can and should occur after an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted after the element.",
      "auto": "A right column break is inserted after the element where appropriate.",
      "avoid": "Column breaks are avoided after the element.",
      "left": "A left column break is inserted after the element.",
      "right": "A right column break is inserted after the element."
    }
  },
  "-moz-column-break-before": {
    "description": "Determines whether a column break can and should occur before an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted before the element.",
      "auto": "A right column break is inserted before the element where appropriate.",
      "avoid": "Column breaks are avoided before the element.",
      "left": "A left column break is inserted before the element.",
      "right": "A right column break is inserted before the element."
    }
  },
  "-moz-column-break-inside": {
    "description": "Determines whether a column break should be avoided within the bounds of an element in a multicolumn flow layout.",
    "values": {
      "auto": "A right column break is inserted within the element where appropriate.",
      "avoid": "Column breaks are avoided within the element."
    }
  },
  "-moz-column-count": {
    "description": "Specifies the number of columns desired in a multicolumn flow.",
    "values": {
      "auto": "The element has one column."
    }
  },
  "-moz-column-gap": {
    "description": "Specifies the space between columns in a multicolumn flow.",
    "values": {
      "normal": "Columns in the element have the normal gap width between them."
    }
  },
  "-moz-column-rule": {
    "description": "Specifies the color, style, and width of the column rule.",
    "values": {
    }
  },
  "-moz-column-rule-color": {
    "description": "Specifies the color of the column rule.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-moz-column-rule-style": {
    "description": "Specifies the style of the column rule.",
    "values": {
      "dashed": "The column rule has a dashed line style.",
      "dotted": "The column rule has a dotted line style.",
      "double": "The column rule has a double solid line style.",
      "groove": "The column rule has a grooved style.",
      "hidden": "The column rule is hidden.",
      "inset": "The column rule has an inset style.",
      "none": "The column rule has no style.",
      "outset": "The column rule has an outset style.",
      "ridge": "The column rule has a ridged style.",
      "solid": "The column rule has a solid line style."
    }
  },
  "-moz-column-rule-width": {
    "description": "Specifies the width of the column rule.",
    "values": {
      "medium": "The column rule has a medium width.",
      "thick": "The column rule has a thick width.",
      "thin": "The column rule has a thin width."
    }
  },
  "-moz-column-width": {
    "description": "Specifies the width of the column in a multicolumn flow.",
    "values": {
      "auto": "Columns in the element are of normal width."
    }
  },
  "-moz-columns": {
    "description": "A composite property that specifies the width and number of columns in a multicolumn flow layout.",
    "values": {
    }
  },
  "-moz-dashboard-region": {
    "description": "Specifies the behavior of regions in a Dashboard widget.",
    "values": {
      "none": "No behavior is specified."
    }
  },
  "-moz-line-break": {
    "description": "Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text.",
    "values": {
      "after-white-space": "The line breaks after white space.",
      "normal": "A standard line-breaking rule"
    }
  },
  "-moz-margin-bottom-collapse": {
    "description": "Specifies the behavior of an element’s bottom margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-moz-margin-collapse": {
    "description": "Specifies the behavior of an element’s vertical margins if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
    }
  },
  "-moz-margin-start": {
    "description": "Provides the width of the starting margin.",
    "values": {
      "auto": "The margin is automatically determined."
    }
  },
  "-moz-margin-top-collapse": {
    "description": "Specifies the behavior of an element’s top margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-moz-marquee": {
    "description": "Defines properties for showing content as though displayed on an electronic marquee sign.",
    "values": {
    }
  },
  "-moz-marquee-direction": {
    "description": "Specifies the direction of motion for a marquee box.",
    "values": {
      "ahead": "The marquee moves from bottom to top.",
      "auto": "The marquee moves in the default direction.",
      "backwards": "The marquee moves from right to left.",
      "down": "The marquee moves from bottom to top.",
      "forwards": "The marquee moves from left to right.",
      "left": "The marquee moves from right to left.",
      "reverse": "The marquee moves from top to bottom.",
      "right": "The marquee moves from left to right.",
      "up": "The marquee moves from bottom to top."
    }
  },
  "-moz-marquee-increment": {
    "description": "Defines the distance the marquee moves in each increment.",
    "values": {
      "large": "The marquee moves a large amount in each increment.",
      "medium": "The marquee moves a medium amount in each increment.",
      "small": "The marquee moves a small amount in each increment."
    }
  },
  "-moz-marquee-repetition": {
    "description": "Specifies the number of times a marquee box repeats (or infinite).",
    "values": {
      "infinite": "The marquee repeats infinitely."
    }
  },
  "-moz-marquee-speed": {
    "description": "Defines the scroll or slide speed of a marquee box.",
    "values": {
      "fast": "The marquee moves at a fast speed.",
      "normal": "The marquee moves at a normal speed.",
      "slow": "The marquee moves at a slow speed."
    }
  },
  "-moz-marquee-style": {
    "description": "Specifies the style of marquee motion.",
    "values": {
      "alternate": "The marquee shifts back and forth.",
      "none": "The marquee does not move.",
      "scroll": "The marquee loops in its specified direction.",
      "slide": "The marquee moves in its specified direction, but stops either when the entirety of its content has been displayed or the content reaches the opposite border of its box, whichever comes second."
    }
  },
  "-moz-mask": {
    "description": "Defines a variety of mask properties within one declaration.",
    "values": {
    }
  },
  "-moz-mask-attachment": {
    "description": "Defines the scrolling or fixed nature of the image mask.",
    "values": {
      "fixed": "The mask does not move when the page scrolls.",
      "scroll": "The image moves when the page scrolls."
    }
  },
  "-moz-mask-box-image": {
    "description": "Defines an image to be used as a mask for a border box.",
    "values": {
    }
  },
  "-moz-mask-clip": {
    "description": "Specifies whether the mask should extend into the border of a box.",
    "values": {
    }
  },
  "-moz-mask-composite": {
    "description": "Sets a compositing style for a mask.",
    "values": {
      "border": "The background extends into the border area.",
      "padding": "The background extends only into the padding area enclosed by the border."
    }
  },
  "-moz-mask-image": {
    "description": "Defines an image to be used as a mask for an element.",
    "values": {
    }
  },
  "-moz-mask-origin": {
    "description": "Determines where the -webkit-mask-position property is anchored.",
    "values": {
      "border": "The mask's position is anchored at the upper-left corner of the element's border.",
      "content": "The mask's position is anchored at the upper-left corner of the element's content.",
      "padding": "The mask's position is anchored at the upper-left corner of the element's padding."
    }
  },
  "-moz-mask-position": {
    "description": "Defines the position of a mask.",
    "values": {
    }
  },
  "-moz-mask-position-x": {
    "description": "Defines the x-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-moz-mask-position-y": {
    "description": "Defines the y-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-moz-mask-repeat": {
    "description": "Defines the repeating qualities of a mask.",
    "values": {
    }
  },
  "-moz-mask-size": {
    "description": "Overrides the size of a mask.",
    "values": {
    }
  },
  "-moz-nbsp-mode": {
    "description": "Defines the behavior of nonbreaking spaces within text.",
    "values": {
      "normal": "Nonbreaking spaces are treated as usual.",
      "space": "Nonbreaking spaces are treated like standard spaces."
    }
  },
  "-moz-padding-start": {
    "description": "Provides the width of the starting padding.",
    "values": {
    }
  },
  "-moz-perspective": {
    "description": "Gives depth to a scene, causing elements farther away from the viewer to appear smaller.",
    "values": {
      "none": "No perspective transform is applied."
    }
  },
  "-moz-perspective-origin": {
    "description": "Sets the origin of the -webkit-perspective property.",
    "values": {
      "50%": "The default value is 50%.",
      "center": "Sets the x or y origin to the center of the element’s border box. If this constant appears before left or right, specifies the y-origin. If it appears after top or bottom, specifies the x-origin. If appears alone, centers both the x and y origin.",
      "left": "Sets the x-origin to the left side of the border box.",
      "right": "Sets the x-origin to the right side of the border box.",
      "top": "Sets the y-origin to the top of the element’s border box.",
      "bottom": "Sets the y-origin to the bottom of the element’s border box."
    }
  },
  "-moz-rtl-ordering": {
    "description": "Overrides ordering defaults for right-to-left content.",
    "values": {
      "logical": "Raw content is in mixed order (requiring a bidirectional renderer).",
      "visual": "Right-to-left content is encoded in reverse order so an entire line of text can be rendered from left to right in a unidirectional fashion."
    }
  },
  "-moz-tap-highlight-color": {
    "description": "Overrides the highlight color shown when the user taps a link or a JavaScript clickable element in Safari on iPhone.",
    "values": {
    }
  },
  "-moz-text-fill-color": {
    "description": "Specifies a fill color for text.",
    "values": {
      "currentcolor": "The value of the element’s color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-moz-text-security": {
    "description": "Specifies the shape to use in place of letters in a password input field.",
    "values": {
      "circle": "A circle shape.",
      "disc": "A disc shape.",
      "none": "No shape is used.",
      "square": "A square shape."
    }
  },
  "-moz-text-size-adjust": {
    "description": "Specifies a size adjustment for displaying text content in Safari on iPhone.",
    "values": {
      "none": "The text size is not adjusted.",
      "auto": "The text size is automatically adjusted for Safari on iPhone."
    }
  },
  "-moz-text-stroke": {
    "description": "Specifies the width and color of the outline (stroke) of text.",
    "values": {
    }
  },
  "-moz-text-stroke-color": {
    "description": "Specifies the color of the outline (stroke) of text.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-moz-text-stroke-width": {
    "description": "Specifies the width for the text outline.",
    "values": {
      "medium": "A medium stroke.",
      "thick": "A thick stroke.",
      "thin": "A thin stroke."
    }
  },
  "-moz-touch-callout": {
    "description": "Disables the default callout shown when you touch and hold a touch target.",
    "values": {
      "default": "Restore the default callout.",
      "none": "The callout is disabled.",
      "inherit": ""
    }
  },
  "-moz-transform": {
    "description": "Specifies transformations to be applied to an element.",
    "values": {
      "none": "No transforms are applied."
    }
  },
  "-moz-transform-origin": {
    "description": "Sets the origin for the -webkit-transform property.",
    "values": {
    }
  },
  "-moz-transform-origin-x": {
    "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-moz-transform-origin-y": {
    "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-moz-transform-origin-z": {
    "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-moz-transform-style": {
    "description": "Defines how nested, transformed elements are rendered in 3D space.",
    "values": {
      "flat": "Flatten all children of this element into the 2D plane.",
      "preserve-3d": "Preserve the 3D perspective."
    }
  },
  "-moz-transition": {
    "description": "Combines -webkit-transition-delay, -webkit-transition-duration, -webkit-transition-property, and -webkit-transition-timing-function into a single property.",
    "values": {
    }
  },
  "-moz-transition-delay": {
    "description": "Defines when the transition starts.",
    "values": {
      "now": "The transition begins immediately. Available in iPhone OS 2.0 and later."
    }
  },
  "-moz-transition-duration": {
    "description": "Defines how long the transition from the old value to the new value should take.",
    "values": {
    }
  },
  "-moz-transition-property": {
    "description": "Specifies the name of the CSS property to which the transition is applied.",
    "values": {
      "none": "No transition specified.",
      "all": "The default transition name."
    }
  },
  "-moz-transition-timing-function": {
    "description": "Specifies how the intermediate values used during a transition are calculated.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0)",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0)",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0)",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0)",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)"
    }
  },
  "-moz-user-drag": {
    "description": "Specifies that an entire element should be draggable instead of its contents.",
    "values": {
      "auto": "The default dragging behavior is used.",
      "element": "The entire element is draggable instead of its contents.",
      "none": "The element cannot be dragged at all."
    }
  },
  "-moz-user-modify": {
    "description": "Determines whether a user can edit the content of an element.",
    "values": {
      "read-only": "The content is read-only.",
      "read-write": "The content can be read and written.",
      "read-write-plaintext-only": "The content can be read and written, but any rich formatting of pasted text is lost."
    }
  },
  "-moz-user-select": {
    "description": "Determines whether a user can select the content of an element.",
    "values": {
      "auto": "The user can select content in the element.",
      "none": "The user cannot select any content.",
      "text": "The user can select text in the element."
    }
  },
  "-ms-animation": {
    "description": "Combines common animation properties into a single property.",
    "values": {
    }
  },
  "-ms-animation-delay": {
    "description": "Defines when an animation starts.",
    "values": {
      "0": "The default value is 0.",
      "now": "The animation begins immediately. Available in iOS 2.0 and later."
    }
  },
  "-ms-animation-direction": {
    "description": "Determines whether the animation should play in reverse on alternate iterations.",
    "values": {
      "normal": "Play each iteration of the animation in the forward direction.",
      "alternate": "Play even-numbered iterations of the animation in the forward direction and odd-numbered iterations in the reverse direction. \n                             When an animation is played in reverse, the timing functions are also reversed. For example, when played in reverse, an ease-in animation appears as an ease-out animation."
    }
  },
  "-ms-animation-duration": {
    "description": "Specifies the length of time that an animation takes to complete one iteration.",
    "values": {
    }
  },
  "-ms-animation-fill-mode": {
    "description": "Specifies whether the effects of an animation are apparent before the animation starts and after it ends.",
    "values": {
      "none": "The effects of the animation are apparent only during the defined duration of the animation.",
      "forwards": "The animation’s final keyframe continues to apply after the final iteration of the animation completes.",
      "backwards": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element. This only affects animations that have a nonzero value for -webkit-animation-delay.",
      "both": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element, and the animation’s final keyframe continues to apply after the final iteration of the animation completes. The initial keyframe only affects animations that have a nonzero value for -webkit-animation-delay."
    }
  },
  "-ms-animation-iteration-count": {
    "description": "Specifies the number of times an animation iterates.",
    "values": {
      "1": "The default value is 1.",
      "infinite": "Repeats the animation forever."
    }
  },
  "-ms-animation-name": {
    "description": "Specifies the name of an animation.",
    "values": {
      "\"\"": "The default value is \"\"."
    }
  },
  "-ms-animation-play-state": {
    "description": "Determines whether the animation is running or paused.",
    "values": {
      "running": "Plays the animation.",
      "paused": "Pauses the animation."
    }
  },
  "-ms-animation-timing-function": {
    "description": "Defines how an animation progresses between keyframes.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)."
    }
  },
  "-ms-appearance": {
    "description": "Changes the appearance of buttons and other controls to resemble native controls.",
    "values": {
      "caps-lock-indicator": "The indicator that appears in a password field when Caps Lock is active. Available in Safari 4.0 and later. Available in iOS 2.0 and later.",
      "button": "",
      "button-bevel": "",
      "caret": "",
      "checkbox": "",
      "default-button": "",
      "listbox": "",
      "listitem": "",
      "media-fullscreen-button": "",
      "media-mute-button": "",
      "media-play-button": "",
      "media-seek-back-button": "",
      "media-seek-forward-button": "",
      "media-slider": "",
      "media-sliderthumb": "",
      "menulist": "",
      "menulist-button": "",
      "menulist-text": "",
      "menulist-textfield": "",
      "none": "",
      "push-button": "",
      "radio": "",
      "searchfield": "",
      "searchfield-cancel-button": "",
      "searchfield-decoration": "",
      "searchfield-results-button": "",
      "searchfield-results-decoration": "",
      "slider-horizontal, slider-vertical": "",
      "sliderthumb-horizontal": "",
      "sliderthumb-vertical": "",
      "square-button": "",
      "textarea": "",
      "textfield": "",
      "scrollbarbutton-down": "Unsupported in Safari 4.0",
      "scrollbarbutton-left": "Unsupported in Safari 4.0",
      "scrollbarbutton-right": "Unsupported in Safari 4.0",
      "scrollbarbutton-up": "Unsupported in Safari 4.0",
      "scrollbargripper-horizontal": "Unsupported in Safari 4.0",
      "scrollbargripper-vertical": "Unsupported in Safari 4.0",
      "scrollbarthumb-horizontal": "Unsupported in Safari 4.0",
      "scrollbarthumb-vertical": "Unsupported in Safari 4.0",
      "scrollbartrack-horizontal": "Unsupported in Safari 4.0",
      "scrollbartrack-vertical": "Unsupported in Safari 4.0"
    }
  },
  "-ms-backface-visibility": {
    "description": "Determines whether or not a transformed element is visible when it is not facing the screen.",
    "values": {
      "visible": "The element is always visible even when it is not facing the screen.",
      "hidden": "The element is invisible if it is not facing the screen."
    }
  },
  "-ms-background-clip": {
    "description": "Specifies the clipping behavior of the background of a box.",
    "values": {
      "border": "The background clips to the border of the box.",
      "content": "The background clips to the content of the box.",
      "padding": "The background clips to the padding of the box.",
      "text": "The background clips to the text of the box. Available in Safari 4.0 and later."
    }
  },
  "-ms-background-composite": {
    "description": "Sets a compositing style for background images and colors.",
    "values": {
      "border": "The background extends into the border area",
      "padding": "The background extends only into the padding area enclosed by the border"
    }
  },
  "-ms-background-origin": {
    "description": "Determines where the background-position property is anchored.",
    "values": {
    }
  },
  "-ms-background-size": {
    "description": "Overrides the size of a background image.",
    "values": {
    }
  },
  "-ms-border-bottom-left-radius": {
    "description": "Specifies that the bottom-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-ms-border-bottom-right-radius": {
    "description": "Specifies that the bottom-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-ms-border-horizontal-spacing": {
    "description": "Defines the spacing between the horizontal portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-ms-border-image": {
    "description": "Specifies an image as the border for a box.",
    "values": {
      "repeat": "The image is tiled.",
      "round": "The image is stretched before it is tiled to prevent partial tiles.",
      "stretch": "The image is stretched to the size of the border."
    }
  },
  "-ms-border-radius": {
    "description": "Specifies that the corners of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-ms-border-top-left-radius": {
    "description": "Specifies that the top-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-ms-border-top-right-radius": {
    "description": "Specifies that the top-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-ms-border-vertical-spacing": {
    "description": "Defines the spacing between the vertical portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-ms-box-align": {
    "description": "Specifies the alignment of nested elements within an outer flexible box element.",
    "values": {
      "baseline": "Elements are aligned with the baseline of the box.",
      "center": "Elements are aligned with the center of the box.",
      "end": "Elements are aligned with the end of the box.",
      "start": "Elements are aligned with the start of the box.",
      "stretch": "Elements are stretched to fill the box."
    }
  },
  "-ms-box-direction": {
    "description": "Specifies the direction in which child elements of a flexible box element are laid out.",
    "values": {
      "normal": "Elements are laid out in the default direction.",
      "reverse": "Elements are laid out in the reverse direction."
    }
  },
  "-ms-box-flex": {
    "description": "Specifies an element’s flexibility.",
    "values": {
    }
  },
  "-ms-box-flex-group": {
    "description": "Specifies groups of dynamically resizing elements that are adjusted to be the same size.",
    "values": {
    }
  },
  "-ms-box-lines": {
    "description": "Specifies whether a flexible box should contain multiple lines of content.",
    "values": {
      "multiple": "The box can contain multiple lines of content.",
      "single": "The box can contain only one line of content."
    }
  },
  "-ms-box-ordinal-group": {
    "description": "Specifies a rough ordering of elements in a flexible box.",
    "values": {
    }
  },
  "-ms-box-orient": {
    "description": "Specifies the layout of elements nested within a flexible box element.",
    "values": {
      "block-axis": "Elements are oriented along the box's axis.",
      "horizontal": "Elements are oriented horizontally.",
      "inline-axis": "Elements are oriented along the inline axis.",
      "vertical": "Elements are oriented vertically."
    }
  },
  "-ms-box-pack": {
    "description": "Specifies alignment of child elements within the current element in the direction of orientation.",
    "values": {
      "center": "Child elements are aligned to the center of the element.",
      "end": "Child elements are aligned to the end of the element.",
      "justify": "Child elements are justified with both the start and end of the element.",
      "start": "Child elements are aligned to the start of the element."
    }
  },
  "-ms-box-reflect": {
    "description": "Defines a reflection of a border box.",
    "values": {
      "above": "The reflection appears above the border box.",
      "below": "The reflection appears below the border box.",
      "left": "The reflection appears to the left of the border box.",
      "right": "The reflection appears to the right of the border box."
    }
  },
  "-ms-box-shadow": {
    "description": "Applies a drop shadow effect to the border box of an object.",
    "values": {
      "none": "The box has no shadow."
    }
  },
  "-ms-box-sizing": {
    "description": "Specifies that the size of a box be measured according to either its content (default) or its total size including borders.",
    "values": {
      "border-box": "The box size includes borders in addition to content.",
      "content-box": "The box size only includes content."
    }
  },
  "-ms-column-break-after": {
    "description": "Determines whether a column break can and should occur after an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted after the element.",
      "auto": "A right column break is inserted after the element where appropriate.",
      "avoid": "Column breaks are avoided after the element.",
      "left": "A left column break is inserted after the element.",
      "right": "A right column break is inserted after the element."
    }
  },
  "-ms-column-break-before": {
    "description": "Determines whether a column break can and should occur before an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted before the element.",
      "auto": "A right column break is inserted before the element where appropriate.",
      "avoid": "Column breaks are avoided before the element.",
      "left": "A left column break is inserted before the element.",
      "right": "A right column break is inserted before the element."
    }
  },
  "-ms-column-break-inside": {
    "description": "Determines whether a column break should be avoided within the bounds of an element in a multicolumn flow layout.",
    "values": {
      "auto": "A right column break is inserted within the element where appropriate.",
      "avoid": "Column breaks are avoided within the element."
    }
  },
  "-ms-column-count": {
    "description": "Specifies the number of columns desired in a multicolumn flow.",
    "values": {
      "auto": "The element has one column."
    }
  },
  "-ms-column-gap": {
    "description": "Specifies the space between columns in a multicolumn flow.",
    "values": {
      "normal": "Columns in the element have the normal gap width between them."
    }
  },
  "-ms-column-rule": {
    "description": "Specifies the color, style, and width of the column rule.",
    "values": {
    }
  },
  "-ms-column-rule-color": {
    "description": "Specifies the color of the column rule.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-ms-column-rule-style": {
    "description": "Specifies the style of the column rule.",
    "values": {
      "dashed": "The column rule has a dashed line style.",
      "dotted": "The column rule has a dotted line style.",
      "double": "The column rule has a double solid line style.",
      "groove": "The column rule has a grooved style.",
      "hidden": "The column rule is hidden.",
      "inset": "The column rule has an inset style.",
      "none": "The column rule has no style.",
      "outset": "The column rule has an outset style.",
      "ridge": "The column rule has a ridged style.",
      "solid": "The column rule has a solid line style."
    }
  },
  "-ms-column-rule-width": {
    "description": "Specifies the width of the column rule.",
    "values": {
      "medium": "The column rule has a medium width.",
      "thick": "The column rule has a thick width.",
      "thin": "The column rule has a thin width."
    }
  },
  "-ms-column-width": {
    "description": "Specifies the width of the column in a multicolumn flow.",
    "values": {
      "auto": "Columns in the element are of normal width."
    }
  },
  "-ms-columns": {
    "description": "A composite property that specifies the width and number of columns in a multicolumn flow layout.",
    "values": {
    }
  },
  "-ms-dashboard-region": {
    "description": "Specifies the behavior of regions in a Dashboard widget.",
    "values": {
      "none": "No behavior is specified."
    }
  },
  "-ms-line-break": {
    "description": "Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text.",
    "values": {
      "after-white-space": "The line breaks after white space.",
      "normal": "A standard line-breaking rule"
    }
  },
  "-ms-margin-bottom-collapse": {
    "description": "Specifies the behavior of an element’s bottom margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-ms-margin-collapse": {
    "description": "Specifies the behavior of an element’s vertical margins if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
    }
  },
  "-ms-margin-start": {
    "description": "Provides the width of the starting margin.",
    "values": {
      "auto": "The margin is automatically determined."
    }
  },
  "-ms-margin-top-collapse": {
    "description": "Specifies the behavior of an element’s top margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-ms-marquee": {
    "description": "Defines properties for showing content as though displayed on an electronic marquee sign.",
    "values": {
    }
  },
  "-ms-marquee-direction": {
    "description": "Specifies the direction of motion for a marquee box.",
    "values": {
      "ahead": "The marquee moves from bottom to top.",
      "auto": "The marquee moves in the default direction.",
      "backwards": "The marquee moves from right to left.",
      "down": "The marquee moves from bottom to top.",
      "forwards": "The marquee moves from left to right.",
      "left": "The marquee moves from right to left.",
      "reverse": "The marquee moves from top to bottom.",
      "right": "The marquee moves from left to right.",
      "up": "The marquee moves from bottom to top."
    }
  },
  "-ms-marquee-increment": {
    "description": "Defines the distance the marquee moves in each increment.",
    "values": {
      "large": "The marquee moves a large amount in each increment.",
      "medium": "The marquee moves a medium amount in each increment.",
      "small": "The marquee moves a small amount in each increment."
    }
  },
  "-ms-marquee-repetition": {
    "description": "Specifies the number of times a marquee box repeats (or infinite).",
    "values": {
      "infinite": "The marquee repeats infinitely."
    }
  },
  "-ms-marquee-speed": {
    "description": "Defines the scroll or slide speed of a marquee box.",
    "values": {
      "fast": "The marquee moves at a fast speed.",
      "normal": "The marquee moves at a normal speed.",
      "slow": "The marquee moves at a slow speed."
    }
  },
  "-ms-marquee-style": {
    "description": "Specifies the style of marquee motion.",
    "values": {
      "alternate": "The marquee shifts back and forth.",
      "none": "The marquee does not move.",
      "scroll": "The marquee loops in its specified direction.",
      "slide": "The marquee moves in its specified direction, but stops either when the entirety of its content has been displayed or the content reaches the opposite border of its box, whichever comes second."
    }
  },
  "-ms-mask": {
    "description": "Defines a variety of mask properties within one declaration.",
    "values": {
    }
  },
  "-ms-mask-attachment": {
    "description": "Defines the scrolling or fixed nature of the image mask.",
    "values": {
      "fixed": "The mask does not move when the page scrolls.",
      "scroll": "The image moves when the page scrolls."
    }
  },
  "-ms-mask-box-image": {
    "description": "Defines an image to be used as a mask for a border box.",
    "values": {
    }
  },
  "-ms-mask-clip": {
    "description": "Specifies whether the mask should extend into the border of a box.",
    "values": {
    }
  },
  "-ms-mask-composite": {
    "description": "Sets a compositing style for a mask.",
    "values": {
      "border": "The background extends into the border area.",
      "padding": "The background extends only into the padding area enclosed by the border."
    }
  },
  "-ms-mask-image": {
    "description": "Defines an image to be used as a mask for an element.",
    "values": {
    }
  },
  "-ms-mask-origin": {
    "description": "Determines where the -webkit-mask-position property is anchored.",
    "values": {
      "border": "The mask's position is anchored at the upper-left corner of the element's border.",
      "content": "The mask's position is anchored at the upper-left corner of the element's content.",
      "padding": "The mask's position is anchored at the upper-left corner of the element's padding."
    }
  },
  "-ms-mask-position": {
    "description": "Defines the position of a mask.",
    "values": {
    }
  },
  "-ms-mask-position-x": {
    "description": "Defines the x-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-ms-mask-position-y": {
    "description": "Defines the y-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-ms-mask-repeat": {
    "description": "Defines the repeating qualities of a mask.",
    "values": {
    }
  },
  "-ms-mask-size": {
    "description": "Overrides the size of a mask.",
    "values": {
    }
  },
  "-ms-nbsp-mode": {
    "description": "Defines the behavior of nonbreaking spaces within text.",
    "values": {
      "normal": "Nonbreaking spaces are treated as usual.",
      "space": "Nonbreaking spaces are treated like standard spaces."
    }
  },
  "-ms-padding-start": {
    "description": "Provides the width of the starting padding.",
    "values": {
    }
  },
  "-ms-perspective": {
    "description": "Gives depth to a scene, causing elements farther away from the viewer to appear smaller.",
    "values": {
      "none": "No perspective transform is applied."
    }
  },
  "-ms-perspective-origin": {
    "description": "Sets the origin of the -webkit-perspective property.",
    "values": {
      "50%": "The default value is 50%.",
      "center": "Sets the x or y origin to the center of the element’s border box. If this constant appears before left or right, specifies the y-origin. If it appears after top or bottom, specifies the x-origin. If appears alone, centers both the x and y origin.",
      "left": "Sets the x-origin to the left side of the border box.",
      "right": "Sets the x-origin to the right side of the border box.",
      "top": "Sets the y-origin to the top of the element’s border box.",
      "bottom": "Sets the y-origin to the bottom of the element’s border box."
    }
  },
  "-ms-rtl-ordering": {
    "description": "Overrides ordering defaults for right-to-left content.",
    "values": {
      "logical": "Raw content is in mixed order (requiring a bidirectional renderer).",
      "visual": "Right-to-left content is encoded in reverse order so an entire line of text can be rendered from left to right in a unidirectional fashion."
    }
  },
  "-ms-tap-highlight-color": {
    "description": "Overrides the highlight color shown when the user taps a link or a JavaScript clickable element in Safari on iPhone.",
    "values": {
    }
  },
  "-ms-text-fill-color": {
    "description": "Specifies a fill color for text.",
    "values": {
      "currentcolor": "The value of the element’s color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-ms-text-security": {
    "description": "Specifies the shape to use in place of letters in a password input field.",
    "values": {
      "circle": "A circle shape.",
      "disc": "A disc shape.",
      "none": "No shape is used.",
      "square": "A square shape."
    }
  },
  "-ms-text-size-adjust": {
    "description": "Specifies a size adjustment for displaying text content in Safari on iPhone.",
    "values": {
      "none": "The text size is not adjusted.",
      "auto": "The text size is automatically adjusted for Safari on iPhone."
    }
  },
  "-ms-text-stroke": {
    "description": "Specifies the width and color of the outline (stroke) of text.",
    "values": {
    }
  },
  "-ms-text-stroke-color": {
    "description": "Specifies the color of the outline (stroke) of text.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-ms-text-stroke-width": {
    "description": "Specifies the width for the text outline.",
    "values": {
      "medium": "A medium stroke.",
      "thick": "A thick stroke.",
      "thin": "A thin stroke."
    }
  },
  "-ms-touch-callout": {
    "description": "Disables the default callout shown when you touch and hold a touch target.",
    "values": {
      "default": "Restore the default callout.",
      "none": "The callout is disabled.",
      "inherit": ""
    }
  },
  "-ms-transform": {
    "description": "Specifies transformations to be applied to an element.",
    "values": {
      "none": "No transforms are applied."
    }
  },
  "-ms-transform-origin": {
    "description": "Sets the origin for the -webkit-transform property.",
    "values": {
    }
  },
  "-ms-transform-origin-x": {
    "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-ms-transform-origin-y": {
    "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-ms-transform-origin-z": {
    "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-ms-transform-style": {
    "description": "Defines how nested, transformed elements are rendered in 3D space.",
    "values": {
      "flat": "Flatten all children of this element into the 2D plane.",
      "preserve-3d": "Preserve the 3D perspective."
    }
  },
  "-ms-transition": {
    "description": "Combines -webkit-transition-delay, -webkit-transition-duration, -webkit-transition-property, and -webkit-transition-timing-function into a single property.",
    "values": {
    }
  },
  "-ms-transition-delay": {
    "description": "Defines when the transition starts.",
    "values": {
      "now": "The transition begins immediately. Available in iPhone OS 2.0 and later."
    }
  },
  "-ms-transition-duration": {
    "description": "Defines how long the transition from the old value to the new value should take.",
    "values": {
    }
  },
  "-ms-transition-property": {
    "description": "Specifies the name of the CSS property to which the transition is applied.",
    "values": {
      "none": "No transition specified.",
      "all": "The default transition name."
    }
  },
  "-ms-transition-timing-function": {
    "description": "Specifies how the intermediate values used during a transition are calculated.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0)",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0)",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0)",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0)",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)"
    }
  },
  "-ms-user-drag": {
    "description": "Specifies that an entire element should be draggable instead of its contents.",
    "values": {
      "auto": "The default dragging behavior is used.",
      "element": "The entire element is draggable instead of its contents.",
      "none": "The element cannot be dragged at all."
    }
  },
  "-ms-user-modify": {
    "description": "Determines whether a user can edit the content of an element.",
    "values": {
      "read-only": "The content is read-only.",
      "read-write": "The content can be read and written.",
      "read-write-plaintext-only": "The content can be read and written, but any rich formatting of pasted text is lost."
    }
  },
  "-ms-user-select": {
    "description": "Determines whether a user can select the content of an element.",
    "values": {
      "auto": "The user can select content in the element.",
      "none": "The user cannot select any content.",
      "text": "The user can select text in the element."
    }
  },
  "-o-animation": {
    "description": "Combines common animation properties into a single property.",
    "values": {
    }
  },
  "-o-animation-delay": {
    "description": "Defines when an animation starts.",
    "values": {
      "0": "The default value is 0.",
      "now": "The animation begins immediately. Available in iOS 2.0 and later."
    }
  },
  "-o-animation-direction": {
    "description": "Determines whether the animation should play in reverse on alternate iterations.",
    "values": {
      "normal": "Play each iteration of the animation in the forward direction.",
      "alternate": "Play even-numbered iterations of the animation in the forward direction and odd-numbered iterations in the reverse direction. \n                             When an animation is played in reverse, the timing functions are also reversed. For example, when played in reverse, an ease-in animation appears as an ease-out animation."
    }
  },
  "-o-animation-duration": {
    "description": "Specifies the length of time that an animation takes to complete one iteration.",
    "values": {
    }
  },
  "-o-animation-fill-mode": {
    "description": "Specifies whether the effects of an animation are apparent before the animation starts and after it ends.",
    "values": {
      "none": "The effects of the animation are apparent only during the defined duration of the animation.",
      "forwards": "The animation’s final keyframe continues to apply after the final iteration of the animation completes.",
      "backwards": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element. This only affects animations that have a nonzero value for -webkit-animation-delay.",
      "both": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element, and the animation’s final keyframe continues to apply after the final iteration of the animation completes. The initial keyframe only affects animations that have a nonzero value for -webkit-animation-delay."
    }
  },
  "-o-animation-iteration-count": {
    "description": "Specifies the number of times an animation iterates.",
    "values": {
      "1": "The default value is 1.",
      "infinite": "Repeats the animation forever."
    }
  },
  "-o-animation-name": {
    "description": "Specifies the name of an animation.",
    "values": {
      "\"\"": "The default value is \"\"."
    }
  },
  "-o-animation-play-state": {
    "description": "Determines whether the animation is running or paused.",
    "values": {
      "running": "Plays the animation.",
      "paused": "Pauses the animation."
    }
  },
  "-o-animation-timing-function": {
    "description": "Defines how an animation progresses between keyframes.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)."
    }
  },
  "-o-appearance": {
    "description": "Changes the appearance of buttons and other controls to resemble native controls.",
    "values": {
      "caps-lock-indicator": "The indicator that appears in a password field when Caps Lock is active. Available in Safari 4.0 and later. Available in iOS 2.0 and later.",
      "button": "",
      "button-bevel": "",
      "caret": "",
      "checkbox": "",
      "default-button": "",
      "listbox": "",
      "listitem": "",
      "media-fullscreen-button": "",
      "media-mute-button": "",
      "media-play-button": "",
      "media-seek-back-button": "",
      "media-seek-forward-button": "",
      "media-slider": "",
      "media-sliderthumb": "",
      "menulist": "",
      "menulist-button": "",
      "menulist-text": "",
      "menulist-textfield": "",
      "none": "",
      "push-button": "",
      "radio": "",
      "searchfield": "",
      "searchfield-cancel-button": "",
      "searchfield-decoration": "",
      "searchfield-results-button": "",
      "searchfield-results-decoration": "",
      "slider-horizontal, slider-vertical": "",
      "sliderthumb-horizontal": "",
      "sliderthumb-vertical": "",
      "square-button": "",
      "textarea": "",
      "textfield": "",
      "scrollbarbutton-down": "Unsupported in Safari 4.0",
      "scrollbarbutton-left": "Unsupported in Safari 4.0",
      "scrollbarbutton-right": "Unsupported in Safari 4.0",
      "scrollbarbutton-up": "Unsupported in Safari 4.0",
      "scrollbargripper-horizontal": "Unsupported in Safari 4.0",
      "scrollbargripper-vertical": "Unsupported in Safari 4.0",
      "scrollbarthumb-horizontal": "Unsupported in Safari 4.0",
      "scrollbarthumb-vertical": "Unsupported in Safari 4.0",
      "scrollbartrack-horizontal": "Unsupported in Safari 4.0",
      "scrollbartrack-vertical": "Unsupported in Safari 4.0"
    }
  },
  "-o-backface-visibility": {
    "description": "Determines whether or not a transformed element is visible when it is not facing the screen.",
    "values": {
      "visible": "The element is always visible even when it is not facing the screen.",
      "hidden": "The element is invisible if it is not facing the screen."
    }
  },
  "-o-background-clip": {
    "description": "Specifies the clipping behavior of the background of a box.",
    "values": {
      "border": "The background clips to the border of the box.",
      "content": "The background clips to the content of the box.",
      "padding": "The background clips to the padding of the box.",
      "text": "The background clips to the text of the box. Available in Safari 4.0 and later."
    }
  },
  "-o-background-composite": {
    "description": "Sets a compositing style for background images and colors.",
    "values": {
      "border": "The background extends into the border area",
      "padding": "The background extends only into the padding area enclosed by the border"
    }
  },
  "-o-background-origin": {
    "description": "Determines where the background-position property is anchored.",
    "values": {
    }
  },
  "-o-background-size": {
    "description": "Overrides the size of a background image.",
    "values": {
    }
  },
  "-o-border-bottom-left-radius": {
    "description": "Specifies that the bottom-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-o-border-bottom-right-radius": {
    "description": "Specifies that the bottom-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-o-border-horizontal-spacing": {
    "description": "Defines the spacing between the horizontal portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-o-border-image": {
    "description": "Specifies an image as the border for a box.",
    "values": {
      "repeat": "The image is tiled.",
      "round": "The image is stretched before it is tiled to prevent partial tiles.",
      "stretch": "The image is stretched to the size of the border."
    }
  },
  "-o-border-radius": {
    "description": "Specifies that the corners of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-o-border-top-left-radius": {
    "description": "Specifies that the top-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-o-border-top-right-radius": {
    "description": "Specifies that the top-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-o-border-vertical-spacing": {
    "description": "Defines the spacing between the vertical portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-o-box-align": {
    "description": "Specifies the alignment of nested elements within an outer flexible box element.",
    "values": {
      "baseline": "Elements are aligned with the baseline of the box.",
      "center": "Elements are aligned with the center of the box.",
      "end": "Elements are aligned with the end of the box.",
      "start": "Elements are aligned with the start of the box.",
      "stretch": "Elements are stretched to fill the box."
    }
  },
  "-o-box-direction": {
    "description": "Specifies the direction in which child elements of a flexible box element are laid out.",
    "values": {
      "normal": "Elements are laid out in the default direction.",
      "reverse": "Elements are laid out in the reverse direction."
    }
  },
  "-o-box-flex": {
    "description": "Specifies an element’s flexibility.",
    "values": {
    }
  },
  "-o-box-flex-group": {
    "description": "Specifies groups of dynamically resizing elements that are adjusted to be the same size.",
    "values": {
    }
  },
  "-o-box-lines": {
    "description": "Specifies whether a flexible box should contain multiple lines of content.",
    "values": {
      "multiple": "The box can contain multiple lines of content.",
      "single": "The box can contain only one line of content."
    }
  },
  "-o-box-ordinal-group": {
    "description": "Specifies a rough ordering of elements in a flexible box.",
    "values": {
    }
  },
  "-o-box-orient": {
    "description": "Specifies the layout of elements nested within a flexible box element.",
    "values": {
      "block-axis": "Elements are oriented along the box's axis.",
      "horizontal": "Elements are oriented horizontally.",
      "inline-axis": "Elements are oriented along the inline axis.",
      "vertical": "Elements are oriented vertically."
    }
  },
  "-o-box-pack": {
    "description": "Specifies alignment of child elements within the current element in the direction of orientation.",
    "values": {
      "center": "Child elements are aligned to the center of the element.",
      "end": "Child elements are aligned to the end of the element.",
      "justify": "Child elements are justified with both the start and end of the element.",
      "start": "Child elements are aligned to the start of the element."
    }
  },
  "-o-box-reflect": {
    "description": "Defines a reflection of a border box.",
    "values": {
      "above": "The reflection appears above the border box.",
      "below": "The reflection appears below the border box.",
      "left": "The reflection appears to the left of the border box.",
      "right": "The reflection appears to the right of the border box."
    }
  },
  "-o-box-shadow": {
    "description": "Applies a drop shadow effect to the border box of an object.",
    "values": {
      "none": "The box has no shadow."
    }
  },
  "-o-box-sizing": {
    "description": "Specifies that the size of a box be measured according to either its content (default) or its total size including borders.",
    "values": {
      "border-box": "The box size includes borders in addition to content.",
      "content-box": "The box size only includes content."
    }
  },
  "-o-column-break-after": {
    "description": "Determines whether a column break can and should occur after an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted after the element.",
      "auto": "A right column break is inserted after the element where appropriate.",
      "avoid": "Column breaks are avoided after the element.",
      "left": "A left column break is inserted after the element.",
      "right": "A right column break is inserted after the element."
    }
  },
  "-o-column-break-before": {
    "description": "Determines whether a column break can and should occur before an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted before the element.",
      "auto": "A right column break is inserted before the element where appropriate.",
      "avoid": "Column breaks are avoided before the element.",
      "left": "A left column break is inserted before the element.",
      "right": "A right column break is inserted before the element."
    }
  },
  "-o-column-break-inside": {
    "description": "Determines whether a column break should be avoided within the bounds of an element in a multicolumn flow layout.",
    "values": {
      "auto": "A right column break is inserted within the element where appropriate.",
      "avoid": "Column breaks are avoided within the element."
    }
  },
  "-o-column-count": {
    "description": "Specifies the number of columns desired in a multicolumn flow.",
    "values": {
      "auto": "The element has one column."
    }
  },
  "-o-column-gap": {
    "description": "Specifies the space between columns in a multicolumn flow.",
    "values": {
      "normal": "Columns in the element have the normal gap width between them."
    }
  },
  "-o-column-rule": {
    "description": "Specifies the color, style, and width of the column rule.",
    "values": {
    }
  },
  "-o-column-rule-color": {
    "description": "Specifies the color of the column rule.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-o-column-rule-style": {
    "description": "Specifies the style of the column rule.",
    "values": {
      "dashed": "The column rule has a dashed line style.",
      "dotted": "The column rule has a dotted line style.",
      "double": "The column rule has a double solid line style.",
      "groove": "The column rule has a grooved style.",
      "hidden": "The column rule is hidden.",
      "inset": "The column rule has an inset style.",
      "none": "The column rule has no style.",
      "outset": "The column rule has an outset style.",
      "ridge": "The column rule has a ridged style.",
      "solid": "The column rule has a solid line style."
    }
  },
  "-o-column-rule-width": {
    "description": "Specifies the width of the column rule.",
    "values": {
      "medium": "The column rule has a medium width.",
      "thick": "The column rule has a thick width.",
      "thin": "The column rule has a thin width."
    }
  },
  "-o-column-width": {
    "description": "Specifies the width of the column in a multicolumn flow.",
    "values": {
      "auto": "Columns in the element are of normal width."
    }
  },
  "-o-columns": {
    "description": "A composite property that specifies the width and number of columns in a multicolumn flow layout.",
    "values": {
    }
  },
  "-o-dashboard-region": {
    "description": "Specifies the behavior of regions in a Dashboard widget.",
    "values": {
      "none": "No behavior is specified."
    }
  },
  "-o-line-break": {
    "description": "Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text.",
    "values": {
      "after-white-space": "The line breaks after white space.",
      "normal": "A standard line-breaking rule"
    }
  },
  "-o-margin-bottom-collapse": {
    "description": "Specifies the behavior of an element’s bottom margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-o-margin-collapse": {
    "description": "Specifies the behavior of an element’s vertical margins if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
    }
  },
  "-o-margin-start": {
    "description": "Provides the width of the starting margin.",
    "values": {
      "auto": "The margin is automatically determined."
    }
  },
  "-o-margin-top-collapse": {
    "description": "Specifies the behavior of an element’s top margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-o-marquee": {
    "description": "Defines properties for showing content as though displayed on an electronic marquee sign.",
    "values": {
    }
  },
  "-o-marquee-direction": {
    "description": "Specifies the direction of motion for a marquee box.",
    "values": {
      "ahead": "The marquee moves from bottom to top.",
      "auto": "The marquee moves in the default direction.",
      "backwards": "The marquee moves from right to left.",
      "down": "The marquee moves from bottom to top.",
      "forwards": "The marquee moves from left to right.",
      "left": "The marquee moves from right to left.",
      "reverse": "The marquee moves from top to bottom.",
      "right": "The marquee moves from left to right.",
      "up": "The marquee moves from bottom to top."
    }
  },
  "-o-marquee-increment": {
    "description": "Defines the distance the marquee moves in each increment.",
    "values": {
      "large": "The marquee moves a large amount in each increment.",
      "medium": "The marquee moves a medium amount in each increment.",
      "small": "The marquee moves a small amount in each increment."
    }
  },
  "-o-marquee-repetition": {
    "description": "Specifies the number of times a marquee box repeats (or infinite).",
    "values": {
      "infinite": "The marquee repeats infinitely."
    }
  },
  "-o-marquee-speed": {
    "description": "Defines the scroll or slide speed of a marquee box.",
    "values": {
      "fast": "The marquee moves at a fast speed.",
      "normal": "The marquee moves at a normal speed.",
      "slow": "The marquee moves at a slow speed."
    }
  },
  "-o-marquee-style": {
    "description": "Specifies the style of marquee motion.",
    "values": {
      "alternate": "The marquee shifts back and forth.",
      "none": "The marquee does not move.",
      "scroll": "The marquee loops in its specified direction.",
      "slide": "The marquee moves in its specified direction, but stops either when the entirety of its content has been displayed or the content reaches the opposite border of its box, whichever comes second."
    }
  },
  "-o-mask": {
    "description": "Defines a variety of mask properties within one declaration.",
    "values": {
    }
  },
  "-o-mask-attachment": {
    "description": "Defines the scrolling or fixed nature of the image mask.",
    "values": {
      "fixed": "The mask does not move when the page scrolls.",
      "scroll": "The image moves when the page scrolls."
    }
  },
  "-o-mask-box-image": {
    "description": "Defines an image to be used as a mask for a border box.",
    "values": {
    }
  },
  "-o-mask-clip": {
    "description": "Specifies whether the mask should extend into the border of a box.",
    "values": {
    }
  },
  "-o-mask-composite": {
    "description": "Sets a compositing style for a mask.",
    "values": {
      "border": "The background extends into the border area.",
      "padding": "The background extends only into the padding area enclosed by the border."
    }
  },
  "-o-mask-image": {
    "description": "Defines an image to be used as a mask for an element.",
    "values": {
    }
  },
  "-o-mask-origin": {
    "description": "Determines where the -webkit-mask-position property is anchored.",
    "values": {
      "border": "The mask's position is anchored at the upper-left corner of the element's border.",
      "content": "The mask's position is anchored at the upper-left corner of the element's content.",
      "padding": "The mask's position is anchored at the upper-left corner of the element's padding."
    }
  },
  "-o-mask-position": {
    "description": "Defines the position of a mask.",
    "values": {
    }
  },
  "-o-mask-position-x": {
    "description": "Defines the x-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-o-mask-position-y": {
    "description": "Defines the y-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-o-mask-repeat": {
    "description": "Defines the repeating qualities of a mask.",
    "values": {
    }
  },
  "-o-mask-size": {
    "description": "Overrides the size of a mask.",
    "values": {
    }
  },
  "-o-nbsp-mode": {
    "description": "Defines the behavior of nonbreaking spaces within text.",
    "values": {
      "normal": "Nonbreaking spaces are treated as usual.",
      "space": "Nonbreaking spaces are treated like standard spaces."
    }
  },
  "-o-padding-start": {
    "description": "Provides the width of the starting padding.",
    "values": {
    }
  },
  "-o-perspective": {
    "description": "Gives depth to a scene, causing elements farther away from the viewer to appear smaller.",
    "values": {
      "none": "No perspective transform is applied."
    }
  },
  "-o-perspective-origin": {
    "description": "Sets the origin of the -webkit-perspective property.",
    "values": {
      "50%": "The default value is 50%.",
      "center": "Sets the x or y origin to the center of the element’s border box. If this constant appears before left or right, specifies the y-origin. If it appears after top or bottom, specifies the x-origin. If appears alone, centers both the x and y origin.",
      "left": "Sets the x-origin to the left side of the border box.",
      "right": "Sets the x-origin to the right side of the border box.",
      "top": "Sets the y-origin to the top of the element’s border box.",
      "bottom": "Sets the y-origin to the bottom of the element’s border box."
    }
  },
  "-o-rtl-ordering": {
    "description": "Overrides ordering defaults for right-to-left content.",
    "values": {
      "logical": "Raw content is in mixed order (requiring a bidirectional renderer).",
      "visual": "Right-to-left content is encoded in reverse order so an entire line of text can be rendered from left to right in a unidirectional fashion."
    }
  },
  "-o-tap-highlight-color": {
    "description": "Overrides the highlight color shown when the user taps a link or a JavaScript clickable element in Safari on iPhone.",
    "values": {
    }
  },
  "-o-text-fill-color": {
    "description": "Specifies a fill color for text.",
    "values": {
      "currentcolor": "The value of the element’s color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-o-text-security": {
    "description": "Specifies the shape to use in place of letters in a password input field.",
    "values": {
      "circle": "A circle shape.",
      "disc": "A disc shape.",
      "none": "No shape is used.",
      "square": "A square shape."
    }
  },
  "-o-text-size-adjust": {
    "description": "Specifies a size adjustment for displaying text content in Safari on iPhone.",
    "values": {
      "none": "The text size is not adjusted.",
      "auto": "The text size is automatically adjusted for Safari on iPhone."
    }
  },
  "-o-text-stroke": {
    "description": "Specifies the width and color of the outline (stroke) of text.",
    "values": {
    }
  },
  "-o-text-stroke-color": {
    "description": "Specifies the color of the outline (stroke) of text.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-o-text-stroke-width": {
    "description": "Specifies the width for the text outline.",
    "values": {
      "medium": "A medium stroke.",
      "thick": "A thick stroke.",
      "thin": "A thin stroke."
    }
  },
  "-o-touch-callout": {
    "description": "Disables the default callout shown when you touch and hold a touch target.",
    "values": {
      "default": "Restore the default callout.",
      "none": "The callout is disabled.",
      "inherit": ""
    }
  },
  "-o-transform": {
    "description": "Specifies transformations to be applied to an element.",
    "values": {
      "none": "No transforms are applied."
    }
  },
  "-o-transform-origin": {
    "description": "Sets the origin for the -webkit-transform property.",
    "values": {
    }
  },
  "-o-transform-origin-x": {
    "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-o-transform-origin-y": {
    "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-o-transform-origin-z": {
    "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-o-transform-style": {
    "description": "Defines how nested, transformed elements are rendered in 3D space.",
    "values": {
      "flat": "Flatten all children of this element into the 2D plane.",
      "preserve-3d": "Preserve the 3D perspective."
    }
  },
  "-o-transition": {
    "description": "Combines -webkit-transition-delay, -webkit-transition-duration, -webkit-transition-property, and -webkit-transition-timing-function into a single property.",
    "values": {
    }
  },
  "-o-transition-delay": {
    "description": "Defines when the transition starts.",
    "values": {
      "now": "The transition begins immediately. Available in iPhone OS 2.0 and later."
    }
  },
  "-o-transition-duration": {
    "description": "Defines how long the transition from the old value to the new value should take.",
    "values": {
    }
  },
  "-o-transition-property": {
    "description": "Specifies the name of the CSS property to which the transition is applied.",
    "values": {
      "none": "No transition specified.",
      "all": "The default transition name."
    }
  },
  "-o-transition-timing-function": {
    "description": "Specifies how the intermediate values used during a transition are calculated.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0)",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0)",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0)",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0)",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)"
    }
  },
  "-o-user-drag": {
    "description": "Specifies that an entire element should be draggable instead of its contents.",
    "values": {
      "auto": "The default dragging behavior is used.",
      "element": "The entire element is draggable instead of its contents.",
      "none": "The element cannot be dragged at all."
    }
  },
  "-o-user-modify": {
    "description": "Determines whether a user can edit the content of an element.",
    "values": {
      "read-only": "The content is read-only.",
      "read-write": "The content can be read and written.",
      "read-write-plaintext-only": "The content can be read and written, but any rich formatting of pasted text is lost."
    }
  },
  "-o-user-select": {
    "description": "Determines whether a user can select the content of an element.",
    "values": {
      "auto": "The user can select content in the element.",
      "none": "The user cannot select any content.",
      "text": "The user can select text in the element."
    }
  },
  "-webkit-animation": {
    "description": "Combines common animation properties into a single property.",
    "values": {
    }
  },
  "-webkit-animation-delay": {
    "description": "Defines when an animation starts.",
    "values": {
      "0": "The default value is 0.",
      "now": "The animation begins immediately. Available in iOS 2.0 and later."
    }
  },
  "-webkit-animation-direction": {
    "description": "Determines whether the animation should play in reverse on alternate iterations.",
    "values": {
      "normal": "Play each iteration of the animation in the forward direction.",
      "alternate": "Play even-numbered iterations of the animation in the forward direction and odd-numbered iterations in the reverse direction. \n                             When an animation is played in reverse, the timing functions are also reversed. For example, when played in reverse, an ease-in animation appears as an ease-out animation."
    }
  },
  "-webkit-animation-duration": {
    "description": "Specifies the length of time that an animation takes to complete one iteration.",
    "values": {
    }
  },
  "-webkit-animation-fill-mode": {
    "description": "Specifies whether the effects of an animation are apparent before the animation starts and after it ends.",
    "values": {
      "none": "The effects of the animation are apparent only during the defined duration of the animation.",
      "forwards": "The animation’s final keyframe continues to apply after the final iteration of the animation completes.",
      "backwards": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element. This only affects animations that have a nonzero value for -webkit-animation-delay.",
      "both": "The animation’s initial keyframe is applied as soon as the animation style is applied to an element, and the animation’s final keyframe continues to apply after the final iteration of the animation completes. The initial keyframe only affects animations that have a nonzero value for -webkit-animation-delay."
    }
  },
  "-webkit-animation-iteration-count": {
    "description": "Specifies the number of times an animation iterates.",
    "values": {
      "1": "The default value is 1.",
      "infinite": "Repeats the animation forever."
    }
  },
  "-webkit-animation-name": {
    "description": "Specifies the name of an animation.",
    "values": {
      "\"\"": "The default value is \"\"."
    }
  },
  "-webkit-animation-play-state": {
    "description": "Determines whether the animation is running or paused.",
    "values": {
      "running": "Plays the animation.",
      "paused": "Pauses the animation."
    }
  },
  "-webkit-animation-timing-function": {
    "description": "Defines how an animation progresses between keyframes.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0).",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0).",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0).",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0).",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)."
    }
  },
  "-webkit-appearance": {
    "description": "Changes the appearance of buttons and other controls to resemble native controls.",
    "values": {
      "caps-lock-indicator": "The indicator that appears in a password field when Caps Lock is active. Available in Safari 4.0 and later. Available in iOS 2.0 and later.",
      "button": "",
      "button-bevel": "",
      "caret": "",
      "checkbox": "",
      "default-button": "",
      "listbox": "",
      "listitem": "",
      "media-fullscreen-button": "",
      "media-mute-button": "",
      "media-play-button": "",
      "media-seek-back-button": "",
      "media-seek-forward-button": "",
      "media-slider": "",
      "media-sliderthumb": "",
      "menulist": "",
      "menulist-button": "",
      "menulist-text": "",
      "menulist-textfield": "",
      "none": "",
      "push-button": "",
      "radio": "",
      "searchfield": "",
      "searchfield-cancel-button": "",
      "searchfield-decoration": "",
      "searchfield-results-button": "",
      "searchfield-results-decoration": "",
      "slider-horizontal, slider-vertical": "",
      "sliderthumb-horizontal": "",
      "sliderthumb-vertical": "",
      "square-button": "",
      "textarea": "",
      "textfield": "",
      "scrollbarbutton-down": "Unsupported in Safari 4.0",
      "scrollbarbutton-left": "Unsupported in Safari 4.0",
      "scrollbarbutton-right": "Unsupported in Safari 4.0",
      "scrollbarbutton-up": "Unsupported in Safari 4.0",
      "scrollbargripper-horizontal": "Unsupported in Safari 4.0",
      "scrollbargripper-vertical": "Unsupported in Safari 4.0",
      "scrollbarthumb-horizontal": "Unsupported in Safari 4.0",
      "scrollbarthumb-vertical": "Unsupported in Safari 4.0",
      "scrollbartrack-horizontal": "Unsupported in Safari 4.0",
      "scrollbartrack-vertical": "Unsupported in Safari 4.0"
    }
  },
  "-webkit-backface-visibility": {
    "description": "Determines whether or not a transformed element is visible when it is not facing the screen.",
    "values": {
      "visible": "The element is always visible even when it is not facing the screen.",
      "hidden": "The element is invisible if it is not facing the screen."
    }
  },
  "-webkit-background-clip": {
    "description": "Specifies the clipping behavior of the background of a box.",
    "values": {
      "border": "The background clips to the border of the box.",
      "content": "The background clips to the content of the box.",
      "padding": "The background clips to the padding of the box.",
      "text": "The background clips to the text of the box. Available in Safari 4.0 and later."
    }
  },
  "-webkit-background-composite": {
    "description": "Sets a compositing style for background images and colors.",
    "values": {
      "border": "The background extends into the border area",
      "padding": "The background extends only into the padding area enclosed by the border"
    }
  },
  "-webkit-background-origin": {
    "description": "Determines where the background-position property is anchored.",
    "values": {
    }
  },
  "-webkit-background-size": {
    "description": "Overrides the size of a background image.",
    "values": {
    }
  },
  "-webkit-border-bottom-left-radius": {
    "description": "Specifies that the bottom-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-webkit-border-bottom-right-radius": {
    "description": "Specifies that the bottom-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-webkit-border-horizontal-spacing": {
    "description": "Defines the spacing between the horizontal portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-webkit-border-image": {
    "description": "Specifies an image as the border for a box.",
    "values": {
      "repeat": "The image is tiled.",
      "round": "The image is stretched before it is tiled to prevent partial tiles.",
      "stretch": "The image is stretched to the size of the border."
    }
  },
  "-webkit-border-radius": {
    "description": "Specifies that the corners of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-webkit-border-top-left-radius": {
    "description": "Specifies that the top-left corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-webkit-border-top-right-radius": {
    "description": "Specifies that the top-right corner of a box be rounded with the specified radius.",
    "values": {
    }
  },
  "-webkit-border-vertical-spacing": {
    "description": "Defines the spacing between the vertical portion of an element’s border and the content within.",
    "values": {
    }
  },
  "-webkit-box-align": {
    "description": "Specifies the alignment of nested elements within an outer flexible box element.",
    "values": {
      "baseline": "Elements are aligned with the baseline of the box.",
      "center": "Elements are aligned with the center of the box.",
      "end": "Elements are aligned with the end of the box.",
      "start": "Elements are aligned with the start of the box.",
      "stretch": "Elements are stretched to fill the box."
    }
  },
  "-webkit-box-direction": {
    "description": "Specifies the direction in which child elements of a flexible box element are laid out.",
    "values": {
      "normal": "Elements are laid out in the default direction.",
      "reverse": "Elements are laid out in the reverse direction."
    }
  },
  "-webkit-box-flex": {
    "description": "Specifies an element’s flexibility.",
    "values": {
    }
  },
  "-webkit-box-flex-group": {
    "description": "Specifies groups of dynamically resizing elements that are adjusted to be the same size.",
    "values": {
    }
  },
  "-webkit-box-lines": {
    "description": "Specifies whether a flexible box should contain multiple lines of content.",
    "values": {
      "multiple": "The box can contain multiple lines of content.",
      "single": "The box can contain only one line of content."
    }
  },
  "-webkit-box-ordinal-group": {
    "description": "Specifies a rough ordering of elements in a flexible box.",
    "values": {
    }
  },
  "-webkit-box-orient": {
    "description": "Specifies the layout of elements nested within a flexible box element.",
    "values": {
      "block-axis": "Elements are oriented along the box's axis.",
      "horizontal": "Elements are oriented horizontally.",
      "inline-axis": "Elements are oriented along the inline axis.",
      "vertical": "Elements are oriented vertically."
    }
  },
  "-webkit-box-pack": {
    "description": "Specifies alignment of child elements within the current element in the direction of orientation.",
    "values": {
      "center": "Child elements are aligned to the center of the element.",
      "end": "Child elements are aligned to the end of the element.",
      "justify": "Child elements are justified with both the start and end of the element.",
      "start": "Child elements are aligned to the start of the element."
    }
  },
  "-webkit-box-reflect": {
    "description": "Defines a reflection of a border box.",
    "values": {
      "above": "The reflection appears above the border box.",
      "below": "The reflection appears below the border box.",
      "left": "The reflection appears to the left of the border box.",
      "right": "The reflection appears to the right of the border box."
    }
  },
  "-webkit-box-shadow": {
    "description": "Applies a drop shadow effect to the border box of an object.",
    "values": {
      "none": "The box has no shadow."
    }
  },
  "-webkit-box-sizing": {
    "description": "Specifies that the size of a box be measured according to either its content (default) or its total size including borders.",
    "values": {
      "border-box": "The box size includes borders in addition to content.",
      "content-box": "The box size only includes content."
    }
  },
  "-webkit-column-break-after": {
    "description": "Determines whether a column break can and should occur after an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted after the element.",
      "auto": "A right column break is inserted after the element where appropriate.",
      "avoid": "Column breaks are avoided after the element.",
      "left": "A left column break is inserted after the element.",
      "right": "A right column break is inserted after the element."
    }
  },
  "-webkit-column-break-before": {
    "description": "Determines whether a column break can and should occur before an element in a multicolumn flow layout.",
    "values": {
      "always": "A column break is always inserted before the element.",
      "auto": "A right column break is inserted before the element where appropriate.",
      "avoid": "Column breaks are avoided before the element.",
      "left": "A left column break is inserted before the element.",
      "right": "A right column break is inserted before the element."
    }
  },
  "-webkit-column-break-inside": {
    "description": "Determines whether a column break should be avoided within the bounds of an element in a multicolumn flow layout.",
    "values": {
      "auto": "A right column break is inserted within the element where appropriate.",
      "avoid": "Column breaks are avoided within the element."
    }
  },
  "-webkit-column-count": {
    "description": "Specifies the number of columns desired in a multicolumn flow.",
    "values": {
      "auto": "The element has one column."
    }
  },
  "-webkit-column-gap": {
    "description": "Specifies the space between columns in a multicolumn flow.",
    "values": {
      "normal": "Columns in the element have the normal gap width between them."
    }
  },
  "-webkit-column-rule": {
    "description": "Specifies the color, style, and width of the column rule.",
    "values": {
    }
  },
  "-webkit-column-rule-color": {
    "description": "Specifies the color of the column rule.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-webkit-column-rule-style": {
    "description": "Specifies the style of the column rule.",
    "values": {
      "dashed": "The column rule has a dashed line style.",
      "dotted": "The column rule has a dotted line style.",
      "double": "The column rule has a double solid line style.",
      "groove": "The column rule has a grooved style.",
      "hidden": "The column rule is hidden.",
      "inset": "The column rule has an inset style.",
      "none": "The column rule has no style.",
      "outset": "The column rule has an outset style.",
      "ridge": "The column rule has a ridged style.",
      "solid": "The column rule has a solid line style."
    }
  },
  "-webkit-column-rule-width": {
    "description": "Specifies the width of the column rule.",
    "values": {
      "medium": "The column rule has a medium width.",
      "thick": "The column rule has a thick width.",
      "thin": "The column rule has a thin width."
    }
  },
  "-webkit-column-width": {
    "description": "Specifies the width of the column in a multicolumn flow.",
    "values": {
      "auto": "Columns in the element are of normal width."
    }
  },
  "-webkit-columns": {
    "description": "A composite property that specifies the width and number of columns in a multicolumn flow layout.",
    "values": {
    }
  },
  "-webkit-dashboard-region": {
    "description": "Specifies the behavior of regions in a Dashboard widget.",
    "values": {
      "none": "No behavior is specified."
    }
  },
  "-webkit-line-break": {
    "description": "Specifies line-breaking rules for CJK (Chinese, Japanese, and Korean) text.",
    "values": {
      "after-white-space": "The line breaks after white space.",
      "normal": "A standard line-breaking rule"
    }
  },
  "-webkit-margin-bottom-collapse": {
    "description": "Specifies the behavior of an element’s bottom margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-webkit-margin-collapse": {
    "description": "Specifies the behavior of an element’s vertical margins if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
    }
  },
  "-webkit-margin-start": {
    "description": "Provides the width of the starting margin.",
    "values": {
      "auto": "The margin is automatically determined."
    }
  },
  "-webkit-margin-top-collapse": {
    "description": "Specifies the behavior of an element’s top margin if it is adjacent to an element with a margin. Elements can maintain their respective margins or share a single margin between them.",
    "values": {
      "collapse": "Two adjacent margins are collapsed into a single margin.",
      "discard": "The element’s margin is discarded if it is adjacent to another element with a margin.",
      "separate": "Two adjacent margins remain separate."
    }
  },
  "-webkit-marquee": {
    "description": "Defines properties for showing content as though displayed on an electronic marquee sign.",
    "values": {
    }
  },
  "-webkit-marquee-direction": {
    "description": "Specifies the direction of motion for a marquee box.",
    "values": {
      "ahead": "The marquee moves from bottom to top.",
      "auto": "The marquee moves in the default direction.",
      "backwards": "The marquee moves from right to left.",
      "down": "The marquee moves from bottom to top.",
      "forwards": "The marquee moves from left to right.",
      "left": "The marquee moves from right to left.",
      "reverse": "The marquee moves from top to bottom.",
      "right": "The marquee moves from left to right.",
      "up": "The marquee moves from bottom to top."
    }
  },
  "-webkit-marquee-increment": {
    "description": "Defines the distance the marquee moves in each increment.",
    "values": {
      "large": "The marquee moves a large amount in each increment.",
      "medium": "The marquee moves a medium amount in each increment.",
      "small": "The marquee moves a small amount in each increment."
    }
  },
  "-webkit-marquee-repetition": {
    "description": "Specifies the number of times a marquee box repeats (or infinite).",
    "values": {
      "infinite": "The marquee repeats infinitely."
    }
  },
  "-webkit-marquee-speed": {
    "description": "Defines the scroll or slide speed of a marquee box.",
    "values": {
      "fast": "The marquee moves at a fast speed.",
      "normal": "The marquee moves at a normal speed.",
      "slow": "The marquee moves at a slow speed."
    }
  },
  "-webkit-marquee-style": {
    "description": "Specifies the style of marquee motion.",
    "values": {
      "alternate": "The marquee shifts back and forth.",
      "none": "The marquee does not move.",
      "scroll": "The marquee loops in its specified direction.",
      "slide": "The marquee moves in its specified direction, but stops either when the entirety of its content has been displayed or the content reaches the opposite border of its box, whichever comes second."
    }
  },
  "-webkit-mask": {
    "description": "Defines a variety of mask properties within one declaration.",
    "values": {
    }
  },
  "-webkit-mask-attachment": {
    "description": "Defines the scrolling or fixed nature of the image mask.",
    "values": {
      "fixed": "The mask does not move when the page scrolls.",
      "scroll": "The image moves when the page scrolls."
    }
  },
  "-webkit-mask-box-image": {
    "description": "Defines an image to be used as a mask for a border box.",
    "values": {
    }
  },
  "-webkit-mask-clip": {
    "description": "Specifies whether the mask should extend into the border of a box.",
    "values": {
    }
  },
  "-webkit-mask-composite": {
    "description": "Sets a compositing style for a mask.",
    "values": {
      "border": "The background extends into the border area.",
      "padding": "The background extends only into the padding area enclosed by the border."
    }
  },
  "-webkit-mask-image": {
    "description": "Defines an image to be used as a mask for an element.",
    "values": {
    }
  },
  "-webkit-mask-origin": {
    "description": "Determines where the -webkit-mask-position property is anchored.",
    "values": {
      "border": "The mask's position is anchored at the upper-left corner of the element's border.",
      "content": "The mask's position is anchored at the upper-left corner of the element's content.",
      "padding": "The mask's position is anchored at the upper-left corner of the element's padding."
    }
  },
  "-webkit-mask-position": {
    "description": "Defines the position of a mask.",
    "values": {
    }
  },
  "-webkit-mask-position-x": {
    "description": "Defines the x-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-webkit-mask-position-y": {
    "description": "Defines the y-coordinate of the position of a mask.",
    "values": {
    }
  },
  "-webkit-mask-repeat": {
    "description": "Defines the repeating qualities of a mask.",
    "values": {
    }
  },
  "-webkit-mask-size": {
    "description": "Overrides the size of a mask.",
    "values": {
    }
  },
  "-webkit-nbsp-mode": {
    "description": "Defines the behavior of nonbreaking spaces within text.",
    "values": {
      "normal": "Nonbreaking spaces are treated as usual.",
      "space": "Nonbreaking spaces are treated like standard spaces."
    }
  },
  "-webkit-padding-start": {
    "description": "Provides the width of the starting padding.",
    "values": {
    }
  },
  "-webkit-perspective": {
    "description": "Gives depth to a scene, causing elements farther away from the viewer to appear smaller.",
    "values": {
      "none": "No perspective transform is applied."
    }
  },
  "-webkit-perspective-origin": {
    "description": "Sets the origin of the -webkit-perspective property.",
    "values": {
      "50%": "The default value is 50%.",
      "center": "Sets the x or y origin to the center of the element’s border box. If this constant appears before left or right, specifies the y-origin. If it appears after top or bottom, specifies the x-origin. If appears alone, centers both the x and y origin.",
      "left": "Sets the x-origin to the left side of the border box.",
      "right": "Sets the x-origin to the right side of the border box.",
      "top": "Sets the y-origin to the top of the element’s border box.",
      "bottom": "Sets the y-origin to the bottom of the element’s border box."
    }
  },
  "-webkit-rtl-ordering": {
    "description": "Overrides ordering defaults for right-to-left content.",
    "values": {
      "logical": "Raw content is in mixed order (requiring a bidirectional renderer).",
      "visual": "Right-to-left content is encoded in reverse order so an entire line of text can be rendered from left to right in a unidirectional fashion."
    }
  },
  "-webkit-tap-highlight-color": {
    "description": "Overrides the highlight color shown when the user taps a link or a JavaScript clickable element in Safari on iPhone.",
    "values": {
    }
  },
  "-webkit-text-fill-color": {
    "description": "Specifies a fill color for text.",
    "values": {
      "currentcolor": "The value of the element’s color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-webkit-text-security": {
    "description": "Specifies the shape to use in place of letters in a password input field.",
    "values": {
      "circle": "A circle shape.",
      "disc": "A disc shape.",
      "none": "No shape is used.",
      "square": "A square shape."
    }
  },
  "-webkit-text-size-adjust": {
    "description": "Specifies a size adjustment for displaying text content in Safari on iPhone.",
    "values": {
      "none": "The text size is not adjusted.",
      "auto": "The text size is automatically adjusted for Safari on iPhone."
    }
  },
  "-webkit-text-stroke": {
    "description": "Specifies the width and color of the outline (stroke) of text.",
    "values": {
    }
  },
  "-webkit-text-stroke-color": {
    "description": "Specifies the color of the outline (stroke) of text.",
    "values": {
      "currentcolor": "The value of the element's color property.",
      "-webkit-activelink": "The default color of a hyperlink that is being clicked.",
      "-webkit-focus-ring-color": "The color that surrounds a UI element, such as a text field, that has focus.",
      "-webkit-link": "The default color of a hyperlink that has been visited.",
      "-webkit-text": "The default text color."
    }
  },
  "-webkit-text-stroke-width": {
    "description": "Specifies the width for the text outline.",
    "values": {
      "medium": "A medium stroke.",
      "thick": "A thick stroke.",
      "thin": "A thin stroke."
    }
  },
  "-webkit-touch-callout": {
    "description": "Disables the default callout shown when you touch and hold a touch target.",
    "values": {
      "default": "Restore the default callout.",
      "none": "The callout is disabled.",
      "inherit": ""
    }
  },
  "-webkit-transform": {
    "description": "Specifies transformations to be applied to an element.",
    "values": {
      "none": "No transforms are applied."
    }
  },
  "-webkit-transform-origin": {
    "description": "Sets the origin for the -webkit-transform property.",
    "values": {
    }
  },
  "-webkit-transform-origin-x": {
    "description": "The x coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-webkit-transform-origin-y": {
    "description": "The y coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-webkit-transform-origin-z": {
    "description": "The z coordinate of the origin for transforms applied to an element with respect to its border box.",
    "values": {
    }
  },
  "-webkit-transform-style": {
    "description": "Defines how nested, transformed elements are rendered in 3D space.",
    "values": {
      "flat": "Flatten all children of this element into the 2D plane.",
      "preserve-3d": "Preserve the 3D perspective."
    }
  },
  "-webkit-transition": {
    "description": "Combines -webkit-transition-delay, -webkit-transition-duration, -webkit-transition-property, and -webkit-transition-timing-function into a single property.",
    "values": {
    }
  },
  "-webkit-transition-delay": {
    "description": "Defines when the transition starts.",
    "values": {
      "now": "The transition begins immediately. Available in iPhone OS 2.0 and later."
    }
  },
  "-webkit-transition-duration": {
    "description": "Defines how long the transition from the old value to the new value should take.",
    "values": {
    }
  },
  "-webkit-transition-property": {
    "description": "Specifies the name of the CSS property to which the transition is applied.",
    "values": {
      "none": "No transition specified.",
      "all": "The default transition name."
    }
  },
  "-webkit-transition-timing-function": {
    "description": "Specifies how the intermediate values used during a transition are calculated.",
    "values": {
      "ease": "Equivalent to cubic-bezier(0.25, 0.1, 0.25, 1.0)",
      "linear": "Equivalent to cubic-bezier(0.0, 0.0, 1.0, 1.0)",
      "ease-in": "Equivalent to cubic-bezier(0.42, 0, 1.0, 1.0)",
      "ease-out": "Equivalent to cubic-bezier(0, 0, 0.58, 1.0)",
      "ease-in-out": "Equivalent to cubic-bezier(0.42, 0, 0.58, 1.0)"
    }
  },
  "-webkit-user-drag": {
    "description": "Specifies that an entire element should be draggable instead of its contents.",
    "values": {
      "auto": "The default dragging behavior is used.",
      "element": "The entire element is draggable instead of its contents.",
      "none": "The element cannot be dragged at all."
    }
  },
  "-webkit-user-modify": {
    "description": "Determines whether a user can edit the content of an element.",
    "values": {
      "read-only": "The content is read-only.",
      "read-write": "The content can be read and written.",
      "read-write-plaintext-only": "The content can be read and written, but any rich formatting of pasted text is lost."
    }
  },
  "-webkit-user-select": {
    "description": "Determines whether a user can select the content of an element.",
    "values": {
      "auto": "The user can select content in the element.",
      "none": "The user cannot select any content.",
      "text": "The user can select text in the element."
    }
  },
  "alignment-adjust": {
    "description": "Setting the alignment point.",
    "values": {
      "auto": "For each glyph corresponding to textual information within the element, the alignment-point is the intersection of the start-edge of the glyph box and the block-progression-direction position of the alignment point from the font. Padding, border or margin do not affect that alignment point. The alignment point of the inline-level element itself is at the intersection of the start-edge of the first inline box and the baseline identified by the alignment-baseline property if this baseline exists in the baseline-table for the element dominant-baseline. If that specific baseline does not exist, the user agent may use heuristics to determine where that missing baseline would be. For other inline box content like images, the user agent will use heuristics to determine the position of the alignment point. For example when the resulting baseline is alphabetic or ideographic, it is expected that the alignment point will be at the intersection of the start-edge and the after-edge of the inline box, including its respective margin. If the resulting baseline is hanging, the intersection of the start-edge and the before-edge of the inline box, including its respective margin should be used instead. \n                         When the alignment-baseline property is set to either after-edge or before-edge, the auto value is equivalent to after-edge or before-edge respectively.",
      "baseline": "The alignment point is at the intersection of the start-edge of the element and the dominant-baseline of the element.",
      "before-edge": "The alignment point is at the intersection of the start-edge of the element and the before-edge of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.",
      "text-before-edge": "The alignment point is at the intersection of the start-edge of the element and the text-before-edge baseline of the element.",
      "central": "The alignment point is at the intersection of the start-edge of the element and the central baseline of the element.",
      "middle": "The alignment point is at the intersection of the start-edge of the element and the middle baseline of the element.",
      "after-edge": "The alignment point is at the intersection of the start-edge of the element and the after-edge of the extended inline box of the element. This may include or not the line-height of the element, depending on the line-stacking-strategy.",
      "text-after-edge": "The alignment point is at the intersection of the start-edge of the element and the text-after-edge baseline of the element.",
      "ideographic": "The alignment point is at the intersection of the start-edge of the element and the ideographic baseline of the element.",
      "alphabetic": "The alignment point is at the intersection of the start-edge of the element and the alphabetic baseline of the element.",
      "hanging": "The alignment point is at the intersection of the start-edge of the element and the hanging baseline of the element.",
      "mathematical": "The alignment point is at the intersection of the start-edge of the element and the mathematical baseline of the element."
    }
  },
  "alignment-baseline": {
    "description": "Aligning the alignment point of an element.",
    "values": {
      "baseline": "The alignment-point of the element being aligned is aligned with the dominant baseline of the parent.",
      "use-script": "If the element script property value is auto, the alignment point of each glyph is aligned with the baseline-identifier of the script to which the glyph belongs. If the element script property value is other than auto, the alignment point of each glyph is aligned with the baseline-identifier specified by the script property. The baseline-identifier position is determined by using the relevant information related to the parent element dominant-baseline set. The alignment point of the element itself is aligned as for the baseline value.",
      "before-edge": "The alignment point of the box is aligned with the before-edge baseline of the line box.",
      "text-before-edge": "The alignment-point of the element being aligned is aligned with the text-before-edge baseline of the parent.",
      "after-edge": "The alignment point of the box is aligned with the after-edge baseline of the line box.",
      "text-after-edge": "The alignment-point of the element being aligned is aligned with the text-after-edge baseline of the parent.",
      "central": "The alignment point of the box is aligned with the central baseline of the parent.",
      "middle": "The alignment point of the box is aligned with the middle baseline of the parent.",
      "ideographic": "The alignment-point of the element being aligned is aligned with the ideographic baseline of the parent.",
      "alphabetic": "The alignment-point of the element being aligned is aligned with the lower baseline of the parent.",
      "hanging": "The alignment-point of the element being aligned is aligned with the hanging baseline of the parent.",
      "mathematical": "The alignment-point of the element being aligned is aligned with the mathematical baseline of the parent."
    }
  },
  "appearance": {
    "description": "Standard user interface appearance.",
    "values": {
      "normal": "",
      "icon": "A small picture representing an object, often with a name or label.",
      "desktop": "A window used to represent a system as a whole that often contains other windows.",
      "workspace": "A window used to represent a project or application that may contain other windows, typically with a titlebar that shows the name of the project or application.",
      "document": "A window used to represent a user document, typically with a titlebar that shows its name. May also be used to represent folders or directories in a file system.",
      "tooltip": "A window that is used to temporarily display information or help about an object. Also called \"info\" in the CSS2 system colors.",
      "dialog": "A window used to present a notification or alternatives for the user to choose as part of an action taken by the user. Also called \"message-box\" in the CSS2 system fonts.",
      "push-button": "A button that has a border surrounding it, often beveled to appear three dimensional, as if it is raised. Also called \"caption\" in CSS2 system fonts.",
      "hyperlink": "A button that represents a hypertext link, often as simple as normal text that is underlined and perhaps colored differently.",
      "radio-button": "A button that displays whether or not it is checked with a small circle next to the button label. There may be a disc inside the circle when the button is checked. An indeterminate (neither checked nor unchecked) state may be indicated with some other graphic in the circle.",
      "checkbox": "A button that displays whether or not it is checked with a small box next to the button label. There may be an x or check mark inside the box when the button is checked. An indeterminate (neither checked nor unchecked) state may be indicated with a dash - or a square or some other graphic in the box.",
      "menu-item": "A choice within a menu, which may also act as a label for a nested (hierarchical) menu.",
      "tab": "A button representing the label for a pane in a tabbed interface.",
      "menubar": "A menu of menus, typically arranged linearly, in a horizontal bar.",
      "pull-down-menu": "A menu where the name of the menu is displayed and the options remain hidden until the user activates the menu. When the user releases or deactivates the menu, the options are hidden again.",
      "pop-up-menu": "A menu where all but the currently selected option remains hidden until the user activates the menu. When the user releases or deactivates the menu, all but the selected option are hidden again.",
      "list-menu": "A list of options for the user to choose from, perhaps more than one at a time.",
      "radio-group": "A menu where the options are displayed as radio-buttons.",
      "checkbox-group": "A menu where the options are displayed as checkboxes.",
      "outline-tree": "A menu where the options can be shown or hidden with small widgets, often represented by a small triangle or plus and minus signs.",
      "range": "A control that displays the current option, perhaps graphically and allows the user to select other options, perhaps by dragging a slider or turning a knob.",
      "combo-box": "A field which is accompanied by a menu of preset values that can be used to quickly enter common or typical values.",
      "signature": "A field for entering a signature.",
      "password": "A field for entering a password. Typically the text is rendered as a set of bullets or boxes to obscure the value."
    }
  },
  "azimuth": {
    "description": "Audio direction.",
    "values": {
      "left-side": "Same as 270deg. With behind, 270deg.",
      "far-left": "Same as 300deg. With behind, 240deg.",
      "left": "Same as 320deg. With behind, 220deg.",
      "center-left": "Same as 340deg. With behind, 200deg.",
      "center": "Same as 0deg. With behind, 180deg.",
      "center-right": "Same as 20deg. With behind, 160deg.",
      "right": "Same as 40deg. With behind, 140deg.",
      "far-right": "Same as 60deg. With behind, 120deg.",
      "right-side": "Same as 90deg. With behind, 90deg.",
      "leftwards": "Moves the sound to the left, relative to the current angle. More precisely, subtracts 20 degrees. Arithmetic is carried out modulo 360 degrees. Note that leftwards is more accurately described as \"turned counter-clockwise,\" since it always subtracts 20 degrees, even if the inherited azimuth is already behind the listener (in which case the sound actually appears to move to the right).",
      "rightwards": "Moves the sound to the right, relative to the current angle. More precisely, adds 20 degrees. See leftwards for arithmetic."
    }
  },
  "background": {
    "description": "The background property is a shorthand property for setting most background properties.",
    "values": {
      "transparent": "",
      "none": "",
      "repeat": "The image is repeated both horizontally and vertically.",
      "repeat-x": "The image is repeated horizontally only.",
      "repeat-y": "The image is repeated vertically only.",
      "no-repeat": "The image is not repeated: only one copy of the image is drawn.",
      "scroll": "",
      "fixed": ""
    }
  },
  "background-attachment": {
    "description": "If background images are specified, this property specifies whether they are fixed with regard to the viewport or scroll along with the element or its contents.",
    "values": {
      "fixed": "The background is fixed with regard to the viewport. In paged media where there is no viewport, a ‘fixed’ background is fixed with respect to the page box and therefore replicated on every page. Note that there is only one viewport per view. Even if an element has a scrolling mechanism (see the overflow property), a fixed background doesn't move with the element.",
      "local": "The background is fixed with regard to the element's contents: if the element has a scrolling mechanism, the background scrolls with the element's contents. In this case, the background behind the element's border (if any) scrolls as well, even though the border itself does not scroll with the contents. The UA may, however, treat the border-box value of background-clip as padding-box in cases where background-attachment is local and the contents of the element scroll.",
      "scroll": "The background is fixed with regard to the element itself and does not scroll with its contents. (It is effectively attached to the element's border.)"
    }
  },
  "background-clip": {
    "description": "Determines the background painting area.",
    "values": {
      "padding-box": "The background is painted within (clipped to) the padding box.",
      "border-box": "The background is painted within (clipped to) the border box.",
      "content-box": "The background is painted within (clipped to) the content box."
    }
  },
  "background-color": {
    "description": "This property sets the background color of an element. The color is drawn behind any background images.",
    "values": {
      "transparent": "The background is transparent."
    }
  },
  "background-image": {
    "description": "This property sets the background image(s) of an element.",
    "values": {
      "none": "No image."
    }
  },
  "background-origin": {
    "description": "Specifies the background positioning area.",
    "values": {
      "padding-box": "The position is relative to the padding box. (For single boxes 0 0 is the upper left corner of the padding edge, 100% 100% is the lower right corner.)",
      "border-box": "The position is relative to the border box.",
      "content-box": "The position is relative to the content box."
    }
  },
  "background-position": {
    "description": "Background image position.",
    "values": {
      "top": "Equivalent to 0% for the vertical position if one or two values are given, otherwise specifies the top edge as the origin for the next offset.",
      "right": "Equivalent to 100% for the horizontal position if one or two values are given, otherwise specifies the right edge as the origin for the next offset.",
      "bottom": "Equivalent to 100% for the vertical position if one or two values are given, otherwise specifies the bottom edge as the origin for the next offset.",
      "left": "Equivalent to 0% for the horizontal position if one or two values are given, otherwise specifies the left edge as the origin for the next offset.",
      "center": "Equivalent to 50% (left 50%) for the horizontal position if the horizontal position is not otherwise specified, or 50% (top 50%) for the vertical position if it is."
    }
  },
  "background-repeat": {
    "description": "Background repeat type.",
    "values": {
      "repeat-x": "Equivalent to repeat no-repeat.",
      "repeat-y": "Equivalent to no-repeat repeat.",
      "repeat": "The image is repeated in this direction as often as needed to cover the background painting area.",
      "space": "The image is repeated as often as will fit within the background positioning area without being clipped and then the images are spaced out to fill the area. The first and last images touch the edges of the area. If the background painting area is larger than the background positioning area, then the pattern repeats to fill the background painting area. The value of background-position for this direction is ignored, unless there is not enough space for two copies of the image in this direction, in which case only one image is placed and background-position determines its position in this direction.",
      "round": "The image is repeated as often as will fit within the background positioning area. If it doesn't fit a whole number of times, it is rescaled so that it does. See the formula under background-size. If the background painting area is larger than the background positioning area, then the pattern repeats to fill the background painting area.",
      "no-repeat": "The image is placed once and not repeated in this direction."
    }
  },
  "background-size": {
    "description": "Specifies the size of the background images.",
    "values": {
      "auto": "An auto value for one dimension is resolved by using the image's intrinsic ratio and the size of the other dimension, or failing that, using the image's intrinsic size, or failing that, treating it as 100%.",
      "cover": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the smallest size such that both its width and its height can completely cover the background positioning area.",
      "contain": "Scale the image, while preserving its intrinsic aspect ratio (if any), to the largest size such that both its width and its height can fit inside the background positioning area."
    }
  },
  "baseline-shift": {
    "description": "Repositioning the dominant baseline.",
    "values": {
      "baseline": "There is no baseline shift; the dominant baseline remains in its original position.",
      "sub": "The dominant baseline is shifted to the default position for subscripts. The offset for this position is determined by the font data for the parent nominal font as adjusted by the dominant baseline-table font-size of the parent element. If there is no applicable font data the User Agent may use heuristic to determine the offset.",
      "super": "The dominant baseline is shifted to the default position for superscripts. The offset for this position is determined by the font data for the parent nominal font as adjusted by the dominant baseline-table font-size of the parent element. If there is no applicable font data the User Agent may use heuristic to determine the offset."
    }
  },
  "bookmark-label": {
    "description": "The label of the bookmark",
    "values": {
    }
  },
  "bookmark-level": {
    "description": "The level of the bookmark",
    "values": {
    }
  },
  "bookmark-target": {
    "description": "This property specifies the target of the bookmark link",
    "values": {
    }
  },
  "border": {
    "description": "Shorthand property for setting the same width, color, and style for all four borders of a box.",
    "values": {
      "thin": "",
      "medium": "",
      "thick": "",
      "none": "No border. Color and width are ignored (i.e., the border has width 0, unless the border is an image, see background-image).",
      "hidden": "Same as none, but has different behavior in the border conflict resolution rules for border-collapsed tables.",
      "dotted": "A series of round dots.",
      "dashed": "A series of square-ended dashes.",
      "solid": "A single line segment.",
      "double": "Two parallel solid lines with some space between them. The thickness of the lines is not specified, but the sum of the lines and the space must equal border-width.",
      "groove": "Looks as if it were carved in the canvas. This is typically achieved by creating a “shadow” from two colors that are slightly lighter and darker than the border-color.",
      "ridge": "Looks as if it were coming out of the canvas.",
      "inset": "Looks as if the content on the inside of the border is sunken into the canvas. Treated as ridge in border-collapsed tables.",
      "outset": "Looks as if the content on the inside of the border is coming out of the canvas. Treated as groove in border-collapsed tables."
    }
  },
  "border-bottom": {
    "description": "Shorthand property for setting the width, style, and color of the bottom border",
    "values": {
    }
  },
  "border-bottom-color": {
    "description": "The foreground color of the bottom border",
    "values": {
    }
  },
  "border-bottom-left-radius": {
    "description": "The bottom left border radius",
    "values": {
    }
  },
  "border-bottom-right-radius": {
    "description": "The bottom right border radius",
    "values": {
    }
  },
  "border-bottom-style": {
    "description": "The style of the bottom border",
    "values": {
    }
  },
  "border-bottom-width": {
    "description": "The thickness of the bottom border",
    "values": {
    }
  },
  "border-clip": {
    "description": "",
    "values": {
    }
  },
  "border-collapse": {
    "description": "Table border model",
    "values": {
    }
  },
  "border-color": {
    "description": "The foreground color of the border",
    "values": {
    }
  },
  "border-image": {
    "description": "",
    "values": {
    }
  },
  "border-left": {
    "description": "Shorthand property for setting the width, style, and color of the left border",
    "values": {
    }
  },
  "border-left-color": {
    "description": "The foreground color of the left border",
    "values": {
    }
  },
  "border-left-style": {
    "description": "The style of the left border",
    "values": {
    }
  },
  "border-left-width": {
    "description": "The thickness of the left border",
    "values": {
    }
  },
  "border-radius": {
    "description": "The border radius.",
    "values": {
    }
  },
  "border-right": {
    "description": "Shorthand property for setting the width, style, and color of the right border",
    "values": {
    }
  },
  "border-right-color": {
    "description": "The foreground color of the right border",
    "values": {
    }
  },
  "border-right-style": {
    "description": "The style of the right border",
    "values": {
    }
  },
  "border-right-width": {
    "description": "The thickness of the right border",
    "values": {
    }
  },
  "border-spacing": {
    "description": "The distance that separates adjoining cell borders.",
    "values": {
    }
  },
  "border-style": {
    "description": "The style of the border",
    "values": {
    }
  },
  "border-top": {
    "description": "Shorthand property for setting the width, style, and color of the top border",
    "values": {
    }
  },
  "border-top-color": {
    "description": "The foreground color of the top border",
    "values": {
    }
  },
  "border-top-left-radius": {
    "description": "The top left border radius",
    "values": {
    }
  },
  "border-top-right-radius": {
    "description": "The top right border radius",
    "values": {
    }
  },
  "border-top-style": {
    "description": "The style of the top border",
    "values": {
    }
  },
  "border-top-width": {
    "description": "The thickness of the top border",
    "values": {
    }
  },
  "border-width": {
    "description": "",
    "values": {
    }
  },
  "bottom": {
    "description": "Absolute position from the bottom edge of the containing block.",
    "values": {
      "auto": "For non-replaced elements, the effect of this value depends on which of related properties have the value auto as well."
    }
  },
  "box-decoration-break": {
    "description": "Behavior when a box is broken at a page break.",
    "values": {
      "slice": "No border and no padding are inserted at the break. border-radius has no effect at its corners; and the border-image is rendered for the whole box as if it were unbroken. The effect is as though the element were rendered with no break present, and then sliced by the break afterward. \n                         Backgrounds are drawn as if, after the element has been laid out (including any justification, bidi reordering, page breaks, etc.), all the element's boxes are taken and put one after the other in visual order. The background is applied to the bounding box of this composite box and then the boxes are put back, with their share of the background. \n                         For boxes broken across lines, first boxes on the same line are connected in visual order. Then boxes on subsequent lines are ordered according to the element's inline progression direction and aligned on the baseline. For example in a left-to-right containing block (‘direction’ is ‘ltr’), the first box is the leftmost box on the first line and boxes from subsequent lines are put to the right of it. In a right-to-left containing block, the first box is the rightmost on the first line and subsequent boxes are put to the left of it. \n                         For boxes broken across columns, the columns are treated as one continuous element, as if the column boxes were glued together in the block progression direction of the multi-column element. For boxes broken across pages, the page content areas are glued together in the block progression direction of the root element. In these cases, if the pieces have different widths (heights, if the root element / multi-column element is in vertical text mode), then each piece draws its background assuming that the whole element has the same width (height) as this piece. This ensures that right-aligned images stay aligned to the right edge, left-aligned images stay aligned to the left edge, and centered images stay centered.",
      "clone": "Each box is independently wrapped with the border and padding. The border-radius and border-image are applied to each box independently. The background is drawn independently in each box of the element. A no-repeat background image will thus be rendered once in each box of the element."
    }
  },
  "box-shadow": {
    "description": "Attaches one or more drop-shadows to the box.",
    "values": {
      "none": "",
      "inset": "The inset keyword, if present, changes the drop shadow from an outer shadow (one that shadows the box onto the canvas, as if it were lifted above the canvas) to an inner shadow (one that shadows the canvas onto the box, as if the box were cut out of the canvas and shifted behind it)."
    }
  },
  "caption-side": {
    "description": "Specifies the position of the caption box with respect to the table box",
    "values": {
    }
  },
  "clear": {
    "description": "This property indicates which sides of an element's box(es) may not be adjacent to an earlier floating box.",
    "values": {
      "none": "No constraint on the box's position with respect to floats.",
      "left": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any left-floating boxes that resulted from elements earlier in the source document.",
      "right": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating boxes that resulted from elements earlier in the source document.",
      "both": "The clearance of the generated box is set to the amount necessary to place the top border edge below the bottom outer edge of any right-floating and left-floating boxes that resulted from elements earlier in the source document."
    }
  },
  "clip": {
    "description": "Element clipping",
    "values": {
    }
  },
  "color": {
    "description": "Text color.",
    "values": {
    }
  },
  "column-count": {
    "description": "The number of columns of a multicol element",
    "values": {
    }
  },
  "column-fill": {
    "description": "Strategy for filling columns.",
    "values": {
      "auto": "Fills columns sequentially.",
      "balance": "Balance content equally between columns, if possible."
    }
  },
  "column-gap": {
    "description": "The gap between columns",
    "values": {
    }
  },
  "column-rule": {
    "description": "Shorthand for setting column-rule-width, column-rule-style, and column-rule-color at the same place",
    "values": {
    }
  },
  "column-rule-color": {
    "description": "The color of the column rule",
    "values": {
    }
  },
  "column-rule-style": {
    "description": "The style of the rule between columns of an element",
    "values": {
    }
  },
  "column-rule-width": {
    "description": "The width of the rule between columns",
    "values": {
    }
  },
  "column-span": {
    "description": "Describes how many columns an element spans across",
    "values": {
    }
  },
  "column-width": {
    "description": "The width of columns in multicol elements",
    "values": {
    }
  },
  "columns": {
    "description": "Shorthand property for setting column-width and column-count",
    "values": {
    }
  },
  "content": {
    "description": "Dictates what is rendered inside the element or pseudo-element.",
    "values": {
      "normal": "For an element, this computes to contents. \n                         For ::alternate, if the superior parent uses the footnote, endnote, or section-note counter in its content property then the computed value of content is contents, otherwise it computes to inhibit. \n                         For ::before, ::after, and ::line-marker this computes to inhibit. \n                         For ::marker, if the superior parent's superior parent uses footnote in its content property then normal computes to the computed value of the list-style-image property if the list-style-image is not none, otherwise counter(footnote, &lt;list-style-type&gt;) \"suffix\" where &lt;list-style-type&gt; is the computed value of the list-style-type property if that property is not none and suffix is the suffix appropriate for that list style type, otherwise inhibit. \n                         For ::marker, if the superior parent's superior parent uses endnote in its content property then normal computes to the computed value of the list-style-image property if the list-style-image is not none, otherwise counter(endnote, &lt;list-style-type&gt;) \"suffix\" where &lt;list-style-type&gt; is the computed value of the list-style-type property if that property is not none and suffix is the suffix appropriate for that list style type, otherwise inhibit. \n                         For ::marker, if the superior parent's superior parent uses section-note in its content property then normal computes to the computed value of the list-style-image property if the list-style-image is not none, otherwise counter(section-note, &lt;list-style-type&gt;) \"suffix\" where &lt;list-style-type&gt; is the computed value of the list-style-type property if that property is not none and suffix is the suffix appropriate for that list style type, otherwise inhibit. \n                         Otherwise, for ::marker, if the computed value of display for the superior parent is list-item then normal computes to the computed value of the list-style-image property if the list-style-image is not none, otherwise counter(list-item, &lt;list-style-type&gt;) \"suffix\" where &lt;list-style-type&gt; is the computed value of the list-style-type property if that property is not none and suffix is the suffix appropriate for that list style type, otherwise inhibit. \n                         For the @footnote area, it computes to pending(footnote). \n                         For margin areas, it computes to none.",
      "none": "On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. \n                         On pseudo-elements it causes the pseudo-element to have no content. \n                         In neither case does it prevent any pseudo-elements which have this element or pseudo-element as a superior from being generated.",
      "inhibit": "On elements, this inhibits the children of the element from being rendered as children of this element, as if the element was empty. \n                         On pseudo-elements, this inhibits the creation of the pseudo-element, as if display computed to none. \n                         In both cases, this further inhibits the creation of any pseudo-elements which have this pseudo-element as a superior.",
      "contents": "The element's descendents. Since this can only be used once per element (you can't duplicate the children if, e.g., one is a plugin or form control) \n                                     Note that while it is useless to include contents twice in a single content property, that is not a parse error. The second occurrence simply has no effect, as it has already been used. It is also not a parse error to use it on a marker pseudo-element, it is only during the rendering stage that it gets treated like none.",
      "footnote": "Shorthand for counter(footnote, normal). This is intended to be used on the in-flow part of a footnote.",
      "endnote": "Shorthand for counter(endnote, normal). This is intended to be used on the in-flow part of a endnote.",
      "section-note": "Shorthand for counter(section-note, normal). This is intended to be used on the in-flow part of a section-note.",
      "list-item": "Shorthand for counter(list-item, normal). Note that this is not equivalent to normal when set on a ::marker pseudo-element that has a superior with display set to list-item, as it ignores the list-style properties.",
      "open-quote": "These values are replaced by the appropriate string from the quotes property.",
      "close-quote": "These values are replaced by the appropriate string from the quotes property.",
      "no-open-quote": "Inserts nothing (as in none), but increments (decrements) the level of nesting for quotes.",
      "no-close-quote": "Inserts nothing (as in none), but increments (decrements) the level of nesting for quotes.",
      "document-url": "The URI of the current document. For local files, this may simply be the local file name."
    }
  },
  "counter-increment": {
    "description": "",
    "values": {
    }
  },
  "counter-reset": {
    "description": "",
    "values": {
    }
  },
  "crop": {
    "description": "",
    "values": {
    }
  },
  "cue": {
    "description": "",
    "values": {
    }
  },
  "cue-after": {
    "description": "",
    "values": {
    }
  },
  "cue-before": {
    "description": "",
    "values": {
    }
  },
  "cursor": {
    "description": "The type of cursor to be displayed for the pointing device",
    "values": {
      "alias": "Indicates an alias of/shortcut to something is to be created. Often rendered as an arrow with a small curved arrow next to it.",
      "all-scroll": "Indicates that the something can be scrolled in any direction. Often rendered as arrows pointing up, down, left, and right with a dot in the middle.",
      "auto": "The UA determines the cursor to display based on the current context.",
      "cell": "Indicates that a cell or set of cells may be selected. Often rendered as a thick plus-sign with a dot in the middle.",
      "context-menu": "A context menu is available for the object under the cursor. Often rendered as an arrow with a small menu-like graphic next to it.",
      "copy": "Indicates something is to be copied. Often rendered as an arrow with a small plus sign next to it.",
      "col-resize": "Indicates that the item/column can be resized horizontally. Often rendered as arrows pointing left and right with a vertical bar separating them.",
      "crosshair": "A simple crosshair (e.g., short line segments resembling a \"+\" sign). Often used to indicate a two dimensional bitmap selection mode.",
      "default": "The platform-dependent default cursor. Often rendered as an arrow.",
      "help": "Help is available for the object under the cursor. Often rendered as a question mark or a balloon.",
      "move": "Indicates something is to be moved.",
      "no-drop": "Indicates that the dragged item cannot be dropped at the current cursor location. Often rendered as a hand or pointer with a small circle with a line through it.",
      "none": "No cursor is rendered for the element.",
      "not-allowed": "Indicates that the requested action will not be carried out. Often rendered as a circle with a line through it.",
      "pointer": "The cursor is a pointer that indicates a link.",
      "progress": "A progress indicator. The program is performing some processing, but is different from wait in that the user may still interact with the program. Often rendered as a spinning beach ball, or an arrow with a watch or hourglass.",
      "row-resize": "Indicates that the item/row can be resized vertically. Often rendered as arrows pointing up and down with a horizontal bar separating them.",
      "text": "Indicates text that may be selected. Often rendered as a vertical I-beam. User agents may automatically display a horizontal I-beam/cursor (e.g. same as the vertical-text keyword) for vertical text, or for that matter, any angle of I-beam/cursor for text that is rendered at any particular angle.",
      "vertical-text": "Indicates vertical-text that may be selected. Often rendered as a horizontal I-beam.",
      "wait": "Indicates that the program is busy and the user should wait. Often rendered as a watch or hourglass.",
      "n-resize": "Indicates that the north edge is to be moved.",
      "w-resize": "Indicates that the west edge is to be moved.",
      "s-resize": "Indicates that the south edge is to be moved.",
      "e-resize": "Indicates that the east edge is to be moved.",
      "nw-resize": "Indicates that the north-west corner is to be moved.",
      "ne-resize": "Indicates that the north-east corner is to be moved.",
      "sw-resize": "Indicates that the south-west corner is to be moved.",
      "se-resize": "Indicates that the south-east corner is to be moved.",
      "ew-resize": "Indicates a bidirectional resize cursor.",
      "ns-resize": "Indicates a bidirectional resize cursor.",
      "nesw-resize": "Indicates a bidirectional resize cursor.",
      "nwse-resize": "Indicates a bidirectional resize cursor."
    }
  },
  "direction": {
    "description": "",
    "values": {
    }
  },
  "display": {
    "description": "The type of box for an element.",
    "values": {
      "inline": "Inline boxes.",
      "block": "Block boxes.",
      "inline-block": "A block box, which itself is flowed as a single inline box, similar to a replaced element. The inside of an inline-block is formatted as a block box, and the box itself is formatted as an inline box.",
      "list-item": "One or more block boxes and one marker box. Marker boxes are defined in the Lists module (http://www.w3.org/TR/css3-lists/)",
      "run-in": "Either block or inline boxes, depending on context (see (http://www.w3.org/TR/css3-box/#run-in-boxes)).",
      "compact": "Either block boxes or a marker box, depending on context (see (http://www.w3.org/TR/css3-box/#compact-boxes)). Properties apply to compact boxes based on their final status.",
      "table": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "inline-table": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-row-group": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-header-group": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-footer-group": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-row": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-column-group": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-column": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-cell": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "table-caption": "See the Tables module (http://www.w3.org/TR/css3-box/#CSS3TBL).",
      "ruby": "See the Ruby module (http://www.w3.org/TR/css3-ruby/).",
      "ruby-base": "See the Ruby module (http://www.w3.org/TR/css3-ruby/).",
      "ruby-text": "See the Ruby module (http://www.w3.org/TR/css3-ruby/).",
      "ruby-base-group": "See the Ruby module (http://www.w3.org/TR/css3-ruby/).",
      "ruby-text-group": "See the Ruby module (http://www.w3.org/TR/css3-ruby/).",
      "none": "This value causes an element to generate no boxes (i.e., the element has no effect on layout). Descendant elements do not generate any boxes either; this behavior cannot be overridden by setting the display property on the descendants."
    }
  },
  "dominant-baseline": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-after-adjust": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-after-align": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-before-adjust": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-before-align": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-size": {
    "description": "",
    "values": {
    }
  },
  "drop-initial-value": {
    "description": "",
    "values": {
    }
  },
  "elevation": {
    "description": "",
    "values": {
    }
  },
  "empty-cells": {
    "description": "",
    "values": {
    }
  },
  "fit": {
    "description": "",
    "values": {
    }
  },
  "fit-position": {
    "description": "",
    "values": {
    }
  },
  "float": {
    "description": "This property specifies whether a box should float to the left, right, or not at all.",
    "values": {
      "none": "The box is not floated.",
      "left": "The element generates a block box that is floated to the left. Content flows on the right side of the box, starting at the top (subject to the clear property).",
      "right": "Similar to left, except the box is floated to the right, and content flows on the left side of the box, starting at the top."
    }
  },
  "float-offset": {
    "description": "This property pushes a float in opposite direction of the where it has been floated.",
    "values": {
    }
  },
  "font": {
    "description": "Shorthand property for font settings.",
    "values": {
      "normal": "",
      "small-caps": "",
      "caption": "The font used for captioned controls (e.g., buttons, drop-downs, etc.).",
      "icon": "The font used to label icons.",
      "menu": "The font used in menus (e.g., dropdown menus and menu lists).",
      "message-box": "The font used in dialog boxes.",
      "small-caption": "The font used for labeling small controls.",
      "status-bar": "The font used in window status bars."
    }
  },
  "font-family": {
    "description": "This property specifies a prioritized list of font family names or generic family names.",
    "values": {
      "serif": "Glyphs of serif fonts, as the term is used in CSS, have finishing strokes, flared or tapering ends, or have actual serifed endings (including slab serifs). Serif fonts are typically proportionately-spaced. They often display a greater variation between thick and thin strokes than fonts from the sans-serif generic font family. CSS uses the term ‘serif’ to apply to a font for any script, although other names may be more familiar for particular scripts, such as Mincho (Japanese), Sung, Song or Kai (Chinese), Batang (Korean). Any font that is so described may be used to represent the generic serif family.",
      "sans-serif": "Glyphs in sans-serif fonts, as the term is used in CSS, have stroke endings that are plain -- without any flaring, cross stroke, or other ornamentation. Sans-serif fonts are typically proportionately-spaced. They often have little variation between thick and thin strokes, compared to fonts from the serif family. CSS uses the term sans-serif to apply to a font for any script, although other names may be more familiar for particular scripts, such as Gothic (Japanese), Hei (Chinese), or Gulim (Korean). Any font that is so described may be used to represent the generic sans-serif family.",
      "cursive": "Glyphs in cursive fonts generally have either joining strokes or other cursive characteristics beyond those of italic typefaces. The glyphs are partially or completely connected, and the result looks more like handwritten pen or brush writing than printed letterwork. Some scripts, such as Arabic, are almost always cursive. CSS uses the term cursive to apply to a font for any script, although other names such as Chancery, Brush, Swing and Script are also used in font names.",
      "fantasy": "Fantasy fonts are primarily decorative fonts that contain playful representations of characters. These do not include Pi or Picture fonts which do not represent actual characters.",
      "monospace": "The sole criterion of a monospace font is that all glyphs have the same fixed width. This is often used to render samples of computer code."
    }
  },
  "font-size": {
    "description": "This property indicates the desired height of glyphs from the font.",
    "values": {
      "xx-small": "",
      "x-small": "",
      "small": "",
      "medium": "",
      "large": "",
      "x-large": "",
      "xx-large": "",
      "larger": "",
      "smaller": ""
    }
  },
  "font-size-adjust": {
    "description": "",
    "values": {
    }
  },
  "font-stretch": {
    "description": "",
    "values": {
    }
  },
  "font-style": {
    "description": "",
    "values": {
    }
  },
  "font-variant": {
    "description": "",
    "values": {
    }
  },
  "font-weight": {
    "description": "",
    "values": {
    }
  },
  "grid-columns": {
    "description": "",
    "values": {
    }
  },
  "grid-rows": {
    "description": "",
    "values": {
    }
  },
  "hanging-punctuation": {
    "description": "",
    "values": {
    }
  },
  "height": {
    "description": "Specifies the height of the content area, padding area or border area (depending on box-sizing) of certain boxes.",
    "values": {
      "auto": "The height depends on the values of other properties."
    }
  },
  "hyphenate-after": {
    "description": "",
    "values": {
    }
  },
  "hyphenate-before": {
    "description": "",
    "values": {
    }
  },
  "hyphenate-character": {
    "description": "",
    "values": {
    }
  },
  "hyphenate-lines": {
    "description": "",
    "values": {
    }
  },
  "hyphenate-resource": {
    "description": "",
    "values": {
    }
  },
  "hyphens": {
    "description": "",
    "values": {
    }
  },
  "icon": {
    "description": "The icon property provides the author the ability to style any arbitrary element with an iconic equivalent.",
    "values": {
      "auto": "Use a default generic icon provided by the user agent."
    }
  },
  "image-orientation": {
    "description": "",
    "values": {
    }
  },
  "image-resolution": {
    "description": "",
    "values": {
    }
  },
  "inline-box-align": {
    "description": "",
    "values": {
    }
  },
  "left": {
    "description": "Absolute position from the left edge of the containing block.",
    "values": {
      "auto": "For non-replaced elements, the effect of this value depends on which of related properties have the value auto as well."
    }
  },
  "letter-spacing": {
    "description": "",
    "values": {
    }
  },
  "line-height": {
    "description": "",
    "values": {
    }
  },
  "line-stacking": {
    "description": "",
    "values": {
    }
  },
  "line-stacking-ruby": {
    "description": "",
    "values": {
    }
  },
  "line-stacking-shift": {
    "description": "",
    "values": {
    }
  },
  "line-stacking-strategy": {
    "description": "",
    "values": {
    }
  },
  "list-style": {
    "description": "",
    "values": {
    }
  },
  "list-style-image": {
    "description": "",
    "values": {
    }
  },
  "list-style-position": {
    "description": "",
    "values": {
    }
  },
  "list-style-type": {
    "description": "",
    "values": {
    }
  },
  "margin": {
    "description": "",
    "values": {
    }
  },
  "margin-bottom": {
    "description": "The bottom margin of a box.",
    "values": {
      "auto": ""
    }
  },
  "margin-left": {
    "description": "The left margin of a box.",
    "values": {
      "auto": ""
    }
  },
  "margin-right": {
    "description": "The right margin of a box.",
    "values": {
      "auto": ""
    }
  },
  "margin-top": {
    "description": "The top margin of a box.",
    "values": {
      "auto": ""
    }
  },
  "mark": {
    "description": "",
    "values": {
    }
  },
  "mark-after": {
    "description": "",
    "values": {
    }
  },
  "mark-before": {
    "description": "",
    "values": {
    }
  },
  "marker-offset": {
    "description": "",
    "values": {
    }
  },
  "marks": {
    "description": "",
    "values": {
    }
  },
  "marquee-direction": {
    "description": "The marquee direction",
    "values": {
    }
  },
  "marquee-loop": {
    "description": "",
    "values": {
    }
  },
  "marquee-speed": {
    "description": "",
    "values": {
    }
  },
  "marquee-style": {
    "description": "",
    "values": {
    }
  },
  "max-height": {
    "description": "",
    "values": {
    }
  },
  "max-width": {
    "description": "",
    "values": {
    }
  },
  "min-height": {
    "description": "",
    "values": {
    }
  },
  "min-width": {
    "description": "",
    "values": {
    }
  },
  "move-to": {
    "description": "",
    "values": {
    }
  },
  "nav-down": {
    "description": "http://www.w3.org/TR/css3-ui/#nav-down",
    "values": {
    }
  },
  "nav-index": {
    "description": "http://www.w3.org/TR/css3-ui/#nav-index",
    "values": {
    }
  },
  "nav-left": {
    "description": "http://www.w3.org/TR/css3-ui/#nav-left",
    "values": {
    }
  },
  "nav-right": {
    "description": "http://www.w3.org/TR/css3-ui/#nav-right",
    "values": {
    }
  },
  "nav-up": {
    "description": "",
    "values": {
    }
  },
  "opacity": {
    "description": "",
    "values": {
      "1": "The default value."
    }
  },
  "orphans": {
    "description": "",
    "values": {
    }
  },
  "outline": {
    "description": "Shorthand for outline-width, outline-style and outline-color",
    "values": {
    }
  },
  "outline-color": {
    "description": "The outline color",
    "values": {
    }
  },
  "outline-offset": {
    "description": "The outline offset",
    "values": {
    }
  },
  "outline-style": {
    "description": "The outline style",
    "values": {
    }
  },
  "outline-width": {
    "description": "The outline width",
    "values": {
    }
  },
  "overflow": {
    "description": "",
    "values": {
    }
  },
  "overflow-style": {
    "description": "",
    "values": {
    }
  },
  "overflow-x": {
    "description": "",
    "values": {
    }
  },
  "overflow-y": {
    "description": "",
    "values": {
    }
  },
  "padding": {
    "description": "",
    "values": {
    }
  },
  "padding-bottom": {
    "description": "The bottom padding of a box.",
    "values": {
      "": ""
    }
  },
  "padding-left": {
    "description": "The left padding of a box.",
    "values": {
      "": ""
    }
  },
  "padding-right": {
    "description": "The right padding of a box.",
    "values": {
      "": ""
    }
  },
  "padding-top": {
    "description": "The top padding of a box.",
    "values": {
      "": ""
    }
  },
  "page": {
    "description": "",
    "values": {
    }
  },
  "page-break-after": {
    "description": "",
    "values": {
    }
  },
  "page-break-before": {
    "description": "",
    "values": {
    }
  },
  "page-break-inside": {
    "description": "",
    "values": {
    }
  },
  "page-policy": {
    "description": "",
    "values": {
    }
  },
  "pause": {
    "description": "",
    "values": {
    }
  },
  "pause-after": {
    "description": "",
    "values": {
    }
  },
  "pause-before": {
    "description": "",
    "values": {
    }
  },
  "phonemes": {
    "description": "",
    "values": {
    }
  },
  "pitch": {
    "description": "",
    "values": {
    }
  },
  "pitch-range": {
    "description": "",
    "values": {
    }
  },
  "play-during": {
    "description": "",
    "values": {
    }
  },
  "pointer-events": {
    "description": "User interface events that occur because of user actions performed on a pointer device are called pointer events.",
    "values": {
    }
  },
  "position": {
    "description": "",
    "values": {
    }
  },
  "presentation-level": {
    "description": "",
    "values": {
    }
  },
  "punctuation-trim": {
    "description": "",
    "values": {
    }
  },
  "quotes": {
    "description": "",
    "values": {
    }
  },
  "rendering-intent": {
    "description": "",
    "values": {
    }
  },
  "resize": {
    "description": "",
    "values": {
    }
  },
  "rest": {
    "description": "",
    "values": {
    }
  },
  "rest-after": {
    "description": "",
    "values": {
    }
  },
  "rest-before": {
    "description": "",
    "values": {
    }
  },
  "richness": {
    "description": "",
    "values": {
    }
  },
  "right": {
    "description": "Absolute position from the right edge of the containing block.",
    "values": {
      "auto": "For non-replaced elements, the effect of this value depends on which of related properties have the value auto as well."
    }
  },
  "rotation": {
    "description": "",
    "values": {
    }
  },
  "rotation-point": {
    "description": "",
    "values": {
    }
  },
  "ruby-align": {
    "description": "",
    "values": {
    }
  },
  "ruby-overhang": {
    "description": "",
    "values": {
    }
  },
  "ruby-position": {
    "description": "",
    "values": {
    }
  },
  "ruby-span": {
    "description": "",
    "values": {
    }
  },
  "size": {
    "description": "",
    "values": {
    }
  },
  "speak": {
    "description": "",
    "values": {
    }
  },
  "speak-header": {
    "description": "",
    "values": {
    }
  },
  "speak-numeral": {
    "description": "",
    "values": {
    }
  },
  "speak-punctuation": {
    "description": "",
    "values": {
    }
  },
  "speech-rate": {
    "description": "",
    "values": {
    }
  },
  "stress": {
    "description": "",
    "values": {
    }
  },
  "string-set": {
    "description": "",
    "values": {
    }
  },
  "tab-side": {
    "description": "",
    "values": {
    }
  },
  "table-layout": {
    "description": "",
    "values": {
    }
  },
  "target": {
    "description": "",
    "values": {
    }
  },
  "target-name": {
    "description": "",
    "values": {
    }
  },
  "target-new": {
    "description": "This property determines what new target destination (if any) is created.",
    "values": {
      "window": "The target is displayed in a new window.",
      "tab": "The target is displayed in a new tab of an existing window.",
      "none": "No new destination is created. The target is not displayed."
    }
  },
  "target-position": {
    "description": "",
    "values": {
    }
  },
  "text-align": {
    "description": "This property describes how inline contents of a block are horizontally aligned if the contents do not completely fill the line box.",
    "values": {
      "start": "The inline contents are aligned to the start edge of the line box.",
      "end": "The inline contents are aligned to the end edge of the line box.",
      "left": "The inline contents are aligned to the left edge of the line box. In vertical text, left aligns to the edge of the line box that would be the start edge for left-to-right text.",
      "right": "The inline contents are aligned to the right edge of the line box. In vertical text, right aligns to the edge of the line box that would be the end edge for left-to-right text.",
      "center": "The inline contents are centered within the line box.",
      "justify": "The text is justified according to the method specified by the text-justify property.",
      "match-parent": "This value behaves the same as inherit except that an inherited start or end keyword is calculated against its parent's direction value and results in a computed value of either left or right."
    }
  },
  "text-align-last": {
    "description": "",
    "values": {
    }
  },
  "text-decoration": {
    "description": "",
    "values": {
    }
  },
  "text-emphasis": {
    "description": "",
    "values": {
    }
  },
  "text-height": {
    "description": "",
    "values": {
    }
  },
  "text-indent": {
    "description": "",
    "values": {
    }
  },
  "text-justify": {
    "description": "",
    "values": {
    }
  },
  "text-outline": {
    "description": "",
    "values": {
    }
  },
  "text-overflow": {
    "description": "This property specifies rendering when inline content overflows its block container element (\"the block\") in its inline progression direction that has overflow other than visible.",
    "values": {
      "clip": "Clip inline content that overflows. Characters may be only partially rendered.",
      "ellipsis": "Render an ellipsis character (U+2026) to represent clipped inline content. Implementations may substitute a more language/script-appropriate ellipsis character, or three dots \"...\" if the ellipsis character is unavailable."
    }
  },
  "text-shadow": {
    "description": "",
    "values": {
    }
  },
  "text-transform": {
    "description": "",
    "values": {
    }
  },
  "text-wrap": {
    "description": "Specifies the mode for text wrapping",
    "values": {
    }
  },
  "top": {
    "description": "Absolute position from the top edge of the containing block.",
    "values": {
      "auto": "For non-replaced elements, the effect of this value depends on which of related properties have the value auto as well."
    }
  },
  "unicode-bidi": {
    "description": "",
    "values": {
    }
  },
  "vertical-align": {
    "description": "",
    "values": {
    }
  },
  "visibility": {
    "description": "The visibility of an element",
    "values": {
    }
  },
  "voice-balance": {
    "description": "",
    "values": {
    }
  },
  "voice-duration": {
    "description": "",
    "values": {
    }
  },
  "voice-family": {
    "description": "",
    "values": {
    }
  },
  "voice-pitch": {
    "description": "",
    "values": {
    }
  },
  "voice-pitch-range": {
    "description": "",
    "values": {
    }
  },
  "voice-rate": {
    "description": "",
    "values": {
    }
  },
  "voice-stress": {
    "description": "",
    "values": {
    }
  },
  "voice-volume": {
    "description": "",
    "values": {
    }
  },
  "volume": {
    "description": "",
    "values": {
    }
  },
  "white-space": {
    "description": "",
    "values": {
    }
  },
  "white-space-collapse": {
    "description": "",
    "values": {
    }
  },
  "widows": {
    "description": "",
    "values": {
    }
  },
  "width": {
    "description": "Specifies the width of the content area, padding area or border area (depending on box-sizing) of certain boxes.",
    "values": {
      "auto": "The width depends on the values of other properties."
    }
  },
  "word-break": {
    "description": "",
    "values": {
    }
  },
  "word-spacing": {
    "description": "Specifies the minimum, maximum, and optimal spacing between words",
    "values": {
    }
  },
  "word-wrap": {
    "description": "Specifies whether the UA may break within a word to prevent overflow when an otherwise-unbreakable string is too long to fit within the line box",
    "values": {
    }
  },
  "z-index": {
    "description": "The stack level.",
    "values": {
      "auto": "The stack level of the generated box in the current stacking context is 0. The box does not establish a new stacking context unless it is the root element."
    }
  }
}
