// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_PROJECTIONS_IAU2000_TRAITS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_IAU2000_TRAITS_HPP


#include <boost/geometry/core/tags.hpp>

#include <boost/geometry/srs/projections/factory.hpp>
#include <boost/geometry/srs/projections/impl/projects.hpp>
#include <boost/geometry/srs/projections/srid_traits.hpp>


namespace boost { namespace geometry { namespace projections
{

#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

/*!
    \brief IAU2000 traits
    \details With help of the IAU2000 traits library users can statically use projections
        or coordinate systems specifying an IAU2000 code. The correct projections for transformations
        are used automically then, still keeping static polymorphism.
    \ingroup projection
    \tparam IAU2000 iau2000 code
*/
template <size_t IAU2000>
struct iau2000_traits
{
    // Specializations define:
    // - type to get projection type
    // - function par to get parameters
};

BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19900, longlat, 2439700, "+proj=longlat +a=2439700 +b=2439700 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19901, longlat, 2439700, "+proj=longlat +a=2439700 +b=2439700 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19914, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19915, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19916, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19917, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19918, stere, 2439700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19919, stere, 2439700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19920, stere, 2439700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19921, stere, 2439700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19960, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19961, sinu, 2439700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19962, stere, 2439700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19963, stere, 2439700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19964, tmerc, 2439700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19965, tmerc, 2439700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19966, ortho, 2439700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19967, ortho, 2439700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19972, laea, 2439700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 19973, laea, 2439700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2439700 +b=2439700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 19979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29900, longlat, 6051800, "+proj=longlat +a=6051800 +b=6051800 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29901, longlat, 6051800, "+proj=longlat +a=6051800 +b=6051800 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29914, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29915, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29916, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29917, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29918, stere, 6051800, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29919, stere, 6051800, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29920, stere, 6051800, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29921, stere, 6051800, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29960, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29961, sinu, 6051800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29962, stere, 6051800, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29963, stere, 6051800, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29964, tmerc, 6051800, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29965, tmerc, 6051800, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29966, ortho, 6051800, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29967, ortho, 6051800, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29972, laea, 6051800, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 29973, laea, 6051800, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6051800 +b=6051800 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 29979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30100, longlat, 1737400, "+proj=longlat +a=1737400 +b=1737400 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30101, longlat, 1737400, "+proj=longlat +a=1737400 +b=1737400 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30114, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30115, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30116, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30117, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30118, stere, 1737400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30119, stere, 1737400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30120, stere, 1737400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30121, stere, 1737400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30160, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30161, sinu, 1737400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30162, stere, 1737400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30163, stere, 1737400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30164, tmerc, 1737400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30165, tmerc, 1737400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30166, ortho, 1737400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30167, ortho, 1737400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30172, laea, 1737400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 30173, laea, 1737400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1737400 +b=1737400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 30179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39900, longlat, 6378140, 6356750, "+proj=longlat +a=6378140 +b=6356750 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39901, longlat, 6378140, 6356750, "+proj=longlat +a=6378140 +b=6356750 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39914, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39915, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39916, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39917, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39918, stere, 6378140, 6356750, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39919, stere, 6378140, 6356750, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39920, stere, 6378140, 6356750, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39921, stere, 6378140, 6356750, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39960, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39961, sinu, 6378140, 6356750, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39962, stere, 6378140, 6356750, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39963, stere, 6378140, 6356750, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39964, tmerc, 6378140, 6356750, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39965, tmerc, 6378140, 6356750, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39966, ortho, 6378140, 6356750, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39967, ortho, 6378140, 6356750, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39972, laea, 6378140, 6356750, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 39973, laea, 6378140, 6356750, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=6378140 +b=6356750 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 39979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40100, longlat, 13400, 9200, "+proj=longlat +a=13400 +b=9200 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40101, longlat, 13400, 9200, "+proj=longlat +a=13400 +b=9200 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40114, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40115, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40116, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40117, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40118, stere, 13400, 9200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40119, stere, 13400, 9200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40120, stere, 13400, 9200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40121, stere, 13400, 9200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40160, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40161, sinu, 13400, 9200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40162, stere, 13400, 9200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40163, stere, 13400, 9200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40164, tmerc, 13400, 9200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40165, tmerc, 13400, 9200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40166, ortho, 13400, 9200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40167, ortho, 13400, 9200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40172, laea, 13400, 9200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40173, laea, 13400, 9200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13400 +b=9200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40200, longlat, 7500, 5200, "+proj=longlat +a=7500 +b=5200 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40201, longlat, 7500, 5200, "+proj=longlat +a=7500 +b=5200 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40214, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40215, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40216, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40217, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40218, stere, 7500, 5200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40219, stere, 7500, 5200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40220, stere, 7500, 5200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40221, stere, 7500, 5200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40260, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40261, sinu, 7500, 5200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40262, stere, 7500, 5200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40263, stere, 7500, 5200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40264, tmerc, 7500, 5200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40265, tmerc, 7500, 5200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40266, ortho, 7500, 5200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40267, ortho, 7500, 5200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40272, laea, 7500, 5200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 40273, laea, 7500, 5200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=7500 +b=5200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 40279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49900, longlat, 3396190, 3376200, "+proj=longlat +a=3396190 +b=3376200 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49901, longlat, 3396190, 3376200, "+proj=longlat +a=3396190 +b=3376200 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49914, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49915, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49916, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49917, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49918, stere, 3396190, 3376200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49919, stere, 3396190, 3376200, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49920, stere, 3396190, 3376200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49921, stere, 3396190, 3376200, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49960, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49961, sinu, 3396190, 3376200, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49962, stere, 3396190, 3376200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49963, stere, 3396190, 3376200, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49964, tmerc, 3396190, 3376200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49965, tmerc, 3396190, 3376200, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49966, ortho, 3396190, 3376200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49967, ortho, 3396190, 3376200, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49972, laea, 3396190, 3376200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 49973, laea, 3396190, 3376200, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=3396190 +b=3376200 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 49979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50100, longlat, 1829400, 1815700, "+proj=longlat +a=1829400 +b=1815700 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50101, longlat, 1829400, 1815700, "+proj=longlat +a=1829400 +b=1815700 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50114, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50115, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50116, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50117, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50118, stere, 1829400, 1815700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50119, stere, 1829400, 1815700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50120, stere, 1829400, 1815700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50121, stere, 1829400, 1815700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50160, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50161, sinu, 1829400, 1815700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50162, stere, 1829400, 1815700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50163, stere, 1829400, 1815700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50164, tmerc, 1829400, 1815700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50165, tmerc, 1829400, 1815700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50166, ortho, 1829400, 1815700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50167, ortho, 1829400, 1815700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50172, laea, 1829400, 1815700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50173, laea, 1829400, 1815700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1829400 +b=1815700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50200, longlat, 1564130, 1560930, "+proj=longlat +a=1564130 +b=1560930 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50201, longlat, 1564130, 1560930, "+proj=longlat +a=1564130 +b=1560930 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50214, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50215, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50216, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50217, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50218, stere, 1564130, 1560930, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50219, stere, 1564130, 1560930, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50220, stere, 1564130, 1560930, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50221, stere, 1564130, 1560930, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50260, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50261, sinu, 1564130, 1560930, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50262, stere, 1564130, 1560930, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50263, stere, 1564130, 1560930, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50264, tmerc, 1564130, 1560930, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50265, tmerc, 1564130, 1560930, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50266, ortho, 1564130, 1560930, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50267, ortho, 1564130, 1560930, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50272, laea, 1564130, 1560930, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50273, laea, 1564130, 1560930, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1564130 +b=1560930 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50300, longlat, 2632400, 2632350, "+proj=longlat +a=2632400 +b=2632350 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50301, longlat, 2632400, 2632350, "+proj=longlat +a=2632400 +b=2632350 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50314, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50315, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50316, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50317, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50318, stere, 2632400, 2632350, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50319, stere, 2632400, 2632350, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50320, stere, 2632400, 2632350, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50321, stere, 2632400, 2632350, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50360, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50361, sinu, 2632400, 2632350, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50362, stere, 2632400, 2632350, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50363, stere, 2632400, 2632350, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50364, tmerc, 2632400, 2632350, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50365, tmerc, 2632400, 2632350, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50366, ortho, 2632400, 2632350, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50367, ortho, 2632400, 2632350, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50372, laea, 2632400, 2632350, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50373, laea, 2632400, 2632350, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2632400 +b=2632350 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50400, longlat, 2409400, 2409300, "+proj=longlat +a=2409400 +b=2409300 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50401, longlat, 2409400, 2409300, "+proj=longlat +a=2409400 +b=2409300 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50414, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50415, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50416, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50417, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50418, stere, 2409400, 2409300, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50419, stere, 2409400, 2409300, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50420, stere, 2409400, 2409300, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50421, stere, 2409400, 2409300, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50460, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50461, sinu, 2409400, 2409300, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50462, stere, 2409400, 2409300, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50463, stere, 2409400, 2409300, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50464, tmerc, 2409400, 2409300, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50465, tmerc, 2409400, 2409300, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50466, ortho, 2409400, 2409300, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50467, ortho, 2409400, 2409300, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50472, laea, 2409400, 2409300, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50473, laea, 2409400, 2409300, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2409400 +b=2409300 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50500, longlat, 125000, 64000, "+proj=longlat +a=125000 +b=64000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50501, longlat, 125000, 64000, "+proj=longlat +a=125000 +b=64000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50514, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50515, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50516, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50517, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50518, stere, 125000, 64000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50519, stere, 125000, 64000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50520, stere, 125000, 64000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50521, stere, 125000, 64000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50560, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50561, sinu, 125000, 64000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50562, stere, 125000, 64000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50563, stere, 125000, 64000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50564, tmerc, 125000, 64000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50565, tmerc, 125000, 64000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50566, ortho, 125000, 64000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50567, ortho, 125000, 64000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50572, laea, 125000, 64000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 50573, laea, 125000, 64000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=125000 +b=64000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50600, longlat, 85000, "+proj=longlat +a=85000 +b=85000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50601, longlat, 85000, "+proj=longlat +a=85000 +b=85000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50614, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50615, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50616, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50617, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50618, stere, 85000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50619, stere, 85000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50620, stere, 85000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50621, stere, 85000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50660, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50661, sinu, 85000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50662, stere, 85000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50663, stere, 85000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50664, tmerc, 85000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50665, tmerc, 85000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50666, ortho, 85000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50667, ortho, 85000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50672, laea, 85000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50673, laea, 85000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=85000 +b=85000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50700, longlat, 40000, "+proj=longlat +a=40000 +b=40000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50701, longlat, 40000, "+proj=longlat +a=40000 +b=40000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50713, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50714, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50715, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50716, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50717, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50718, stere, 40000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50719, stere, 40000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50720, stere, 40000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50721, stere, 40000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50760, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50761, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50762, stere, 40000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50763, stere, 40000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50764, tmerc, 40000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50765, tmerc, 40000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50766, ortho, 40000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50767, ortho, 40000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50771, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50772, laea, 40000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50773, laea, 40000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50779, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50800, longlat, 18000, "+proj=longlat +a=18000 +b=18000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50801, longlat, 18000, "+proj=longlat +a=18000 +b=18000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50813, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50814, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50815, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50816, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50817, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50818, stere, 18000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50819, stere, 18000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50820, stere, 18000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50821, stere, 18000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50860, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50861, sinu, 18000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50862, stere, 18000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50863, stere, 18000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50864, tmerc, 18000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50865, tmerc, 18000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50866, ortho, 18000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50867, ortho, 18000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50868, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50869, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50870, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50871, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50872, laea, 18000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50873, laea, 18000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18000 +b=18000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50874, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50875, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50876, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50877, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50878, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50879, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50900, longlat, 14000, "+proj=longlat +a=14000 +b=14000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50901, longlat, 14000, "+proj=longlat +a=14000 +b=14000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50914, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50915, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50916, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50917, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50918, stere, 14000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50919, stere, 14000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50920, stere, 14000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50921, stere, 14000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50960, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50961, sinu, 14000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50962, stere, 14000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50963, stere, 14000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50964, tmerc, 14000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50965, tmerc, 14000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50966, ortho, 14000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50967, ortho, 14000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50972, laea, 14000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 50973, laea, 14000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=14000 +b=14000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 50979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51000, longlat, 12000, "+proj=longlat +a=12000 +b=12000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51001, longlat, 12000, "+proj=longlat +a=12000 +b=12000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51010, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51011, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51012, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51013, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51014, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51015, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51016, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51017, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51018, stere, 12000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51019, stere, 12000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51020, stere, 12000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51021, stere, 12000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51060, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51061, sinu, 12000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51062, stere, 12000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51063, stere, 12000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51064, tmerc, 12000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51065, tmerc, 12000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51066, ortho, 12000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51067, ortho, 12000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51068, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51069, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51070, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51071, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51072, laea, 12000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51073, laea, 12000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=12000 +b=12000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51074, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51075, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51076, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51077, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51078, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51079, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51100, longlat, 15000, "+proj=longlat +a=15000 +b=15000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51101, longlat, 15000, "+proj=longlat +a=15000 +b=15000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51114, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51115, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51116, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51117, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51118, stere, 15000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51119, stere, 15000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51120, stere, 15000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51121, stere, 15000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51160, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51161, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51162, stere, 15000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51163, stere, 15000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51164, tmerc, 15000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51165, tmerc, 15000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51166, ortho, 15000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51167, ortho, 15000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51172, laea, 15000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51173, laea, 15000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51200, longlat, 10000, "+proj=longlat +a=10000 +b=10000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51201, longlat, 10000, "+proj=longlat +a=10000 +b=10000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51214, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51215, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51216, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51217, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51218, stere, 10000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51219, stere, 10000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51220, stere, 10000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51221, stere, 10000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51260, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51261, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51262, stere, 10000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51263, stere, 10000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51264, tmerc, 10000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51265, tmerc, 10000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51266, ortho, 10000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51267, ortho, 10000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51272, laea, 10000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51273, laea, 10000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51300, longlat, 5000, "+proj=longlat +a=5000 +b=5000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51301, longlat, 5000, "+proj=longlat +a=5000 +b=5000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51314, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51315, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51316, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51317, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51318, stere, 5000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51319, stere, 5000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51320, stere, 5000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51321, stere, 5000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51360, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51361, sinu, 5000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51362, stere, 5000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51363, stere, 5000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51364, tmerc, 5000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51365, tmerc, 5000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51366, ortho, 5000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51367, ortho, 5000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51372, laea, 5000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51373, laea, 5000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=5000 +b=5000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51400, longlat, 58000, 42000, "+proj=longlat +a=58000 +b=42000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51401, longlat, 58000, 42000, "+proj=longlat +a=58000 +b=42000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51414, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51415, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51416, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51417, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51418, stere, 58000, 42000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51419, stere, 58000, 42000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51420, stere, 58000, 42000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51421, stere, 58000, 42000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51460, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51461, sinu, 58000, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51462, stere, 58000, 42000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51463, stere, 58000, 42000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51464, tmerc, 58000, 42000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51465, tmerc, 58000, 42000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51466, ortho, 58000, 42000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51467, ortho, 58000, 42000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51472, laea, 58000, 42000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51473, laea, 58000, 42000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=58000 +b=42000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51500, longlat, 10000, 7000, "+proj=longlat +a=10000 +b=7000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51501, longlat, 10000, 7000, "+proj=longlat +a=10000 +b=7000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51514, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51515, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51516, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51517, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51518, stere, 10000, 7000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51519, stere, 10000, 7000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51520, stere, 10000, 7000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51521, stere, 10000, 7000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51560, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51561, sinu, 10000, 7000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51562, stere, 10000, 7000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51563, stere, 10000, 7000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51564, tmerc, 10000, 7000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51565, tmerc, 10000, 7000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51566, ortho, 10000, 7000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51567, ortho, 10000, 7000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51572, laea, 10000, 7000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 51573, laea, 10000, 7000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=7000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51600, longlat, 21500, "+proj=longlat +a=21500 +b=21500 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51601, longlat, 21500, "+proj=longlat +a=21500 +b=21500 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51614, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51615, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51616, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51617, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51618, stere, 21500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51619, stere, 21500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51620, stere, 21500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51621, stere, 21500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51660, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51661, sinu, 21500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51662, stere, 21500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51663, stere, 21500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51664, tmerc, 21500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51665, tmerc, 21500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51666, ortho, 21500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51667, ortho, 21500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51672, laea, 21500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 51673, laea, 21500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21500 +b=21500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 51679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59900, longlat, 71492000, 66854000, "+proj=longlat +a=71492000 +b=66854000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59901, longlat, 71492000, 66854000, "+proj=longlat +a=71492000 +b=66854000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59914, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59915, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59916, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59917, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59918, stere, 71492000, 66854000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59919, stere, 71492000, 66854000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59920, stere, 71492000, 66854000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59921, stere, 71492000, 66854000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59960, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59961, sinu, 71492000, 66854000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59962, stere, 71492000, 66854000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59963, stere, 71492000, 66854000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59964, tmerc, 71492000, 66854000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59965, tmerc, 71492000, 66854000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59966, ortho, 71492000, 66854000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59967, ortho, 71492000, 66854000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59972, laea, 71492000, 66854000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 59973, laea, 71492000, 66854000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=71492000 +b=66854000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 59979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60100, longlat, 209100, 191400, "+proj=longlat +a=209100 +b=191400 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60101, longlat, 209100, 191400, "+proj=longlat +a=209100 +b=191400 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60114, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60115, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60116, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60117, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60118, stere, 209100, 191400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60119, stere, 209100, 191400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60120, stere, 209100, 191400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60121, stere, 209100, 191400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60160, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60161, sinu, 209100, 191400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60162, stere, 209100, 191400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60163, stere, 209100, 191400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60164, tmerc, 209100, 191400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60165, tmerc, 209100, 191400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60166, ortho, 209100, 191400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60167, ortho, 209100, 191400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60172, laea, 209100, 191400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60173, laea, 209100, 191400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=209100 +b=191400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60200, longlat, 256300, 244600, "+proj=longlat +a=256300 +b=244600 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60201, longlat, 256300, 244600, "+proj=longlat +a=256300 +b=244600 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60214, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60215, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60216, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60217, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60218, stere, 256300, 244600, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60219, stere, 256300, 244600, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60220, stere, 256300, 244600, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60221, stere, 256300, 244600, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60260, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60261, sinu, 256300, 244600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60262, stere, 256300, 244600, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60263, stere, 256300, 244600, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60264, tmerc, 256300, 244600, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60265, tmerc, 256300, 244600, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60266, ortho, 256300, 244600, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60267, ortho, 256300, 244600, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60272, laea, 256300, 244600, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60273, laea, 256300, 244600, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=256300 +b=244600 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60300, longlat, 535600, 525800, "+proj=longlat +a=535600 +b=525800 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60301, longlat, 535600, 525800, "+proj=longlat +a=535600 +b=525800 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60314, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60315, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60316, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60317, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60318, stere, 535600, 525800, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60319, stere, 535600, 525800, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60320, stere, 535600, 525800, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60321, stere, 535600, 525800, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60360, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60361, sinu, 535600, 525800, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60362, stere, 535600, 525800, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60363, stere, 535600, 525800, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60364, tmerc, 535600, 525800, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60365, tmerc, 535600, 525800, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60366, ortho, 535600, 525800, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60367, ortho, 535600, 525800, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60372, laea, 535600, 525800, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60373, laea, 535600, 525800, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=535600 +b=525800 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60400, longlat, 560000, "+proj=longlat +a=560000 +b=560000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60401, longlat, 560000, "+proj=longlat +a=560000 +b=560000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60414, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60415, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60416, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60417, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60418, stere, 560000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60419, stere, 560000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60420, stere, 560000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60421, stere, 560000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60460, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60461, sinu, 560000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60462, stere, 560000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60463, stere, 560000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60464, tmerc, 560000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60465, tmerc, 560000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60466, ortho, 560000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60467, ortho, 560000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60472, laea, 560000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60473, laea, 560000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=560000 +b=560000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60500, longlat, 764000, "+proj=longlat +a=764000 +b=764000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60501, longlat, 764000, "+proj=longlat +a=764000 +b=764000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60514, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60515, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60516, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60517, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60518, stere, 764000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60519, stere, 764000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60520, stere, 764000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60521, stere, 764000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60560, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60561, sinu, 764000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60562, stere, 764000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60563, stere, 764000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60564, tmerc, 764000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60565, tmerc, 764000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60566, ortho, 764000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60567, ortho, 764000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60572, laea, 764000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60573, laea, 764000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=764000 +b=764000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60600, longlat, 2575000, "+proj=longlat +a=2575000 +b=2575000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60601, longlat, 2575000, "+proj=longlat +a=2575000 +b=2575000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60614, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60615, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60616, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60617, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60618, stere, 2575000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60619, stere, 2575000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60620, stere, 2575000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60621, stere, 2575000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60660, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60661, sinu, 2575000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60662, stere, 2575000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60663, stere, 2575000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60664, tmerc, 2575000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60665, tmerc, 2575000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60666, ortho, 2575000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60667, ortho, 2575000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60672, laea, 2575000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60673, laea, 2575000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=2575000 +b=2575000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60700, longlat, 164000, 107000, "+proj=longlat +a=164000 +b=107000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60701, longlat, 164000, 107000, "+proj=longlat +a=164000 +b=107000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60713, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60714, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60715, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60716, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60717, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60718, stere, 164000, 107000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60719, stere, 164000, 107000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60720, stere, 164000, 107000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60721, stere, 164000, 107000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60760, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60761, sinu, 164000, 107000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60762, stere, 164000, 107000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60763, stere, 164000, 107000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60764, tmerc, 164000, 107000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60765, tmerc, 164000, 107000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60766, ortho, 164000, 107000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60767, ortho, 164000, 107000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60771, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60772, laea, 164000, 107000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60773, laea, 164000, 107000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=164000 +b=107000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60779, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60800, longlat, 718000, "+proj=longlat +a=718000 +b=718000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60801, longlat, 718000, "+proj=longlat +a=718000 +b=718000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60813, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60814, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60815, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60816, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60817, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60818, stere, 718000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60819, stere, 718000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60820, stere, 718000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60821, stere, 718000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60860, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60861, sinu, 718000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60862, stere, 718000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60863, stere, 718000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60864, tmerc, 718000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60865, tmerc, 718000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60866, ortho, 718000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60867, ortho, 718000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60868, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60869, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60870, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60871, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60872, laea, 718000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 60873, laea, 718000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=718000 +b=718000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60874, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60875, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60876, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60877, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60878, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60879, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60900, longlat, 115000, 105000, "+proj=longlat +a=115000 +b=105000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60901, longlat, 115000, 105000, "+proj=longlat +a=115000 +b=105000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60914, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60915, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60916, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60917, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60918, stere, 115000, 105000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60919, stere, 115000, 105000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60920, stere, 115000, 105000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60921, stere, 115000, 105000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60960, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60961, sinu, 115000, 105000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60962, stere, 115000, 105000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60963, stere, 115000, 105000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60964, tmerc, 115000, 105000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60965, tmerc, 115000, 105000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60966, ortho, 115000, 105000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60967, ortho, 115000, 105000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60972, laea, 115000, 105000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 60973, laea, 115000, 105000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=115000 +b=105000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 60979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61000, longlat, 97000, 77000, "+proj=longlat +a=97000 +b=77000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61001, longlat, 97000, 77000, "+proj=longlat +a=97000 +b=77000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61010, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61011, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61012, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61013, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61014, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61015, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61016, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61017, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61018, stere, 97000, 77000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61019, stere, 97000, 77000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61020, stere, 97000, 77000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61021, stere, 97000, 77000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61060, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61061, sinu, 97000, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61062, stere, 97000, 77000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61063, stere, 97000, 77000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61064, tmerc, 97000, 77000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61065, tmerc, 97000, 77000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61066, ortho, 97000, 77000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61067, ortho, 97000, 77000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61068, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61069, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61070, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61071, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61072, laea, 97000, 77000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61073, laea, 97000, 77000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=97000 +b=77000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61074, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61075, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61076, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61077, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61078, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61079, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61100, longlat, 69000, 55000, "+proj=longlat +a=69000 +b=55000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61101, longlat, 69000, 55000, "+proj=longlat +a=69000 +b=55000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61114, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61115, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61116, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61117, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61118, stere, 69000, 55000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61119, stere, 69000, 55000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61120, stere, 69000, 55000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61121, stere, 69000, 55000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61160, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61161, sinu, 69000, 55000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61162, stere, 69000, 55000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61163, stere, 69000, 55000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61164, tmerc, 69000, 55000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61165, tmerc, 69000, 55000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61166, ortho, 69000, 55000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61167, ortho, 69000, 55000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61172, laea, 69000, 55000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61173, laea, 69000, 55000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=69000 +b=55000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61200, longlat, 16000, "+proj=longlat +a=16000 +b=16000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61201, longlat, 16000, "+proj=longlat +a=16000 +b=16000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61214, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61215, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61216, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61217, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61218, stere, 16000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61219, stere, 16000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61220, stere, 16000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61221, stere, 16000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61260, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61261, sinu, 16000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61262, stere, 16000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61263, stere, 16000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61264, tmerc, 16000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61265, tmerc, 16000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61266, ortho, 16000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61267, ortho, 16000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61272, laea, 16000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61273, laea, 16000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=16000 +b=16000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61300, longlat, 15000, 7500, "+proj=longlat +a=15000 +b=7500 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61301, longlat, 15000, 7500, "+proj=longlat +a=15000 +b=7500 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61314, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61315, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61316, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61317, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61318, stere, 15000, 7500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61319, stere, 15000, 7500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61320, stere, 15000, 7500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61321, stere, 15000, 7500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61360, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61361, sinu, 15000, 7500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61362, stere, 15000, 7500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61363, stere, 15000, 7500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61364, tmerc, 15000, 7500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61365, tmerc, 15000, 7500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61366, ortho, 15000, 7500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61367, ortho, 15000, 7500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61372, laea, 15000, 7500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61373, laea, 15000, 7500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=7500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61400, longlat, 15000, 8000, "+proj=longlat +a=15000 +b=8000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61401, longlat, 15000, 8000, "+proj=longlat +a=15000 +b=8000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61414, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61415, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61416, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61417, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61418, stere, 15000, 8000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61419, stere, 15000, 8000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61420, stere, 15000, 8000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61421, stere, 15000, 8000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61460, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61461, sinu, 15000, 8000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61462, stere, 15000, 8000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61463, stere, 15000, 8000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61464, tmerc, 15000, 8000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61465, tmerc, 15000, 8000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61466, ortho, 15000, 8000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61467, ortho, 15000, 8000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61472, laea, 15000, 8000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61473, laea, 15000, 8000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=8000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61500, longlat, 18500, 13500, "+proj=longlat +a=18500 +b=13500 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61501, longlat, 18500, 13500, "+proj=longlat +a=18500 +b=13500 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61514, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61515, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61516, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61517, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61518, stere, 18500, 13500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61519, stere, 18500, 13500, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61520, stere, 18500, 13500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61521, stere, 18500, 13500, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61560, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61561, sinu, 18500, 13500, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61562, stere, 18500, 13500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61563, stere, 18500, 13500, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61564, tmerc, 18500, 13500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61565, tmerc, 18500, 13500, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61566, ortho, 18500, 13500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61567, ortho, 18500, 13500, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61572, laea, 18500, 13500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61573, laea, 18500, 13500, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=18500 +b=13500 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61600, longlat, 74000, 34000, "+proj=longlat +a=74000 +b=34000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61601, longlat, 74000, 34000, "+proj=longlat +a=74000 +b=34000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61614, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61615, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61616, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61617, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61618, stere, 74000, 34000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61619, stere, 74000, 34000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61620, stere, 74000, 34000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61621, stere, 74000, 34000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61660, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61661, sinu, 74000, 34000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61662, stere, 74000, 34000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61663, stere, 74000, 34000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61664, tmerc, 74000, 34000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61665, tmerc, 74000, 34000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61666, ortho, 74000, 34000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61667, ortho, 74000, 34000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61672, laea, 74000, 34000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61673, laea, 74000, 34000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=34000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61700, longlat, 55000, 31000, "+proj=longlat +a=55000 +b=31000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61701, longlat, 55000, 31000, "+proj=longlat +a=55000 +b=31000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61713, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61714, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61715, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61716, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61717, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61718, stere, 55000, 31000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61719, stere, 55000, 31000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61720, stere, 55000, 31000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61721, stere, 55000, 31000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61760, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61761, sinu, 55000, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61762, stere, 55000, 31000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61763, stere, 55000, 31000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61764, tmerc, 55000, 31000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61765, tmerc, 55000, 31000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61766, ortho, 55000, 31000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61767, ortho, 55000, 31000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61771, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61772, laea, 55000, 31000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 61773, laea, 55000, 31000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=55000 +b=31000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61779, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61800, longlat, 10000, "+proj=longlat +a=10000 +b=10000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61801, longlat, 10000, "+proj=longlat +a=10000 +b=10000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61813, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61814, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61815, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61816, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61817, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61818, stere, 10000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61819, stere, 10000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61820, stere, 10000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61821, stere, 10000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61860, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61861, sinu, 10000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61862, stere, 10000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61863, stere, 10000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61864, tmerc, 10000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61865, tmerc, 10000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61866, ortho, 10000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61867, ortho, 10000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61868, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61869, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61870, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61871, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61872, laea, 10000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 61873, laea, 10000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=10000 +b=10000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61874, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61875, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61876, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61877, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61878, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 61879, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69900, longlat, 60268000, 54364000, "+proj=longlat +a=60268000 +b=54364000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69901, longlat, 60268000, 54364000, "+proj=longlat +a=60268000 +b=54364000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69914, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69915, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69916, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69917, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69918, stere, 60268000, 54364000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69919, stere, 60268000, 54364000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69920, stere, 60268000, 54364000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69921, stere, 60268000, 54364000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69960, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69961, sinu, 60268000, 54364000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69962, stere, 60268000, 54364000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69963, stere, 60268000, 54364000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69964, tmerc, 60268000, 54364000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69965, tmerc, 60268000, 54364000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69966, ortho, 60268000, 54364000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69967, ortho, 60268000, 54364000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69972, laea, 60268000, 54364000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 69973, laea, 60268000, 54364000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=60268000 +b=54364000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 69979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70100, longlat, 581100, 577700, "+proj=longlat +a=581100 +b=577700 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70101, longlat, 581100, 577700, "+proj=longlat +a=581100 +b=577700 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70114, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70115, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70116, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70117, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70118, stere, 581100, 577700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70119, stere, 581100, 577700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70120, stere, 581100, 577700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70121, stere, 581100, 577700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70160, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70161, sinu, 581100, 577700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70162, stere, 581100, 577700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70163, stere, 581100, 577700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70164, tmerc, 581100, 577700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70165, tmerc, 581100, 577700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70166, ortho, 581100, 577700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70167, ortho, 581100, 577700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70172, laea, 581100, 577700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70173, laea, 581100, 577700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=581100 +b=577700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70200, longlat, 584700, "+proj=longlat +a=584700 +b=584700 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70201, longlat, 584700, "+proj=longlat +a=584700 +b=584700 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70214, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70215, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70216, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70217, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70218, stere, 584700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70219, stere, 584700, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70220, stere, 584700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70221, stere, 584700, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70260, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70261, sinu, 584700, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70262, stere, 584700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70263, stere, 584700, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70264, tmerc, 584700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70265, tmerc, 584700, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70266, ortho, 584700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70267, ortho, 584700, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70272, laea, 584700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70273, laea, 584700, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=584700 +b=584700 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70300, longlat, 788900, "+proj=longlat +a=788900 +b=788900 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70301, longlat, 788900, "+proj=longlat +a=788900 +b=788900 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70314, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70315, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70316, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70317, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70318, stere, 788900, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70319, stere, 788900, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70320, stere, 788900, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70321, stere, 788900, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70360, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70361, sinu, 788900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70362, stere, 788900, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70363, stere, 788900, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70364, tmerc, 788900, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70365, tmerc, 788900, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70366, ortho, 788900, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70367, ortho, 788900, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70372, laea, 788900, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70373, laea, 788900, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=788900 +b=788900 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70400, longlat, 761400, "+proj=longlat +a=761400 +b=761400 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70401, longlat, 761400, "+proj=longlat +a=761400 +b=761400 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70414, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70415, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70416, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70417, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70418, stere, 761400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70419, stere, 761400, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70420, stere, 761400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70421, stere, 761400, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70460, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70461, sinu, 761400, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70462, stere, 761400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70463, stere, 761400, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70464, tmerc, 761400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70465, tmerc, 761400, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70466, ortho, 761400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70467, ortho, 761400, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70472, laea, 761400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70473, laea, 761400, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=761400 +b=761400 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70500, longlat, 240400, 232900, "+proj=longlat +a=240400 +b=232900 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70501, longlat, 240400, 232900, "+proj=longlat +a=240400 +b=232900 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70514, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70515, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70516, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70517, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70518, stere, 240400, 232900, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70519, stere, 240400, 232900, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70520, stere, 240400, 232900, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70521, stere, 240400, 232900, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70560, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70561, sinu, 240400, 232900, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70562, stere, 240400, 232900, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70563, stere, 240400, 232900, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70564, tmerc, 240400, 232900, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70565, tmerc, 240400, 232900, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70566, ortho, 240400, 232900, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70567, ortho, 240400, 232900, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70572, laea, 240400, 232900, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 70573, laea, 240400, 232900, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=240400 +b=232900 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70600, longlat, 13000, "+proj=longlat +a=13000 +b=13000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70601, longlat, 13000, "+proj=longlat +a=13000 +b=13000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70614, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70615, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70616, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70617, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70618, stere, 13000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70619, stere, 13000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70620, stere, 13000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70621, stere, 13000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70660, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70661, sinu, 13000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70662, stere, 13000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70663, stere, 13000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70664, tmerc, 13000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70665, tmerc, 13000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70666, ortho, 13000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70667, ortho, 13000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70672, laea, 13000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70673, laea, 13000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=13000 +b=13000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70700, longlat, 15000, "+proj=longlat +a=15000 +b=15000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70701, longlat, 15000, "+proj=longlat +a=15000 +b=15000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70713, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70714, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70715, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70716, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70717, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70718, stere, 15000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70719, stere, 15000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70720, stere, 15000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70721, stere, 15000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70760, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70761, sinu, 15000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70762, stere, 15000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70763, stere, 15000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70764, tmerc, 15000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70765, tmerc, 15000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70766, ortho, 15000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70767, ortho, 15000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70771, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70772, laea, 15000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70773, laea, 15000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=15000 +b=15000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70779, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70800, longlat, 21000, "+proj=longlat +a=21000 +b=21000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70801, longlat, 21000, "+proj=longlat +a=21000 +b=21000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70813, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70814, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70815, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70816, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70817, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70818, stere, 21000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70819, stere, 21000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70820, stere, 21000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70821, stere, 21000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70860, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70861, sinu, 21000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70862, stere, 21000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70863, stere, 21000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70864, tmerc, 21000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70865, tmerc, 21000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70866, ortho, 21000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70867, ortho, 21000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70868, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70869, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70870, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70871, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70872, laea, 21000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70873, laea, 21000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=21000 +b=21000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70874, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70875, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70876, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70877, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70878, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70879, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70900, longlat, 31000, "+proj=longlat +a=31000 +b=31000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70901, longlat, 31000, "+proj=longlat +a=31000 +b=31000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70914, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70915, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70916, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70917, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70918, stere, 31000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70919, stere, 31000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70920, stere, 31000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70921, stere, 31000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70960, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70961, sinu, 31000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70962, stere, 31000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70963, stere, 31000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70964, tmerc, 31000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70965, tmerc, 31000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70966, ortho, 31000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70967, ortho, 31000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70972, laea, 31000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 70973, laea, 31000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=31000 +b=31000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 70979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71000, longlat, 27000, "+proj=longlat +a=27000 +b=27000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71001, longlat, 27000, "+proj=longlat +a=27000 +b=27000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71010, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71011, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71012, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71013, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71014, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71015, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71016, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71017, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71018, stere, 27000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71019, stere, 27000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71020, stere, 27000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71021, stere, 27000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71060, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71061, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71062, stere, 27000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71063, stere, 27000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71064, tmerc, 27000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71065, tmerc, 27000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71066, ortho, 27000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71067, ortho, 27000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71068, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71069, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71070, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71071, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71072, laea, 27000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71073, laea, 27000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71074, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71075, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71076, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71077, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71078, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71079, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71100, longlat, 42000, "+proj=longlat +a=42000 +b=42000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71101, longlat, 42000, "+proj=longlat +a=42000 +b=42000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71114, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71115, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71116, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71117, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71118, stere, 42000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71119, stere, 42000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71120, stere, 42000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71121, stere, 42000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71160, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71161, sinu, 42000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71162, stere, 42000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71163, stere, 42000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71164, tmerc, 42000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71165, tmerc, 42000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71166, ortho, 42000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71167, ortho, 42000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71172, laea, 42000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71173, laea, 42000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=42000 +b=42000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71200, longlat, 54000, "+proj=longlat +a=54000 +b=54000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71201, longlat, 54000, "+proj=longlat +a=54000 +b=54000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71214, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71215, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71216, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71217, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71218, stere, 54000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71219, stere, 54000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71220, stere, 54000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71221, stere, 54000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71260, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71261, sinu, 54000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71262, stere, 54000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71263, stere, 54000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71264, tmerc, 54000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71265, tmerc, 54000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71266, ortho, 54000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71267, ortho, 54000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71272, laea, 54000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71273, laea, 54000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=54000 +b=54000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71300, longlat, 27000, "+proj=longlat +a=27000 +b=27000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71301, longlat, 27000, "+proj=longlat +a=27000 +b=27000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71314, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71315, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71316, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71317, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71318, stere, 27000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71319, stere, 27000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71320, stere, 27000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71321, stere, 27000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71360, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71361, sinu, 27000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71362, stere, 27000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71363, stere, 27000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71364, tmerc, 27000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71365, tmerc, 27000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71366, ortho, 27000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71367, ortho, 27000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71372, laea, 27000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71373, laea, 27000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=27000 +b=27000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71400, longlat, 33000, "+proj=longlat +a=33000 +b=33000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71401, longlat, 33000, "+proj=longlat +a=33000 +b=33000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71414, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71415, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71416, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71417, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71418, stere, 33000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71419, stere, 33000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71420, stere, 33000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71421, stere, 33000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71460, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71461, sinu, 33000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71462, stere, 33000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71463, stere, 33000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71464, tmerc, 33000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71465, tmerc, 33000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71466, ortho, 33000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71467, ortho, 33000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71472, laea, 33000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71473, laea, 33000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=33000 +b=33000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71500, longlat, 77000, "+proj=longlat +a=77000 +b=77000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71501, longlat, 77000, "+proj=longlat +a=77000 +b=77000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71514, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71515, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71516, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71517, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71518, stere, 77000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71519, stere, 77000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71520, stere, 77000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71521, stere, 77000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71560, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71561, sinu, 77000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71562, stere, 77000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71563, stere, 77000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71564, tmerc, 77000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71565, tmerc, 77000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71566, ortho, 77000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71567, ortho, 77000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71572, laea, 77000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 71573, laea, 77000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=77000 +b=77000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 71579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79900, longlat, 25559000, 24973000, "+proj=longlat +a=25559000 +b=24973000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79901, longlat, 25559000, 24973000, "+proj=longlat +a=25559000 +b=24973000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79914, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79915, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79916, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79917, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79918, stere, 25559000, 24973000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79919, stere, 25559000, 24973000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79920, stere, 25559000, 24973000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79921, stere, 25559000, 24973000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79960, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79961, sinu, 25559000, 24973000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79962, stere, 25559000, 24973000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79963, stere, 25559000, 24973000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79964, tmerc, 25559000, 24973000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79965, tmerc, 25559000, 24973000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79966, ortho, 25559000, 24973000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79967, ortho, 25559000, 24973000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79972, laea, 25559000, 24973000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 79973, laea, 25559000, 24973000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=25559000 +b=24973000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 79979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80100, longlat, 1352600, "+proj=longlat +a=1352600 +b=1352600 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80101, longlat, 1352600, "+proj=longlat +a=1352600 +b=1352600 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80114, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80115, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80116, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80117, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80118, stere, 1352600, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80119, stere, 1352600, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80120, stere, 1352600, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80121, stere, 1352600, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80160, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80161, sinu, 1352600, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80162, stere, 1352600, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80163, stere, 1352600, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80164, tmerc, 1352600, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80165, tmerc, 1352600, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80166, ortho, 1352600, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80167, ortho, 1352600, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80172, laea, 1352600, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80173, laea, 1352600, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1352600 +b=1352600 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80200, longlat, 170000, "+proj=longlat +a=170000 +b=170000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80201, longlat, 170000, "+proj=longlat +a=170000 +b=170000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80210, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80211, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80212, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80213, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80214, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80215, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80216, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80217, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80218, stere, 170000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80219, stere, 170000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80220, stere, 170000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80221, stere, 170000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80260, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80261, sinu, 170000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80262, stere, 170000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80263, stere, 170000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80264, tmerc, 170000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80265, tmerc, 170000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80266, ortho, 170000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80267, ortho, 170000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80268, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80269, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80270, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80271, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80272, laea, 170000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80273, laea, 170000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=170000 +b=170000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80274, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80275, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80276, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80277, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80278, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80279, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80300, longlat, 29000, "+proj=longlat +a=29000 +b=29000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80301, longlat, 29000, "+proj=longlat +a=29000 +b=29000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80310, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80311, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80312, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80313, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80314, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80315, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80316, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80317, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80318, stere, 29000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80319, stere, 29000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80320, stere, 29000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80321, stere, 29000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80360, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80361, sinu, 29000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80362, stere, 29000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80363, stere, 29000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80364, tmerc, 29000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80365, tmerc, 29000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80366, ortho, 29000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80367, ortho, 29000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80368, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80369, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80370, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80371, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80372, laea, 29000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80373, laea, 29000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=29000 +b=29000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80374, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80375, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80376, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80377, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80378, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80379, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80400, longlat, 40000, "+proj=longlat +a=40000 +b=40000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80401, longlat, 40000, "+proj=longlat +a=40000 +b=40000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80410, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80411, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80412, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80413, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80414, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80415, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80416, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80417, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80418, stere, 40000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80419, stere, 40000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80420, stere, 40000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80421, stere, 40000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80460, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80461, sinu, 40000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80462, stere, 40000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80463, stere, 40000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80464, tmerc, 40000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80465, tmerc, 40000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80466, ortho, 40000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80467, ortho, 40000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80468, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80469, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80470, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80471, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80472, laea, 40000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80473, laea, 40000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=40000 +b=40000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80474, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80475, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80476, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80477, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80478, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80479, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80500, longlat, 74000, "+proj=longlat +a=74000 +b=74000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80501, longlat, 74000, "+proj=longlat +a=74000 +b=74000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80510, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80511, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80512, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80513, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80514, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80515, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80516, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80517, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80518, stere, 74000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80519, stere, 74000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80520, stere, 74000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80521, stere, 74000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80560, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80561, sinu, 74000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80562, stere, 74000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80563, stere, 74000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80564, tmerc, 74000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80565, tmerc, 74000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80566, ortho, 74000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80567, ortho, 74000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80568, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80569, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80570, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80571, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80572, laea, 74000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80573, laea, 74000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=74000 +b=74000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80574, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80575, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80576, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80577, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80578, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80579, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80600, longlat, 79000, "+proj=longlat +a=79000 +b=79000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80601, longlat, 79000, "+proj=longlat +a=79000 +b=79000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80610, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80611, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80612, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80613, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80614, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80615, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80616, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80617, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80618, stere, 79000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80619, stere, 79000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80620, stere, 79000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80621, stere, 79000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80660, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80661, sinu, 79000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80662, stere, 79000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80663, stere, 79000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80664, tmerc, 79000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80665, tmerc, 79000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80666, ortho, 79000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80667, ortho, 79000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80668, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80669, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80670, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80671, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80672, laea, 79000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80673, laea, 79000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=79000 +b=79000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80674, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80675, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80676, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80677, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80678, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80679, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80700, longlat, 96000, "+proj=longlat +a=96000 +b=96000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80701, longlat, 96000, "+proj=longlat +a=96000 +b=96000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80710, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80711, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80712, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80713, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80714, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80715, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80716, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80717, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80718, stere, 96000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80719, stere, 96000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80720, stere, 96000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80721, stere, 96000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80760, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80761, sinu, 96000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80762, stere, 96000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80763, stere, 96000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80764, tmerc, 96000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80765, tmerc, 96000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80766, ortho, 96000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80767, ortho, 96000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80768, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80769, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80770, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80771, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80772, laea, 96000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 80773, laea, 96000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=96000 +b=96000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80774, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80775, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80776, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80777, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80778, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80779, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80800, longlat, 218000, 201000, "+proj=longlat +a=218000 +b=201000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80801, longlat, 218000, 201000, "+proj=longlat +a=218000 +b=201000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80810, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80811, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80812, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80813, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80814, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80815, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80816, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80817, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80818, stere, 218000, 201000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80819, stere, 218000, 201000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80820, stere, 218000, 201000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80821, stere, 218000, 201000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80860, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80861, sinu, 218000, 201000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80862, stere, 218000, 201000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80863, stere, 218000, 201000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80864, tmerc, 218000, 201000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80865, tmerc, 218000, 201000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80866, ortho, 218000, 201000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80867, ortho, 218000, 201000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80868, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80869, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80870, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80871, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80872, laea, 218000, 201000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 80873, laea, 218000, 201000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=218000 +b=201000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80874, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80875, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80876, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80877, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80878, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 80879, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89900, longlat, 24764000, 24341000, "+proj=longlat +a=24764000 +b=24341000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89901, longlat, 24764000, 24341000, "+proj=longlat +a=24764000 +b=24341000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89914, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89915, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89916, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89917, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89918, stere, 24764000, 24341000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89919, stere, 24764000, 24341000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89920, stere, 24764000, 24341000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89921, stere, 24764000, 24341000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89960, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89961, sinu, 24764000, 24341000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89962, stere, 24764000, 24341000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89963, stere, 24764000, 24341000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89964, tmerc, 24764000, 24341000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89965, tmerc, 24764000, 24341000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89966, ortho, 24764000, 24341000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89967, ortho, 24764000, 24341000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89972, laea, 24764000, 24341000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_AB(iau2000, 89973, laea, 24764000, 24341000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=24764000 +b=24341000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 89979, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90100, longlat, 593000, "+proj=longlat +a=593000 +b=593000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90101, longlat, 593000, "+proj=longlat +a=593000 +b=593000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90110, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90111, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90112, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90113, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90114, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90115, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90116, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90117, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90118, stere, 593000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90119, stere, 593000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90120, stere, 593000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90121, stere, 593000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90160, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90161, sinu, 593000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90162, stere, 593000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90163, stere, 593000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90164, tmerc, 593000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90165, tmerc, 593000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90166, ortho, 593000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90167, ortho, 593000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90168, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90169, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90170, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90171, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90172, laea, 593000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 90173, laea, 593000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=593000 +b=593000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90174, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90175, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90176, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90177, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90178, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 90179, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99900, longlat, 1195000, "+proj=longlat +a=1195000 +b=1195000 +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99901, longlat, 1195000, "+proj=longlat +a=1195000 +b=1195000 +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99910, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99911, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99912, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99913, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99914, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99915, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99916, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99917, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99918, stere, 1195000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99919, stere, 1195000, "+proj=stere +lat_0=90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99920, stere, 1195000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99921, stere, 1195000, "+proj=stere +lat_0=-90 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99960, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99961, sinu, 1195000, "+proj=sinu +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99962, stere, 1195000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99963, stere, 1195000, "+proj=stere +lat_0=0 +lon_0=0 +k=1 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99964, tmerc, 1195000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99965, tmerc, 1195000, "+proj=tmerc +lat_0=0 +lon_0=0 +k=0.9996 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99966, ortho, 1195000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99967, ortho, 1195000, "+proj=ortho +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99968, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99969, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99970, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99971, "")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99972, laea, 1195000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_S (iau2000, 99973, laea, 1195000, "+proj=laea +lat_0=90 +lon_0=0 +x_0=0 +y_0=0 +a=1195000 +b=1195000 +units=m +no_defs")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99974, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99975, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99976, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99977, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99978, "")
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS (iau2000, 99979, "")

} // namespace detail
#endif // DOXYGEN_NO_DETAIL

}}} // namespace boost::geometry::projections


#endif

