/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.time.ZoneId;
import java.util.Objects;
import java.util.function.LongSupplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.MutableDateTime;
import org.joda.time.format.DateTimeFormatter;

public class JodaDateMathParser
implements DateMathParser {
    private final FormatDateTimeFormatter dateTimeFormatter;

    public JodaDateMathParser(FormatDateTimeFormatter dateTimeFormatter) {
        Objects.requireNonNull(dateTimeFormatter);
        this.dateTimeFormatter = dateTimeFormatter;
    }

    @Override
    public long parse(String text, LongSupplier now, boolean roundUp, ZoneId tz) {
        String mathString;
        long time;
        DateTimeZone timeZone;
        DateTimeZone dateTimeZone = timeZone = tz == null ? null : DateUtils.zoneIdToDateTimeZone(tz);
        if (text.startsWith("now")) {
            try {
                time = now.getAsLong();
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("could not read the current timestamp", (Throwable)e, new Object[0]);
            }
            mathString = text.substring("now".length());
        } else {
            int index = text.indexOf("||");
            if (index == -1) {
                return this.parseDateTime(text, timeZone, roundUp);
            }
            time = this.parseDateTime(text.substring(0, index), timeZone, false);
            mathString = text.substring(index + 2);
        }
        return this.parseMath(mathString, time, roundUp, timeZone);
    }

    private long parseMath(String mathString, long time, boolean roundUp, DateTimeZone timeZone) throws ElasticsearchParseException {
        if (timeZone == null) {
            timeZone = DateTimeZone.UTC;
        }
        MutableDateTime dateTime = new MutableDateTime(time, timeZone);
        int i = 0;
        while (i < mathString.length()) {
            int num;
            int sign;
            boolean round;
            char c;
            if ((c = mathString.charAt(i++)) == '/') {
                round = true;
                sign = 1;
            } else {
                round = false;
                if (c == '+') {
                    sign = 1;
                } else if (c == '-') {
                    sign = -1;
                } else {
                    throw new ElasticsearchParseException("operator not supported for date math [{}]", mathString);
                }
            }
            if (i >= mathString.length()) {
                throw new ElasticsearchParseException("truncated date math [{}]", mathString);
            }
            if (!Character.isDigit(mathString.charAt(i))) {
                num = 1;
            } else {
                int numFrom = i;
                while (i < mathString.length() && Character.isDigit(mathString.charAt(i))) {
                    ++i;
                }
                if (i >= mathString.length()) {
                    throw new ElasticsearchParseException("truncated date math [{}]", mathString);
                }
                num = Integer.parseInt(mathString.substring(numFrom, i));
            }
            if (round && num != 1) {
                throw new ElasticsearchParseException("rounding `/` can only be used on single unit types [{}]", mathString);
            }
            char unit = mathString.charAt(i++);
            MutableDateTime.Property propertyToRound = null;
            switch (unit) {
                case 'y': {
                    if (round) {
                        propertyToRound = dateTime.yearOfCentury();
                        break;
                    }
                    dateTime.addYears(sign * num);
                    break;
                }
                case 'M': {
                    if (round) {
                        propertyToRound = dateTime.monthOfYear();
                        break;
                    }
                    dateTime.addMonths(sign * num);
                    break;
                }
                case 'w': {
                    if (round) {
                        propertyToRound = dateTime.weekOfWeekyear();
                        break;
                    }
                    dateTime.addWeeks(sign * num);
                    break;
                }
                case 'd': {
                    if (round) {
                        propertyToRound = dateTime.dayOfMonth();
                        break;
                    }
                    dateTime.addDays(sign * num);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (round) {
                        propertyToRound = dateTime.hourOfDay();
                        break;
                    }
                    dateTime.addHours(sign * num);
                    break;
                }
                case 'm': {
                    if (round) {
                        propertyToRound = dateTime.minuteOfHour();
                        break;
                    }
                    dateTime.addMinutes(sign * num);
                    break;
                }
                case 's': {
                    if (round) {
                        propertyToRound = dateTime.secondOfMinute();
                        break;
                    }
                    dateTime.addSeconds(sign * num);
                    break;
                }
                default: {
                    throw new ElasticsearchParseException("unit [{}] not supported for date math [{}]", Character.valueOf(unit), mathString);
                }
            }
            if (propertyToRound == null) continue;
            if (roundUp) {
                propertyToRound.add(1);
                propertyToRound.roundFloor();
                dateTime.addMillis(-1);
                continue;
            }
            propertyToRound.roundFloor();
        }
        return dateTime.getMillis();
    }

    private long parseDateTime(String value, DateTimeZone timeZone, boolean roundUpIfNoTime) {
        DateTimeFormatter parser = this.dateTimeFormatter.parser();
        if (timeZone != null) {
            parser = parser.withZone(timeZone);
        }
        try {
            MutableDateTime date = roundUpIfNoTime ? new MutableDateTime(1970, 1, 1, 23, 59, 59, 999, DateTimeZone.UTC) : new MutableDateTime(1970, 1, 1, 0, 0, 0, 0, DateTimeZone.UTC);
            int end = parser.parseInto(date, value, 0);
            if (end < 0) {
                int position = ~end;
                throw new IllegalArgumentException("Parse failure at index [" + position + "] of [" + value + "]");
            }
            if (end != value.length()) {
                throw new IllegalArgumentException("Unrecognized chars at the end of [" + value + "]: [" + value.substring(end) + "]");
            }
            return date.getMillis();
        }
        catch (IllegalArgumentException e) {
            throw new ElasticsearchParseException("failed to parse date field [{}] with format [{}]", (Throwable)e, value, this.dateTimeFormatter.format());
        }
    }
}

