/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.single.SingleNodeDiscovery;
import org.elasticsearch.discovery.zen.FileBasedUnicastHostsProvider;
import org.elasticsearch.discovery.zen.SettingsBasedHostsProvider;
import org.elasticsearch.discovery.zen.UnicastHostsProvider;
import org.elasticsearch.discovery.zen.ZenDiscovery;
import org.elasticsearch.plugins.DiscoveryPlugin;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class DiscoveryModule {
    private static final Logger logger = LogManager.getLogger(DiscoveryModule.class);
    public static final Setting<String> DISCOVERY_TYPE_SETTING = new Setting("discovery.type", "zen", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<List<String>> DISCOVERY_HOSTS_PROVIDER_SETTING = Setting.listSetting("discovery.zen.hosts_provider", Collections.emptyList(), Function.identity(), Setting.Property.NodeScope);
    private final Discovery discovery;

    public DiscoveryModule(Settings settings, ThreadPool threadPool, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService, MasterService masterService, ClusterApplier clusterApplier, ClusterSettings clusterSettings, List<DiscoveryPlugin> plugins, AllocationService allocationService, Path configFile) {
        ArrayList<BiConsumer<DiscoveryNode, ClusterState>> joinValidators = new ArrayList<BiConsumer<DiscoveryNode, ClusterState>>();
        HashMap<String, Supplier<UnicastHostsProvider>> hostProviders = new HashMap<String, Supplier<UnicastHostsProvider>>();
        hostProviders.put("settings", () -> new SettingsBasedHostsProvider(settings, transportService));
        hostProviders.put("file", () -> new FileBasedUnicastHostsProvider(settings, configFile));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getZenHostsProviders(transportService, networkService).entrySet().forEach(entry -> {
                if (hostProviders.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register zen hosts provider [" + (String)entry.getKey() + "] twice");
                }
            });
            BiConsumer<DiscoveryNode, ClusterState> joinValidator = plugin.getJoinValidator();
            if (joinValidator == null) continue;
            joinValidators.add(joinValidator);
        }
        List<String> hostsProviderNames = DISCOVERY_HOSTS_PROVIDER_SETTING.get(settings);
        if (!hostsProviderNames.contains("settings")) {
            ArrayList<String> extendedHostsProviderNames = new ArrayList<String>();
            extendedHostsProviderNames.add("settings");
            extendedHostsProviderNames.addAll(hostsProviderNames);
            hostsProviderNames = extendedHostsProviderNames;
        }
        HashSet<String> missingProviderNames = new HashSet<String>(hostsProviderNames);
        missingProviderNames.removeAll(hostProviders.keySet());
        if (!missingProviderNames.isEmpty()) {
            throw new IllegalArgumentException("Unknown zen hosts providers " + missingProviderNames);
        }
        List filteredHostsProviders = hostsProviderNames.stream().map(hostProviders::get).map(Supplier::get).collect(Collectors.toList());
        UnicastHostsProvider hostsProvider = hostsResolver -> {
            ArrayList<TransportAddress> addresses = new ArrayList<TransportAddress>();
            for (UnicastHostsProvider provider : filteredHostsProviders) {
                addresses.addAll(provider.buildDynamicHosts(hostsResolver));
            }
            return Collections.unmodifiableList(addresses);
        };
        HashMap<String, Supplier<Discovery>> discoveryTypes = new HashMap<String, Supplier<Discovery>>();
        discoveryTypes.put("zen", () -> new ZenDiscovery(settings, threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService, Collections.unmodifiableCollection(joinValidators)));
        discoveryTypes.put("single-node", () -> new SingleNodeDiscovery(settings, transportService, masterService, clusterApplier));
        for (DiscoveryPlugin plugin : plugins) {
            plugin.getDiscoveryTypes(threadPool, transportService, namedWriteableRegistry, masterService, clusterApplier, clusterSettings, hostsProvider, allocationService).entrySet().forEach(entry -> {
                if (discoveryTypes.put((String)entry.getKey(), (Supplier)entry.getValue()) != null) {
                    throw new IllegalArgumentException("Cannot register discovery type [" + (String)entry.getKey() + "] twice");
                }
            });
        }
        String discoveryType = DISCOVERY_TYPE_SETTING.get(settings);
        Supplier discoverySupplier = (Supplier)discoveryTypes.get(discoveryType);
        if (discoverySupplier == null) {
            throw new IllegalArgumentException("Unknown discovery type [" + discoveryType + "]");
        }
        logger.info("using discovery type [{}] and host providers {}", (Object)discoveryType, (Object)hostsProviderNames);
        this.discovery = Objects.requireNonNull((Discovery)discoverySupplier.get());
    }

    public Discovery getDiscovery() {
        return this.discovery;
    }
}

