/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.blobstore;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RateLimiter;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.blobstore.BlobContainer;
import org.elasticsearch.common.blobstore.BlobMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobContainer;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.compress.NotXContentException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.metrics.CounterMetric;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardRestoreFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotFailedException;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshots;
import org.elasticsearch.index.snapshots.blobstore.RateLimitingInputStream;
import org.elasticsearch.index.snapshots.blobstore.SlicedInputStream;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.elasticsearch.index.store.Store;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.RepositoryVerificationException;
import org.elasticsearch.repositories.blobstore.BlobStoreFormat;
import org.elasticsearch.repositories.blobstore.ChecksumBlobStoreFormat;
import org.elasticsearch.snapshots.InvalidSnapshotNameException;
import org.elasticsearch.snapshots.SnapshotCreationException;
import org.elasticsearch.snapshots.SnapshotException;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotShardFailure;

public abstract class BlobStoreRepository
extends AbstractLifecycleComponent
implements Repository {
    protected final RepositoryMetaData metadata;
    protected final NamedXContentRegistry namedXContentRegistry;
    private static final int BUFFER_SIZE = 4096;
    private static final String SNAPSHOT_PREFIX = "snap-";
    private static final String SNAPSHOT_CODEC = "snapshot";
    private static final String INDEX_FILE_PREFIX = "index-";
    private static final String INDEX_LATEST_BLOB = "index.latest";
    private static final String INCOMPATIBLE_SNAPSHOTS_BLOB = "incompatible-snapshots";
    private static final String TESTS_FILE = "tests-";
    private static final String METADATA_NAME_FORMAT = "meta-%s.dat";
    private static final String METADATA_CODEC = "metadata";
    private static final String INDEX_METADATA_CODEC = "index-metadata";
    private static final String SNAPSHOT_NAME_FORMAT = "snap-%s.dat";
    private static final String SNAPSHOT_INDEX_PREFIX = "index-";
    private static final String SNAPSHOT_INDEX_NAME_FORMAT = "index-%s";
    private static final String SNAPSHOT_INDEX_CODEC = "snapshots";
    private static final String DATA_BLOB_PREFIX = "__";
    private final RateLimiter snapshotRateLimiter;
    private final RateLimiter restoreRateLimiter;
    private final CounterMetric snapshotRateLimitingTimeInNanos = new CounterMetric();
    private final CounterMetric restoreRateLimitingTimeInNanos = new CounterMetric();
    private ChecksumBlobStoreFormat<MetaData> globalMetaDataFormat;
    private ChecksumBlobStoreFormat<IndexMetaData> indexMetaDataFormat;
    private ChecksumBlobStoreFormat<SnapshotInfo> snapshotFormat;
    private final boolean readOnly;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat;
    private final ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots> indexShardSnapshotsFormat;
    private final Object lock = new Object();
    private final SetOnce<BlobContainer> blobContainer = new SetOnce();
    private final SetOnce<BlobStore> blobStore = new SetOnce();

    protected BlobStoreRepository(RepositoryMetaData metadata, Settings globalSettings, NamedXContentRegistry namedXContentRegistry) {
        super(globalSettings);
        this.metadata = metadata;
        this.namedXContentRegistry = namedXContentRegistry;
        this.snapshotRateLimiter = this.getRateLimiter(metadata.settings(), "max_snapshot_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.restoreRateLimiter = this.getRateLimiter(metadata.settings(), "max_restore_bytes_per_sec", new ByteSizeValue(40L, ByteSizeUnit.MB));
        this.readOnly = metadata.settings().getAsBoolean("readonly", false);
        this.indexShardSnapshotFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshot>(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, BlobStoreIndexShardSnapshot::fromXContent, namedXContentRegistry, this.isCompress());
        this.indexShardSnapshotsFormat = new ChecksumBlobStoreFormat<BlobStoreIndexShardSnapshots>(SNAPSHOT_INDEX_CODEC, SNAPSHOT_INDEX_NAME_FORMAT, BlobStoreIndexShardSnapshots::fromXContent, namedXContentRegistry, this.isCompress());
        ByteSizeValue chunkSize = this.chunkSize();
        if (chunkSize != null && chunkSize.getBytes() <= 0L) {
            throw new IllegalArgumentException("the chunk size cannot be negative: [" + chunkSize + "]");
        }
    }

    @Override
    protected void doStart() {
        this.globalMetaDataFormat = new ChecksumBlobStoreFormat<MetaData>(METADATA_CODEC, METADATA_NAME_FORMAT, MetaData::fromXContent, this.namedXContentRegistry, this.isCompress());
        this.indexMetaDataFormat = new ChecksumBlobStoreFormat<IndexMetaData>(INDEX_METADATA_CODEC, METADATA_NAME_FORMAT, IndexMetaData::fromXContent, this.namedXContentRegistry, this.isCompress());
        this.snapshotFormat = new ChecksumBlobStoreFormat<SnapshotInfo>(SNAPSHOT_CODEC, SNAPSHOT_NAME_FORMAT, SnapshotInfo::fromXContentInternal, this.namedXContentRegistry, this.isCompress());
    }

    @Override
    protected void doStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        BlobStore store;
        Object object = this.lock;
        synchronized (object) {
            store = this.blobStore.get();
        }
        if (store != null) {
            try {
                store.close();
            }
            catch (Exception t) {
                this.logger.warn("cannot close blob store", (Throwable)t);
            }
        }
    }

    BlobContainer getBlobContainer() {
        return this.blobContainer.get();
    }

    protected BlobStore getBlobStore() {
        return this.blobStore.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobContainer blobContainer() {
        this.assertSnapshotOrGenericThread();
        BlobContainer blobContainer = this.blobContainer.get();
        if (blobContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                blobContainer = this.blobContainer.get();
                if (blobContainer == null) {
                    blobContainer = this.blobStore().blobContainer(this.basePath());
                    this.blobContainer.set(blobContainer);
                }
            }
        }
        return blobContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BlobStore blobStore() {
        this.assertSnapshotOrGenericThread();
        BlobStore store = this.blobStore.get();
        if (store == null) {
            Object object = this.lock;
            synchronized (object) {
                store = this.blobStore.get();
                if (store == null) {
                    if (!this.lifecycle.started()) {
                        throw new RepositoryException(this.metadata.name(), "repository is not in started state");
                    }
                    try {
                        store = this.createBlobStore();
                    }
                    catch (RepositoryException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new RepositoryException(this.metadata.name(), "cannot create blob store", e);
                    }
                    this.blobStore.set(store);
                }
            }
        }
        return store;
    }

    protected abstract BlobStore createBlobStore() throws Exception;

    protected abstract BlobPath basePath();

    protected boolean isCompress() {
        return false;
    }

    protected ByteSizeValue chunkSize() {
        return null;
    }

    @Override
    public RepositoryMetaData getMetadata() {
        return this.metadata;
    }

    @Override
    public void initializeSnapshot(SnapshotId snapshotId, List<IndexId> indices, MetaData clusterMetaData) {
        if (this.isReadOnly()) {
            throw new RepositoryException(this.metadata.name(), "cannot create snapshot in a readonly repository");
        }
        try {
            String snapshotName = snapshotId.getName();
            RepositoryData repositoryData = this.getRepositoryData();
            if (repositoryData.getAllSnapshotIds().stream().anyMatch(s -> s.getName().equals(snapshotName))) {
                throw new InvalidSnapshotNameException(this.metadata.name(), snapshotId.getName(), "snapshot with the same name already exists");
            }
            if (this.snapshotFormat.exists(this.blobContainer(), snapshotId.getUUID())) {
                throw new InvalidSnapshotNameException(this.metadata.name(), snapshotId.getName(), "snapshot with the same name already exists");
            }
            this.globalMetaDataFormat.write(clusterMetaData, this.blobContainer(), snapshotId.getUUID());
            for (IndexId index : indices) {
                IndexMetaData indexMetaData = clusterMetaData.index(index.getName());
                BlobPath indexPath = this.basePath().add("indices").add(index.getId());
                BlobContainer indexMetaDataBlobContainer = this.blobStore().blobContainer(indexPath);
                this.indexMetaDataFormat.write(indexMetaData, indexMetaDataBlobContainer, snapshotId.getUUID());
            }
        }
        catch (IOException ex) {
            throw new SnapshotCreationException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
    }

    @Override
    public void deleteSnapshot(SnapshotId snapshotId, long repositoryStateId) {
        if (this.isReadOnly()) {
            throw new RepositoryException(this.metadata.name(), "cannot delete snapshot from a readonly repository");
        }
        RepositoryData repositoryData = this.getRepositoryData();
        SnapshotInfo snapshot = null;
        try {
            snapshot = this.getSnapshotInfo(snapshotId);
        }
        catch (SnapshotMissingException ex) {
            throw ex;
        }
        catch (IllegalStateException | ElasticsearchParseException | SnapshotException ex) {
            this.logger.warn(() -> new ParameterizedMessage("cannot read snapshot file [{}]", (Object)snapshotId), (Throwable)ex);
        }
        try {
            RepositoryData updatedRepositoryData = repositoryData.removeSnapshot(snapshotId);
            this.writeIndexGen(updatedRepositoryData, repositoryStateId);
            this.deleteSnapshotBlobIgnoringErrors(snapshot, snapshotId.getUUID());
            this.deleteGlobalMetaDataBlobIgnoringErrors(snapshot, snapshotId.getUUID());
            if (snapshot != null) {
                List<String> indices = snapshot.indices();
                for (String index : indices) {
                    IndexId indexId = repositoryData.resolveIndexId(index);
                    IndexMetaData indexMetaData = null;
                    try {
                        indexMetaData = this.getSnapshotIndexMetaData(snapshotId, indexId);
                    }
                    catch (IOException | ElasticsearchParseException ex) {
                        this.logger.warn(() -> new ParameterizedMessage("[{}] [{}] failed to read metadata for index", (Object)snapshotId, (Object)index), (Throwable)ex);
                    }
                    this.deleteIndexMetaDataBlobIgnoringErrors(snapshot, indexId);
                    if (indexMetaData == null) continue;
                    for (int shardId = 0; shardId < indexMetaData.getNumberOfShards(); ++shardId) {
                        try {
                            this.delete(snapshotId, snapshot.version(), indexId, new ShardId(indexMetaData.getIndex(), shardId));
                            continue;
                        }
                        catch (SnapshotException ex) {
                            int finalShardId = shardId;
                            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to delete shard data for shard [{}][{}]", snapshotId, index, finalShardId), (Throwable)ex);
                        }
                    }
                }
            }
            HashSet<IndexId> indicesToCleanUp = Sets.newHashSet(repositoryData.getIndices().values());
            indicesToCleanUp.removeAll(updatedRepositoryData.getIndices().values());
            BlobContainer indicesBlobContainer = this.blobStore().blobContainer(this.basePath().add("indices"));
            for (IndexId indexId : indicesToCleanUp) {
                try {
                    indicesBlobContainer.deleteBlob(indexId.getId());
                }
                catch (DirectoryNotEmptyException dnee) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] index [{}] no longer part of any snapshots in the repository, but failed to clean up its index folder due to the directory not being empty.", (Object)this.metadata.name(), (Object)indexId), (Throwable)dnee);
                }
                catch (IOException ioe) {
                    this.logger.debug(() -> new ParameterizedMessage("[{}] index [{}] no longer part of any snapshots in the repository, but failed to clean up its index folder.", (Object)this.metadata.name(), (Object)indexId), (Throwable)ioe);
                }
            }
        }
        catch (IOException | ResourceNotFoundException ex) {
            throw new RepositoryException(this.metadata.name(), "failed to delete snapshot [" + snapshotId + "]", ex);
        }
    }

    private void deleteSnapshotBlobIgnoringErrors(SnapshotInfo snapshotInfo, String blobId) {
        try {
            this.snapshotFormat.delete(this.blobContainer(), blobId);
        }
        catch (IOException e) {
            if (snapshotInfo != null) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] Unable to delete snapshot file [{}]", (Object)snapshotInfo.snapshotId(), (Object)blobId), (Throwable)e);
            }
            this.logger.warn(() -> new ParameterizedMessage("Unable to delete snapshot file [{}]", (Object)blobId), (Throwable)e);
        }
    }

    private void deleteGlobalMetaDataBlobIgnoringErrors(SnapshotInfo snapshotInfo, String blobId) {
        try {
            this.globalMetaDataFormat.delete(this.blobContainer(), blobId);
        }
        catch (IOException e) {
            if (snapshotInfo != null) {
                this.logger.warn(() -> new ParameterizedMessage("[{}] Unable to delete global metadata file [{}]", (Object)snapshotInfo.snapshotId(), (Object)blobId), (Throwable)e);
            }
            this.logger.warn(() -> new ParameterizedMessage("Unable to delete global metadata file [{}]", (Object)blobId), (Throwable)e);
        }
    }

    private void deleteIndexMetaDataBlobIgnoringErrors(SnapshotInfo snapshotInfo, IndexId indexId) {
        SnapshotId snapshotId = snapshotInfo.snapshotId();
        BlobContainer indexMetaDataBlobContainer = this.blobStore().blobContainer(this.basePath().add("indices").add(indexId.getId()));
        try {
            this.indexMetaDataFormat.delete(indexMetaDataBlobContainer, snapshotId.getUUID());
        }
        catch (IOException ex) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to delete metadata for index [{}]", (Object)snapshotId, (Object)indexId.getName()), (Throwable)ex);
        }
    }

    @Override
    public SnapshotInfo finalizeSnapshot(SnapshotId snapshotId, List<IndexId> indices, long startTime, String failure, int totalShards, List<SnapshotShardFailure> shardFailures, long repositoryStateId, boolean includeGlobalState) {
        SnapshotInfo blobStoreSnapshot = new SnapshotInfo(snapshotId, indices.stream().map(IndexId::getName).collect(Collectors.toList()), startTime, failure, System.currentTimeMillis(), totalShards, shardFailures, includeGlobalState);
        try {
            this.snapshotFormat.write(blobStoreSnapshot, this.blobContainer(), snapshotId.getUUID());
            RepositoryData repositoryData = this.getRepositoryData();
            this.writeIndexGen(repositoryData.addSnapshot(snapshotId, blobStoreSnapshot.state(), indices), repositoryStateId);
        }
        catch (FileAlreadyExistsException ex) {
            throw new RepositoryException(this.metadata.name(), "Blob already exists while finalizing snapshot, assume the snapshot has already been saved", ex);
        }
        catch (IOException ex) {
            throw new RepositoryException(this.metadata.name(), "failed to update snapshot in repository", ex);
        }
        return blobStoreSnapshot;
    }

    @Override
    public SnapshotInfo getSnapshotInfo(SnapshotId snapshotId) {
        try {
            return (SnapshotInfo)this.snapshotFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException | NotXContentException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to get snapshots", (Throwable)ex);
        }
    }

    @Override
    public MetaData getSnapshotGlobalMetaData(SnapshotId snapshotId) {
        try {
            return (MetaData)this.globalMetaDataFormat.read(this.blobContainer(), snapshotId.getUUID());
        }
        catch (NoSuchFileException ex) {
            throw new SnapshotMissingException(this.metadata.name(), snapshotId, (Throwable)ex);
        }
        catch (IOException ex) {
            throw new SnapshotException(this.metadata.name(), snapshotId, "failed to read global metadata", (Throwable)ex);
        }
    }

    @Override
    public IndexMetaData getSnapshotIndexMetaData(SnapshotId snapshotId, IndexId index) throws IOException {
        BlobPath indexPath = this.basePath().add("indices").add(index.getId());
        return (IndexMetaData)this.indexMetaDataFormat.read(this.blobStore().blobContainer(indexPath), snapshotId.getUUID());
    }

    private RateLimiter getRateLimiter(Settings repositorySettings, String setting, ByteSizeValue defaultRate) {
        ByteSizeValue maxSnapshotBytesPerSec = repositorySettings.getAsBytesSize(setting, this.settings.getAsBytesSize(setting, defaultRate));
        if (maxSnapshotBytesPerSec.getBytes() <= 0L) {
            return null;
        }
        return new RateLimiter.SimpleRateLimiter(maxSnapshotBytesPerSec.getMbFrac());
    }

    @Override
    public long getSnapshotThrottleTimeInNanos() {
        return this.snapshotRateLimitingTimeInNanos.count();
    }

    @Override
    public long getRestoreThrottleTimeInNanos() {
        return this.restoreRateLimitingTimeInNanos.count();
    }

    protected void assertSnapshotOrGenericThread() {
        assert (Thread.currentThread().getName().contains(SNAPSHOT_CODEC) || Thread.currentThread().getName().contains("generic")) : "Expected current thread [" + Thread.currentThread() + "] to be the snapshot or generic thread.";
    }

    @Override
    public String startVerification() {
        try {
            if (this.isReadOnly()) {
                this.blobStore();
                return null;
            }
            String seed = UUIDs.randomBase64UUID();
            byte[] testBytes = Strings.toUTF8Bytes(seed);
            BlobContainer testContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            String blobName = "master.dat";
            BytesArray bytes = new BytesArray(testBytes);
            try (StreamInput stream = bytes.streamInput();){
                testContainer.writeBlobAtomic(blobName, stream, bytes.length(), true);
            }
            return seed;
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "path " + this.basePath() + " is not accessible on master node", exp);
        }
    }

    @Override
    public void endVerification(String seed) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("shouldn't be called");
        }
        try {
            this.blobStore().delete(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
        }
        catch (IOException exp) {
            throw new RepositoryVerificationException(this.metadata.name(), "cannot delete test data at " + this.basePath(), exp);
        }
    }

    @Override
    public RepositoryData getRepositoryData() {
        try {
            RepositoryData repositoryData;
            XContentParser parser;
            BytesStreamOutput out;
            long indexGen = this.latestIndexBlobId();
            String snapshotsIndexBlobName = "index-" + Long.toString(indexGen);
            try (InputStream blob = this.blobContainer().readBlob(snapshotsIndexBlobName);){
                out = new BytesStreamOutput();
                Streams.copy(blob, out);
                try {
                    parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, out.bytes(), XContentType.JSON);
                    try {
                        repositoryData = RepositoryData.snapshotsFromXContent(parser, indexGen);
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                catch (NotXContentException e) {
                    this.logger.warn("[{}] index blob is not valid x-content [{} bytes]", (Object)snapshotsIndexBlobName, (Object)out.bytes().length());
                    throw e;
                }
            }
            try {
                blob = this.blobContainer().readBlob(INCOMPATIBLE_SNAPSHOTS_BLOB);
                try {
                    out = new BytesStreamOutput();
                    Streams.copy(blob, out);
                    parser = XContentHelper.createParser(NamedXContentRegistry.EMPTY, LoggingDeprecationHandler.INSTANCE, out.bytes(), XContentType.JSON);
                    try {
                        repositoryData = repositoryData.incompatibleSnapshotsFromXContent(parser);
                    }
                    finally {
                        if (parser != null) {
                            parser.close();
                        }
                    }
                }
                finally {
                    if (blob != null) {
                        blob.close();
                    }
                }
            }
            catch (NoSuchFileException e) {
                if (this.isReadOnly()) {
                    this.logger.debug("[{}] Incompatible snapshots blob [{}] does not exist, the likely reason is that there are no incompatible snapshots in the repository", (Object)this.metadata.name(), (Object)INCOMPATIBLE_SNAPSHOTS_BLOB);
                }
                this.writeIncompatibleSnapshots(RepositoryData.EMPTY);
            }
            return repositoryData;
        }
        catch (NoSuchFileException ex) {
            return RepositoryData.EMPTY;
        }
        catch (IOException ioe) {
            throw new RepositoryException(this.metadata.name(), "could not read repository data from index blob", ioe);
        }
    }

    public static String testBlobPrefix(String seed) {
        return TESTS_FILE + seed;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void writeIndexGen(RepositoryData repositoryData, long repositoryStateId) throws IOException {
        BytesReference genBytes;
        BytesReference snapshotsBytes;
        assert (!this.isReadOnly());
        long currentGen = this.latestIndexBlobId();
        if (repositoryStateId != -2L && currentGen != repositoryStateId) {
            throw new RepositoryException(this.metadata.name(), "concurrent modification of the index-N file, expected current generation [" + repositoryStateId + "], actual current generation [" + currentGen + "] - possibly due to simultaneous snapshot deletion requests");
        }
        long newGen = currentGen + 1L;
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(bStream);){
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
                repositoryData.snapshotsToXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.close();
            }
            snapshotsBytes = bStream.bytes();
        }
        String indexBlob = "index-" + Long.toString(newGen);
        this.logger.debug("Repository [{}] writing new index generational blob [{}]", (Object)this.metadata.name(), (Object)indexBlob);
        this.writeAtomic(indexBlob, snapshotsBytes, true);
        if (!this.isReadOnly() && newGen - 2L >= 0L) {
            String oldSnapshotIndexFile = "index-" + Long.toString(newGen - 2L);
            this.blobContainer().deleteBlobIgnoringIfNotExists(oldSnapshotIndexFile);
        }
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            bStream.writeLong(newGen);
            genBytes = bStream.bytes();
        }
        this.logger.debug("Repository [{}] updating index.latest with generation [{}]", (Object)this.metadata.name(), (Object)newGen);
        this.writeAtomic(INDEX_LATEST_BLOB, genBytes, false);
    }

    void writeIncompatibleSnapshots(RepositoryData repositoryData) throws IOException {
        BytesReference bytes;
        assert (!this.isReadOnly());
        try (BytesStreamOutput bStream = new BytesStreamOutput();){
            try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(bStream);){
                XContentBuilder builder = XContentFactory.contentBuilder(XContentType.JSON, stream);
                repositoryData.incompatibleSnapshotsToXContent(builder, ToXContent.EMPTY_PARAMS);
                builder.close();
            }
            bytes = bStream.bytes();
        }
        this.writeAtomic(INCOMPATIBLE_SNAPSHOTS_BLOB, bytes, false);
    }

    long latestIndexBlobId() throws IOException {
        try {
            return this.listBlobsToGetLatestIndexId();
        }
        catch (UnsupportedOperationException e) {
            try {
                return this.readSnapshotIndexLatestBlob();
            }
            catch (NoSuchFileException nsfe) {
                return -1L;
            }
        }
    }

    long readSnapshotIndexLatestBlob() throws IOException {
        try (InputStream blob = this.blobContainer().readBlob(INDEX_LATEST_BLOB);){
            BytesStreamOutput out = new BytesStreamOutput();
            Streams.copy(blob, out);
            long l = Numbers.bytesToLong(out.bytes().toBytesRef());
            return l;
        }
    }

    private long listBlobsToGetLatestIndexId() throws IOException {
        Map<String, BlobMetaData> blobs = this.blobContainer().listBlobsByPrefix("index-");
        long latest = -1L;
        if (blobs.isEmpty()) {
            return latest;
        }
        for (BlobMetaData blobMetaData : blobs.values()) {
            String blobName = blobMetaData.name();
            try {
                long curr = Long.parseLong(blobName.substring("index-".length()));
                latest = Math.max(latest, curr);
            }
            catch (NumberFormatException nfe) {
                this.logger.debug("[{}] Unknown blob in the repository: {}", (Object)this.metadata.name(), (Object)blobName);
            }
        }
        return latest;
    }

    private void writeAtomic(String blobName, BytesReference bytesRef, boolean failIfAlreadyExists) throws IOException {
        try (StreamInput stream = bytesRef.streamInput();){
            this.blobContainer().writeBlobAtomic(blobName, stream, bytesRef.length(), failIfAlreadyExists);
        }
    }

    @Override
    public void snapshotShard(IndexShard shard, Store store, SnapshotId snapshotId, IndexId indexId, IndexCommit snapshotIndexCommit, IndexShardSnapshotStatus snapshotStatus) {
        SnapshotContext snapshotContext = new SnapshotContext(store, snapshotId, indexId, snapshotStatus, System.currentTimeMillis());
        try {
            snapshotContext.snapshot(snapshotIndexCommit);
        }
        catch (Exception e) {
            snapshotStatus.moveToFailed(System.currentTimeMillis(), ExceptionsHelper.detailedMessage(e));
            if (e instanceof IndexShardSnapshotFailedException) {
                throw (IndexShardSnapshotFailedException)e;
            }
            throw new IndexShardSnapshotFailedException(store.shardId(), (Throwable)e);
        }
    }

    @Override
    public void restoreShard(IndexShard shard, SnapshotId snapshotId, Version version, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState) {
        RestoreContext snapshotContext = new RestoreContext(shard, snapshotId, version, indexId, snapshotShardId, recoveryState);
        try {
            snapshotContext.restore();
        }
        catch (Exception e) {
            throw new IndexShardRestoreFailedException(shard.shardId(), "failed to restore snapshot [" + snapshotId + "]", e);
        }
    }

    @Override
    public IndexShardSnapshotStatus getShardSnapshotStatus(SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId) {
        Context context = new Context(snapshotId, version, indexId, shardId);
        BlobStoreIndexShardSnapshot snapshot = context.loadSnapshot();
        return IndexShardSnapshotStatus.newDone(snapshot.startTime(), snapshot.time(), snapshot.incrementalFileCount(), snapshot.totalFileCount(), snapshot.incrementalSize(), snapshot.totalSize());
    }

    @Override
    public void verify(String seed, DiscoveryNode localNode) {
        block9: {
            this.assertSnapshotOrGenericThread();
            BlobContainer testBlobContainer = this.blobStore().blobContainer(this.basePath().add(BlobStoreRepository.testBlobPrefix(seed)));
            if (testBlobContainer.blobExists("master.dat")) {
                try {
                    BytesArray bytes = new BytesArray(seed);
                    try (StreamInput stream = bytes.streamInput();){
                        testBlobContainer.writeBlob("data-" + localNode.getId() + ".dat", stream, bytes.length(), true);
                        break block9;
                    }
                }
                catch (IOException exp) {
                    throw new RepositoryVerificationException(this.metadata.name(), "store location [" + this.blobStore() + "] is not accessible on the node [" + localNode + "]", exp);
                }
            }
            throw new RepositoryVerificationException(this.metadata.name(), "a file written by master to the store [" + this.blobStore() + "] cannot be accessed on the node [" + localNode + "]. This might indicate that the store [" + this.blobStore() + "] is not shared between this node and the master node or that permissions on the store don't allow reading files written by the master node");
        }
    }

    private void delete(SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId) {
        Context context = new Context(snapshotId, version, indexId, shardId, shardId);
        context.delete();
    }

    public String toString() {
        return "BlobStoreRepository[[" + this.metadata.name() + "], [" + this.blobStore() + ']' + ']';
    }

    BlobStoreFormat<BlobStoreIndexShardSnapshot> indexShardSnapshotFormat(Version version) {
        return this.indexShardSnapshotFormat;
    }

    private static void maybeRecalculateMetadataHash(BlobContainer blobContainer, BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store.MetadataSnapshot snapshot) throws Exception {
        StoreFileMetaData metadata;
        if (fileInfo != null && (metadata = snapshot.get(fileInfo.physicalName())) != null && metadata.hash().length > 0 && fileInfo.metadata().hash().length == 0) {
            try (PartSliceStream stream = new PartSliceStream(blobContainer, fileInfo);){
                BytesRefBuilder builder = new BytesRefBuilder();
                Store.MetadataSnapshot.hashFile(builder, stream, fileInfo.length());
                BytesRef hash = fileInfo.metadata().hash();
                assert (hash.length == 0);
                hash.bytes = builder.bytes();
                hash.offset = 0;
                hash.length = builder.length();
            }
        }
    }

    static /* synthetic */ Logger access$1100(BlobStoreRepository x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$1200(BlobStoreRepository x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$1300(BlobStoreRepository x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$1500(BlobStoreRepository x0) {
        return x0.logger;
    }

    static /* synthetic */ Logger access$1600(BlobStoreRepository x0) {
        return x0.logger;
    }

    private class RestoreContext
    extends Context {
        private final IndexShard targetShard;
        private final RecoveryState recoveryState;

        RestoreContext(IndexShard shard, SnapshotId snapshotId, Version version, IndexId indexId, ShardId snapshotShardId, RecoveryState recoveryState) {
            super(snapshotId, version, indexId, shard.shardId(), snapshotShardId);
            this.recoveryState = recoveryState;
            this.targetShard = shard;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restore() throws IOException {
            Store store = this.targetShard.store();
            store.incRef();
            try {
                SegmentInfos segmentCommitInfos;
                Object fileInfo;
                Store.MetadataSnapshot recoveryTargetMetadata;
                BlobStoreRepository.this.logger.debug("[{}] [{}] restoring to [{}] ...", (Object)this.snapshotId, (Object)BlobStoreRepository.this.metadata.name(), (Object)this.shardId);
                BlobStoreIndexShardSnapshot snapshot = this.loadSnapshot();
                if (snapshot.indexFiles().size() == 1 && snapshot.indexFiles().get(0).physicalName().startsWith("segments_") && snapshot.indexFiles().get(0).hasUnknownChecksum()) {
                    IndexWriter writer = new IndexWriter(store.directory(), new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setOpenMode(IndexWriterConfig.OpenMode.CREATE).setCommitOnClose(true));
                    writer.close();
                    return;
                }
                SnapshotFiles snapshotFiles = new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles());
                try {
                    recoveryTargetMetadata = this.targetShard.snapshotStoreMetadata();
                }
                catch (IndexNotFoundException e) {
                    BlobStoreRepository.this.logger.trace("[{}] [{}] restoring from to an empty shard", (Object)this.shardId, (Object)this.snapshotId);
                    recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
                }
                catch (IOException e) {
                    BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("{} Can't read metadata from store, will not reuse any local file while restoring", (Object)this.shardId), (Throwable)e);
                    recoveryTargetMetadata = Store.MetadataSnapshot.EMPTY;
                }
                ArrayList<BlobStoreIndexShardSnapshot.FileInfo> filesToRecover = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
                HashMap<String, StoreFileMetaData> snapshotMetaData = new HashMap<String, StoreFileMetaData>();
                HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> fileInfos = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
                for (BlobStoreIndexShardSnapshot.FileInfo fileInfo2 : snapshot.indexFiles()) {
                    try {
                        BlobStoreRepository.maybeRecalculateMetadataHash(this.blobContainer, fileInfo2, recoveryTargetMetadata);
                    }
                    catch (Exception e) {
                        BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("{} Can't calculate hash from blog for file [{}] [{}]", this.shardId, fileInfo2.physicalName(), fileInfo2.metadata()), (Throwable)e);
                    }
                    snapshotMetaData.put(fileInfo2.metadata().name(), fileInfo2.metadata());
                    fileInfos.put(fileInfo2.metadata().name(), fileInfo2);
                }
                Store.MetadataSnapshot sourceMetaData = new Store.MetadataSnapshot(Collections.unmodifiableMap(snapshotMetaData), Collections.emptyMap(), 0L);
                StoreFileMetaData restoredSegmentsFile = sourceMetaData.getSegmentsFile();
                if (restoredSegmentsFile == null) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Snapshot has no segments file");
                }
                Store.RecoveryDiff diff = sourceMetaData.recoveryDiff(recoveryTargetMetadata);
                for (StoreFileMetaData md : diff.identical) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    this.recoveryState.getIndex().addFileDetail(((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).name(), ((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).length(), true);
                    if (!BlobStoreRepository.this.logger.isTraceEnabled()) continue;
                    BlobStoreRepository.this.logger.trace("[{}] [{}] not_recovering [{}] from [{}], exists in local store and is same", (Object)this.shardId, (Object)this.snapshotId, (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).physicalName(), (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).name());
                }
                for (StoreFileMetaData md : Iterables.concat(diff.different, diff.missing)) {
                    fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)fileInfos.get(md.name());
                    filesToRecover.add((BlobStoreIndexShardSnapshot.FileInfo)fileInfo);
                    this.recoveryState.getIndex().addFileDetail(((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).name(), ((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).length(), false);
                    if (!BlobStoreRepository.this.logger.isTraceEnabled()) continue;
                    if (md == null) {
                        BlobStoreRepository.this.logger.trace("[{}] [{}] recovering [{}] from [{}], does not exists in local store", (Object)this.shardId, (Object)this.snapshotId, (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).physicalName(), (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).name());
                        continue;
                    }
                    BlobStoreRepository.this.logger.trace("[{}] [{}] recovering [{}] from [{}], exists in local store but is different", (Object)this.shardId, (Object)this.snapshotId, (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).physicalName(), (Object)((BlobStoreIndexShardSnapshot.FileInfo)fileInfo).name());
                }
                RecoveryState.Index index = this.recoveryState.getIndex();
                if (filesToRecover.isEmpty()) {
                    BlobStoreRepository.this.logger.trace("no files to recover, all exists within the local store");
                }
                try {
                    List<String> deleteIfExistFiles = Arrays.asList(store.directory().listAll());
                    for (BlobStoreIndexShardSnapshot.FileInfo fileToRecover : filesToRecover) {
                        String physicalName = fileToRecover.physicalName();
                        if (deleteIfExistFiles.contains(physicalName)) {
                            BlobStoreRepository.this.logger.trace("[{}] [{}] deleting pre-existing file [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)physicalName);
                            store.directory().deleteFile(physicalName);
                        }
                        BlobStoreRepository.this.logger.trace("[{}] [{}] restoring file [{}]", (Object)this.shardId, (Object)this.snapshotId, (Object)fileToRecover.name());
                        this.restoreFile(fileToRecover, store);
                    }
                }
                catch (IOException ex) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Failed to recover index", ex);
                }
                try {
                    segmentCommitInfos = Lucene.pruneUnreferencedFiles(restoredSegmentsFile.name(), store.directory());
                }
                catch (IOException e) {
                    throw new IndexShardRestoreFailedException(this.shardId, "Failed to fetch index version after copying it over", e);
                }
                this.recoveryState.getIndex().updateVersion(segmentCommitInfos.getVersion());
                try {
                    for (String storeFile : store.directory().listAll()) {
                        if (Store.isAutogenerated(storeFile) || snapshotFiles.containPhysicalIndexFile(storeFile)) continue;
                        try {
                            store.deleteQuiet("restore", storeFile);
                            store.directory().deleteFile(storeFile);
                        }
                        catch (IOException e) {
                            BlobStoreRepository.this.logger.warn("[{}] failed to delete file [{}] during snapshot cleanup", (Object)this.snapshotId, (Object)storeFile);
                        }
                    }
                }
                catch (IOException e) {
                    BlobStoreRepository.this.logger.warn("[{}] failed to list directory - some of files might not be deleted", (Object)this.snapshotId);
                }
            }
            finally {
                store.decRef();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void restoreFile(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Store store) throws IOException {
            boolean success = false;
            try (PartSliceStream partSliceStream = new PartSliceStream(this.blobContainer, fileInfo);){
                InputStream stream = BlobStoreRepository.this.restoreRateLimiter == null ? partSliceStream : new RateLimitingInputStream(partSliceStream, BlobStoreRepository.this.restoreRateLimiter, BlobStoreRepository.this.restoreRateLimitingTimeInNanos::inc);
                try {
                    try (IndexOutput indexOutput = store.createVerifyingOutput(fileInfo.physicalName(), fileInfo.metadata(), IOContext.DEFAULT);){
                        int length;
                        byte[] buffer = new byte[4096];
                        while ((length = stream.read(buffer)) > 0) {
                            indexOutput.writeBytes(buffer, 0, length);
                            this.recoveryState.getIndex().addRecoveredBytesToFile(fileInfo.name(), length);
                        }
                        Store.verify(indexOutput);
                        indexOutput.close();
                        store.directory().sync(Collections.singleton(fileInfo.physicalName()));
                        success = true;
                    }
                    if (success) return;
                }
                catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {
                    try {
                        try {
                            store.markStoreCorrupted(ex);
                            throw ex;
                        }
                        catch (IOException e) {
                            BlobStoreRepository.this.logger.warn("store cannot be marked as corrupted", (Throwable)e);
                        }
                        throw ex;
                    }
                    catch (Throwable throwable) {
                        if (success) throw throwable;
                        store.deleteQuiet(fileInfo.physicalName());
                        throw throwable;
                    }
                }
                store.deleteQuiet(fileInfo.physicalName());
                return;
            }
        }
    }

    private static final class PartSliceStream
    extends SlicedInputStream {
        private final BlobContainer container;
        private final BlobStoreIndexShardSnapshot.FileInfo info;

        PartSliceStream(BlobContainer container, BlobStoreIndexShardSnapshot.FileInfo info) {
            super(info.numberOfParts());
            this.info = info;
            this.container = container;
        }

        @Override
        protected InputStream openSlice(long slice) throws IOException {
            return this.container.readBlob(this.info.partName(slice));
        }
    }

    private class SnapshotContext
    extends Context {
        private final Store store;
        private final IndexShardSnapshotStatus snapshotStatus;
        private final long startTime;

        SnapshotContext(Store store, SnapshotId snapshotId, IndexId indexId, IndexShardSnapshotStatus snapshotStatus, long startTime) {
            super(snapshotId, Version.CURRENT, indexId, store.shardId());
            this.snapshotStatus = snapshotStatus;
            this.store = store;
            this.startTime = startTime;
        }

        /*
         * Exception decompiling
         */
        public void snapshot(IndexCommit snapshotIndexCommit) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void snapshotFile(BlobStoreIndexShardSnapshot.FileInfo fileInfo) throws IOException {
            String file = fileInfo.physicalName();
            try (IndexInput indexInput = this.store.openVerifyingInput(file, IOContext.READONCE, fileInfo.metadata());){
                int i = 0;
                while ((long)i < fileInfo.numberOfParts()) {
                    InputStreamIndexInput inputStreamIndexInput;
                    long partBytes = fileInfo.partBytes(i);
                    InputStream inputStream = inputStreamIndexInput = new InputStreamIndexInput(indexInput, partBytes);
                    if (BlobStoreRepository.this.snapshotRateLimiter != null) {
                        inputStream = new RateLimitingInputStream(inputStreamIndexInput, BlobStoreRepository.this.snapshotRateLimiter, BlobStoreRepository.this.snapshotRateLimitingTimeInNanos::inc);
                    }
                    inputStream = new AbortableInputStream(inputStream, fileInfo.physicalName());
                    this.blobContainer.writeBlob(fileInfo.partName(i), inputStream, partBytes, true);
                    ++i;
                }
                Store.verify(indexInput);
                this.snapshotStatus.addProcessedFile(fileInfo.length());
            }
            catch (Exception t) {
                this.failStoreIfCorrupted(t);
                this.snapshotStatus.addProcessedFile(0L);
                throw t;
            }
        }

        private void failStoreIfCorrupted(Exception e) {
            if (Lucene.isCorruptionException(e)) {
                try {
                    this.store.markStoreCorrupted((IOException)e);
                }
                catch (IOException inner) {
                    inner.addSuppressed(e);
                    BlobStoreRepository.this.logger.warn("store cannot be marked as corrupted", (Throwable)inner);
                }
            }
        }

        private boolean snapshotFileExistsInBlobs(BlobStoreIndexShardSnapshot.FileInfo fileInfo, Map<String, BlobMetaData> blobs) {
            BlobMetaData blobMetaData = blobs.get(fileInfo.name());
            if (blobMetaData != null) {
                return blobMetaData.length() == fileInfo.length();
            }
            if (blobs.containsKey(fileInfo.partName(0L))) {
                int part = 0;
                long totalSize = 0L;
                while ((blobMetaData = blobs.get(fileInfo.partName(part++))) != null) {
                    totalSize += blobMetaData.length();
                }
                return totalSize == fileInfo.length();
            }
            return false;
        }

        private /* synthetic */ Message lambda$snapshot$1(BlobStoreIndexShardSnapshot.FileInfo fileInfo) {
            return new ParameterizedMessage("{} Can't calculate hash from blob for file [{}] [{}]", this.shardId, fileInfo.physicalName(), fileInfo.metadata());
        }

        private /* synthetic */ boolean lambda$snapshot$0(SnapshotFiles sf) {
            return sf.snapshot().equals(this.snapshotId.getName());
        }

        private class AbortableInputStream
        extends FilterInputStream {
            private final String fileName;

            AbortableInputStream(InputStream delegate, String fileName) {
                super(delegate);
                this.fileName = fileName;
            }

            @Override
            public int read() throws IOException {
                this.checkAborted();
                return this.in.read();
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                this.checkAborted();
                return this.in.read(b, off, len);
            }

            private void checkAborted() {
                if (SnapshotContext.this.snapshotStatus.isAborted()) {
                    BlobStoreRepository.this.logger.debug("[{}] [{}] Aborted on the file [{}], exiting", (Object)SnapshotContext.this.shardId, (Object)SnapshotContext.this.snapshotId, (Object)this.fileName);
                    throw new IndexShardSnapshotFailedException(SnapshotContext.this.shardId, "Aborted");
                }
            }
        }
    }

    private class Context {
        protected final SnapshotId snapshotId;
        protected final ShardId shardId;
        protected final BlobContainer blobContainer;
        protected final Version version;

        Context(SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId) {
            this(snapshotId, version, indexId, shardId, shardId);
        }

        Context(SnapshotId snapshotId, Version version, IndexId indexId, ShardId shardId, ShardId snapshotShardId) {
            this.snapshotId = snapshotId;
            this.version = version;
            this.shardId = shardId;
            this.blobContainer = BlobStoreRepository.this.blobStore().blobContainer(BlobStoreRepository.this.basePath().add("indices").add(indexId.getId()).add(Integer.toString(snapshotShardId.getId())));
        }

        public void delete() {
            Map<String, BlobMetaData> blobs;
            try {
                blobs = this.blobContainer.listBlobs();
            }
            catch (IOException e) {
                throw new IndexShardSnapshotException(this.shardId, "Failed to list content of gateway", e);
            }
            Tuple<BlobStoreIndexShardSnapshots, Integer> tuple = this.buildBlobStoreIndexShardSnapshots(blobs);
            BlobStoreIndexShardSnapshots snapshots = tuple.v1();
            int fileListGeneration = tuple.v2();
            try {
                BlobStoreRepository.this.indexShardSnapshotFormat(this.version).delete(this.blobContainer, this.snapshotId.getUUID());
            }
            catch (IOException e) {
                BlobStoreRepository.this.logger.debug("[{}] [{}] failed to delete shard snapshot file", (Object)this.shardId, (Object)this.snapshotId);
            }
            ArrayList<SnapshotFiles> newSnapshotsList = new ArrayList<SnapshotFiles>();
            for (SnapshotFiles point : snapshots) {
                if (point.snapshot().equals(this.snapshotId.getName())) continue;
                newSnapshotsList.add(point);
            }
            this.finalize(newSnapshotsList, fileListGeneration + 1, blobs, "snapshot deletion [" + this.snapshotId + "]");
        }

        BlobStoreIndexShardSnapshot loadSnapshot() {
            try {
                return BlobStoreRepository.this.indexShardSnapshotFormat(this.version).read(this.blobContainer, this.snapshotId.getUUID());
            }
            catch (IOException ex) {
                throw new SnapshotException(BlobStoreRepository.this.metadata.name(), this.snapshotId, "failed to read shard snapshot file for " + this.shardId, (Throwable)ex);
            }
        }

        protected void finalize(List<SnapshotFiles> snapshots, int fileListGeneration, Map<String, BlobMetaData> blobs, String reason) {
            String indexGeneration = Integer.toString(fileListGeneration);
            String currentIndexGen = BlobStoreRepository.this.indexShardSnapshotsFormat.blobName(indexGeneration);
            BlobStoreIndexShardSnapshots updatedSnapshots = new BlobStoreIndexShardSnapshots(snapshots);
            try {
                for (String blobName : blobs.keySet()) {
                    if (!FsBlobContainer.isTempBlobName(blobName)) continue;
                    try {
                        this.blobContainer.deleteBlobIgnoringIfNotExists(blobName);
                    }
                    catch (IOException e) {
                        BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete index blob [{}] during finalization", this.snapshotId, this.shardId, blobName), (Throwable)e);
                        throw e;
                    }
                }
                if (snapshots.size() > 0) {
                    BlobStoreRepository.this.indexShardSnapshotsFormat.writeAtomic(updatedSnapshots, this.blobContainer, indexGeneration);
                }
                for (String blobName : blobs.keySet()) {
                    if (!blobName.startsWith("index-")) continue;
                    try {
                        this.blobContainer.deleteBlobIgnoringIfNotExists(blobName);
                    }
                    catch (IOException e) {
                        BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete index blob [{}] during finalization", this.snapshotId, this.shardId, blobName), (Throwable)e);
                        throw e;
                    }
                }
                for (String blobName : blobs.keySet()) {
                    if (!blobName.startsWith(BlobStoreRepository.DATA_BLOB_PREFIX) || updatedSnapshots.findNameFile(BlobStoreIndexShardSnapshot.FileInfo.canonicalName(blobName)) != null) continue;
                    try {
                        this.blobContainer.deleteBlobIgnoringIfNotExists(blobName);
                    }
                    catch (IOException e) {
                        BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("[{}][{}] failed to delete data blob [{}] during finalization", this.snapshotId, this.shardId, blobName), (Throwable)e);
                    }
                }
            }
            catch (IOException e) {
                String message = "Failed to finalize " + reason + " with shard index [" + currentIndexGen + "]";
                throw new IndexShardSnapshotFailedException(this.shardId, message, e);
            }
        }

        protected String fileNameFromGeneration(long generation) {
            return BlobStoreRepository.DATA_BLOB_PREFIX + Long.toString(generation, 36);
        }

        protected long findLatestFileNameGeneration(Map<String, BlobMetaData> blobs) {
            long generation = -1L;
            for (String name : blobs.keySet()) {
                if (!name.startsWith(BlobStoreRepository.DATA_BLOB_PREFIX)) continue;
                name = BlobStoreIndexShardSnapshot.FileInfo.canonicalName(name);
                try {
                    long currentGen = Long.parseLong(name.substring(BlobStoreRepository.DATA_BLOB_PREFIX.length()), 36);
                    if (currentGen <= generation) continue;
                    generation = currentGen;
                }
                catch (NumberFormatException e) {
                    BlobStoreRepository.this.logger.warn("file [{}] does not conform to the '{}' schema", (Object)name, (Object)BlobStoreRepository.DATA_BLOB_PREFIX);
                }
            }
            return generation;
        }

        protected Tuple<BlobStoreIndexShardSnapshots, Integer> buildBlobStoreIndexShardSnapshots(Map<String, BlobMetaData> blobs) {
            int latest = -1;
            Set<String> blobKeys = blobs.keySet();
            for (String name : blobKeys) {
                if (!name.startsWith("index-")) continue;
                try {
                    int gen = Integer.parseInt(name.substring("index-".length()));
                    if (gen <= latest) continue;
                    latest = gen;
                }
                catch (NumberFormatException ex) {
                    BlobStoreRepository.this.logger.warn("failed to parse index file name [{}]", (Object)name);
                }
            }
            if (latest >= 0) {
                try {
                    BlobStoreIndexShardSnapshots shardSnapshots = (BlobStoreIndexShardSnapshots)BlobStoreRepository.this.indexShardSnapshotsFormat.read(this.blobContainer, Integer.toString(latest));
                    return new Tuple<BlobStoreIndexShardSnapshots, Integer>(shardSnapshots, latest);
                }
                catch (IOException e) {
                    String file = "index-" + latest;
                    BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("failed to read index file [{}]", (Object)file), (Throwable)e);
                }
            } else if (!blobKeys.isEmpty()) {
                BlobStoreRepository.this.logger.debug("Could not find a readable index-N file in a non-empty shard snapshot directory [{}]", (Object)this.blobContainer.path());
            }
            ArrayList<SnapshotFiles> snapshots = new ArrayList<SnapshotFiles>();
            for (String name : blobKeys) {
                try {
                    BlobStoreIndexShardSnapshot snapshot = null;
                    if (name.startsWith(BlobStoreRepository.SNAPSHOT_PREFIX)) {
                        snapshot = (BlobStoreIndexShardSnapshot)BlobStoreRepository.this.indexShardSnapshotFormat.readBlob(this.blobContainer, name);
                    }
                    if (snapshot == null) continue;
                    snapshots.add(new SnapshotFiles(snapshot.snapshot(), snapshot.indexFiles()));
                }
                catch (IOException e) {
                    BlobStoreRepository.this.logger.warn(() -> new ParameterizedMessage("failed to read commit point [{}]", (Object)name), (Throwable)e);
                }
            }
            return new Tuple<BlobStoreIndexShardSnapshots, Integer>(new BlobStoreIndexShardSnapshots(snapshots), -1);
        }
    }
}

