/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.action;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.TaskOperationFailure;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.rollup.RollupField;
import org.elasticsearch.xpack.core.rollup.job.RollupIndexerJobStats;
import org.elasticsearch.xpack.core.rollup.job.RollupJobConfig;
import org.elasticsearch.xpack.core.rollup.job.RollupJobStatus;

public class GetRollupJobsAction
extends Action<Request, Response, RequestBuilder> {
    public static final GetRollupJobsAction INSTANCE = new GetRollupJobsAction();
    public static final String NAME = "cluster:monitor/xpack/rollup/get";
    public static final ParseField JOBS = new ParseField("jobs", new String[0]);
    public static final ParseField CONFIG = new ParseField("config", new String[0]);
    public static final ParseField STATUS = new ParseField("status", new String[0]);
    public static final ParseField STATS = new ParseField("stats", new String[0]);

    private GetRollupJobsAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, INSTANCE);
    }

    public Response newResponse() {
        return new Response();
    }

    public static class JobWrapper
    implements Writeable,
    ToXContentObject {
        private final RollupJobConfig job;
        private final RollupIndexerJobStats stats;
        private final RollupJobStatus status;
        public static final ConstructingObjectParser<JobWrapper, Void> PARSER = new ConstructingObjectParser("cluster:monitor/xpack/rollup/get", a -> new JobWrapper((RollupJobConfig)a[0], (RollupIndexerJobStats)a[1], (RollupJobStatus)a[2]));

        public JobWrapper(RollupJobConfig job, RollupIndexerJobStats stats, RollupJobStatus status) {
            this.job = job;
            this.stats = stats;
            this.status = status;
        }

        public JobWrapper(StreamInput in) throws IOException {
            this.job = new RollupJobConfig(in);
            this.stats = new RollupIndexerJobStats(in);
            this.status = new RollupJobStatus(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.job.writeTo(out);
            this.stats.writeTo(out);
            this.status.writeTo(out);
        }

        public RollupJobConfig getJob() {
            return this.job;
        }

        public RollupIndexerJobStats getStats() {
            return this.stats;
        }

        public RollupJobStatus getStatus() {
            return this.status;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(CONFIG.getPreferredName());
            this.job.toXContent(builder, params);
            builder.field(STATUS.getPreferredName(), (ToXContent)this.status);
            builder.field(STATS.getPreferredName(), (ToXContent)this.stats, params);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.job, this.stats, this.status);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JobWrapper other = (JobWrapper)obj;
            return Objects.equals(this.job, other.job) && Objects.equals(this.stats, other.stats) && Objects.equals(this.status, other.status);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (p, c) -> RollupJobConfig.fromXContent(p, null), CONFIG);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> RollupIndexerJobStats.PARSER.apply(arg_0, arg_1), STATS);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), (arg_0, arg_1) -> RollupJobStatus.PARSER.apply(arg_0, arg_1), STATUS);
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable,
    ToXContentObject {
        private List<JobWrapper> jobs;

        public Response(List<JobWrapper> jobs) {
            super(Collections.emptyList(), Collections.emptyList());
            this.jobs = jobs;
        }

        public Response(List<JobWrapper> jobs, List<TaskOperationFailure> taskFailures, List<? extends FailedNodeException> nodeFailures) {
            super(taskFailures, nodeFailures);
            this.jobs = jobs;
        }

        public Response() {
            super(Collections.emptyList(), Collections.emptyList());
        }

        public Response(StreamInput in) throws IOException {
            super(Collections.emptyList(), Collections.emptyList());
            this.readFrom(in);
        }

        public List<JobWrapper> getJobs() {
            return this.jobs;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.jobs = in.readList(JobWrapper::new);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeList(this.jobs);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(JOBS.getPreferredName());
            builder.startArray();
            for (JobWrapper job : this.jobs) {
                job.toXContent(builder, params);
            }
            builder.endArray();
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.jobs);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Response other = (Response)((Object)obj);
            return Objects.equals(this.jobs, other.jobs);
        }

        public final String toString() {
            return Strings.toString((ToXContent)this);
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        protected RequestBuilder(ElasticsearchClient client, GetRollupJobsAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends BaseTasksRequest<Request>
    implements ToXContent {
        private String id;

        public Request(String id) {
            this.id = Strings.isNullOrEmpty((String)id) || id.equals("*") ? "_all" : id;
        }

        public Request() {
        }

        public boolean match(Task task) {
            if (this.id.equals("_all")) {
                return task.getDescription().startsWith("rollup_");
            }
            return task.getDescription().equals("rollup_" + this.id);
        }

        public String getId() {
            return this.id;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.id = in.readString();
            if (Strings.isNullOrEmpty((String)this.id) || this.id.equals("*")) {
                this.id = "_all";
            }
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.id);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(RollupField.ID.getPreferredName(), this.id);
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.id);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.id, other.id);
        }
    }
}

