/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.indexing.IndexerJobStats;

public class RollupIndexerJobStats
extends IndexerJobStats {
    private static ParseField NUM_PAGES = new ParseField("pages_processed", new String[0]);
    private static ParseField NUM_INPUT_DOCUMENTS = new ParseField("documents_processed", new String[0]);
    private static ParseField NUM_OUTPUT_DOCUMENTS = new ParseField("rollups_indexed", new String[0]);
    private static ParseField NUM_INVOCATIONS = new ParseField("trigger_count", new String[0]);
    public static final ConstructingObjectParser<RollupIndexerJobStats, Void> PARSER = new ConstructingObjectParser(NAME.getPreferredName(), args -> new RollupIndexerJobStats((Long)args[0], (Long)args[1], (Long)args[2], (Long)args[3]));

    public RollupIndexerJobStats() {
    }

    public RollupIndexerJobStats(long numPages, long numInputDocuments, long numOuputDocuments, long numInvocations) {
        super(numPages, numInputDocuments, numOuputDocuments, numInvocations);
    }

    public RollupIndexerJobStats(StreamInput in) throws IOException {
        super(in);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NUM_PAGES.getPreferredName(), this.numPages);
        builder.field(NUM_INPUT_DOCUMENTS.getPreferredName(), this.numInputDocuments);
        builder.field(NUM_OUTPUT_DOCUMENTS.getPreferredName(), this.numOuputDocuments);
        builder.field(NUM_INVOCATIONS.getPreferredName(), this.numInvocations);
        builder.endObject();
        return builder;
    }

    public static RollupIndexerJobStats fromXContent(XContentParser parser) {
        try {
            return (RollupIndexerJobStats)PARSER.parse(parser, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_PAGES);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INPUT_DOCUMENTS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_OUTPUT_DOCUMENTS);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), NUM_INVOCATIONS);
    }
}

