/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.common.xcontent;

import java.io.IOException;
import org.elasticsearch.common.xcontent.XContentParser;

public class XContentUtils {
    private XContentUtils() {
    }

    public static Object readValue(XContentParser parser, XContentParser.Token token) throws IOException {
        if (token == XContentParser.Token.VALUE_NULL) {
            return null;
        }
        if (token == XContentParser.Token.VALUE_STRING) {
            return parser.text();
        }
        if (token == XContentParser.Token.VALUE_NUMBER) {
            XContentParser.NumberType numberType = parser.numberType();
            if (numberType == XContentParser.NumberType.INT) {
                return parser.intValue();
            }
            if (numberType == XContentParser.NumberType.LONG) {
                return parser.longValue();
            }
            if (numberType == XContentParser.NumberType.FLOAT) {
                return Float.valueOf(parser.floatValue());
            }
            if (numberType == XContentParser.NumberType.DOUBLE) {
                return parser.doubleValue();
            }
        } else {
            if (token == XContentParser.Token.VALUE_BOOLEAN) {
                return parser.booleanValue();
            }
            if (token == XContentParser.Token.START_OBJECT) {
                return parser.map();
            }
            if (token == XContentParser.Token.START_ARRAY) {
                return parser.list();
            }
            if (token == XContentParser.Token.VALUE_EMBEDDED_OBJECT) {
                return parser.binaryValue();
            }
        }
        return null;
    }
}

