/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.util.Objects;
import java.util.TimeZone;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeProcessor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.ReadableDateTime;

public class DateTimeProcessor
extends BaseDateTimeProcessor {
    public static final String NAME = "dt";
    private final DateTimeExtractor extractor;

    public DateTimeProcessor(DateTimeExtractor extractor, TimeZone timeZone) {
        super(timeZone);
        this.extractor = extractor;
    }

    public DateTimeProcessor(StreamInput in) throws IOException {
        super(in);
        this.extractor = (DateTimeExtractor)in.readEnum(DateTimeExtractor.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeEnum((Enum)this.extractor);
    }

    public String getWriteableName() {
        return NAME;
    }

    DateTimeExtractor extractor() {
        return this.extractor;
    }

    @Override
    public Object doProcess(long millis) {
        DateTime dt = new DateTime(millis, DateTimeZone.forTimeZone((TimeZone)this.timeZone()));
        return this.extractor.extract((ReadableDateTime)dt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.extractor, this.timeZone()});
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DateTimeProcessor other = (DateTimeProcessor)obj;
        return Objects.equals((Object)this.extractor, (Object)other.extractor) && Objects.equals(this.timeZone(), other.timeZone());
    }

    public String toString() {
        return this.extractor.toString();
    }

    public static enum DateTimeExtractor {
        DAY_OF_MONTH(DateTimeFieldType.dayOfMonth()),
        DAY_OF_WEEK(DateTimeFieldType.dayOfWeek()),
        DAY_OF_YEAR(DateTimeFieldType.dayOfYear()),
        HOUR_OF_DAY(DateTimeFieldType.hourOfDay()),
        MINUTE_OF_DAY(DateTimeFieldType.minuteOfDay()),
        MINUTE_OF_HOUR(DateTimeFieldType.minuteOfHour()),
        MONTH_OF_YEAR(DateTimeFieldType.monthOfYear()),
        SECOND_OF_MINUTE(DateTimeFieldType.secondOfMinute()),
        WEEK_OF_YEAR(DateTimeFieldType.weekOfWeekyear()),
        YEAR(DateTimeFieldType.year());

        private final DateTimeFieldType field;

        private DateTimeExtractor(DateTimeFieldType field) {
            this.field = field;
        }

        public int extract(ReadableDateTime dt) {
            return dt.get(this.field);
        }
    }
}

