/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.string;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.execution.search.SqlSourceBuilder;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.function.scalar.string.ReplaceFunctionProcessor;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class ReplaceFunctionPipe
extends Pipe {
    private final Pipe source;
    private final Pipe pattern;
    private final Pipe replacement;

    public ReplaceFunctionPipe(Location location, Expression expression, Pipe source, Pipe pattern, Pipe replacement) {
        super(location, expression, Arrays.asList(source, pattern, replacement));
        this.source = source;
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public final Pipe replaceChildren(List<Pipe> newChildren) {
        if (newChildren.size() != 3) {
            throw new IllegalArgumentException("expected [3] children but received [" + newChildren.size() + "]");
        }
        return this.replaceChildren(newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public final Pipe resolveAttributes(Pipe.AttributeResolver resolver) {
        Pipe newSource = this.source.resolveAttributes(resolver);
        Pipe newPattern = this.pattern.resolveAttributes(resolver);
        Pipe newReplacement = this.replacement.resolveAttributes(resolver);
        if (newSource == this.source && newPattern == this.pattern && newReplacement == this.replacement) {
            return this;
        }
        return this.replaceChildren(newSource, newPattern, newReplacement);
    }

    @Override
    public boolean supportedByAggsOnlyQuery() {
        return this.source.supportedByAggsOnlyQuery() && this.pattern.supportedByAggsOnlyQuery() && this.replacement.supportedByAggsOnlyQuery();
    }

    @Override
    public boolean resolved() {
        return this.source.resolved() && this.pattern.resolved() && this.replacement.resolved();
    }

    protected Pipe replaceChildren(Pipe newSource, Pipe newPattern, Pipe newReplacement) {
        return new ReplaceFunctionPipe(this.location(), this.expression(), newSource, newPattern, newReplacement);
    }

    @Override
    public final void collectFields(SqlSourceBuilder sourceBuilder) {
        this.source.collectFields(sourceBuilder);
        this.pattern.collectFields(sourceBuilder);
        this.replacement.collectFields(sourceBuilder);
    }

    @Override
    protected NodeInfo<ReplaceFunctionPipe> info() {
        return NodeInfo.create(this, ReplaceFunctionPipe::new, this.expression(), this.source, this.pattern, this.replacement);
    }

    @Override
    public ReplaceFunctionProcessor asProcessor() {
        return new ReplaceFunctionProcessor(this.source.asProcessor(), this.pattern.asProcessor(), this.replacement.asProcessor());
    }

    public Pipe source() {
        return this.source;
    }

    public Pipe pattern() {
        return this.pattern;
    }

    public Pipe replacement() {
        return this.replacement;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.source, this.pattern, this.replacement);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReplaceFunctionPipe other = (ReplaceFunctionPipe)obj;
        return Objects.equals(this.source, other.source) && Objects.equals(this.pattern, other.pattern) && Objects.equals(this.replacement, other.replacement);
    }
}

